/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.flow.helper.FlowJobHelper;
import kd.hr.hbp.business.flow.job.HRFlowJobHandler;
import kd.hr.hbp.business.flow.job.HRFlowJobRequest;
import kd.hr.hbp.business.flow.job.HRFlowJobResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.flow.FlowJobStatusEnum;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class SalaryListPlugin
extends HRDataBaseList {
    private static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"SalaryListPlugin-run-Thread", (int)3, (int)10);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("salaryconfirm".equals(operate.getOperateKey())) {
            ListView view = (ListView)this.getView();
            String metaNumber = view.getBillFormId();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(metaNumber);
            ArrayList ids = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            for (ListSelectedRow row : selectedRows) {
                ids.add(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())));
            }
            DynamicObject[] dys = helper.queryOriginalArray("flowinsid,jobinsid,jobinsmetanumber", new QFilter[]{new QFilter("id", "in", (Object)ids)});
            HashSet flowInsIds = Sets.newHashSetWithExpectedSize((int)dys.length);
            for (DynamicObject dy : dys) {
                String flowInsId = dy.getString("flowinsid");
                if (flowInsIds.contains(flowInsId)) continue;
                flowInsIds.add(flowInsId);
                EXECUTOR_SERVICE.execute(() -> {
                    long jobInsId = dy.getLong("jobinsid");
                    String jobMetaNumber = dy.getString("jobinsmetanumber");
                    HRBaseServiceHelper jobInsHelper = new HRBaseServiceHelper(jobMetaNumber);
                    DynamicObject jobInsDy = jobInsHelper.loadSingle((Object)jobInsId);
                    HashMap requestData = Maps.newHashMapWithExpectedSize((int)4);
                    requestData.put("metaNumber", metaNumber);
                    requestData.put("isManualConfirm", "false");
                    requestData.put("fieldName", "salaryconfirm");
                    requestData.put("isConfirm", "true");
                    this.jobRun(RequestContext.get(), requestData, jobInsDy);
                });
            }
        }
    }

    private void jobRun(RequestContext context, Map<String, Object> requestData, DynamicObject jobInsDy) {
        long rootFlowId = jobInsDy.getLong("rootjobflowinsid");
        DynamicObjectCollection actionArray = jobInsDy.getDynamicObjectCollection("jobaction");
        for (DynamicObject action : actionArray) {
            DynamicObject[] nextJobInsDys;
            List nextJobInsIds;
            if (!"execute".equals(action.getString("actiontype"))) continue;
            HRFlowJobRequest flowRequest = new HRFlowJobRequest();
            flowRequest.setJobActionType("execute");
            flowRequest.setRequestData(requestData);
            HRFlowJobHandler jobHandler = new HRFlowJobHandler(jobInsDy, context);
            HRFlowJobResponse response = jobHandler.execute(flowRequest);
            if (FlowJobStatusEnum.STATUS_RUN_SUCCESS != response.getJobStatus() || !Objects.nonNull(nextJobInsIds = FlowJobHelper.getEntryNextList((Long)rootFlowId, (Long)jobInsDy.getLong("id"))) || nextJobInsIds.isEmpty()) continue;
            HRBaseServiceHelper helper = new HRBaseServiceHelper(jobInsDy.getDataEntityType().getName());
            for (DynamicObject nextJobIns : nextJobInsDys = helper.loadDynamicObjectArray(nextJobInsIds.stream().map(id -> Long.parseLong(String.valueOf(id))).distinct().toArray())) {
                DynamicObjectCollection nextActionArray = nextJobIns.getDynamicObjectCollection("jobaction");
                for (DynamicObject nextAction : nextActionArray) {
                    if (!"execute".equals(nextAction.getString("actiontype"))) continue;
                    Map<String, Object> params = nextAction.getDynamicObjectCollection("inparam").stream().collect(Collectors.toMap(dy -> dy.getString("inparamname"), dy -> {
                        Object value = dy.get("runvalue");
                        if ("bizObject".equals(dy.get("inparamtype"))) {
                            try {
                                value = Long.valueOf(String.valueOf(value));
                            }
                            catch (Exception e) {
                                value = String.valueOf(value);
                            }
                        }
                        return value;
                    }));
                    this.jobRun(context, params, nextJobIns);
                }
            }
        }
    }
}

