/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.datarule.HRDataRuleTreeSearchServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.bussiness.util.QueryEntitiesUtil;

public class HRPermChargeTreeServiceHelper {
    private TreeView treeView;
    private QueryEntitiesUtil queryEntitiesUtil;

    public HRPermChargeTreeServiceHelper(TreeView treeView) {
        this.treeView = treeView;
        this.queryEntitiesUtil = new QueryEntitiesUtil();
    }

    public void reBuildWholeTree() {
        this.treeView.deleteAllNodes();
        TreeNode rootNode = HRDataRuleTreeSearchServiceHelper.buildRootNode();
        this.addCloudNode(rootNode);
        this.treeView.addNode(rootNode);
        this.treeView.focusNode(rootNode);
        this.treeView.treeNodeClick("", rootNode.getId());
    }

    private void addCloudNode(TreeNode rootNode) {
        List<Map<String, String>> bizCloudNodeList = this.getBizCloud();
        String parentId = rootNode.getId();
        ArrayList<TreeNode> clouds = new ArrayList<TreeNode>(16);
        for (Map<String, String> bizCloudNode : bizCloudNodeList) {
            String id = bizCloudNode.get("id");
            String name = bizCloudNode.get("name");
            TreeNode cloudNode = new TreeNode(parentId, id, name, true);
            clouds.add(cloudNode);
        }
        List cloudIds = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)clouds.size());
        cloudIds.forEach(cloudId -> clouds.stream().filter(node -> HRStringUtils.equals((String)cloudId, (String)node.getId().substring(8))).findFirst().ifPresent(nodes::add));
        rootNode.addChildren((List)nodes);
    }

    private List<Map<String, String>> getBizCloud() {
        HRBaseServiceHelper hrCloudHelper = new HRBaseServiceHelper("hrcs_hrcloud");
        HashSet<String> adminGroupAppAuthorRange = new HashSet<String>(16);
        HashSet<String> adminGroupAppAuthorRangeClouds = new HashSet<String>(16);
        this.getAdminGroupAppAuthorRange(adminGroupAppAuthorRange, adminGroupAppAuthorRangeClouds);
        DynamicObject[] dys = hrCloudHelper.query(new QFilter[]{new QFilter("id", "in", adminGroupAppAuthorRangeClouds)});
        List cloudIds = Arrays.stream(dys).map(it -> it.getString("id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizcloud");
        QFilter filter = new QFilter("id", "in", cloudIds);
        DynamicObject[] clouds = serviceHelper.query("id,name", new QFilter[]{filter}, "sequence asc");
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(clouds.length);
        for (DynamicObject dy : clouds) {
            HashMap<String, String> bizCloudMap = new HashMap<String, String>();
            bizCloudMap.put("id", "1_split_" + dy.getString("id"));
            bizCloudMap.put("name", dy.getString("name"));
            result.add(bizCloudMap);
        }
        return result;
    }

    public void handleExpandNodeClick(String parentId) {
        String nodeIdPrefix = parentId.split("_split_")[0];
        String parentTrueId = this.isRootNode(parentId) ? parentId : parentId.split("_split_")[1];
        QFilter[] qfArr = new QFilter[1];
        DynamicObject[] load = null;
        String localeId = RequestContext.get().getLang().name();
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            load = this.filterLeftCloud(parentTrueId, qfArr);
            this.setCloudTreeNode(parentId, localeId, load);
        }
    }

    private void setCloudTreeNode(String parentId, String localeid, DynamicObject[] load) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)load.length);
        for (DynamicObject obj : load) {
            String id = "2_split_" + obj.getString("id");
            String name = obj.getString("id");
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)obj.getString("id"));
            if (appInfo != null && appInfo.getName() != null && appInfo.getName().get((Object)localeid) != null) {
                name = (String)appInfo.getName().get((Object)localeid);
            }
            TreeNode appNode = new TreeNode(parentId, id, name, false);
            resultList.add(appNode);
        }
        this.treeView.addNodes((List)resultList);
    }

    private DynamicObject[] filterLeftCloud(String parentTrueId, QFilter[] qfArr) {
        Set ids = this.queryEntitiesUtil.queryAppInCloud(parentTrueId, null);
        List<String> forBidApps = this.getForBidApps();
        HashSet<String> adminGroupAppAuthorRange = new HashSet<String>(16);
        this.getAdminGroupAppAuthorRange(adminGroupAppAuthorRange, null);
        ids.retainAll(adminGroupAppAuthorRange);
        ids.removeAll(forBidApps);
        qfArr[0] = new QFilter("id", "in", (Object)ids);
        qfArr = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])qfArr, (String)"id");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"", (QFilter[])qfArr, (String)"sequence");
        return load;
    }

    private boolean isRootNode(String nodeId) {
        return HRStringUtils.equals((String)nodeId, (String)"1010");
    }

    private List<String> getForBidApps() {
        List forBidApps;
        IPageCache pageCache = this.treeView.getView().getPageCache();
        String forBidAppStr = pageCache.get("forBidApps");
        if (HRStringUtils.isEmpty((String)forBidAppStr)) {
            HashSet entities = new HashSet(16);
            HashSet apps = new HashSet(16);
            HashMap appEntity = new HashMap(16);
            EntityCtrlServiceHelper.queryEntityForBidInfo(entities, apps, appEntity);
            pageCache.put("forBidApps", SerializationUtils.toJsonString(apps));
            forBidApps = Lists.newArrayList(apps);
        } else {
            forBidApps = (List)SerializationUtils.fromJsonString((String)forBidAppStr, List.class);
        }
        return forBidApps;
    }

    private void getAdminGroupAppAuthorRange(Set<String> app, Set<String> cloudIds) {
        HRBaseServiceHelper userAdminGroupServiceHelper = new HRBaseServiceHelper("perm_useradmingroup");
        HRBaseServiceHelper adminGroupServiceHelper = new HRBaseServiceHelper("perm_admingroupapp");
        DynamicObject[] userGroupItems = userAdminGroupServiceHelper.query("usergroup.id", new QFilter[]{new QFilter("user.id", "=", (Object)RequestContext.get().getCurrUserId())});
        List userGroupIds = Arrays.stream(userGroupItems).map(it -> it.getLong("usergroup.id")).collect(Collectors.toList());
        DynamicObject[] apps = adminGroupServiceHelper.query("app", new QFilter[]{new QFilter("usergroup.id", "in", userGroupIds)});
        app.addAll(Arrays.stream(apps).map(it -> it.getString("app")).collect(Collectors.toSet()));
        if (cloudIds != null) {
            HRBaseServiceHelper appServiceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            DynamicObject[] bizApps = appServiceHelper.query("bizcloud", new QFilter[]{new QFilter("id", "in", app)});
            cloudIds.addAll(Arrays.stream(bizApps).map(it -> it.getString("bizcloud.id")).collect(Collectors.toSet()));
        }
    }
}

