/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util.earlywarn;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.PluginFieldCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.labelandreport.ComplexObjTransferUtil;
import kd.hr.hrcs.common.constants.earlywarn.WarningSceneConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;

@ExcludeFromJacocoGeneratedReport
public class WarnComplexObjTransferUtil
implements WarningSceneConstants {
    public static HRComplexObjContext transferToComplexObjContext(List<WarnJoinEntityBo> joinEntities, List<WarnQueryFieldBo> queryFields, List<WarnEntityRelationBo> entityRelations, List<WarnCalFieldBo> calculateFields, List<QFilter> qFilters) {
        return WarnComplexObjTransferUtil.transferToComplexObjContext(joinEntities, queryFields, entityRelations, calculateFields, qFilters, Collections.emptyList());
    }

    public static HRComplexObjContext transferToComplexObjContext(List<WarnJoinEntityBo> joinEntities, List<WarnQueryFieldBo> queryFields, List<WarnEntityRelationBo> entityRelations, List<WarnCalFieldBo> calculateFields, List<QFilter> qFilters, List<PluginFieldCommonBo> pluginFields) {
        List<JoinEntityCommonBo> joinEntityCommonBos = WarnComplexObjTransferUtil.transferJoinEntityBos(joinEntities);
        List<QueryFieldCommonBo> queryFieldCommonBos = WarnComplexObjTransferUtil.transferQueryFieldBos(queryFields);
        Map relationBoMap = entityRelations.stream().collect(Collectors.toMap(EntityRelationCommonBo::getJoinEntityAlias, Function.identity(), (x, y) -> y));
        ArrayList sortedEntityRelations = Lists.newArrayListWithExpectedSize((int)10);
        for (WarnJoinEntityBo joinEntity : joinEntities) {
            String longNumber = joinEntity.getLongNumber();
            if (HRStringUtils.equals((String)longNumber, (String)"0")) continue;
            WarnEntityRelationBo entityRelationBo = (WarnEntityRelationBo)((Object)relationBoMap.get(joinEntity.getEntityAlias()));
            sortedEntityRelations.add(entityRelationBo);
        }
        List<EntityRelationCommonBo> entityRelationCommonBos = WarnComplexObjTransferUtil.transferEntityRelationBos(sortedEntityRelations);
        HRComplexObjContext context = ComplexObjTransferUtil.transferToComplexObjContext(joinEntityCommonBos, queryFieldCommonBos, entityRelationCommonBos, qFilters);
        if (context == null) {
            return null;
        }
        context.setTransferField(false);
        List complexObjFieldInfoList = context.getComplexObjFieldInfoList();
        for (WarnCalFieldBo calField : calculateFields) {
            String type = HRStringUtils.equals((String)"simple", (String)calField.getType()) ? "2" : "3";
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(calField.getExpr(), type, calField.getFieldNumber());
            fieldInfo.setDataType(DataTypeEnum.of((String)calField.getValueType()));
            List<String> refEntityFields = calField.getRefEntityFields();
            List<WarnCalFieldBo> refCalculateFields = calField.getRefCalculateFields();
            HashSet refFieldAliasSet = Sets.newHashSetWithExpectedSize((int)(refEntityFields.size() + refCalculateFields.size()));
            refFieldAliasSet.addAll(refEntityFields);
            refCalculateFields.forEach(field -> refFieldAliasSet.add(field.getFieldNumber()));
            fieldInfo.setRefFieldAliasSet((Set)refFieldAliasSet);
            complexObjFieldInfoList.add(fieldInfo);
        }
        if (pluginFields != null) {
            for (PluginFieldCommonBo pluginField : pluginFields) {
                complexObjFieldInfoList.add(new HRComplexObjFieldInfo(pluginField.getFieldAlias(), pluginField.getDataType(), pluginField));
            }
        }
        for (HRComplexObjFieldInfo fieldInfo : complexObjFieldInfoList) {
            if (DataTypeEnum.DATETIME != fieldInfo.getDataType()) continue;
            fieldInfo.setTransfer(false);
        }
        return context;
    }

    public static List<JoinEntityCommonBo> transferJoinEntityBos(List<WarnJoinEntityBo> joinEntityBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(joinEntityBos), JoinEntityCommonBo.class);
    }

    public static List<QueryFieldCommonBo> transferQueryFieldBos(List<WarnQueryFieldBo> queryFieldBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(queryFieldBos), QueryFieldCommonBo.class);
    }

    public static List<EntityRelationCommonBo> transferEntityRelationBos(List<WarnEntityRelationBo> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), EntityRelationCommonBo.class);
    }

    public static List<WarnEntityRelationBo> reverseEntityRelationBos(List<EntityRelationCommonBo> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), WarnEntityRelationBo.class);
    }
}

