/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hrcs.common.constants.SignType;

@ExcludeFromJacocoGeneratedReport
public class EContractTemplateSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(dataEntityArr);
        }
    }

    private void canSave(ExtendedDataEntity[] dataEntityArr) {
        block5: for (ExtendedDataEntity dataEntity : dataEntityArr) {
            this.validateAttrComm(dataEntity);
            String signtype = (String)dataEntity.getValue("signtype");
            switch (SignType.getSignTypeByCode((String)signtype)) {
                case SINGLESIGNBYPERSON: {
                    this.validateAttrByPerson(dataEntity);
                    continue block5;
                }
                case SINGLESIGNBYEN: {
                    this.validateAttrByEn(dataEntity);
                    continue block5;
                }
                case DOUBLESIGN: {
                    this.validateAttrByPerson(dataEntity);
                    this.validateAttrByEn(dataEntity);
                    continue block5;
                }
            }
        }
    }

    private void validateAttrComm(ExtendedDataEntity dataEntity) {
        OrmLocaleValue name;
        String number = (String)dataEntity.getValue("number");
        if (HRStringUtils.isEmpty((String)number)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\u503c", (String)"DEContractTemplateSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(name = (OrmLocaleValue)dataEntity.getValue("name")) || name.size() == 0 || HRStringUtils.isEmpty((String)name.getLocaleValue())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u503c", (String)"DEContractTemplateSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateAttrByPerson(ExtendedDataEntity dataEntity) {
        String signidea;
        Integer offsetydouble;
        Integer offsetxdouble;
        String keyworddouble = (String)dataEntity.getValue("keyworddouble");
        if (HRStringUtils.isEmpty((String)keyworddouble)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e2a\u4eba\u7b7e\u7f72\u4f4d\u7f6e", (String)"DEContractTemplateSaveValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if ((offsetxdouble = (Integer)dataEntity.getValue("offsetxdouble")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e59\u65b9\u7b7e\u7f72\u5750\u6807\u504f\u79fb\u91cf-X\u8f74", (String)"DEContractTemplateSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if ((offsetydouble = (Integer)dataEntity.getValue("offsetydouble")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e59\u65b9\u7b7e\u7f72\u5750\u6807\u504f\u79fb\u91cf-Y\u8f74", (String)"DEContractTemplateSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)(signidea = (String)dataEntity.getValue("signidea")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e2a\u4eba\u7b7e\u7f72\u610f\u613f\u65b9\u5f0f", (String)"DEContractTemplateSaveValidator_10", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        String legalsealkey = (String)dataEntity.getValue("legalsealkey");
        boolean corporateseal = (Boolean)dataEntity.getValue("corporateseal");
        if (corporateseal && HRStringUtils.isEmpty((String)legalsealkey)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6cd5\u4eba\u7ae0\u7b7e\u7ae0\u4f4d\u7f6e\u3002", (String)"DEContractTemplateSaveValidator_11", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateAttrByEn(ExtendedDataEntity dataEntity) {
        Integer offsety;
        Integer offsetx;
        String keyword;
        String sealWay;
        DynamicObject sealTypeid = (DynamicObject)dataEntity.getValue("sealtypeid");
        if (sealTypeid == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f01\u4e1a\u5370\u7ae0\u7c7b\u578b", (String)"EContractTemplateSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)(sealWay = (String)dataEntity.getValue("sealway")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f01\u4e1a\u5370\u7ae0\u52a0\u76d6\u65b9\u5f0f", (String)"EContractTemplateSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)(keyword = (String)dataEntity.getValue("keyword")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f01\u4e1a\u7b7e\u7f72\u4f4d\u7f6e", (String)"DEContractTemplateSaveValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if ((offsetx = (Integer)dataEntity.getValue("offsetx")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7532\u65b9\u7b7e\u7f72\u5750\u6807\u504f\u79fb\u91cf-X\u8f74", (String)"DEContractTemplateSaveValidator_8", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if ((offsety = (Integer)dataEntity.getValue("offsety")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7532\u65b9\u7b7e\u7f72\u5750\u6807\u504f\u79fb\u91cf-Y\u8f74", (String)"DEContractTemplateSaveValidator_9", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }
}

