/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class PrivacySaveConfigSaveValidator
extends HRDataBaseValidator {
    private static String HRMP_HRCS_OPPLUGIN = "hrmp-hrcs-opplugin";

    public void validate() {
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave();
        }
    }

    private void canSave() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity dataEntity : datas = this.getDataEntities()) {
            DynamicObject privacySaveDy = dataEntity.getDataEntity();
            DynamicObjectCollection colls = privacySaveDy.getDynamicObjectCollection("entityentry");
            HashMap repeatMap = Maps.newHashMapWithExpectedSize((int)colls.size());
            for (int i = 0; i < colls.size(); ++i) {
                DynamicObject dy = (DynamicObject)colls.get(i);
                DynamicObject entity = dy.getDynamicObject("entity");
                if (entity == null) continue;
                String key = this.getRepeatMapKey(dy.getString("bizappid.id"), dy.getString("entity.id"), dy.getString("table"), dy.getString("privacyfield"));
                if (null != repeatMap.get(key)) {
                    ((List)repeatMap.get(key)).add(i + 1);
                } else {
                    ArrayList repeatRows = Lists.newArrayListWithExpectedSize((int)colls.size());
                    repeatRows.add(i + 1);
                    repeatMap.put(key, repeatRows);
                }
                String entityNumber = entity.getString("number");
                DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties();
                String privacyField = dy.getString("privacyfield");
                String personField = dy.getString("personfield");
                if (null == properties.get((Object)privacyField)) {
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u9690\u79c1\u5b57\u6bb5/\u6807\u8bc6\u9519\u8bef\uff0c\u5b9e\u4f53\u201c%2$s\u201d\u4e0d\u5b58\u5728\u201c%3$s\u201d\u5b57\u6bb5\u3002", (String)"PrivacySaveConfigSaveValidator_1", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), i + 1, entity.getLocaleString("name"), privacyField));
                }
                if (null != properties.get((Object)personField)) continue;
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u4e0e\u4eba\u5173\u8054\u5b57\u6bb5/\u6807\u8bc6\u9519\u8bef\uff01\u5b9e\u4f53\u201c%2$s\u201d\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5\u201c%3$s\u201d\u3002", (String)"PrivacySaveConfigSaveValidator_2", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), i + 1, entity.getLocaleString("name"), personField));
            }
            if (repeatMap.isEmpty()) continue;
            for (List repeatList : repeatMap.values()) {
                if (repeatList.size() <= 1) continue;
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u5b57\u6bb5\u91cd\u590d\u3002", (String)"PrivacySaveConfigSaveValidator_3", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), repeatList));
            }
        }
    }

    private String getRepeatMapKey(String bizApp, String entity, String table, String field) {
        return String.format(Locale.ROOT, "%s#%s#%s#%s", bizApp, entity, table, field);
    }
}

