/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PromptImportSaveValidator
extends AbstractValidator {
    private final Map<String, String> appIdCloudIdMap = new HashMap<String, String>();
    private final Map<String, String> form2AppIdMap = new HashMap<String, String>();

    public void validate() {
        ExtendedDataEntity[] data = this.getDataEntities();
        Set numberSet = Arrays.stream(data).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getString("number")).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_prompt");
        DynamicObject[] results = serviceHelper.query("id,number,name,description,businessobject,app,cloud,selectcontent,issyspreset", new QFilter[]{new QFilter("number", "in", numberSet)});
        Map<String, DynamicObject> dataBasePromptMap = Arrays.stream(results).collect(Collectors.toMap(result -> result.getString("number"), result -> result));
        ArrayList newData = Lists.newArrayListWithExpectedSize((int)data.length);
        ArrayList editData = Lists.newArrayListWithExpectedSize((int)data.length);
        for (ExtendedDataEntity extendedDataEntity2 : data) {
            String excelNumber = extendedDataEntity2.getDataEntity().getString("number");
            if (dataBasePromptMap.containsKey(excelNumber)) {
                editData.add(extendedDataEntity2);
                continue;
            }
            newData.add(extendedDataEntity2);
        }
        ExtendedDataEntity[] newDataArray = newData.toArray(new ExtendedDataEntity[0]);
        PromptImportSaveValidator.handleEAC(newDataArray);
        this.validateNewData(newDataArray);
        this.validateEditData(editData.toArray(new ExtendedDataEntity[0]), dataBasePromptMap);
    }

    private void validateNewData(ExtendedDataEntity[] data) {
        for (ExtendedDataEntity extendedDataEntity : data) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!Objects.equals(dataEntity.getString("selectcontent"), "2")) {
                this.showErrorMsg(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u7684\u201c\u542f\u7528\u6587\u6848\u201d\u53ea\u80fd\u9009\u62e9\u201c\u81ea\u5b9a\u4e49\u6587\u6848\u201d\u3002", (String)"PromptSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), new Object[0]);
                continue;
            }
            this.validateExcelData(extendedDataEntity, dataEntity);
        }
    }

    private void validateEditData(ExtendedDataEntity[] data, Map<String, DynamicObject> dataBasePromptMap) {
        for (ExtendedDataEntity extendedDataEntity : data) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject dataBaseDy = dataBasePromptMap.get(dataEntity.getString("number"));
            if (!Objects.equals(dataEntity.getString("businessobject.id"), dataBaseDy.getString("businessobject.id"))) {
                this.showErrorMsg(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u7684\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"PromptSaveValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), new Object[0]);
                continue;
            }
            if (!Objects.equals(dataEntity.getString("app.id"), dataBaseDy.getString("app.id"))) {
                this.showErrorMsg(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u7684\u5e94\u7528\u7f16\u7801\u4e3a\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PromptSaveValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), new Object[0]);
                continue;
            }
            if (!Objects.equals(dataEntity.getString("cloud.id"), dataBaseDy.getString("cloud.id"))) {
                this.showErrorMsg(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u7684\u5e94\u7528\u7f16\u7801\u4e3a\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PromptSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), new Object[0]);
                continue;
            }
            boolean isSysPre = dataBaseDy.getBoolean("issyspreset");
            if (isSysPre || Objects.equals(dataEntity.getString("selectcontent"), "2")) continue;
            this.showErrorMsg(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u7684\u201c\u542f\u7528\u6587\u6848\u201d\u53ea\u80fd\u9009\u62e9\u201c\u81ea\u5b9a\u4e49\u6587\u6848\u201d\u3002", (String)"PromptSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    private void validateExcelData(ExtendedDataEntity dataEntity, DynamicObject dy) {
        PromptImportSaveValidator.getPredicateToDo(dy, dataEntity, param -> Objects.nonNull(param.get("app")) && !HRStringUtils.equals((String)this.getCloudId(param.getDynamicObject("app").getString("id")), (String)param.getString("cloud.id")), dataDy -> this.showErrorMsg((ExtendedDataEntity)dataDy, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e91\u4e0b\u4e0d\u5b58\u5728\u201c%2$s\u201d\u5e94\u7528\u3002", (String)"PromptSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), Objects.nonNull(dy.get("cloud.name")) ? dy.getLocaleString("cloud.name").getLocaleValue() : " ", dy.getLocaleString("app.name").getLocaleValue()));
        PromptImportSaveValidator.getPredicateToDo(dy, dataEntity, param -> Objects.nonNull(param.get("businessobject")) && !HRStringUtils.equals((String)this.getAppID(param.getDynamicObject("businessobject").getString("dentityid")), (String)param.getString("app.id")), dataDy -> this.showErrorMsg((ExtendedDataEntity)dataDy, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5e94\u7528\u4e0b\u4e0d\u5b58\u5728\u201c%2$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"PromptSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), Objects.nonNull(dy.get("app.name")) ? dy.getLocaleString("app.name").getLocaleValue() : " ", dy.getLocaleString("businessobject.name").getLocaleValue()));
    }

    private String getCloudId(String appID) {
        if (this.appIdCloudIdMap.containsKey(appID)) {
            return this.appIdCloudIdMap.get(appID);
        }
        String cloudId = BizCloudServiceHelp.getBizCloudByAppID((String)appID).getString("id");
        this.appIdCloudIdMap.put(appID, cloudId);
        return cloudId;
    }

    private String getAppID(String formID) {
        if (this.form2AppIdMap.containsKey(formID)) {
            return this.form2AppIdMap.get(formID);
        }
        String appId = BizAppServiceHelp.getBizAppByFormID((String)formID).getString("id");
        this.form2AppIdMap.put(formID, appId);
        return appId;
    }

    private void showErrorMsg(ExtendedDataEntity dataEntity, String msg, Object ... params) {
        this.addErrorMessage(dataEntity, String.format(Locale.ROOT, msg, params));
    }

    private static <T, R> void getPredicateToDo(T judgeParam, R handleObj, Predicate<T> pred, Consumer<R> consumer) {
        if (pred.test(judgeParam)) {
            consumer.accept(handleObj);
        }
    }

    private static void handleEAC(ExtendedDataEntity[] data) {
        HashSet entityIdSet = Sets.newHashSetWithExpectedSize((int)data.length);
        for (ExtendedDataEntity dataEntity : data) {
            DynamicObject busObj = dataEntity.getDataEntity().getDynamicObject("businessobject");
            if (busObj == null) continue;
            entityIdSet.add(busObj.getString("dentityid"));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_formmeta");
        DynamicObject[] results = serviceHelper.query("id,number,masterid", new QFilter[]{new QFilter("id", "in", (Object)entityIdSet)});
        Map<String, String> masterIdMap = Arrays.stream(results).collect(Collectors.toMap(result -> result.getString("id"), result -> result.getString("masterid")));
        entityIdSet.addAll(masterIdMap.values());
        HRBaseServiceHelper serviceHelper2 = new HRBaseServiceHelper("hbp_entityobject");
        DynamicObject[] results2 = serviceHelper2.query("id,number,dentityid,bizappid,bizappid.bizcloud", new QFilter[]{new QFilter("dentityid", "in", (Object)entityIdSet)});
        Map<String, DynamicObject> entityMap = Arrays.stream(results2).collect(Collectors.toMap(result -> result.getString("dentityid"), result -> result));
        for (ExtendedDataEntity dataEntity : data) {
            DynamicObject cloud = dataEntity.getDataEntity().getDynamicObject("cloud");
            DynamicObject app = dataEntity.getDataEntity().getDynamicObject("app");
            DynamicObject busObj = dataEntity.getDataEntity().getDynamicObject("businessobject");
            if (busObj != null) {
                String entityId = busObj.getString("dentityid");
                String masterId = masterIdMap.get(entityId);
                if (!StringUtils.isEmpty((CharSequence)masterId)) {
                    dataEntity.getDataEntity().set("businessobject", (Object)entityMap.get(masterId));
                }
                if (app == null) {
                    dataEntity.getDataEntity().set("app", (Object)entityMap.get(entityId).getDynamicObject("bizappid"));
                }
                if (cloud != null) continue;
                dataEntity.getDataEntity().set("cloud", (Object)entityMap.get(entityId).getDynamicObject("bizappid.bizcloud"));
                continue;
            }
            if (app == null || cloud != null) continue;
            dataEntity.getDataEntity().set("cloud", (Object)app.getDynamicObject("bizcloud"));
        }
    }
}

