/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class RetentionConfigEnableValidator
extends HRDataBaseValidator {
    public void validate() {
        if (Objects.equals("enable", this.getOperateKey())) {
            String oneErrorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\u3002", (String)"RetentionConfigEnableValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
            this.validateEnable(oneErrorMsg, true);
        } else if (Objects.equals("disable", this.getOperateKey())) {
            String oneErrorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\u3002", (String)"RetentionConfigEnableValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
            this.validateEnable(oneErrorMsg, false);
        }
    }

    private void validateEnable(String oneErrorMsg, boolean isEnable) {
        String status;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String string = status = isEnable ? "1" : "0";
        if (dataEntities.length == 1) {
            String enable = dataEntities[0].getDataEntity().getString("enable");
            if (Objects.equals(status, enable)) {
                this.addErrorMessage(dataEntities[0], oneErrorMsg);
            }
        } else {
            ValidateResult validateResult = this.getValidateResult();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dyn = dataEntity.getDataEntity();
                if (!Objects.equals(status, dyn.getString("enable"))) continue;
                String multiErrorMsg = isEnable ? ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u542f\u7528\u3002", (String)"RetentionConfigEnableValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{dyn.getString("role.number")}) : ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7981\u7528\u3002", (String)"RetentionConfigEnableValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{dyn.getString("role.number")});
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", dyn.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", this.getOperationName(), multiErrorMsg, ErrorLevel.Error);
                errorInfo.setEntityKey(this.getEntityKey());
                errorInfo.setSubRowIndex(dataEntity.getSubRowIndex());
                validateResult.addErrorInfo((OperateErrorInfo)errorInfo);
                this.getFalseDataEntities().add(dataEntity);
            }
        }
    }
}

