/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hrcs.bussiness.servicehelper.econtract.KeywordMappingServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class TplVariableConfigValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.checkSaveData(dataEntityArr);
        } else if (HRStringUtils.equals((String)operationKey, (String)"deleteentity")) {
            this.checkDeleteDataByVariable(dataEntityArr);
        }
    }

    private void checkSaveData(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)extendedDataEntity.getValue("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u3002", (String)"TplVariableConfigPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject object : dynamicObjectCollection) {
                if (HRStringUtils.isEmpty((String)((String)object.get("parentfieldname")))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7236\u5b9e\u4f53\u5b57\u6bb5\u201d\uff1a\u201c\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u8bbe\u7f6e\u201d\u7b2c%1$s\u884c\u3002", (String)"TplVariableConfigValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), object.get("seq")));
                }
                if (!HRStringUtils.isEmpty((String)((String)object.get("sonfieldname")))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b50\u5b9e\u4f53\u5b57\u6bb5\u201d\uff1a\u201c\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u8bbe\u7f6e\u201d\u7b2c%1$s\u884c\u3002", (String)"TplVariableConfigValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), object.get("seq")));
            }
        }
    }

    private void checkDeleteDataByVariable(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            DynamicObject dy = extendedDataEntity.getDataEntity();
            HRBaseServiceHelper keyMappingHelp = new HRBaseServiceHelper("hrcs_commonvariable");
            DynamicObject[] query = keyMappingHelp.query("relateentityid", new QFilter[0]);
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            this.checkVariableMapping(extendedDataEntity, resultMap, dy, query);
        }
    }

    private void checkVariableMapping(ExtendedDataEntity extendedDataEntity, HashMap<String, HashMap<Long, List<String>>> resultMap, DynamicObject dy, DynamicObject[] query) {
        DynamicObject[] entityByParentId;
        String finalName;
        Long pkValue = (Long)dy.getPkValue();
        ArrayList tempList = Lists.newArrayListWithCapacity((int)16);
        String isEntry = dy.getString("isentry");
        if (HRStringUtils.isNotEmpty((String)isEntry) && HRStringUtils.equals((String)isEntry, (String)"1")) {
            DynamicObject[] entryNumber = dy.getString("entrynumber");
            String[] split = entryNumber.split("\\.");
            finalName = this.getEntryName(split[0], split[1]);
        } else {
            finalName = dy.getDynamicObject("sonentity").getLocaleString("name").getLocaleValue();
        }
        for (DynamicObject dynamicObject : query) {
            long relateentityid = dynamicObject.getLong("relateentityid");
            if (relateentityid != pkValue) continue;
            tempList.add("\u201d" + dynamicObject.getLocaleString("name").getLocaleValue() + "\u201c");
        }
        if (tempList.size() > 0) {
            String join = String.join((CharSequence)"\u3001", tempList);
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u5220\u9664\u5931\u8d25\uff0c\u5e38\u7528\u53d8\u91cf%2$s\u7684\u53d6\u503c\u89c4\u5219\u4e2d\u4f7f\u7528\u4e86\u6b64\u5bf9\u8c61\u3002", (String)"TplVariableConfigValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), finalName, join));
        }
        if ((entityByParentId = KeywordMappingServiceHelper.findEntityByParentId((long)pkValue)) == null || entityByParentId.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : entityByParentId) {
            this.checkVariableMapping(extendedDataEntity, resultMap, dynamicObject, query);
        }
    }

    private String getEntryName(String formNumber, String entryProperty) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formNumber);
        String entityName = dataEntityType.getDisplayName().getLocaleValue();
        DynamicProperty property = dataEntityType.getProperty(entryProperty);
        String localeValue = property.getDisplayName().getLocaleValue();
        return entityName + "." + localeValue;
    }
}

