/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.api;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRListUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class MsgApiValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("delete".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            Set<Long> apiIds = Stream.of(dataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            Set<Long> usedApiIds = this.checkApiIsUsed(apiIds);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                long apiId = dataEntity.getDataEntity().getLong("id");
                if (!usedApiIds.contains(apiId)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5API\u5df2\u88ab\u53d1\u5e03\u4e2d\u5fc3\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MsgApiValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private Set<Long> checkApiIsUsed(Collection<Long> apiIds) {
        HashSet allRefIds = Sets.newHashSetWithExpectedSize((int)16);
        if (Objects.isNull(apiIds) || apiIds.isEmpty()) {
            return allRefIds;
        }
        DBRoute hmp = new DBRoute("hmp");
        String selectPubApiSql = "select fapisourceid as \"apiId\" from t_hrcs_msgpublishapi where fapisourceid in (" + HRListUtils.getListInSqlPlaceholder(new ArrayList<Long>(apiIds)) + ")";
        Set pubApiSet = (Set)HRDBUtil.query((DBRoute)hmp, (String)selectPubApiSql, (Object[])apiIds.toArray(), rs -> {
            HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
            while (rs.next()) {
                idSet.add(rs.getLong("apiId"));
            }
            return idSet;
        });
        if (!pubApiSet.isEmpty()) {
            allRefIds.addAll(pubApiSet);
        }
        return allRefIds;
    }
}

