/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.flow;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class SystemCapabilityValidator
extends HRDataBaseValidator {
    private static final String FIELD_IN_PARAM = "inparam";
    private static final String FIELD_IN_PARAM_TYPE = "inparamtype";
    private static final String FIELD_IN_PARAM_BIZ_OBJECT = "inparambizobject";
    private static final String FIELD_IN_OBJECT_PROPERTY = "inobjectproperty";
    private static final String FIELD_IN_OBJECT_PROPERTY_NAME = "inobjectpropertyname";
    private static final String FIELD_OUT_PARAM = "outparam";
    private static final String FIELD_OUT_PARAM_TYPE = "outparamtype";
    private static final String FIELD_OUT_PARAM_BIZ_OBJECT = "outparambizobject";
    private static final String PARAM_TYPE_VALUE_BIZ_OBJECT = "bizObject";
    private static final String PARAM_TYPE_VALUE_ENUM = "enum";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if ("save".equals(operateKey)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.checkNull(dataEntity);
                this.checkPropertyField(dataEntity);
            }
        }
    }

    private void checkNull(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection inParams = data.getDynamicObjectCollection(FIELD_IN_PARAM);
        for (int index = 0; index < inParams.size(); ++index) {
            DynamicObject bizObject;
            DynamicObject param = (DynamicObject)inParams.get(index);
            String paramType = param.getString(FIELD_IN_PARAM_TYPE);
            if (PARAM_TYPE_VALUE_ENUM.equals(paramType)) {
                bizObject = param.getDynamicObject(FIELD_IN_PARAM_BIZ_OBJECT);
                if (Objects.isNull(bizObject)) {
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7b2c%1$s\u884c\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u3002", (String)"SystemCapabilityValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), index + 1));
                    return;
                }
                String propertyField = param.getString(FIELD_IN_OBJECT_PROPERTY);
                if (!HRStringUtils.isEmpty((String)propertyField)) continue;
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u7b2c[%1$s]\u884c\u7684\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (String)"SystemCapabilityValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), index + 1));
                return;
            }
            if (!PARAM_TYPE_VALUE_BIZ_OBJECT.equals(paramType) || !Objects.isNull(bizObject = param.getDynamicObject(FIELD_IN_PARAM_BIZ_OBJECT))) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7b2c%1$s\u884c\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u3002", (String)"SystemCapabilityValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), index + 1));
            return;
        }
        DynamicObjectCollection outParams = data.getDynamicObjectCollection(FIELD_OUT_PARAM);
        for (int index = 0; index < outParams.size(); ++index) {
            DynamicObject bizObject;
            DynamicObject param = (DynamicObject)outParams.get(index);
            String paramType = param.getString(FIELD_OUT_PARAM_TYPE);
            if (!PARAM_TYPE_VALUE_BIZ_OBJECT.equals(paramType) || !Objects.isNull(bizObject = param.getDynamicObject(FIELD_OUT_PARAM_BIZ_OBJECT))) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8f93\u51fa\u53c2\u6570\u7b2c%1$s\u884c\u7684\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u662f\u5426\u4e3a\u7a7a\u3002", (String)"SystemCapabilityValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), index + 1));
            return;
        }
    }

    private void checkPropertyField(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection params = data.getDynamicObjectCollection(FIELD_IN_PARAM);
        for (int index = 0; index < params.size(); ++index) {
            DynamicProperty property;
            DynamicObject bizObject;
            DynamicObject param = (DynamicObject)params.get(index);
            String paramType = param.getString(FIELD_IN_PARAM_TYPE);
            if (!PARAM_TYPE_VALUE_ENUM.equals(paramType) || (bizObject = param.getDynamicObject(FIELD_IN_PARAM_BIZ_OBJECT)) == null) continue;
            String metaNumber = bizObject.getString("number");
            String metaName = bizObject.getString("name");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaNumber);
            String propertyField = param.getString(FIELD_IN_OBJECT_PROPERTY);
            if (HRStringUtils.isEmpty((String)propertyField) || !Objects.isNull(property = mainEntityType.getProperty(propertyField))) continue;
            String propertyName = param.getString(FIELD_IN_OBJECT_PROPERTY_NAME);
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u7b2c[%1$s]\u884c\u7684\u5bf9\u8c61\u5c5e\u6027\u5b57\u6bb5[%2$s]\u5728\u4e1a\u52a1\u5bf9\u8c61[%3$s]\u4e2d\u4e0d\u5b58\u5728", (String)"SystemCapabilityValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), index + 1, propertyName, metaName));
            return;
        }
    }
}

