/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.function;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class FunctionTypeValidator
extends HRDataBaseValidator {
    private static final HRBaseServiceHelper FUNCTION_HELPER = new HRBaseServiceHelper("hrcs_function");

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if ("delete".equals(operateKey)) {
            Object[] ids = Stream.of(dataEntities).map(ExtendedDataEntity::getDataEntity).map(DataEntityBase::getPkValue).toArray();
            DynamicObject[] functionIds = FUNCTION_HELPER.queryOriginalArray("id,group.id", new QFilter[]{new QFilter("group.id", "in", (Object)ids)});
            Set<Long> typeIds = Stream.of(functionIds).map(dy -> dy.getLong("group.id")).collect(Collectors.toSet());
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.checkDelete(dataEntity, typeIds);
            }
        }
    }

    private void checkDelete(ExtendedDataEntity dataEntity, Set<Long> typeIds) {
        DynamicObject dy = dataEntity.getDataEntity();
        Long id = (Long)dy.getPkValue();
        if (typeIds.contains(id)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u4e0b\u5b58\u5728\u672a\u5220\u9664\u7684\u51fd\u6570\u914d\u7f6e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8be5\u5206\u7c7b\u3002", (String)"FunctionTypeValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }
}

