/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.servicehelper.label.HRLabelObjectConfigServiceHelper;

public class LabelObjectValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "enablestatus": {
                this.validateEnable(dataEntities);
                break;
            }
            case "disablestatus": {
                this.validateDisable(dataEntities);
                break;
            }
            case "save": {
                this.validateSave(dataEntities);
                break;
            }
        }
    }

    private void validateSave(ExtendedDataEntity[] dataEntities) {
        LabelService labelService = new LabelService();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String condition = dataEntity.getDataEntity().getString("condition");
            List errorInfoList = labelService.validateCondition(condition);
            if (CollectionUtils.isEmpty((Collection)errorInfoList)) continue;
            for (String msg : errorInfoList) {
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void validateEnable(ExtendedDataEntity[] dataEntities) {
        HashMap dataEntityMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        String enableErrMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53ef\u7528\u3002", (String)"LabelObjectValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            if ("1".equals(dyn.getString("publishstatus"))) {
                this.addErrorMessage(dataEntity, enableErrMsg);
                continue;
            }
            dataEntityMap.put(dyn.getLong("id"), dataEntity);
        }
        Map statusMap = HRLabelObjectConfigServiceHelper.getLabelObjectConfigStatus((List)Lists.newArrayList(dataEntityMap.keySet()));
        String errMsg = ResManager.loadKDString((String)"\u5c1a\u672a\u5b8c\u6210\u80fd\u529b\u914d\u7f6e\uff0c\u65e0\u6cd5\u542f\u7528\u3002", (String)"LabelObjectValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
        statusMap.forEach((key, value) -> {
            if (!value.booleanValue()) {
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)dataEntityMap.get(key);
                this.addErrorMessage(extendedDataEntity, errMsg);
            }
        });
    }

    private void validateDisable(ExtendedDataEntity[] dataEntities) {
        String errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\u3002", (String)"LabelObjectValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            if (!"0".equals(dyn.getString("publishstatus"))) continue;
            this.addErrorMessage(dataEntity, errMsg);
        }
    }
}

