/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hrcs.bussiness.service.label.LblStrategyServiceHelper;
import kd.hr.hrcs.common.constants.label.LabelConstants;
import kd.hr.hrcs.common.constants.label.LabelManageConstants;
import kd.hr.hrcs.common.constants.label.LabelTypeEnum;

public class LabelSaveValidator
extends HRDataBaseValidator
implements LabelConstants,
LabelManageConstants {
    private static final Pattern compile = Pattern.compile("^[a-zA-Z0-9_.]+$");

    public void validate() {
        String operKey;
        String isFromForm = "";
        if (this.getOption().containsVariable("isFromForm")) {
            isFromForm = this.getOption().getVariableValue("isFromForm");
        }
        if ("save".equals(operKey = this.getOperateKey()) || "submit".equals(operKey) && HRStringUtils.isNotEmpty((String)isFromForm) && "Y".equals(isFromForm)) {
            ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
            if (!this.checkObjectDuplicate(dataEntityArr)) {
                return;
            }
            this.checkLabelValueDuplicate(dataEntityArr);
            String service = this.getOption().getVariableValue("service");
            String expr = (String)this.getOption().getVariables().get("expression");
            String dataListSize = this.getOption().getVariableValue("dataListSize");
            for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String configType = dataEntity.getString("configtype");
                String type = dataEntity.getString("type");
                if (LabelTypeEnum.FACT.getType().equals(type)) {
                    int size = Integer.parseInt(dataListSize);
                    if (size == 0) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u7b7e\u503c\u57df\u201d\u3002", (String)"LabelSaveValidator_11", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                    } else {
                        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentitylabelvalue");
                        for (int i = 0; i < size; ++i) {
                            if (i + 1 <= entryEntity.size()) continue;
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u7b7e\u503c\u57df\u201d\u7b2c%s\u884c\uff1a\u201c\u6807\u7b7e\u503c\u89c4\u5219\u540d\u79f0\u201d\u3002", (String)"LabelSaveValidator_12", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{i + 1}));
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u7b7e\u503c\u57df\u201d\u7b2c%s\u884c\uff1a\u201c\u6807\u7b7e\u503c\u89c4\u5219\u91ca\u4e49\u201d\u3002", (String)"LabelSaveValidator_13", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{i + 1}));
                            entryEntity.addNew();
                        }
                    }
                    if ("2".equals(configType)) {
                        Map serviceGroupMap = (Map)SerializationUtils.fromJsonString((String)service, Map.class);
                        this.checkService(extendedDataEntity, serviceGroupMap);
                        continue;
                    }
                    this.checkExpr(extendedDataEntity, expr);
                    continue;
                }
                this.checkEmpty(extendedDataEntity);
            }
        }
    }

    private void checkEmpty(ExtendedDataEntity extendedDataEntity) {
        DynamicObjectCollection entry = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entryentitylabelvalue");
        if (entry.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u7b7e\u503c\u57df\u201d\u3002", (String)"LabelSaveValidator_11", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkObjectDuplicate(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            Set labelObjectSet;
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)extendedDataEntity.getDataEntity().get("entryentityrange");
            if (dynamicObjectCollection == null || (labelObjectSet = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getLong("labelobject_id")).collect(Collectors.toSet())).size() == dynamicObjectCollection.size()) continue;
            String errMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u7684\u6253\u6807\u5bf9\u8c61\u3002", (String)"LabelSaveValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, errMsg);
            return false;
        }
        return true;
    }

    private void checkLabelValueDuplicate(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            Set labelValueSet;
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)extendedDataEntity.getDataEntity().get("entryentitylabelvalue");
            if (dynamicObjectCollection == null || (labelValueSet = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getString("labelvalue")).collect(Collectors.toSet())).size() == dynamicObjectCollection.size()) continue;
            String errMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u7684\u6807\u7b7e\u503c\u3002", (String)"LabelSaveValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, errMsg);
            return;
        }
    }

    private void checkExpr(ExtendedDataEntity dataEntityArr, String expr) {
        DynamicObjectCollection entryEntity = dataEntityArr.getDataEntity().getDynamicObjectCollection("entryentitylabelvalue");
        DynamicObjectCollection entryEntityRange = dataEntityArr.getDataEntity().getDynamicObjectCollection("entryentityrange");
        if (HRStringUtils.isEmpty((String)expr)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                ArrayList emptyList = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
                for (DynamicObject lblObj : entryEntityRange) {
                    String langLblObjName = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"LabelSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{lblObj.getString("labelobject.name")});
                    emptyList.add(langLblObjName);
                }
                String name = ResManager.loadKDString((String)"\u3001", (String)"LabelSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
                String join = String.join((CharSequence)name, emptyList);
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u6807\u7b7e\u503c\u57df\u201d\u7b2c%1$s\u884c\uff1a%2$s\u5bf9\u8c61\u7684\u201c\u6807\u7b7e\u503c\u89c4\u5219\u201d\u3002", (String)"LabelSaveValidator_10", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), i + 1, join);
                this.addErrorMessage(dataEntityArr, msg);
            }
        } else {
            Map exprMap = (Map)SerializationUtils.fromJsonString((String)expr, Map.class);
            for (int i = 0; i < entryEntity.size(); ++i) {
                ArrayList emptyList = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
                Map sonMap = (Map)exprMap.get(i + "");
                if (sonMap == null) {
                    for (DynamicObject lblObj : entryEntityRange) {
                        String langLblObjName = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"LabelSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{lblObj.getString("labelobject.name")});
                        emptyList.add(langLblObjName);
                    }
                } else {
                    for (DynamicObject lblObj : entryEntityRange) {
                        Map exprData = (Map)sonMap.get(lblObj.getString("labelobject.id"));
                        String langLblObjName = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"LabelSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{lblObj.getString("labelobject.name")});
                        if (!CollectionUtils.isEmpty((Map)exprData)) continue;
                        emptyList.add(langLblObjName);
                    }
                }
                if (emptyList.isEmpty()) continue;
                String name = ResManager.loadKDString((String)"\u3001", (String)"LabelSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
                String join = String.join((CharSequence)name, emptyList);
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u6807\u7b7e\u503c\u57df\u201d\u7b2c%1$s\u884c\uff1a%2$s\u5bf9\u8c61\u7684\u201c\u6807\u7b7e\u503c\u89c4\u5219\u201d\u3002", (String)"LabelSaveValidator_10", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), i + 1, join);
                this.addErrorMessage(dataEntityArr, msg);
            }
        }
    }

    private void checkService(ExtendedDataEntity dataEntityArr, Map<String, Map<String, String>> serviceGroupMap) {
        DynamicObject dynamicObject = dataEntityArr.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentitylabelvalue");
        DynamicObjectCollection entryEntityRange = dynamicObject.getDynamicObjectCollection("entryentityrange");
        HashMap appNumMap = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            Object msg;
            String join;
            String name;
            ArrayList matcherList = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
            ArrayList emptyList = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
            ArrayList serviceErrorList = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
            Map<String, String> sonGroup = serviceGroupMap.get(i + "");
            if (sonGroup == null) {
                for (DynamicObject lblObj : entryEntityRange) {
                    String langLblObjName = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"LabelSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{lblObj.getString("labelobject.name")});
                    emptyList.add(langLblObjName);
                }
            } else {
                for (DynamicObject lblObj : entryEntityRange) {
                    String service = sonGroup.get(lblObj.getString("labelobject.id"));
                    String langLblObjName = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"LabelSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{lblObj.getString("labelobject.name")});
                    if (HRStringUtils.isEmpty((String)service)) {
                        emptyList.add(langLblObjName);
                        continue;
                    }
                    Matcher matcher = compile.matcher(service);
                    if (!matcher.find()) {
                        matcherList.add(langLblObjName);
                        continue;
                    }
                    int index = service.indexOf(".");
                    if (index == -1) {
                        serviceErrorList.add(langLblObjName);
                        continue;
                    }
                    appNumMap.put(lblObj.getString("labelobject.name"), service.substring(0, index));
                }
            }
            if (!emptyList.isEmpty()) {
                name = ResManager.loadKDString((String)"\u3001", (String)"LabelSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
                join = String.join((CharSequence)name, emptyList);
                msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u7b7e\u503c\u57df\u201d\u7b2c%1$s\u884c\uff1a%2$s\u5bf9\u8c61\u7684\u201c\u6807\u7b7e\u503c\u89c4\u5219\u670d\u52a1\u7c7b\u201d\u3002", (String)"LabelSaveValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), i + 1, join);
                this.addErrorMessage(dataEntityArr, (String)msg);
            }
            if (!matcherList.isEmpty()) {
                name = ResManager.loadKDString((String)"\u3001", (String)"LabelSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
                join = String.join((CharSequence)name, matcherList);
                msg = String.format(ResManager.loadKDString((String)"\u201c\u6807\u7b7e\u503c\u57df\u201d\u7b2c%1$s\u884c\uff1a%2$s\u5bf9\u8c61\u7684\u6807\u7b7e\u503c\u89c4\u5219\u670d\u52a1\u7c7b\u683c\u5f0f\u9519\u8bef\uff0c\u4ec5\u652f\u6301\u8f93\u5165\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u6216\u201c.\u201d\u3002", (String)"LabelSaveValidator_8", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), i + 1, join);
                this.addErrorMessage(dataEntityArr, (String)msg);
            }
            DynamicObject[] bizApps = LblStrategyServiceHelper.getBizApps((Set)Sets.newHashSet(appNumMap.values()));
            Set appNumSet = Arrays.stream(bizApps).map(ba -> ba.getString("number")).collect(Collectors.toSet());
            for (Map.Entry entry : appNumMap.entrySet()) {
                if (appNumSet.contains(entry.getValue())) continue;
                serviceErrorList.add(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"LabelSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{entry.getKey()}));
            }
            if (serviceErrorList.isEmpty()) continue;
            String name2 = ResManager.loadKDString((String)"\u3001", (String)"LabelSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
            String join2 = String.join((CharSequence)name2, serviceErrorList);
            String msg2 = String.format(ResManager.loadKDString((String)"\u201c\u6807\u7b7e\u503c\u57df\u201d\u7b2c%1$s\u884c\uff1a%2$s\u5bf9\u8c61\u7684\u6807\u7b7e\u503c\u89c4\u5219\u670d\u52a1\u7c7b\u9519\u8bef\uff0c\u8bf7\u6309\u89c4\u8303\u201c\u670d\u52a1\u7c7b\u6240\u5c5e\u5e94\u7528\u7f16\u7801.\u670d\u52a1\u7c7b\u540d\u201d\u586b\u5199\u3002", (String)"LabelSaveValidator_9", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), i + 1, join2);
            this.addErrorMessage(dataEntityArr, msg2);
        }
    }
}

