/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.label;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;

public class LabelStrategyValidator
extends HRDataBaseValidator
implements LblStrategyConstants {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey)) {
            ExtendedDataEntity dataEntity = this.getDataEntities()[0];
            String workType = dataEntity.getDataEntity().getString("worktype");
            if ("0".equals(workType)) {
                this.validateSaveWithRule(dataEntity);
            }
        } else if ("enable".equals(operateKey)) {
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                String name;
                DynamicObject dyn = dataEntity.getDataEntity();
                String labelEnable = dyn.getString("label.enable");
                String labelObjEnable = dyn.getString("labelobject.publishstatus");
                ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)2);
                if ("0".equals(labelEnable)) {
                    name = dyn.getString("label.name");
                    errMsgList.add(ResManager.loadKDString((String)"\u201c%s\u201d\u6807\u7b7e", (String)"LabelStrategyValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{name}));
                }
                if ("0".equals(labelObjEnable)) {
                    name = dyn.getString("labelobject.name");
                    errMsgList.add(ResManager.loadKDString((String)"\u201c%s\u201d\u6253\u6807\u5bf9\u8c61", (String)"LabelStrategyValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{name}));
                }
                if (errMsgList.isEmpty()) continue;
                String join = String.join((CharSequence)ResManager.loadKDString((String)"\u3001", (String)"LabelStrategyValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), errMsgList);
                String errMsg = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u6b64\u6253\u6807\u7b56\u7565\u5173\u8054\u7684%s\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u6b64\u7b56\u7565\u3002", (String)"LabelStrategyValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{join});
                this.addErrorMessage(dataEntity, errMsg);
            }
        }
    }

    private void validateSaveWithRule(ExtendedDataEntity dataEntity) {
        String hrFilterValue = (String)this.getOption().getVariables().get("filterValue");
        if (!HRStringUtils.isEmpty((String)hrFilterValue)) {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)hrFilterValue, Map.class);
            DynamicObject dyn = dataEntity.getDataEntity();
            long lblObjId = dyn.getLong("labelobject.id");
            DynamicObject lblObjConfig = LabelObjectServiceHelper.getLblObjConfig((Long)lblObjId);
            DynamicObjectCollection fieldCol = lblObjConfig.getDynamicObjectCollection("conditionentryentity");
            for (DynamicObject field : fieldCol) {
                String key = field.getString("ruleentitynumberalias") + "." + field.getString("rulefieldnumber");
                if (valueMap.containsKey(key)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6253\u6807\u8303\u56f4\u5708\u5b9a\u7ef4\u5ea6\u5df2\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6253\u6807\u5bf9\u8c61\u518d\u4fdd\u5b58\u3002", (String)"LabelStrategyValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                break;
            }
            if (fieldCol.size() != valueMap.size()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6253\u6807\u8303\u56f4\u5708\u5b9a\u7ef4\u5ea6\u5df2\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6253\u6807\u5bf9\u8c61\u518d\u4fdd\u5b58\u3002", (String)"LabelStrategyValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

