/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import org.apache.commons.collections.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class DynaFormCtrlSaveValidator
extends HRDataBaseValidator {
    private static final Pattern CHINESE_WORD_PATTERN = Pattern.compile("^[0-9a-zA-Z_.!\u03b4]{1,}$");

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(dataEntityArr);
        }
    }

    private void canSave(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity extendDataEntity : dataEntityArr) {
            Object propKey2;
            DynamicObject dataEntity = extendDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            List newPropKeys = entryEntity.stream().filter(it -> HRStringUtils.isNotEmpty((String)it.getString("propkey")) && HRStringUtils.isNotEmpty((String)it.getString("propname"))).map(it -> it.getString("propkey")).collect(Collectors.toList());
            for (Object propKey2 : newPropKeys) {
                if (!this.regexNumberContainChan((String)propKey2)) {
                    this.addErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u8f93\u5165\u5185\u5bb9\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u3001\u4e0b\u5212\u7ebf\u4ee5\u53ca\u53e5\u53f7\u5916\u7684\u7279\u6b8a\u5b57\u7b26\u3002", (String)"DynaFormCtrlDelAndSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                    break;
                }
                if (((String)propKey2).split("\\.").length <= 3) continue;
                this.addErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5173\u8054\u4e24\u5c42\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u3002", (String)"DynaFormCtrlDelAndSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                break;
            }
            ArrayList rowIds = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
            propKey2 = entryEntity.iterator();
            while (propKey2.hasNext()) {
                DynamicObject row = (DynamicObject)propKey2.next();
                String bdTypeId = row.getString("bdtype.id");
                Object bucafunc = row.get("bucafunc");
                if (!HRStringUtils.equals((String)"bos_org", (String)bdTypeId) || null != bucafunc) continue;
                rowIds.add(row.getInt("seq"));
            }
            if (!CollectionUtils.isNotEmpty((Collection)rowIds)) continue;
            String rowStr = rowIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.addErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e3a\u4e1a\u52a1\u5355\u5143\uff0c\u8bf7\u9009\u62e9\u5bf9\u5e94\u804c\u80fd\u3002", (String)"DynaFormCtrlDelAndSaveValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{rowStr}));
        }
    }

    private boolean regexNumberContainChan(String str) {
        Matcher isNum = CHINESE_WORD_PATTERN.matcher(str);
        return isNum.find();
    }
}

