/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.perm.dyna;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hrcs.bussiness.servicehelper.perm.dyna.DynaAuthSchemeServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class DynaAuthSchemeValidator
extends HRDataBaseValidator {
    private List<String> validOperationKeys = Lists.newArrayList((Object[])new String[]{"delete", "setadminrange", "disable", "enable", "submit", "unsubmit", "audit"});

    public void validate() {
        long schemeId;
        HRBaseServiceHelper serviceHelper;
        boolean exists;
        super.validate();
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        Set operationalSchemes = DynaAuthSchemeServiceHelper.queryOperationalSchemes();
        if (HRStringUtils.equals((String)"save", (String)operationKey) || HRStringUtils.equals((String)"submit", (String)operationKey) || HRStringUtils.equals((String)"changesave", (String)operationKey) || HRStringUtils.equals((String)"auditconfirmchange", (String)operationKey)) {
            for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
                this.validateSceneRequired(extendedDataEntity);
            }
        }
        if (HRStringUtils.equals((String)"submit", (String)operationKey) && dataEntityArr.length == 1 && !(exists = (serviceHelper = new HRBaseServiceHelper("hrcs_dynascheme")).isExists((Object)(schemeId = dataEntityArr[0].getDataEntity().getLong("id"))))) {
            return;
        }
        if (this.validOperationKeys.contains(operationKey)) {
            for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String adminGroupName = dataEntity.getString("admingroup.name");
                long schemeId2 = dataEntity.getLong("boid");
                if (operationalSchemes.contains(schemeId2)) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u60a8\u4e0d\u662f%s\u7684\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u7ef4\u62a4\u5f53\u524d\u52a8\u6001\u6388\u6743\u65b9\u6848\u3002", (String)"DynaAuthSchemeValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{adminGroupName}));
            }
        }
    }

    private void validateSceneRequired(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String authAction = dataEntity.getString("authaction");
        int assignSceneEntrySize = dataEntity.getDynamicObjectCollection("assignsceneentry").size();
        int cancelSceneEntrySize = dataEntity.getDynamicObjectCollection("cancelsceneentry").size();
        if (HRStringUtils.equals((String)"1", (String)authAction)) {
            if (assignSceneEntrySize <= 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u914d\u6388\u6743\u573a\u666f\u3002", (String)"DynaAuthSchemeValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)"2", (String)authAction)) {
            if (cancelSceneEntrySize <= 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d6\u6d88\u6388\u6743\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DynaAuthSchemeValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
        } else if (assignSceneEntrySize <= 0 && cancelSceneEntrySize <= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u914d\u6216\u53d6\u6d88\u6388\u6743\u7684\u573a\u666f\u3002", (String)"DynaAuthSchemeValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        } else {
            if (assignSceneEntrySize <= 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u914d\u6388\u6743\u573a\u666f\u3002", (String)"DynaAuthSchemeValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
            if (cancelSceneEntrySize <= 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d6\u6d88\u6388\u6743\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DynaAuthSchemeValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

