/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.privacy;

import java.text.MessageFormat;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class RetentionConfigValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.checkRetentionPeriod(dataEntityArr);
        }
    }

    private void checkRetentionPeriod(ExtendedDataEntity[] dataEntityArr) {
        Integer minRetentionPeriod;
        Map paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(RequestContext.get().getOrgId())));
        if (paramsMap != null && (minRetentionPeriod = (Integer)paramsMap.get("minretentionperiod")) != null) {
            for (ExtendedDataEntity dataEntity : dataEntityArr) {
                DynamicObject privacySaveDy = dataEntity.getDataEntity();
                DynamicObjectCollection coll = privacySaveDy.getDynamicObjectCollection("entryentity");
                for (int index = 0; index < coll.size(); ++index) {
                    DynamicObject retentionPeriodDy = (DynamicObject)coll.get(index);
                    int period = retentionPeriodDy.getInt("retentionperiod");
                    if (period >= minRetentionPeriod) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u7b2c{0}\u884c\u7684\u7559\u5b58\u671f\u201c{1}\u201d\u4e0d\u80fd\u5c0f\u4e8e\u7cfb\u7edf\u5141\u8bb8\u7684\u6700\u5c0f\u7559\u5b58\u671f\u201c{2}\u201d\u4e2a\u6708\u3002", index + 1, period, minRetentionPeriod), (String)"RetentionConfigValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

