/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import org.apache.commons.lang3.StringUtils;

public class MsgCenterPubAndSaveOp
extends HRDataBaseOp {
    private static String API_ENTRY_ENTITY = "apientryentity";
    private static String HRCS_PUBMSGLOG = "hrcs_pubmsglog";
    private static String API_OPERATE_TYPE = "apiopertype";
    private static String STATUS = "status";
    private static String PUBLISH_DATE = "publishdate";
    private static String OFFLINE_DATE = "offlinedate";
    private static String API_ENABLE = "apienable";
    private static String API_NUMBER = "apinumber";
    private static String API_NAME = "apiname";
    private static String API_DESCRIPTION = "apidescription";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("pubstatus");
        fieldKeys.add(STATUS);
        fieldKeys.add(PUBLISH_DATE);
        fieldKeys.add(OFFLINE_DATE);
        fieldKeys.add(API_ENTRY_ENTITY);
        fieldKeys.add("apientryentity.apienable");
        fieldKeys.add("apientryentity.apipubstatus");
        fieldKeys.add("apientryentity.apisource");
        fieldKeys.add("apientryentity.apipubstatus");
        fieldKeys.add("apientryentity.apinumber");
        fieldKeys.add("apientryentity.apiname");
        fieldKeys.add("apientryentity.apidescription");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dys = args.getDataEntities();
        this.savePubStatus(dys);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter qfFilter = new QFilter("id", "=", dys[0].get("id"));
        DynamicObject[] dbObj = helper.query(new QFilter[]{qfFilter});
        if (dbObj.length == 0) {
            this.addMsgLog(dys, "A");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                String operationKey;
                ExtendedDataEntity[] datas = this.getDataEntities();
                switch (operationKey = this.getOperateKey()) {
                    case "saveandpub": {
                        DynamicObject dy = datas[0].getDataEntity();
                        String number = dy.getString("number");
                        this.addErrorMsg(datas, number);
                        break;
                    }
                }
            }

            private void addErrorMsg(ExtendedDataEntity[] datas, String number) {
                if (MsgCenterPubAndSaveOp.this.regexNumberContainChan(number)) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u53d1\u5e03\u7f16\u7801\u53ea\u80fd\u8f93\u5165\u82f1\u6587\u3001\u6570\u5b57\u6216\u7279\u6b8a\u5b57\u7b26\u3002", (String)"MsgCenterPubAndSaveOp_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private boolean regexNumberContainChan(String str) {
        Pattern chieseWordPattern = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher isNum = chieseWordPattern.matcher(str);
        return isNum.find();
    }

    private void addMsgLog(DynamicObject[] dys, String operType) {
        DynamicObjectCollection pubLogDys = new DynamicObjectCollection();
        DynamicObject pubMsgLog = null;
        for (DynamicObject dy : dys) {
            pubMsgLog = BusinessDataServiceHelper.newDynamicObject((String)HRCS_PUBMSGLOG);
            long pkId = DBServiceHelper.genLongIds((String)HRCS_PUBMSGLOG, (int)1)[0];
            pubMsgLog.set("id", (Object)pkId);
            pubMsgLog.set("pubmsg", (Object)dy);
            pubMsgLog.set("msgsender", (Object)RequestContext.get().getCurrUserId());
            pubMsgLog.set("operdate", (Object)new Date());
            DynamicObjectCollection apiLogEntryentity = pubMsgLog.getDynamicObjectCollection("apilogentryentity");
            pubMsgLog.set("opertype", (Object)operType);
            pubMsgLog.set(STATUS, (Object)"C");
            pubMsgLog.set("enable", (Object)1);
            pubMsgLog.set("createtime", (Object)new Date());
            pubMsgLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectCollection apientryentity = dy.getDynamicObjectCollection(API_ENTRY_ENTITY);
            pubLogDys.add((Object)pubMsgLog);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
            QFilter qfFilter = new QFilter("id", "=", dy.get("id"));
            DynamicObject[] dbObj = helper.query("apientryentity.apinumber,apientryentity.apiname,apientryentity.apidescription,apientryentity.actionservice,apientryentity.actionmethod,apientryentity.apipubstatus,apientryentity.apinumber,apientryentity.apiname,apientryentity.apidescription", new QFilter[]{qfFilter});
            if (apientryentity.isEmpty()) continue;
            this.saveApiEntry(operType, apiLogEntryentity, apientryentity, dbObj);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HRCS_PUBMSGLOG);
        serviceHelper.saveOne(pubMsgLog);
    }

    private void saveApiEntry(String operType, DynamicObjectCollection apiLogEntryentity, DynamicObjectCollection apientryentity, DynamicObject[] dbObj) {
        for (int i = 0; i < apientryentity.size(); ++i) {
            DynamicObject apiDy = (DynamicObject)apientryentity.get(i);
            if (dbObj.length != 0) continue;
            this.saveApiEntryByNew(operType, apiLogEntryentity, i, apiDy);
        }
    }

    private void saveApiEntryByNew(String operType, DynamicObjectCollection apiLogEntryentity, int i, DynamicObject apiDy) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)HRCS_PUBMSGLOG);
        EntityType type = (EntityType)mainType.getAllEntities().get("apilogentryentity");
        if (StringUtils.equals((CharSequence)apiDy.getString(API_ENABLE), (CharSequence)"A")) {
            DynamicObject entryItem1 = (DynamicObject)type.createInstance();
            entryItem1.set(API_OPERATE_TYPE, (Object)"D");
            this.addLogs(apiLogEntryentity, i, apiDy, entryItem1);
            DynamicObject entryItem = (DynamicObject)type.createInstance();
            entryItem.set(API_OPERATE_TYPE, (Object)operType);
            this.addLogs(apiLogEntryentity, i, apiDy, entryItem);
        } else if (StringUtils.equals((CharSequence)apiDy.getString(API_ENABLE), (CharSequence)"B")) {
            DynamicObject entryItem1 = (DynamicObject)type.createInstance();
            entryItem1.set(API_OPERATE_TYPE, (Object)"D");
            this.addLogs(apiLogEntryentity, i, apiDy, entryItem1);
            DynamicObject entryItem2 = (DynamicObject)type.createInstance();
            entryItem2.set(API_OPERATE_TYPE, (Object)"A");
            this.addLogs(apiLogEntryentity, i, apiDy, entryItem2);
            DynamicObject entryItem = (DynamicObject)type.createInstance();
            entryItem.set(API_OPERATE_TYPE, (Object)"C");
            this.addLogs(apiLogEntryentity, i, apiDy, entryItem);
        } else {
            DynamicObject entryItem = (DynamicObject)type.createInstance();
            entryItem.set(API_OPERATE_TYPE, (Object)"D");
            this.addLogs(apiLogEntryentity, i, apiDy, entryItem);
        }
    }

    private void addLogs(DynamicObjectCollection apiLogEntryentity, int i, DynamicObject apiDy, DynamicObject entryItem1) {
        entryItem1.set("seq", (Object)i);
        entryItem1.set(API_NUMBER, apiDy.get(API_NUMBER));
        entryItem1.set(API_NAME, apiDy.get(API_NAME));
        entryItem1.set(API_DESCRIPTION, apiDy.get(API_DESCRIPTION));
        apiLogEntryentity.add((Object)entryItem1);
    }

    private void savePubStatus(DynamicObject[] dys) {
        for (DynamicObject dy : dys) {
            dy.set("msgpubno", (Object)dy.getString("number"));
            dy.set("pubstatus", (Object)"P");
            dy.set(PUBLISH_DATE, (Object)new Date());
            dy.set(OFFLINE_DATE, null);
            if (!Objects.isNull(dy.get("puber"))) continue;
            dy.set("puber", (Object)RequestContext.get().getCurrUserId());
        }
    }
}

