/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.opplugin.validator.MsgPublishSaveValidator;
import org.apache.commons.lang3.StringUtils;

public class MsgCenterPublishSaveOp
extends HRDataBaseOp {
    private static final String PUB_STATUS = "pubstatus";
    private static final String PUBER = "puber";
    private static final String PUBLISH_DATE = "publishdate";
    private static final String OFFLINE_DATE = "offlinedate";
    private static final String API_ENTRY_ENTITY = "apientryentity";
    private static final String API_LOG_ENTRY_ENTITY = "apilogentryentity";
    private static final String HRCS_PUB_MSG_LOG = "hrcs_pubmsglog";
    private static final String PUB_MSG = "pubmsg";
    private static final String MSG_SENDER = "msgsender";
    private static final String OPER_DATE = "operdate";
    private static final String OPER_TYPE = "opertype";
    private static final String API_OPER_TYPE = "apiopertype";
    private static final String API_NUMBER = "apinumber";
    private static final String API_NAME = "apiname";
    private static final String API_DESCRIPTION = "apidescription";
    private static final String API_ENABLE = "apienable";
    private static final String API_PUB_STATUS = "apipubstatus";
    private static final String MSG_PUBLISHER = "msgpublisher";
    private static final String FIELD_ACTIONCLOUD_ID = "actioncloud.id";
    private static final String FIELD_ACTIONAPP_ID = "actionapp.id";
    private static final String HRMP_HRCS_OPPLUGIN = "hrmp-hrcs-opplugin";
    private static final String FIELD_MSGPROBO = "msgprobo";
    private static final String FIELD_MODIFYITEM = "modifyitem";
    private static final String FIELD_MODIFYFIELD = "modifyfield";
    private static final String FIELD_BEFOREMODIFY = "beforemodify";
    private static final String FIELD_AFTERMODIFY = "aftermodify";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add(PUB_STATUS);
        fieldKeys.add("status");
        fieldKeys.add(PUBER);
        fieldKeys.add(PUBLISH_DATE);
        fieldKeys.add(OFFLINE_DATE);
        fieldKeys.add("apientryentity.seq");
        fieldKeys.add("apientryentity.issysset");
        fieldKeys.add("apientryentity.apienable");
        fieldKeys.add("apientryentity.apipubstatus");
        fieldKeys.add("apientryentity.apisource");
        fieldKeys.add("apientryentity.apinumber");
        fieldKeys.add("apientryentity.apiname");
        fieldKeys.add("apientryentity.apitype");
        fieldKeys.add("apientryentity.apiservice");
        fieldKeys.add("apientryentity.apimethod");
        fieldKeys.add("apientryentity.apipubcloud");
        fieldKeys.add("apientryentity.apipubapp");
        fieldKeys.add("apientryentity.apidescription");
        fieldKeys.add("apientryentity.params");
        fieldKeys.add("apientryentity.outputtype");
        fieldKeys.add("apientryentity.inputparam");
        fieldKeys.add("apientryentity.outputparam");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new MsgPublishSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        DynamicObject[] dys = args.getDataEntities();
        switch (operationKey) {
            case "pubmsg": {
                this.addMsgLog(dys, "A");
                this.savePubStatus(dys);
                break;
            }
            case "save": {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
                QFilter qfFilter = new QFilter("id", "=", dys[0].get("id"));
                DynamicObject[] dbObj = helper.query(new QFilter[]{qfFilter});
                if (dbObj.length > 0) {
                    this.addMsgLogMod(dys, "B");
                } else {
                    this.addMsgLogAdd(dys);
                }
                DynamicObject pubDy = dys[0];
                pubDy.set("msgpubno", (Object)pubDy.getString("number"));
                this.updateSubApiEntity(pubDy);
                break;
            }
            case "stoppub": {
                this.addMsgLog(dys, "C");
                this.saveStopPubStatus(dys);
                for (DynamicObject dy : dys) {
                    this.updateSubApiEntity(dy);
                }
                break;
            }
            case "delete": {
                this.delMsgLog(dys);
            }
        }
    }

    private void delMsgLog(DynamicObject[] dys) {
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)dys.length);
        for (DynamicObject dynamicObject : dys) {
            ids.add(dynamicObject.getLong("id"));
        }
        HRBaseServiceHelper pubLogServiceHelper = new HRBaseServiceHelper(HRCS_PUB_MSG_LOG);
        QFilter subQfFilter = new QFilter(PUB_MSG, "in", (Object)ids);
        DynamicObject[] result = pubLogServiceHelper.queryOriginalArray("id,pubmsg.id", new QFilter[]{subQfFilter});
        Object[] pks = new Long[result.length];
        for (int i = 0; i < result.length; ++i) {
            pks[i] = result[i].getLong("id");
        }
        pubLogServiceHelper.delete(pks);
    }

    private void addMsgLogAdd(DynamicObject[] dys) {
        DynamicObject pubMsgLog = BusinessDataServiceHelper.newDynamicObject((String)HRCS_PUB_MSG_LOG);
        long pkId = DBServiceHelper.genLongIds((String)HRCS_PUB_MSG_LOG, (int)1)[0];
        this.setLogValue(pubMsgLog, pkId, dys[0], "D");
        DynamicObjectCollection apiLogEntryEntity = pubMsgLog.getDynamicObjectCollection(API_LOG_ENTRY_ENTITY);
        DynamicObjectCollection apiEntryEntity = dys[0].getDynamicObjectCollection(API_ENTRY_ENTITY);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)HRCS_PUB_MSG_LOG);
        EntityType type = (EntityType)mainType.getAllEntities().get(API_LOG_ENTRY_ENTITY);
        for (int i = 0; i < apiEntryEntity.size(); ++i) {
            DynamicObject apiDy = (DynamicObject)apiEntryEntity.get(i);
            this.saveApiEntryByNew(apiLogEntryEntity, type, i, apiDy);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HRCS_PUB_MSG_LOG);
        serviceHelper.saveOne(pubMsgLog);
    }

    private void addMsgLogMod(DynamicObject[] dys, String operatorType) {
        DynamicObject pubMsgLog = null;
        for (DynamicObject dy : dys) {
            pubMsgLog = BusinessDataServiceHelper.newDynamicObject((String)HRCS_PUB_MSG_LOG);
            long pkId = DBServiceHelper.genLongIds((String)HRCS_PUB_MSG_LOG, (int)1)[0];
            this.setLogValue(pubMsgLog, pkId, dy, operatorType);
            DynamicObjectCollection apiLogEntryEntity = pubMsgLog.getDynamicObjectCollection(API_LOG_ENTRY_ENTITY);
            DynamicObjectCollection apiEntryEntity = dy.getDynamicObjectCollection(API_ENTRY_ENTITY);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
            QFilter qfFilter = new QFilter("id", "=", dy.get("id"));
            DynamicObject[] dbObj = helper.query("apientryentity.api,apientryentity,apientryentity.actionservice,apientryentity.actionmethod,apientryentity.apipubstatus,apientryentity.apienable,apientryentity.apinumber,apientryentity.apiname, apientryentity.apidescription", new QFilter[]{qfFilter});
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)dbObj[0].get(API_ENTRY_ENTITY);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)HRCS_PUB_MSG_LOG);
            EntityType type = (EntityType)mainType.getAllEntities().get(API_LOG_ENTRY_ENTITY);
            this.saveDelApiLog(apiEntryEntity, dynamicObjectCollection, apiLogEntryEntity, type);
            if (apiEntryEntity.isEmpty()) continue;
            this.saveApiEntry(dy.getLong("id"), apiLogEntryEntity, apiEntryEntity, dynamicObjectCollection, type);
        }
        this.addModifyLog(dys[0], pubMsgLog);
    }

    private void setLogValue(DynamicObject pubMsgLog, long pkId, DynamicObject dy, String operatorType) {
        pubMsgLog.set("id", (Object)pkId);
        pubMsgLog.set(PUB_MSG, (Object)dy);
        pubMsgLog.set(MSG_SENDER, (Object)RequestContext.get().getCurrUserId());
        pubMsgLog.set(OPER_DATE, (Object)new Date());
        pubMsgLog.set(OPER_TYPE, (Object)operatorType);
        pubMsgLog.set("status", (Object)"C");
        pubMsgLog.set("enable", (Object)1);
        pubMsgLog.set("createtime", (Object)new Date());
        pubMsgLog.set("creator", (Object)RequestContext.get().getCurrUserId());
    }

    private void saveApiEntry(long pubId, DynamicObjectCollection apiLogEntryentity, DynamicObjectCollection apientryentity, DynamicObjectCollection dynamicObjectCollection, EntityType type) {
        for (int i = 0; i < apientryentity.size(); ++i) {
            DynamicObject apiDy = (DynamicObject)apientryentity.get(i);
            if (!this.isExistDB(apiDy, dynamicObjectCollection)) {
                this.saveApiEntryByNew(apiLogEntryentity, type, i, apiDy);
                continue;
            }
            this.saveApiEntryByModify(pubId, apiLogEntryentity, dynamicObjectCollection, type, i, apiDy);
        }
    }

    private void saveApiEntryByModify(long pubId, DynamicObjectCollection apiLogEntryentity, DynamicObjectCollection dynamicObjectCollection, EntityType type, int i, DynamicObject apiDy) {
        String apienable = apiDy.getString(API_ENABLE);
        int status = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String oldApienable = dynamicObject.getString(API_ENABLE);
            if (apiDy.getLong("id") != dynamicObject.getLong("id")) continue;
            status = this.getApiStatus(apienable, oldApienable);
        }
        switch (status) {
            case 1: {
                DynamicObject entryItem1 = (DynamicObject)type.createInstance();
                entryItem1.set(API_OPER_TYPE, (Object)"A");
                this.setEntryItem(i, apiDy, entryItem1);
                apiLogEntryentity.add((Object)entryItem1);
                DynamicObject entryItem2 = (DynamicObject)type.createInstance();
                entryItem2.set(API_OPER_TYPE, (Object)"C");
                this.setEntryItem(i, apiDy, entryItem2);
                apiLogEntryentity.add((Object)entryItem2);
                break;
            }
            case 2: {
                DynamicObject entryItem3 = (DynamicObject)type.createInstance();
                entryItem3.set(API_OPER_TYPE, (Object)"C");
                this.setEntryItem(i, apiDy, entryItem3);
                apiLogEntryentity.add((Object)entryItem3);
                break;
            }
            case 3: {
                DynamicObject entryItem4 = (DynamicObject)type.createInstance();
                entryItem4.set(API_OPER_TYPE, (Object)"A");
                this.setEntryItem(i, apiDy, entryItem4);
                apiLogEntryentity.add((Object)entryItem4);
                break;
            }
        }
    }

    private int getApiStatus(String apienable, String oldApienable) {
        int status = StringUtils.equals((CharSequence)apienable, (CharSequence)oldApienable) ? 0 : (StringUtils.equals((CharSequence)apienable, (CharSequence)"A") ? 3 : (StringUtils.equals((CharSequence)apienable, (CharSequence)"B") ? (StringUtils.equals((CharSequence)oldApienable, (CharSequence)"C") ? 1 : 2) : 0));
        return status;
    }

    private void saveApiEntryByNew(DynamicObjectCollection apiLogEntryentity, EntityType type, int i, DynamicObject apiDy) {
        if (StringUtils.equals((CharSequence)apiDy.getString(API_ENABLE), (CharSequence)"A")) {
            DynamicObject entryItem = (DynamicObject)type.createInstance();
            entryItem.set(API_OPER_TYPE, (Object)"D");
            this.setEntryItem(i, apiDy, entryItem);
            apiLogEntryentity.add((Object)entryItem);
            DynamicObject entryItem1 = (DynamicObject)type.createInstance();
            entryItem1.set(API_OPER_TYPE, (Object)"A");
            this.setEntryItem(i, apiDy, entryItem1);
            apiLogEntryentity.add((Object)entryItem1);
        } else if (StringUtils.equals((CharSequence)apiDy.getString(API_ENABLE), (CharSequence)"C")) {
            DynamicObject entryItem = (DynamicObject)type.createInstance();
            entryItem.set(API_OPER_TYPE, (Object)"D");
            this.setEntryItem(i, apiDy, entryItem);
            apiLogEntryentity.add((Object)entryItem);
        } else if (StringUtils.equals((CharSequence)apiDy.getString(API_ENABLE), (CharSequence)"B")) {
            DynamicObject entryItem1 = (DynamicObject)type.createInstance();
            entryItem1.set(API_OPER_TYPE, (Object)"D");
            this.setEntryItem(i, apiDy, entryItem1);
            apiLogEntryentity.add((Object)entryItem1);
            DynamicObject entryItem2 = (DynamicObject)type.createInstance();
            entryItem2.set(API_OPER_TYPE, (Object)"A");
            this.setEntryItem(i, apiDy, entryItem2);
            apiLogEntryentity.add((Object)entryItem2);
            DynamicObject entryItem = (DynamicObject)type.createInstance();
            entryItem.set(API_OPER_TYPE, (Object)"C");
            this.setEntryItem(i, apiDy, entryItem);
            apiLogEntryentity.add((Object)entryItem);
        }
    }

    private void setEntryItem(int i, DynamicObject apiDy, DynamicObject entryItem1) {
        entryItem1.set("seq", (Object)i);
        entryItem1.set(API_NUMBER, apiDy.get(API_NUMBER));
        entryItem1.set(API_NAME, apiDy.get(API_NAME));
        entryItem1.set(API_DESCRIPTION, apiDy.get(API_DESCRIPTION));
    }

    private void saveDelApiLog(DynamicObjectCollection newApientryentity, DynamicObjectCollection oldDynamicObjectCollection, DynamicObjectCollection apiLogEntryentity, EntityType type) {
        if (oldDynamicObjectCollection.size() > newApientryentity.size()) {
            ArrayList<Long> list1 = new ArrayList<Long>(newApientryentity.size());
            for (DynamicObject newDynamicObject : newApientryentity) {
                list1.add(newDynamicObject.getLong("id"));
            }
            ArrayList<Long> list2 = new ArrayList<Long>(oldDynamicObjectCollection.size());
            for (DynamicObject oldDynamicObject : oldDynamicObjectCollection) {
                list2.add(oldDynamicObject.getLong("id"));
            }
            list2.removeAll(list1);
            this.addList(oldDynamicObjectCollection, apiLogEntryentity, type, list2);
        }
    }

    private void addList(DynamicObjectCollection oldDynamicObjectCollection, DynamicObjectCollection apiLogEntryentity, EntityType type, List<Long> list2) {
        for (Long id : list2) {
            for (DynamicObject oldDynamicObject : oldDynamicObjectCollection) {
                if (oldDynamicObject.getLong("id") != id.longValue()) continue;
                DynamicObject entryItem = (DynamicObject)type.createInstance();
                entryItem.set(API_OPER_TYPE, (Object)"E");
                this.setEntryItem(1, oldDynamicObject, entryItem);
                apiLogEntryentity.add((Object)entryItem);
            }
        }
    }

    private boolean isExistDB(DynamicObject apiDy, DynamicObjectCollection dynamicObjectCollection) {
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (apiDy.getLong("id") != dynamicObject.getLong("id")) continue;
            return true;
        }
        return false;
    }

    private void addMsgLog(DynamicObject[] dys, String operatorType) {
        DynamicObjectCollection pubLogDys = new DynamicObjectCollection();
        for (DynamicObject dy : dys) {
            DynamicObject pubMsgLogDyn = BusinessDataServiceHelper.newDynamicObject((String)HRCS_PUB_MSG_LOG);
            long pkId = DBServiceHelper.genLongIds((String)HRCS_PUB_MSG_LOG, (int)1)[0];
            this.setLogValue(pubMsgLogDyn, pkId, dy, operatorType);
            DynamicObjectCollection apiLogEntryEntity = pubMsgLogDyn.getDynamicObjectCollection(API_LOG_ENTRY_ENTITY);
            DynamicObjectCollection apiEntryEntity = dy.getDynamicObjectCollection(API_ENTRY_ENTITY);
            pubLogDys.add((Object)pubMsgLogDyn);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
            QFilter qfFilter = new QFilter("id", "=", dy.get("id"));
            DynamicObject[] dbObj = helper.query("pubstatus,apientryentity.api,apientryentity,apientryentity.actionservice,apientryentity.actionmethod,apientryentity.apipubstatus,apientryentity.apienable,apientryentity.apinumber,apientryentity.apiname,apientryentity.apidescription", new QFilter[]{qfFilter});
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)operatorType)) continue;
            this.addApiLogEntry(apiLogEntryEntity, apiEntryEntity, dbObj);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HRCS_PUB_MSG_LOG);
        serviceHelper.save(pubLogDys);
    }

    private void addApiLogEntry(DynamicObjectCollection apiLogEntryentity, DynamicObjectCollection apientryentity, DynamicObject[] dbObj) {
        if (StringUtils.equals((CharSequence)"N", (CharSequence)dbObj[0].getString(PUB_STATUS))) {
            if (apientryentity.isEmpty()) {
                return;
            }
            for (int i = 0; i < apientryentity.size(); ++i) {
                DynamicObject apiDy = (DynamicObject)apientryentity.get(i);
                if (!StringUtils.equals((CharSequence)apiDy.getString(API_ENABLE), (CharSequence)"C")) continue;
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)HRCS_PUB_MSG_LOG);
                EntityType type = (EntityType)mainType.getAllEntities().get(API_LOG_ENTRY_ENTITY);
                DynamicObject entryItem = (DynamicObject)type.createInstance();
                entryItem.set("seq", (Object)i);
                entryItem.set(API_OPER_TYPE, (Object)"D");
                entryItem.set(API_NUMBER, apiDy.get(API_NUMBER));
                entryItem.set(API_NAME, apiDy.get(API_NAME));
                entryItem.set(API_DESCRIPTION, apiDy.get(API_DESCRIPTION));
                apiLogEntryentity.add((Object)entryItem);
            }
        }
    }

    private void saveStopPubStatus(DynamicObject[] dys) {
        for (DynamicObject dy : dys) {
            dy.set(PUB_STATUS, (Object)"S");
            dy.set(OFFLINE_DATE, (Object)new Date());
            dy.set(PUBLISH_DATE, null);
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)dy.get(API_ENTRY_ENTITY);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                dynamicObject.set(API_PUB_STATUS, (Object)"S");
            }
        }
    }

    private void savePubStatus(DynamicObject[] dys) {
        for (DynamicObject dy : dys) {
            dy.set(PUB_STATUS, (Object)"P");
            dy.set(PUBLISH_DATE, (Object)new Date());
            dy.set(OFFLINE_DATE, null);
            dy.set("status", (Object)"C");
            if ("true".equals(this.getOption().getVariableValue("isEdit", "false"))) {
                if (!Objects.isNull(dy.get(PUBER))) continue;
                dy.set(PUBER, (Object)RequestContext.get().getCurrUserId());
                continue;
            }
            dy.set(PUBER, (Object)RequestContext.get().getCurrUserId());
        }
    }

    private void addModifyLog(DynamicObject needSaveObj, DynamicObject log) {
        String oldName;
        DynamicObject[] dyCols = this.queryDyCols(needSaveObj);
        if (dyCols.length == 0) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HRCS_PUB_MSG_LOG);
            serviceHelper.saveOne(log);
            return;
        }
        DynamicObject dbObj = dyCols[0];
        String name = needSaveObj.getString("name");
        if (!HRStringUtils.equals((String)name, (String)(oldName = dbObj.getString("name")))) {
            this.modifyMsgNameBySub(needSaveObj.getLong("id"), name);
        }
        DynamicObjectCollection mdEntryLog = log.getDynamicObjectCollection("publogentryentity");
        this.logTextItem(name, oldName, mdEntryLog, ResManager.loadKDString((String)"\u6d88\u606f\u540d\u79f0", (String)"MsgCenterPublishSaveOp_1", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d88\u606f\u57fa\u672c\u4fe1\u606f", (String)"MsgCenterPublishSaveOp_0", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
        this.handleMsgTag(needSaveObj, dbObj, mdEntryLog);
        this.handleDatabaseItem(needSaveObj, dbObj, mdEntryLog, "publishbd.id", ResManager.loadKDString((String)"\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b", (String)"MsgCenterPublishSaveOp_5", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), "publishbd");
        DynamicObjectCollection subBusFieldCols = (DynamicObjectCollection)needSaveObj.get("subbusfield");
        List<Long> ids = this.querySubIds(needSaveObj);
        DynamicObject[] cols = this.queryBusinessFieldDyArr(ids);
        String oldSub = this.buildOldSubName(cols);
        String newSub = this.buildNewSubName(subBusFieldCols);
        if (!StringUtils.equals((CharSequence)oldSub, (CharSequence)newSub)) {
            this.handleSubBusField(mdEntryLog, oldSub, newSub);
        }
        this.handleDatabaseItem(needSaveObj, dbObj, mdEntryLog, FIELD_ACTIONCLOUD_ID, ResManager.loadKDString((String)"\u6240\u5c5e\u4e1a\u52a1\u4e91", (String)"MsgCenterPublishSaveOp_6", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), "actioncloud");
        this.handleDatabaseItem(needSaveObj, dbObj, mdEntryLog, FIELD_ACTIONAPP_ID, ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528", (String)"MsgCenterPublishSaveOp_7", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), "actionapp");
        this.handleDatabaseItem(needSaveObj, dbObj, mdEntryLog, "actiontype.id", ResManager.loadKDString((String)"\u6d3b\u52a8", (String)"MsgCenterPublishSaveOp_8", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), "action");
        this.handleDescription(needSaveObj, dbObj, mdEntryLog);
        String issubscribe = needSaveObj.getString("issubscribe");
        String oldIssubscribe = dbObj.getString("issubscribe");
        this.logIssubItem(mdEntryLog, issubscribe, oldIssubscribe);
        this.handleDatabaseItem(needSaveObj, dbObj, mdEntryLog, "puber.id", ResManager.loadKDString((String)"\u53d1\u5e03\u4eba", (String)"MsgCenterPublishSaveOp_9", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), PUBER);
        this.handleMsgProbOid(needSaveObj, dbObj, mdEntryLog);
        DynamicObjectCollection apiLogEntryentity = log.getDynamicObjectCollection(API_LOG_ENTRY_ENTITY);
        if (mdEntryLog.size() != 0 || apiLogEntryentity.size() != 0) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HRCS_PUB_MSG_LOG);
            serviceHelper.saveOne(log);
        }
    }

    private void handleSubBusField(DynamicObjectCollection mdEntryLog, String oldSub, String newSub) {
        this.logTextItem(newSub, oldSub, mdEntryLog, ResManager.loadKDString((String)"\u53ef\u8ba2\u9605\u4e1a\u52a1\u7c7b\u578b", (String)"MsgCenterPublishSaveOp_2", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d88\u606f\u57fa\u672c\u4fe1\u606f", (String)"MsgCenterPublishSaveOp_0", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
    }

    private void handleDescription(DynamicObject needSaveObj, DynamicObject dbObj, DynamicObjectCollection mdEntryLog) {
        this.logTextItem(needSaveObj.getString("description"), dbObj.getString("description"), mdEntryLog, ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"MsgCenterPublishSaveOp_3", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d88\u606f\u57fa\u672c\u4fe1\u606f", (String)"MsgCenterPublishSaveOp_0", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
    }

    private void handleMsgProbOid(DynamicObject needSaveObj, DynamicObject dbObj, DynamicObjectCollection mdEntryLog) {
        Long msgProBoId = needSaveObj.getLong("msgprobo.id");
        Long oldMsgProBoId = dbObj.getLong("msgprobo.id");
        this.logDatabaseItemMsgprobo(needSaveObj, dbObj, mdEntryLog, msgProBoId, oldMsgProBoId, ResManager.loadKDString((String)"\u6d88\u606f\u4ea7\u751f\u4e1a\u52a1\u5bf9\u8c61", (String)"MsgCenterPublishSaveOp_4", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d88\u606f\u57fa\u672c\u4fe1\u606f", (String)"MsgCenterPublishSaveOp_0", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), FIELD_MSGPROBO);
    }

    private String buildOldSubName(DynamicObject[] cols) {
        if (Objects.isNull(cols)) {
            return null;
        }
        ArrayList<String> oldSub = new ArrayList<String>(cols.length);
        for (DynamicObject col : cols) {
            oldSub.add(String.valueOf(col.getString("name")));
        }
        oldSub.sort(Comparator.comparing(String::hashCode));
        return StringUtils.join(oldSub, (String)",");
    }

    private String buildNewSubName(DynamicObjectCollection subbusfieldCols) {
        if (Objects.isNull(subbusfieldCols)) {
            return null;
        }
        ArrayList<String> newSub = new ArrayList<String>(subbusfieldCols.size());
        for (DynamicObject dynamicObject : subbusfieldCols) {
            DynamicObject baseData = dynamicObject.getDynamicObject("fbasedataid");
            if (!Objects.nonNull(baseData)) continue;
            newSub.add(baseData.getString("name"));
        }
        newSub.sort(Comparator.comparing(String::hashCode));
        return StringUtils.join(newSub, (String)",");
    }

    private DynamicObject[] queryBusinessFieldDyArr(List<Long> ids) {
        HRBaseServiceHelper businessHelper = new HRBaseServiceHelper("hbss_bussinessfield");
        QFilter qfFilter = new QFilter("id", "in", ids);
        return businessHelper.query("name", new QFilter[]{qfFilter});
    }

    private void handleDatabaseItem(DynamicObject needSaveObj, DynamicObject dbObj, DynamicObjectCollection mdEntryLog, String FieldName, String item, String key) {
        String actioncloud = needSaveObj.getString(FieldName);
        String oldActioncloud = dbObj.getString(FieldName);
        this.logDatabaseItem(needSaveObj, dbObj, mdEntryLog, actioncloud, oldActioncloud, item, ResManager.loadKDString((String)"\u6d88\u606f\u57fa\u672c\u4fe1\u606f", (String)"MsgCenterPublishSaveOp_0", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), key);
    }

    private List<Long> querySubIds(DynamicObject needSaveObj) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select fbasedataid as \"basedataid\" ").append(" from t_hrcs_subbsifield").append(" where fid = (").append(needSaveObj.get("id")).append(')');
        return (List)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)selectSql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> extendDatalist = new ArrayList<Long>(16);
                while (rs.next()) {
                    extendDatalist.add(rs.getLong("basedataid"));
                }
                return extendDatalist;
            }
        });
    }

    private void handleMsgTag(DynamicObject needSaveObj, DynamicObject dbObj, DynamicObjectCollection mdEntryLog) {
        String msgtag = needSaveObj.getString("msgtag");
        String oldMsgtag = dbObj.getString("msgtag");
        this.logTextItem(msgtag, oldMsgtag, mdEntryLog, ResManager.loadKDString((String)"\u6d88\u606f\u6807\u7b7e", (String)"MsgCenterPublishSaveOp_10", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d88\u606f\u57fa\u672c\u4fe1\u606f", (String)"MsgCenterPublishSaveOp_0", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
    }

    private DynamicObject[] queryDyCols(DynamicObject needSaveObj) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter idQfFilter = new QFilter("id", "=", needSaveObj.get("id"));
        return helper.query("subbusfield,puber,msgtag,publishbd.id,actioncloud.id,actionapp.id,actiontype,description,action,issubscribe,msgprobo.id,pubstatus,status,publishdate,offlinedate,apientryentity.apienable,apientryentity.apipubstatus,apientryentity.api,apientryentity.apipubstatus,apientryentity.apinumber,apientryentity.apiname,apientryentity.apidescription", new QFilter[]{idQfFilter});
    }

    private void modifyMsgNameBySub(long pubId, String name) {
        DynamicObject[] result;
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter(MSG_PUBLISHER, "=", (Object)pubId);
        for (DynamicObject dynamicObject : result = subServiceHelper.query(new QFilter[]{subQfFilter})) {
            dynamicObject.set("name", (Object)name);
        }
        subServiceHelper.save(result);
    }

    private void logIssubItem(DynamicObjectCollection mdEntryLog, String issubscribe, String oldIssubscribe) {
        if (!HRStringUtils.equals((String)issubscribe, (String)oldIssubscribe)) {
            HashMap valMap = Maps.newHashMap();
            valMap.put("1", ResManager.loadKDString((String)"\u4e0d\u53ef\u53d6\u6d88", (String)"MsgCenterPublishSaveOp_11", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
            valMap.put("2", ResManager.loadKDString((String)"\u53ef\u53d6\u6d88\uff0c\u53d6\u6d88\u65e0\u63d0\u793a", (String)"MsgCenterPublishSaveOp_12", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
            valMap.put("3", ResManager.loadKDString((String)"\u53ef\u53d6\u6d88\uff0c\u53d6\u6d88\u9700\u63d0\u793a", (String)"MsgCenterPublishSaveOp_13", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
            DynamicObjectType entryType = mdEntryLog.getDynamicObjectType();
            DynamicObject entryItem = new DynamicObject(entryType);
            mdEntryLog.add((Object)entryItem);
            entryItem.set(FIELD_MODIFYITEM, (Object)ResManager.loadKDString((String)"\u6d88\u606f\u57fa\u672c\u4fe1\u606f", (String)"MsgCenterPublishSaveOp_0", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
            entryItem.set(FIELD_MODIFYFIELD, (Object)ResManager.loadKDString((String)"\u662f\u5426\u53ef\u53d6\u6d88\u8ba2\u9605", (String)"MsgCenterPublishSaveOp_14", (String)HRMP_HRCS_OPPLUGIN, (Object[])new Object[0]));
            entryItem.set(FIELD_BEFOREMODIFY, valMap.get(oldIssubscribe));
            entryItem.set(FIELD_AFTERMODIFY, valMap.get(issubscribe));
        }
    }

    private void logTextItem(String newVal, String oldVal, DynamicObjectCollection mdEntryLog, String field, String item) {
        if (!HRStringUtils.equals((String)newVal, (String)oldVal)) {
            DynamicObjectType entryType = mdEntryLog.getDynamicObjectType();
            DynamicObject entryItem = new DynamicObject(entryType);
            mdEntryLog.add((Object)entryItem);
            entryItem.set(FIELD_MODIFYITEM, (Object)item);
            entryItem.set(FIELD_MODIFYFIELD, (Object)field);
            entryItem.set(FIELD_BEFOREMODIFY, (Object)oldVal);
            entryItem.set(FIELD_AFTERMODIFY, (Object)newVal);
        }
    }

    private void logDatabaseItem(DynamicObject needSaveObj, DynamicObject dbObj, DynamicObjectCollection mdEntryLog, String newVal, String oldVal, String field, String item, String key) {
        if (!HRStringUtils.equals((String)newVal, (String)oldVal)) {
            DynamicObjectType entryType = mdEntryLog.getDynamicObjectType();
            DynamicObject entryItem = new DynamicObject(entryType);
            mdEntryLog.add((Object)entryItem);
            entryItem.set(FIELD_MODIFYITEM, (Object)item);
            entryItem.set(FIELD_MODIFYFIELD, (Object)field);
            entryItem.set(FIELD_BEFOREMODIFY, (Object)dbObj.getString(key + ".name"));
            entryItem.set(FIELD_AFTERMODIFY, (Object)needSaveObj.getString(key + ".name"));
        }
    }

    private void logDatabaseItemMsgprobo(DynamicObject needSaveObj, DynamicObject dbObj, DynamicObjectCollection mdEntryLog, Long newVal, Long oldVal, String field, String item, String key) {
        if (!HRStringUtils.equals((String)String.valueOf(newVal), (String)String.valueOf(oldVal))) {
            DynamicObjectType entryType = mdEntryLog.getDynamicObjectType();
            DynamicObject entryItem = new DynamicObject(entryType);
            mdEntryLog.add((Object)entryItem);
            entryItem.set(FIELD_MODIFYITEM, (Object)item);
            entryItem.set(FIELD_MODIFYFIELD, (Object)field);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgcreatebo");
            QFilter filter = new QFilter("id", "=", (Object)dbObj.getLong(key + ".id"));
            DynamicObject result = helper.queryOne(new QFilter[]{filter});
            if (Objects.nonNull(result)) {
                entryItem.set(FIELD_BEFOREMODIFY, result.get("name"));
            }
            QFilter afilter = new QFilter("id", "=", (Object)needSaveObj.getLong(key + ".id"));
            DynamicObject aResult = helper.queryOne(new QFilter[]{afilter});
            if (Objects.nonNull(aResult)) {
                entryItem.set(FIELD_AFTERMODIFY, aResult.get("name"));
            }
        }
    }

    private void updateSubApiEntity(DynamicObject pubDy) {
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter pubIdQFilter = new QFilter("msgpublisher.id", "=", pubDy.getPkValue());
        DynamicObject[] subDys = subServiceHelper.query("apientryentity,apientryentity.seq,apientryentity.apiname,apientryentity.apinumber,apientryentity.apidescription,apientryentity.params,apientryentity.apitype,apientryentity.apienable,apientryentity.apipuberdate,apientryentity.apipuber,apientryentity.apisource,apientryentity.pubapi,apientryentity.apiservice,apientryentity.apimethod,apientryentity.apipubcloud,apientryentity.apipubapp,apientryentity.outputtype,apientryentity.inputparam,apientryentity.outputparam,apientryentity.apisubstatus,apientryentity.issysset", new QFilter[]{pubIdQFilter});
        if (Objects.isNull(subDys) || subDys.length == 0) {
            return;
        }
        DynamicObjectCollection pubApis = pubDy.getDynamicObjectCollection(API_ENTRY_ENTITY);
        Map<Long, Boolean> subApiStatusMap = pubApis.stream().collect(Collectors.toMap(api -> api.getLong("apisource.id"), api -> "A".equals(api.getString(API_ENABLE)) && "P".equals(api.getString(API_PUB_STATUS)), (v1, v2) -> v2));
        Map<Object, DynamicObject> pubEntryIdToDyMap = pubApis.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, api -> api));
        for (DynamicObject sub : subDys) {
            DynamicObjectCollection subApis = sub.getDynamicObjectCollection(API_ENTRY_ENTITY);
            Map<Long, String> subApiSubStatusMap = subApis.stream().collect(Collectors.toMap(api -> api.getLong("apisource.id"), api -> api.getString("apisubstatus"), (v1, v2) -> v2));
            DynamicObjectType subApisDynamicObjectType = subApis.getDynamicObjectType();
            Iterator iterator = subApis.iterator();
            HashSet subPubApiIds = Sets.newHashSetWithExpectedSize((int)subApis.size());
            while (iterator.hasNext()) {
                DynamicObject subApi = (DynamicObject)iterator.next();
                Object pubApiId = subApi.get("pubapi");
                DynamicObject pubApi = pubEntryIdToDyMap.get(pubApiId);
                subPubApiIds.add(pubApiId);
                if (pubApi == null) {
                    iterator.remove();
                    continue;
                }
                this.updateSubApi(pubDy, subApiStatusMap, subApiSubStatusMap, subApi, pubApi);
            }
            if (pubEntryIdToDyMap.isEmpty()) continue;
            HashSet pubIds = Sets.newHashSet(pubEntryIdToDyMap.keySet());
            pubIds.removeAll(subPubApiIds);
            for (Object pubId : pubIds) {
                DynamicObject pubApi = pubEntryIdToDyMap.get(pubId);
                if (pubApi == null || "N".equals(pubApi.get(API_PUB_STATUS))) continue;
                DynamicObject subApi = new DynamicObject(subApisDynamicObjectType);
                this.updateSubApi(pubDy, subApiStatusMap, subApiSubStatusMap, subApi, pubApi);
                subApis.add((Object)subApi);
            }
        }
        subServiceHelper.save(subDys);
    }

    private void updateSubApi(DynamicObject pubDy, Map<Long, Boolean> subApiStatusMap, Map<Long, String> subApiSubStatusMap, DynamicObject subApi, DynamicObject pubApi) {
        Boolean isApiEnable = subApiStatusMap.get(pubApi.getLong("apisource.id"));
        if (isApiEnable == null) {
            isApiEnable = false;
        }
        subApi.set("seq", pubApi.get("seq"));
        subApi.set(API_NAME, pubApi.get(API_NAME));
        subApi.set(API_NUMBER, pubApi.get(API_NUMBER));
        subApi.set(API_DESCRIPTION, pubApi.get(API_DESCRIPTION));
        subApi.set("params", pubApi.get("params"));
        subApi.set("apitype", pubApi.get("apitype"));
        subApi.set(API_ENABLE, (Object)(isApiEnable != false ? "A" : "B"));
        subApi.set("apipuberdate", pubDy.get(PUBLISH_DATE));
        subApi.set("apipuber", pubDy.get(PUBER));
        subApi.set("apisource", pubApi.get("apisource"));
        subApi.set("pubapi", pubApi.get("id"));
        subApi.set("apiservice", pubApi.get("apiservice"));
        subApi.set("apimethod", pubApi.get("apimethod"));
        subApi.set("apipubcloud", pubApi.get("apipubcloud"));
        subApi.set("apipubapp", pubApi.get("apipubapp"));
        subApi.set("outputtype", pubApi.get("outputtype"));
        subApi.set("inputparam", pubApi.get("inputparam"));
        subApi.set("outputparam", pubApi.get("outputparam"));
        subApi.set("issysset", pubApi.get("issysset"));
        String subStatus = subApiSubStatusMap.get(pubApi.getLong("apisource.id"));
        if (Objects.isNull(subStatus)) {
            subStatus = "0";
        }
        subApi.set("apisubstatus", (Object)subStatus);
    }
}

