/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hrcs.opplugin.validator.MsgSubSaveValidator;

public class MsgSubDetailsOp
extends HRDataBaseOp {
    private static String MSG_PUBLISHER = "msgpublisher";
    private static String PUBER = "puber";
    private static String SUB_STATUS = "substatus";
    private static String PUB_DATE = "pubdate";
    private static String MSG_PUBLISHER_ID = "msgpublisher.id";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add(MSG_PUBLISHER);
        fieldKeys.add("subscribebd");
        fieldKeys.add(PUB_DATE);
        fieldKeys.add(PUBER);
        fieldKeys.add("msgdomain");
        fieldKeys.add("msgactiontype");
        fieldKeys.add("apientryentity.apinumber");
        fieldKeys.add("apientryentity.apiname");
        fieldKeys.add("consumercloud");
        fieldKeys.add("consumerapp");
        fieldKeys.add("consumerService");
        fieldKeys.add("consumerMethod");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new MsgSubSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dys = args.getDataEntities();
        String operationKey = args.getOperationKey().toLowerCase(Locale.ROOT);
        if ("unsub".equals(operationKey)) {
            this.synSubLogDy(dys[0], "0");
            this.updatePubTableStatus(dys[0].getLong(MSG_PUBLISHER_ID));
            MsgCenterServiceHelper.updateEnable((Long)dys[0].getLong("id"), (String)"0");
        } else if ("sub".equals(operationKey)) {
            this.synSubLogDy(dys[0], "1");
            this.updatePubTableStatusBySub(dys[0].getLong(MSG_PUBLISHER_ID));
            MsgCenterServiceHelper.updateEnable((Long)dys[0].getLong("id"), (String)"1");
        }
    }

    private void updatePubTableStatus(Long id) {
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter(MSG_PUBLISHER, "=", (Object)id);
        subQfFilter.and(new QFilter(SUB_STATUS, "=", (Object)"1"));
        DynamicObject[] result = subServiceHelper.query("suber.id", new QFilter[]{subQfFilter});
        if (result.length == 0) {
            QFilter pubQfFilter = new QFilter("id", "=", (Object)id);
            DynamicObject pubDy = pubServiceHelper.queryOne(SUB_STATUS, new QFilter[]{pubQfFilter});
            pubDy.set(SUB_STATUS, (Object)"0");
            pubServiceHelper.saveOne(pubDy);
        }
    }

    private void updatePubTableStatusBySub(Long id) {
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter pubQfFilter = new QFilter("id", "=", (Object)id);
        DynamicObject pubDy = pubServiceHelper.queryOne(SUB_STATUS, new QFilter[]{pubQfFilter});
        if (!HRStringUtils.equals((String)"1", (String)pubDy.getString(SUB_STATUS))) {
            pubDy.set(SUB_STATUS, (Object)"1");
            pubServiceHelper.saveOne(pubDy);
        }
    }

    private void synSubLogDy(DynamicObject dy, String subType) {
        Date now = new Date();
        Long pkid = (Long)dy.getPkValue();
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter("id", "=", (Object)pkid);
        DynamicObject result = subServiceHelper.queryOne("msgpublisher.id,subscribebd.id,apientryentity,apientryentity.number,apientryentity.name", new QFilter[]{subQfFilter});
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter pubQfFilter = new QFilter("id", "=", result.get(MSG_PUBLISHER_ID));
        DynamicObject msgDy = pubServiceHelper.queryOne("puber.id,subbusfield.id,actiontype.id,publishdate,publishbd.id,msgtag,number", new QFilter[]{pubQfFilter});
        DynamicObjectCollection subLogDys = new DynamicObjectCollection();
        DynamicObject subMsgLog = BusinessDataServiceHelper.newDynamicObject((String)"hrcs_submgslog");
        Long logPkId = ORM.create().genLongId("hrcs_submgslog");
        subMsgLog.set("id", (Object)logPkId);
        subMsgLog.set("number", dy.get("number"));
        subMsgLog.set("publisher", msgDy.get(PUBER));
        subMsgLog.set(PUB_DATE, msgDy.get("publishdate"));
        subMsgLog.set("msgsender", (Object)RequestContext.get().getCurrUserId());
        subMsgLog.set("subdate", (Object)now);
        subMsgLog.set("subtype", (Object)subType);
        subMsgLog.set("consumer", result.get("subscribebd.id"));
        subMsgLog.set("pubdomain", msgDy.get("publishbd.id"));
        subMsgLog.set("actiontype", msgDy.get("actiontype.id"));
        subMsgLog.set("status", (Object)"C");
        subMsgLog.set("enable", (Object)"1");
        subMsgLog.set("createtime", (Object)now);
        subMsgLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        subMsgLog.set(PUBER, dy.get(MSG_PUBLISHER));
        subMsgLog.set("suber", dy.get("id"));
        subLogDys.add((Object)subMsgLog);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_submgslog");
        serviceHelper.save(subLogDys);
    }
}

