/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.servicehelper.PermFilesServiceHelper;
import kd.hr.hrcs.opplugin.validator.PermFilesSaveValidator;

public class PermFilesSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        this.getOption().setVariableValue("ignorerefentityids", "hrcs_permorgentry");
        args.addValidator((AbstractValidator)new PermFilesSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] datas = args.getDataEntities();
        String key = args.getOperationKey();
        if (HRStringUtils.equals((String)key, (String)"save")) {
            for (DynamicObject data : datas) {
                this.saveOrgEntrys(data);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] datas = args.getDataEntities();
        String key = args.getOperationKey();
        if (HRStringUtils.equals((String)key, (String)"delete")) {
            this.deleteAdminorgEntrys(datas);
        }
    }

    private void deleteAdminorgEntrys(DynamicObject[] datas) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permorgentry");
        ArrayList<Long> permFileIds = new ArrayList<Long>(datas.length);
        for (DynamicObject data : datas) {
            Long permFileId = data.getLong("id");
            permFileIds.add(permFileId);
        }
        QFilter idFilter = new QFilter("permfile", "in", permFileIds);
        serviceHelper.deleteByFilter(new QFilter[]{idFilter});
    }

    private void saveOrgEntrys(DynamicObject dyc) {
        Long fileId = dyc.getLong("id");
        Long userId = dyc.getLong("user.id");
        DynamicObjectCollection adminorgEntryColl = dyc.getDynamicObjectCollection("adminorgentry");
        DynamicObject[] oldOrgEntrys = PermFilesServiceHelper.getPermAdminorgEntrysByUserId((Long)userId);
        Map<Long, DynamicObject> oldOrgMap = this.changeOrgEntrysToMap(oldOrgEntrys);
        DynamicObjectCollection newEntryColl = new DynamicObjectCollection();
        DynamicObjectCollection updateEntryColl = new DynamicObjectCollection();
        DynamicObjectCollection removeEntryColl = new DynamicObjectCollection();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"hrcs_permorgentry");
        for (DynamicObject adminOrgEntry : adminorgEntryColl) {
            Long entryId = adminOrgEntry.getLong("entryid");
            if (entryId == null || entryId.equals(0L)) {
                DynamicObject newEntry = this.assembleNewEntry(mainEntityType, adminOrgEntry, fileId, userId);
                newEntryColl.add((Object)newEntry);
                continue;
            }
            DynamicObject oldOrgEntry = oldOrgMap.remove(entryId);
            oldOrgEntry.set("containssub", adminOrgEntry.get("containssub"));
            updateEntryColl.add((Object)oldOrgEntry);
        }
        for (Map.Entry<Long, DynamicObject> key : oldOrgMap.entrySet()) {
            DynamicObject oldOrgEntry = key.getValue();
            oldOrgEntry.set("status", (Object)"0");
            removeEntryColl.add((Object)oldOrgEntry);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permorgentry");
        serviceHelper.save(newEntryColl);
        serviceHelper.save(updateEntryColl);
        serviceHelper.save(removeEntryColl);
    }

    private DynamicObject assembleNewEntry(MainEntityType mainEntityType, DynamicObject adminOrgEntry, Long fileId, Long userId) {
        DynamicObject dyc = new DynamicObject((DynamicObjectType)mainEntityType);
        boolean containsSub = adminOrgEntry.getBoolean("containssub");
        Long orgId = adminOrgEntry.getLong("adminorg.id");
        dyc.set("containssub", (Object)containsSub);
        dyc.set("adminorg", (Object)orgId);
        dyc.set("permfile", (Object)fileId);
        dyc.set("user", (Object)userId);
        dyc.set("status", (Object)"1");
        return dyc;
    }

    private Map<Long, DynamicObject> changeOrgEntrysToMap(DynamicObject[] orgEntrys) {
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(orgEntrys.length);
        for (DynamicObject orgEntry : orgEntrys) {
            Long entryId = orgEntry.getLong("id");
            orgMap.put(entryId, orgEntry);
        }
        return orgMap;
    }
}

