/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.api;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRListUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.opplugin.validator.api.MsgApiValidator;

public class HRAPIListOp
extends HRDataBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dys = args.getDataEntities();
        if (dys == null || dys.length < 1) {
            return;
        }
        String opKey = args.getOperationKey();
        if ("disable".equals(opKey) || "enable".equals(opKey)) {
            this.updateMsg(dys);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        super.onAddValidators(event);
        event.addValidator((AbstractValidator)new MsgApiValidator());
    }

    private void setApiEnable(long pubId, Map<Long, DynamicObject> apiIdToDyMap, DynamicObject apiEntityDy, boolean isPub, Map<String, Boolean> pubApiStatusMap) {
        Long apiId = apiEntityDy.getLong("apisource.id");
        DynamicObject dyApi = apiIdToDyMap.get(apiId);
        if (Objects.isNull(dyApi)) {
            return;
        }
        if (isPub) {
            boolean apiEnable = "1".equals(dyApi.getString("enable"));
            boolean apiPubStatus = "P".equals(apiEntityDy.getString("apipubstatus"));
            apiEntityDy.set("apienable", (Object)(apiEnable ? "A" : "B"));
            pubApiStatusMap.put(String.valueOf(pubId) + String.valueOf(apiId), apiEnable && apiPubStatus);
        } else {
            Boolean apiEnable = pubApiStatusMap.get(String.valueOf(pubId) + String.valueOf(apiId));
            if (Objects.nonNull(apiEnable)) {
                apiEntityDy.set("apienable", (Object)(apiEnable != false ? "A" : "B"));
            }
        }
    }

    private void updateMsg(DynamicObject[] dyApis) {
        Object[] apiIds = Stream.of(dyApis).map(DataEntityBase::getPkValue).toArray();
        String selectSql = "select fid as \"id\" from  t_hrcs_msgpublishapi where fapisourceid in (" + HRListUtils.getListInSqlPlaceholder(Arrays.asList(apiIds)) + ")";
        List pubIds = (List)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)selectSql, (Object[])apiIds, rs -> {
            ArrayList<Long> longIds = new ArrayList<Long>(16);
            while (rs.next()) {
                longIds.add(rs.getLong("id"));
            }
            return longIds;
        });
        Map<Long, DynamicObject> apiIdToDyMap = Stream.of(dyApis).collect(Collectors.toMap(api -> (Long)api.getPkValue(), api -> api));
        List listIds = HRListUtils.splitList((List)pubIds, (int)1000);
        HashMap pubApiStatusMap = Maps.newHashMapWithExpectedSize((int)(pubIds.size() * 2));
        Iterator iterator = listIds.iterator();
        while (iterator.hasNext()) {
            QFilter pubIdQFilter;
            HRBaseServiceHelper subServiceHelper;
            DynamicObject[] subDys;
            HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
            List ids = (List)iterator.next();
            QFilter idQFilter = new QFilter("id", "in", (Object)ids);
            DynamicObject[] pubDys = pubServiceHelper.query("id,apientryentity,apientryentity.name,apientryentity.apinumber,apientryentity.apisource,apientryentity.apienable,apientryentity.apipubstatus", new QFilter[]{idQFilter});
            if (Objects.nonNull(pubDys) && pubDys.length > 0) {
                for (DynamicObject dynamicObject : pubDys) {
                    DynamicObjectCollection dyCols = (DynamicObjectCollection)dynamicObject.get("apientryentity");
                    for (DynamicObject dy : dyCols) {
                        this.setApiEnable(dynamicObject.getLong("id"), apiIdToDyMap, dy, true, pubApiStatusMap);
                    }
                }
                pubServiceHelper.updateDatas(pubDys);
            }
            if (!Objects.nonNull(subDys = (subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber")).query("msgpublisher.id,apientryentity,apientryentity.name,apientryentity.apinumber,apientryentity.apisource,apientryentity.apienable", new QFilter[]{pubIdQFilter = new QFilter("msgpublisher.id", "in", (Object)ids)})) || subDys.length <= 0) continue;
            for (DynamicObject dynamicObject : subDys) {
                DynamicObjectCollection dyCols = (DynamicObjectCollection)dynamicObject.get("apientryentity");
                for (DynamicObject dy : dyCols) {
                    this.setApiEnable(dynamicObject.getLong("msgpublisher.id"), apiIdToDyMap, dy, false, pubApiStatusMap);
                }
            }
            subServiceHelper.updateDatas(subDys);
        }
    }
}

