/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.es;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.common.enums.query.EnumQueryEntityReleaseStatus;
import kd.hr.hbp.common.enums.query.EssyncSchemeConfigInitStatus;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.service.aisearch.EsSyncSchemeConfigService;
import kd.hr.hrcs.bussiness.service.multientity.EntityReleaseInfoService;
import kd.hr.hrcs.bussiness.service.multientity.impl.AISearchEsQueryEntityReleaseService;
import kd.hr.hrcs.bussiness.service.multientity.impl.EsBatchImportDataJobAndPlanService;
import kd.hr.hrcs.bussiness.service.multientity.impl.EsQueryEntityReleaseService;
import kd.hr.hrcs.opplugin.web.es.validator.EsSyncRecordSaveValidator;

public class EsSyncRecordSaveOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("syncmode");
        fieldKeys.add("esscheme.id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EsSyncRecordSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject obj : e.getDataEntities()) {
            String syncmode = obj.getString("syncmode");
            if ("manual".equals(syncmode)) {
                obj.set("plansynctime", (Object)new Date());
            }
            Long recordId = obj.getLong("id");
            DynamicObject esscheme = (DynamicObject)obj.get("esscheme");
            String queryEntity = esscheme.getString("queryentity.number");
            DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)queryEntity);
            if ("manual".equals(syncmode)) {
                switch (entityReleaseInfo.getString("bizapplytype")) {
                    case "1": {
                        EsQueryEntityReleaseService.getInstance().batchImportData(Long.valueOf(esscheme.getLong("id")), recordId);
                        break;
                    }
                    case "2": {
                        AISearchEsQueryEntityReleaseService.getInstance().batchImportData(Long.valueOf(esscheme.getLong("id")), recordId);
                        break;
                    }
                }
                continue;
            }
            if (!"fixedtime".equals(syncmode)) continue;
            Date plansynctime = obj.getDate("plansynctime");
            EsBatchImportDataJobAndPlanService jobAndPlanService = new EsBatchImportDataJobAndPlanService();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("esschemeId", esscheme.getLong("id"));
            map.put("name", queryEntity);
            obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
            map.put("recordId", obj.getLong("id"));
            map.put("bizapplytype", entityReleaseInfo.getString("bizapplytype"));
            jobAndPlanService.fixedTimeRelease(map, plansynctime);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject obj : e.getDataEntities()) {
            String syncmode = obj.getString("syncmode");
            if (!"manual".equals(syncmode)) continue;
            DynamicObject esscheme = (DynamicObject)obj.get("esscheme");
            DynamicObject esschemesave = EsSyncSchemeConfigService.load((Long)esscheme.getLong("id"));
            if (EssyncSchemeConfigInitStatus.UNSTART.getStatus().equals(esschemesave.getString("initstate"))) {
                esschemesave.set("initstate", (Object)EssyncSchemeConfigInitStatus.STARTING.getStatus());
                EsSyncSchemeConfigService.saveOne((DynamicObject)esschemesave);
            }
            obj.set("status", (Object)EnumQueryEntityReleaseStatus.BATCH_IMPORTING.getStatus());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }
}

