/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.hismodel.validate;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.hismodel.HisEntityDependentService;
import kd.hr.hrcs.bussiness.servicehelper.hismodel.HisEntityDependentServiceHelper;
import kd.hr.hrcs.common.constants.hismodel.HisEntityDependentConstants;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityConditionVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityRelVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityVO;
import kd.hr.hrcs.common.model.hismodel.HisEntityDependentVO;

@ExcludeFromJacocoGeneratedReport
public class HisEntityDependentValidator
extends AbstractValidator
implements HisEntityDependentConstants {
    public void validate() {
        if ("save".equals(this.getOperateKey())) {
            this.validateSave();
        }
    }

    private void validateSave() {
        String saveData = this.getOption().getVariableValue("saveData");
        boolean isEmpty = false;
        List hisEntityDependentVOList = null;
        if (HRStringUtils.isEmpty((String)saveData)) {
            isEmpty = true;
        } else {
            hisEntityDependentVOList = JSON.parseArray((String)saveData, HisEntityDependentVO.class);
            if (CollectionUtils.isEmpty((Collection)hisEntityDependentVOList)) {
                isEmpty = true;
            } else {
                for (HisEntityDependentVO hisEntityDependentVO : hisEntityDependentVOList) {
                    if (CollectionUtils.isEmpty((Collection)hisEntityDependentVO.getEdEntityList())) {
                        isEmpty = true;
                        break;
                    }
                    for (HisEDEntityVO hisEDEntityVO : hisEntityDependentVO.getEdEntityList()) {
                        if (!HRStringUtils.isEmpty((String)hisEDEntityVO.getEntity())) continue;
                        isEmpty = true;
                        break;
                    }
                    if (!isEmpty) continue;
                    break;
                }
            }
        }
        if (isEmpty) {
            this.addErrorMessage(this.getDataEntities()[0], ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5b9e\u4f53\u4f9d\u8d56\u5173\u7cfb\u3002", (String)"HisEntityDependentValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        this.validateRing(hisEntityDependentVOList);
        this.validateDifferent(hisEntityDependentVOList);
    }

    private void validateDifferent(List<HisEntityDependentVO> hisEntityDependentVOList) {
        long edId = this.getDataEntities()[0].getDataEntity().getLong("id");
        String currentEdId = edId == 0L ? null : String.valueOf(edId);
        hisEntityDependentVOList.forEach(ed -> ed.setEdId(currentEdId));
        List<HisEntityDependentVO> otherHisEntityDependentVOList = this.getOtherEdVOList();
        otherHisEntityDependentVOList.addAll(hisEntityDependentVOList);
        HashMap relMap = Maps.newHashMapWithExpectedSize((int)otherHisEntityDependentVOList.size());
        for (HisEntityDependentVO hisEntityDependentVO : otherHisEntityDependentVOList) {
            String row = "R" + hisEntityDependentVO.getRow();
            String edName = hisEntityDependentVO.getEdName();
            String edIdStr = hisEntityDependentVO.getEdId();
            List edEntityList = hisEntityDependentVO.getEdEntityList();
            for (int i = 0; i < edEntityList.size() - 1; ++i) {
                HisEDEntityVO leftEntity = (HisEDEntityVO)edEntityList.get(i);
                HisEDEntityVO rightEntity = (HisEDEntityVO)edEntityList.get(i + 1);
                HisEDEntityRelVO edEntityRel = rightEntity.getEdEntityRel();
                if (edEntityRel == null) {
                    edEntityRel = new HisEDEntityRelVO();
                    edEntityRel.setLeftEntityNum(leftEntity.getEntityNum());
                    edEntityRel.setRightEntityNum(rightEntity.getEntityNum());
                }
                edEntityRel.setRow(row);
                edEntityRel.setEdId(edIdStr);
                edEntityRel.setEdName(edName);
                edEntityRel.setLeftEntityName(leftEntity.getEntityName());
                edEntityRel.setRightEntityName(rightEntity.getEntityName());
                String key = leftEntity.getEntityNum() + "#" + rightEntity.getEntityNum();
                List relList = relMap.getOrDefault(key, Lists.newArrayListWithExpectedSize((int)edEntityList.size()));
                relList.add(edEntityRel);
                relMap.put(key, relList);
            }
        }
        this.validateDifferent(relMap);
    }

    private void validateDifferent(Map<String, List<HisEDEntityRelVO>> relMap) {
        long edId = this.getDataEntities()[0].getDataEntity().getLong("id");
        String currentEdId = edId == 0L ? null : String.valueOf(edId);
        for (Map.Entry<String, List<HisEDEntityRelVO>> entry : relMap.entrySet()) {
            List<HisEDEntityRelVO> value = entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            String edName = null;
            for (int i = 0; i < value.size(); ++i) {
                HisEDEntityRelVO leftRel = value.get(i);
                for (int j = i + 1; j < value.size(); ++j) {
                    String row;
                    HisEDEntityRelVO rightRel = value.get(j);
                    boolean isDifferent = false;
                    if (leftRel.getConditionList() == null && rightRel.getConditionList() != null || leftRel.getConditionList() != null && rightRel.getConditionList() == null) {
                        isDifferent = true;
                    } else if (leftRel.getConditionList() != null && rightRel.getConditionList() != null) {
                        Set rightPropSet;
                        HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)leftRel.getConditionList().size());
                        for (HisEDEntityConditionVO hisEDEntityConditionVO : leftRel.getConditionList()) {
                            rightPropSet = conditionMap.getOrDefault(hisEDEntityConditionVO.getLeftProp(), Sets.newHashSetWithExpectedSize((int)rightRel.getConditionList().size()));
                            rightPropSet.add(hisEDEntityConditionVO.getRightProp());
                            conditionMap.put(hisEDEntityConditionVO.getLeftProp(), rightPropSet);
                        }
                        for (HisEDEntityConditionVO hisEDEntityConditionVO : rightRel.getConditionList()) {
                            rightPropSet = (Set)conditionMap.get(hisEDEntityConditionVO.getLeftProp());
                            if (rightPropSet != null && !rightPropSet.add(hisEDEntityConditionVO.getRightProp())) continue;
                            isDifferent = true;
                            break;
                        }
                    }
                    if (!isDifferent) continue;
                    if (HRStringUtils.equals((String)leftRel.getEdId(), (String)rightRel.getEdId())) {
                        ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)4);
                        errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4", (String)"HisEntityDependentValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{leftRel.getRow()}));
                        errMsgList.add(ResManager.loadKDString((String)"\u4e0e", (String)"HisEntityDependentValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                        errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4", (String)"HisEntityDependentValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{rightRel.getRow()}));
                        errMsgList.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u2212%2$s\u201d\u7684\u5b9e\u4f53\u4f9d\u8d56\u6761\u4ef6\u4e0d\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HisEntityDependentValidator_9", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), leftRel.getLeftEntityName(), leftRel.getRightEntityName()));
                        this.addErrorMessage(this.getDataEntities()[0], String.join((CharSequence)"", errMsgList));
                        continue;
                    }
                    if (HRStringUtils.equals((String)leftRel.getEdId(), (String)currentEdId)) {
                        row = leftRel.getRow();
                        edName = rightRel.getEdName();
                    } else {
                        row = rightRel.getRow();
                        edName = leftRel.getEdName();
                    }
                    if (stringBuilder.indexOf(row) != -1) continue;
                    ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)4);
                    errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4", (String)"HisEntityDependentValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{row}));
                    errMsgList.add(ResManager.loadKDString((String)"\u3001", (String)"HisEntityDependentValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                    stringBuilder.append(String.join((CharSequence)"", errMsgList));
                }
            }
            if (stringBuilder.length() <= 0) continue;
            ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)4);
            errMsgList.add(stringBuilder.substring(0, stringBuilder.length() - 1));
            errMsgList.add(ResManager.loadKDString((String)"\u4e0e", (String)"HisEntityDependentValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            String errMsg2 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u2212%2$s\u201d\u7684\u5b9e\u4f53\u4f9d\u8d56\u6761\u4ef6\u4e0d\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HisEntityDependentValidator_9", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), value.get(0).getLeftEntityName(), value.get(0).getRightEntityName());
            String errMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d%2$s", (String)"HisEntityDependentValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), edName, errMsg2);
            errMsgList.add(errMsg);
            this.addErrorMessage(this.getDataEntities()[0], String.join((CharSequence)"", errMsgList));
        }
    }

    private void validateRing(List<HisEntityDependentVO> hisEntityDependentVOList) {
        List<HisEntityDependentVO> excludeList = this.validateCurrentRing(hisEntityDependentVOList);
        for (HisEntityDependentVO hisEntityDependentVO : excludeList) {
            hisEntityDependentVOList.removeIf(ed -> HRStringUtils.equals((String)("R" + ed.getRow()), (String)hisEntityDependentVO.getRow()));
        }
        this.validateAllRing(hisEntityDependentVOList);
    }

    private void validateAllRing(List<HisEntityDependentVO> hisEntityDependentVOList) {
        List<HisEntityDependentVO> otherHisEntityDependentVOList = this.getOtherEdVOList();
        List<HisEntityDependentVO> copyList = this.deepCopy(hisEntityDependentVOList, HisEntityDependentVO.class);
        this.handleRel(otherHisEntityDependentVOList);
        this.handleRel(copyList);
        HashMap doubleToRing = Maps.newHashMapWithExpectedSize((int)otherHisEntityDependentVOList.size());
        for (int i = 0; i < copyList.size(); ++i) {
            HisEntityDependentVO left = copyList.get(i);
            ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)4);
            errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4\u5b9e\u4f53\u4f9d\u8d56\u5173\u7cfb", (String)"HisEntityDependentValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{left.getRow()}));
            errMsgList.add(ResManager.loadKDString((String)"\u4e0e", (String)"HisEntityDependentValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            boolean hasRing = false;
            for (int j = 0; j < otherHisEntityDependentVOList.size(); ++j) {
                HisEntityDependentVO right = otherHisEntityDependentVOList.get(j);
                List<HisEDEntityVO> newList = this.deepCopy(right.getEdEntityList(), HisEDEntityVO.class);
                newList.addAll(left.getEdEntityList());
                if (!this.isRing(newList)) continue;
                String groupLang = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d%2$s", (String)"HisEntityDependentValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), right.getEdName(), right.getRow());
                errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4\u5b9e\u4f53\u4f9d\u8d56\u5173\u7cfb", (String)"HisEntityDependentValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{groupLang}));
                errMsgList.add(ResManager.loadKDString((String)"\u3001", (String)"HisEntityDependentValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                Set rightRingIndexSet = doubleToRing.getOrDefault(i, Sets.newHashSetWithExpectedSize((int)otherHisEntityDependentVOList.size()));
                rightRingIndexSet.add(j);
                doubleToRing.put(i, rightRingIndexSet);
                hasRing = true;
            }
            if (!hasRing) continue;
            String join = String.join((CharSequence)"", errMsgList);
            String substring = join.substring(0, join.length() - 1);
            this.addErrorMessage(this.getDataEntities()[0], String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6210\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HisEntityDependentValidator_8", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), substring));
        }
        HashMap errMsgMap = Maps.newHashMapWithExpectedSize((int)otherHisEntityDependentVOList.size());
        block2: for (int j = 0; j < otherHisEntityDependentVOList.size(); ++j) {
            ArrayList errMsgTopList = Lists.newArrayListWithExpectedSize((int)4);
            HisEntityDependentVO bottom = otherHisEntityDependentVOList.get(j);
            for (int i = 0; i < copyList.size(); ++i) {
                Set rightRingIndexSet = doubleToRing.getOrDefault(i, Sets.newHashSet());
                if (rightRingIndexSet.contains(j)) continue;
                HisEntityDependentVO top = copyList.get(i);
                bottom.getEdEntityList().addAll(top.getEdEntityList());
                if (this.isRing(bottom.getEdEntityList())) {
                    List errMsgList = (List)errMsgMap.get(i);
                    String groupLang = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d%2$s", (String)"HisEntityDependentValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), bottom.getEdName(), bottom.getRow());
                    if (errMsgList == null) {
                        errMsgTopList.add(ResManager.loadKDString((String)"%s\u7ec4\u5b9e\u4f53\u4f9d\u8d56\u5173\u7cfb", (String)"HisEntityDependentValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{top.getRow()}));
                        errMsgTopList.add(ResManager.loadKDString((String)"\u4e0e", (String)"HisEntityDependentValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                        errMsgTopList.add(ResManager.loadKDString((String)"%s\u7ec4\u5b9e\u4f53\u4f9d\u8d56\u5173\u7cfb", (String)"HisEntityDependentValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{groupLang}));
                        errMsgTopList.add(ResManager.loadKDString((String)"\u3001", (String)"HisEntityDependentValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                        errMsgMap.put(i, errMsgTopList);
                        continue block2;
                    }
                    errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4\u5b9e\u4f53\u4f9d\u8d56\u5173\u7cfb", (String)"HisEntityDependentValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{groupLang}));
                    errMsgList.add(ResManager.loadKDString((String)"\u3001", (String)"HisEntityDependentValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                    continue block2;
                }
                errMsgTopList.add(ResManager.loadKDString((String)"%s\u7ec4", (String)"HisEntityDependentValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{top.getRow()}));
                errMsgTopList.add(ResManager.loadKDString((String)"\u3001", (String)"HisEntityDependentValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
        }
        errMsgMap.forEach((key, value) -> {
            String join = String.join((CharSequence)"", value);
            String substring = join.substring(0, join.length() - 1);
            this.addErrorMessage(this.getDataEntities()[0], String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6210\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HisEntityDependentValidator_8", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), substring));
        });
    }

    private List<HisEntityDependentVO> validateCurrentRing(List<HisEntityDependentVO> hisEntityDependentVOList) {
        int i;
        ArrayList excludeList = Lists.newArrayListWithExpectedSize((int)hisEntityDependentVOList.size());
        List<HisEntityDependentVO> copyList = this.deepCopy(hisEntityDependentVOList, HisEntityDependentVO.class);
        this.handleRel(copyList);
        Iterator<HisEntityDependentVO> iterator = copyList.iterator();
        while (iterator.hasNext()) {
            HisEntityDependentVO next = iterator.next();
            List edEntityList = next.getEdEntityList();
            if (!this.isRing(edEntityList)) continue;
            this.addErrorMessage(this.getDataEntities()[0], ResManager.loadKDString((String)"%s\u7ec4\u5b9e\u4f53\u4f9d\u8d56\u5173\u7cfb\u6210\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HisEntityDependentValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{next.getRow()}));
            iterator.remove();
            excludeList.add(next);
        }
        HashMap doubleToRing = Maps.newHashMapWithExpectedSize((int)copyList.size());
        for (i = 0; i < copyList.size(); ++i) {
            HisEntityDependentVO left = copyList.get(i);
            for (int j = 1; j < copyList.size(); ++j) {
                HisEntityDependentVO right = copyList.get(j);
                List<HisEDEntityVO> newList = this.deepCopy(right.getEdEntityList(), HisEDEntityVO.class);
                newList.addAll(left.getEdEntityList());
                if (!this.isRing(newList)) continue;
                String groupLang = ResManager.loadKDString((String)"%s\u7ec4", (String)"HisEntityDependentValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{left.getRow()});
                this.addErrorMessage(this.getDataEntities()[0], String.format(ResManager.loadKDString((String)"%1$s\u4e0e%2$s\u7ec4\u5b9e\u4f53\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u5173\u7cfb\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"HisEntityDependentValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), groupLang, right.getRow()));
                Set rightRingIndexSet = doubleToRing.getOrDefault(i, Sets.newHashSetWithExpectedSize((int)copyList.size()));
                rightRingIndexSet.add(j);
                doubleToRing.put(i, rightRingIndexSet);
            }
        }
        block3: for (i = 0; i < copyList.size(); ++i) {
            ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)4);
            HisEntityDependentVO top = copyList.get(i);
            errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4", (String)"HisEntityDependentValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{top.getRow()}));
            Set rightRingIndexSet = doubleToRing.getOrDefault(i, Sets.newHashSet());
            for (int j = 1; j < copyList.size(); ++j) {
                if (rightRingIndexSet.contains(j)) continue;
                HisEntityDependentVO bottom = copyList.get(j);
                top.getEdEntityList().addAll(bottom.getEdEntityList());
                if (this.isRing(top.getEdEntityList())) {
                    this.addErrorMessage(this.getDataEntities()[0], String.format(ResManager.loadKDString((String)"%1$s\u4e0e%2$s\u7ec4\u5b9e\u4f53\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u5173\u7cfb\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"HisEntityDependentValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), String.join((CharSequence)"", errMsgList), bottom.getRow()));
                    continue block3;
                }
                errMsgList.add(ResManager.loadKDString((String)"\u3001", (String)"HisEntityDependentValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                errMsgList.add(ResManager.loadKDString((String)"%s\u7ec4", (String)"HisEntityDependentValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{bottom.getRow()}));
            }
        }
        return excludeList;
    }

    private boolean isRing(List<HisEDEntityVO> edEntityList) {
        HashMap dependentMap = Maps.newHashMapWithExpectedSize((int)256);
        for (HisEDEntityVO hisEDEntityVO : edEntityList) {
            HashSet dependentEntitySet;
            String entity = hisEDEntityVO.getEntity();
            HisEDEntityRelVO edEntityRel = hisEDEntityVO.getEdEntityRel();
            Set set = dependentEntitySet = dependentMap.get(entity) == null ? Sets.newHashSetWithExpectedSize((int)16) : (Set)dependentMap.get(entity);
            if (edEntityRel != null) {
                String leftEntityNum = edEntityRel.getLeftEntityNum();
                dependentEntitySet.add(leftEntityNum);
            }
            dependentMap.put(entity, dependentEntitySet);
        }
        for (Map.Entry entry : dependentMap.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            dependentMap.put(entry.getKey(), null);
        }
        return this.hasRing(dependentMap);
    }

    private boolean hasRing(Map<String, Set<String>> dependentMap) {
        if (dependentMap.isEmpty()) {
            return false;
        }
        HashSet dependentEmptySet = Sets.newHashSetWithExpectedSize((int)dependentMap.size());
        dependentMap.forEach((key, value) -> {
            if (value == null) {
                dependentEmptySet.add(key);
            }
        });
        if (dependentEmptySet.isEmpty() && !dependentMap.isEmpty()) {
            return true;
        }
        dependentEmptySet.forEach(dependentMap::remove);
        for (Map.Entry<String, Set<String>> next : dependentMap.entrySet()) {
            Set<String> value2 = next.getValue();
            value2.removeIf(dependentEmptySet::contains);
            if (!value2.isEmpty()) continue;
            next.setValue(null);
        }
        return this.hasRing(dependentMap);
    }

    private <T> List<T> deepCopy(List<T> list, Class<T> clazz) {
        String json = JSON.toJSONString(list);
        return JSON.parseArray((String)json, clazz);
    }

    private void handleRel(List<HisEntityDependentVO> copyList) {
        for (HisEntityDependentVO hisEntityDependentVO : copyList) {
            hisEntityDependentVO.setRow("R" + hisEntityDependentVO.getRow());
            List edEntityList = hisEntityDependentVO.getEdEntityList();
            if (edEntityList.size() <= 1) continue;
            for (int i = 1; i < edEntityList.size(); ++i) {
                HisEDEntityRelVO hisEDEntityRelVO = new HisEDEntityRelVO();
                hisEDEntityRelVO.setLeftEntityNum(((HisEDEntityVO)edEntityList.get(i - 1)).getEntity());
                ((HisEDEntityVO)edEntityList.get(i)).setEdEntityRel(hisEDEntityRelVO);
            }
        }
    }

    private List<HisEntityDependentVO> getOtherEdVOList() {
        long edId = this.getDataEntities()[0].getDataEntity().getLong("id");
        DynamicObject[] entities = HisEntityDependentServiceHelper.getEntities((QFilter[])new QFilter[]{new QFilter("ed", "!=", (Object)edId)});
        DynamicObject[] entityRel = HisEntityDependentServiceHelper.getEntityRel((QFilter[])new QFilter[]{new QFilter("ed", "!=", (Object)edId)});
        HisEntityDependentService service = new HisEntityDependentService();
        return service.buildHisEntityDependentVOList(entities, entityRel);
    }
}

