/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.hismodel.validate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.repository.hismodel.EventEntityRepository;
import kd.hr.hrcs.bussiness.domain.service.impl.HisEventEntityService;
import kd.hr.hrcs.bussiness.service.hismodel.model.constant.HisSystemConstants;

public class HisEventEntityRegValidator
extends AbstractValidator
implements HisSystemConstants {
    private final HisEventEntityService service = HisEventEntityService.getInstance();

    public void validate() {
        String operateKey;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey = this.getOperateKey()) {
            case "save": {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.checkMustInput(dataEntity);
                }
                break;
            }
            case "delete": {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.checkDeleteInput(dataEntity);
                }
                break;
            }
        }
    }

    private void checkDeleteInput(ExtendedDataEntity dataEntity) {
        boolean hasData;
        String name;
        DynamicObject dy = dataEntity.getDataEntity();
        Long id = dy.getLong("id");
        String isRef = this.service.checkIsRef(id, name = dy.getString("name"));
        if (HRStringUtils.isNotEmpty((String)isRef)) {
            this.addFatalErrorMessage(dataEntity, isRef);
        }
        if (hasData = EventEntityRepository.checkHasData((Long)id)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u4e8b\u52a1\u7ec4\u4e2d\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"HisEventEntityRegValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkMustInput(ExtendedDataEntity dataEntity) {
        boolean checkBizCloud;
        DynamicObject dy = dataEntity.getDataEntity();
        Long id = dy.getLong("id");
        DynamicObject busevententity = dy.getDynamicObject("busevententity");
        DynamicObject evententity = dy.getDynamicObject("evententity");
        DynamicObject hisevententity = dy.getDynamicObject("hisevententity");
        boolean fromDatabase = dy.getDataEntityState().getFromDatabase();
        boolean mustFill = this.service.checkMustFill(dy.getString("name"), dy.getString("number"), busevententity, evententity, hisevententity);
        if (mustFill) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"HisEventEntityRegValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        boolean checkModify = this.service.checkModify(fromDatabase, busevententity, evententity, hisevententity, id);
        if (checkModify) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u4e8b\u52a1\u7ec4\u4e2d\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"HisEventEntityRegValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        if (!(checkBizCloud = this.service.checkBizApp(busevententity, evententity, hisevententity))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e8b\u52a1\u5b9e\u4f53\u3001\u4e1a\u52a1\u4e8b\u52a1\u5173\u7cfb\u5b9e\u4f53\u3001\u5386\u53f2\u7248\u672c\u4e8b\u52a1\u5173\u7cfb\u5b9e\u4f53\u4e2d\u6240\u9009\u5b9e\u4f53\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u5e94\u7528\u3002", (String)"HisEventEntityRegValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
        List errorMsg = this.service.checkRepeat(id, busevententity, evententity, hisevententity);
        for (String msg : errorMsg) {
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }
}

