/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.msgcenter;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class MsgCenterSaveOp
extends HRDataBaseOp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                String feedback = row.getString("exceptionfeedback");
                if (HRStringUtils.isEmpty((String)feedback)) continue;
                entryMap.put(row.getLong("id"), row);
            }
        }
        try {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgexceptionlog");
            DynamicObject[] results = serviceHelper.query("id,msgcenterentry,exceptionfeedback,exceptionfeedbackdesc,exceptionfeedbacktime,createtime", new QFilter[]{new QFilter("msgcenterentry", "in", entryMap.keySet())});
            Map<Long, List<DynamicObject>> resultGroupMap = Arrays.stream(results).collect(Collectors.groupingBy(result -> result.getLong("msgcenterentry")));
            Date date = new Date();
            DynamicObjectCollection saveLogCol = new DynamicObjectCollection();
            entryMap.forEach((key, value) -> {
                List dynamicObjectList = (List)resultGroupMap.get(key);
                if (dynamicObjectList != null) {
                    dynamicObjectList.sort(Comparator.comparing(o -> ((DynamicObject)o).getDate("createtime")).reversed());
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
                    String feedback = dynamicObject.getString("exceptionfeedback");
                    if (HRStringUtils.isEmpty((String)feedback)) {
                        dynamicObject.set("exceptionfeedback", (Object)value.getString("exceptionfeedback"));
                        dynamicObject.set("exceptionfeedbackdesc", (Object)value.getString("exceptionfeedbackdesc"));
                        dynamicObject.set("exceptionfeedbacktime", (Object)date);
                        saveLogCol.add((Object)dynamicObject);
                    }
                }
            });
            serviceHelper.save(saveLogCol);
        }
        finally {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        }
    }
}

