/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.perm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.opplugin.validator.HRRoleGrpSaveValidator;

@ExcludeFromJacocoGeneratedReport
public class HRRoleGrpSaveOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(HRRoleGrpSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new HRRoleGrpSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("level");
        e.getFieldKeys().add("parent_id");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("fullname");
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("parent");
    }

    private List<Object> getOldParent(List<List<Object>> modify, String tableName, String routeKey, String fidTableName, String parentTableName, ISimpleProperty fidType) {
        ArrayList<Object> oldParent = new ArrayList<Object>(16);
        for (List<Object> list : modify) {
            if (list.size() <= 0) continue;
            this.getOldParent(tableName, routeKey, fidTableName, parentTableName, fidType, oldParent, list);
        }
        return oldParent;
    }

    private void getOldParent(String tableName, String routeKey, String fidTableName, String parentTableName, final ISimpleProperty fidType, List<Object> oldParent, List<Object> list) {
        String queryFid = this.stringJoin(list, ",");
        String querySql = "select  " + parentTableName + " from " + tableName + " where  " + fidTableName + " in  (" + queryFid + ")";
        List temp = new ArrayList(16);
        try {
            temp = (List)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)querySql, null, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                @ExcludeFromJacocoGeneratedReport
                public List<Object> handle(ResultSet rs) throws SQLException {
                    ArrayList<Object> temp;
                    block3: {
                        block2: {
                            temp = new ArrayList<Object>(16);
                            if (!(fidType instanceof VarcharProp)) break block2;
                            while (rs.next()) {
                                String tempValue = rs.getString(1);
                                temp.add(tempValue);
                            }
                            break block3;
                        }
                        if (!(fidType instanceof LongProp)) break block3;
                        while (rs.next()) {
                            Long tempValue = rs.getLong(1);
                            temp.add(tempValue);
                        }
                    }
                    return temp;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(Locale.ROOT, "error:%s;  sql:%s", e.getMessage(), querySql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        oldParent.addAll(temp);
    }

    private void baseTreeHandle(BeforeOperationArgs args) {
        DynamicObject[] doj = args.getDataEntities();
        HRBaseServiceHelper bosRoleGrpHelper = new HRBaseServiceHelper("perm_rolegroup");
        DynamicObject bosRoleGrp = bosRoleGrpHelper.generateEmptyDynamicObject();
        HashMap<Object, Object> saveMap = new HashMap<Object, Object>();
        HashMap<Object, Integer> deleteMap = new HashMap<Object, Integer>();
        if (doj != null && doj.length > 0) {
            this.doBaseTree(args, doj, bosRoleGrp, saveMap, deleteMap);
        }
    }

    private void doBaseTree(BeforeOperationArgs args, DynamicObject[] doj, DynamicObject bosRoleGrp, Map<Object, Object> saveMap, Map<Object, Integer> deleteMap) {
        IDataEntityType type = bosRoleGrp.getDataEntityType();
        ISimpleProperty pkProp = type.getPrimaryKey();
        String routeKey = type.getDBRouteKey();
        String fisleaf = "";
        String parentName = "";
        String tableName = bosRoleGrp.getDataEntityType().getAlias();
        String numberTabelName = "";
        String primaryKey = type.getPrimaryKey().getName();
        String fidTableName = type.getPrimaryKey() != null ? type.getPrimaryKey().getAlias() : "";
        String parentTableName = "";
        String numberName = ((BasedataEntityType)type).getBillNo();
        if (!this.checkBlank(numberName, tableName, primaryKey)) {
            return;
        }
        for (DynamicObject[] prop : type.getProperties()) {
            if (prop instanceof ParentBasedataProp) {
                parentName = prop.getName();
                parentTableName = prop.getAlias();
            }
            if (prop.getName().equals("isleaf")) {
                fisleaf = prop.getAlias();
            }
            if (!prop.getName().equals(numberName)) continue;
            numberTabelName = prop.getAlias();
        }
        if (!this.checkTableBlank(numberTabelName, parentName, fidTableName, parentTableName)) {
            return;
        }
        String sql = "update " + tableName + " set " + fisleaf + " =? where " + fidTableName + " =?";
        for (DynamicObject dynamicObject : doj) {
            DynamicObject parent = dynamicObject.getDynamicObject(parentName);
            boolean ifContinue = this.ifContinue(args, saveMap, deleteMap, fisleaf, primaryKey, dynamicObject, parent);
            if (ifContinue) continue;
            return;
        }
        Set<Map.Entry<Object, Object>> saveEntry = saveMap.entrySet();
        ArrayList<List<Object>> fids = new ArrayList<List<Object>>(16);
        List<Object> temp = new ArrayList<Object>(16);
        ArrayList<Object> saveParentId = new ArrayList<Object>(16);
        temp = this.handleSaveTemp(saveEntry, fids, temp);
        fids.add(temp);
        List<Object> modifyFid = this.isNewData(fids, tableName, routeKey, fidTableName, pkProp);
        this.doBaseTreeForDetail(doj, modifyFid, saveEntry, saveParentId, tableName, routeKey, fidTableName, parentTableName, pkProp, saveMap, deleteMap, fisleaf, sql);
    }

    private boolean checkBlank(String numberName, String tableName, String primaryKey) {
        return !StringUtils.isBlank((CharSequence)numberName) && !StringUtils.isBlank((CharSequence)tableName) && !StringUtils.isBlank((CharSequence)primaryKey);
    }

    private boolean checkTableBlank(String numberTabelName, String parentName, String fidTableName, String parentTableName) {
        return !StringUtils.isBlank((CharSequence)numberTabelName) && !StringUtils.isBlank((CharSequence)parentName) && !StringUtils.isBlank((CharSequence)fidTableName) && !StringUtils.isBlank((CharSequence)parentTableName);
    }

    private void doBaseTreeForDetail(DynamicObject[] doj, List<Object> modifyFid, Set<Map.Entry<Object, Object>> saveEntry, List<Object> saveParentId, String tableName, String routeKey, String fidTableName, String parentTableName, ISimpleProperty pkProp, Map<Object, Object> saveMap, Map<Object, Integer> deleteMap, String fisleaf, String sql) {
        if (CollectionUtils.isEmpty(modifyFid)) {
            doj[0].set("isleaf", (Object)1);
        }
        for (Map.Entry<Object, Object> entry : saveEntry) {
            if (modifyFid == null || modifyFid.contains(entry.getKey())) continue;
            saveParentId.add(entry.getValue());
        }
        ArrayList<Object> setZeroFids = new ArrayList<Object>(16);
        ArrayList<Object> setOneFids = new ArrayList<Object>(16);
        setZeroFids.addAll(saveParentId);
        ArrayList<List<Object>> modify = new ArrayList<List<Object>>(16);
        List<Object> temp = new ArrayList<Object>(16);
        temp = this.handleModifyTemp(temp, null == modifyFid ? Collections.emptyList() : modifyFid, modify);
        modify.add(temp);
        List<Object> oldParent = this.getOldParent(modify, tableName, routeKey, fidTableName, parentTableName, pkProp);
        ArrayList<List<Object>> queryParent = new ArrayList<List<Object>>(16);
        temp = new ArrayList(16);
        temp = this.handleBatchTempData(saveMap, temp, oldParent, queryParent);
        queryParent.add(temp);
        Map<Object, List<Object>> notModifys = this.hasChildren(queryParent, tableName, "modify", routeKey, fidTableName, parentTableName, pkProp);
        this.judgeOldParent(saveMap, setOneFids, notModifys);
        for (Map.Entry<Object, Object> entry : saveEntry) {
            setZeroFids.add(entry.getValue());
        }
        Set<Map.Entry<Object, Integer>> deleteEntry = deleteMap.entrySet();
        ArrayList<List<Object>> deleterQueryParent = new ArrayList<List<Object>>(16);
        temp = new ArrayList(16);
        temp = this.handlerDeleteTemp(temp, deleteEntry, deleterQueryParent);
        deleterQueryParent.add(temp);
        Map<Object, List<Object>> deleteParentChildren = this.hasChildren(deleterQueryParent, tableName, "delete", routeKey, fidTableName, parentTableName, pkProp);
        HashMap<Object, Integer> tempMap = new HashMap<Object, Integer>();
        this.buildTempMap(deleteParentChildren, tempMap);
        this.compareDeleteAndChild(setOneFids, deleteEntry, tempMap);
        this.submitSqlAndDb(routeKey, fisleaf, fidTableName, sql, setZeroFids, setOneFids);
    }

    private List<Object> handleSaveTemp(Set<Map.Entry<Object, Object>> saveEntry, List<List<Object>> fids, List<Object> temp) {
        int index = 0;
        for (Map.Entry<Object, Object> entry : saveEntry) {
            if (index < 1000) {
                temp.add(entry.getKey());
            } else {
                temp.add(entry.getKey());
                fids.add(temp);
                temp = new ArrayList<Object>(16);
                index = 0;
            }
            ++index;
        }
        return temp;
    }

    private List<Object> handleModifyTemp(List<Object> temp, List<Object> modifyFid, List<List<Object>> modify) {
        int index = 0;
        for (Object object : modifyFid) {
            if (index < 1000) {
                temp.add(object);
            } else {
                temp.add(object);
                modify.add(temp);
                temp = new ArrayList<Object>(16);
                index = 0;
            }
            ++index;
        }
        return temp;
    }

    private List<Object> handleBatchTempData(Map<Object, Object> saveMap, List<Object> temp, List<Object> oldParent, List<List<Object>> queryParent) {
        int index = 0;
        for (Object object : oldParent) {
            if (saveMap.containsValue(object)) continue;
            if (index < 1000) {
                temp.add(object);
            } else {
                temp.add(object);
                queryParent.add(temp);
                temp = new ArrayList<Object>(16);
                index = 0;
            }
            ++index;
        }
        return temp;
    }

    private void judgeOldParent(Map<Object, Object> saveMap, List<Object> setOneFids, Map<Object, List<Object>> notModifys) {
        for (Map.Entry<Object, List<Object>> entry : notModifys.entrySet()) {
            int otherSunCount = 0;
            List<Object> suns = entry.getValue();
            for (Object object : suns) {
                if (saveMap.containsKey(object)) continue;
                ++otherSunCount;
            }
            if (otherSunCount != 0) continue;
            setOneFids.add(entry.getKey());
        }
    }

    private List<Object> handlerDeleteTemp(List<Object> temp, Set<Map.Entry<Object, Integer>> deleteEntry, List<List<Object>> deleterQueryParent) {
        int index = 0;
        for (Map.Entry<Object, Integer> entry : deleteEntry) {
            if (index < 1000) {
                temp.add(entry.getKey());
            } else {
                temp.add(entry.getKey());
                deleterQueryParent.add(temp);
                temp = new ArrayList<Object>(16);
                index = 0;
            }
            ++index;
        }
        return temp;
    }

    private void buildTempMap(Map<Object, List<Object>> deleteParentChildren, Map<Object, Integer> tempMap) {
        for (Map.Entry<Object, List<Object>> entry : deleteParentChildren.entrySet()) {
            List<Object> suns = entry.getValue();
            Integer tempObj = tempMap.get(entry.getKey());
            if (Objects.nonNull(tempObj)) {
                tempMap.put(entry.getKey(), tempMap.get(entry.getKey()) + suns.size());
                continue;
            }
            tempMap.put(entry.getKey(), suns.size());
        }
    }

    private void compareDeleteAndChild(List<Object> setOneFids, Set<Map.Entry<Object, Integer>> deleteEntry, Map<Object, Integer> tempMap) {
        for (Map.Entry<Object, Integer> entry : deleteEntry) {
            if (entry.getValue().intValue() != tempMap.get(entry.getKey()).intValue()) continue;
            setOneFids.add(entry.getKey());
        }
    }

    private void submitSqlAndDb(String routeKey, String fisleaf, String fidTableName, String sql, List<Object> setZeroFids, List<Object> setOneFids) {
        ArrayList<SqlParameter[]> sqlParameters = new ArrayList<SqlParameter[]>(16);
        for (Object object : setZeroFids) {
            sqlParameters.add(new SqlParameter[]{new SqlParameter(fisleaf, 1, (Object)0), new SqlParameter(fidTableName, 12, object)});
        }
        if (sqlParameters.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)sql, sqlParameters);
        }
        sqlParameters = new ArrayList(setZeroFids.size());
        for (Object object : setOneFids) {
            sqlParameters.add(new SqlParameter[]{new SqlParameter(fisleaf, 1, (Object)1), new SqlParameter(fidTableName, 12, object)});
        }
        if (sqlParameters.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)sql, sqlParameters);
        }
    }

    private boolean ifContinue(BeforeOperationArgs e, Map<Object, Object> saveMap, Map<Object, Integer> deleteMap, String fisleaf, String primaryKey, DynamicObject dynamicObject, DynamicObject parent) {
        if (StringUtils.isNotBlank((CharSequence)fisleaf)) {
            Object fid = dynamicObject.get(primaryKey);
            switch (e.getOperationKey()) {
                case "save": {
                    this.doSaveAction(saveMap, primaryKey, parent, fid);
                    break;
                }
                case "submit": {
                    this.doSaveAction(saveMap, primaryKey, parent, fid);
                    break;
                }
                case "delete": {
                    this.handleDelete(parent, deleteMap, primaryKey);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void handleDelete(DynamicObject parent, Map<Object, Integer> deleteMap, String primaryKey) {
        if (parent != null) {
            if (deleteMap.containsKey(parent.get(primaryKey))) {
                deleteMap.put(parent.get(primaryKey), deleteMap.get(parent.get(primaryKey)) + 1);
            } else {
                deleteMap.put(parent.get(primaryKey), 1);
            }
        }
    }

    private void doSaveAction(Map<Object, Object> saveMap, String primaryKey, DynamicObject parent, Object fid) {
        if (parent != null) {
            saveMap.put(fid, parent.get(primaryKey));
        }
    }

    private Map<Object, List<Object>> hasChildren(List<List<Object>> fids, String tableName, String operationType, String routeKey, String fidTableName, String parentTableName, ISimpleProperty fidType) {
        HashMap<Object, List<Object>> hasChildrenFid = new HashMap<Object, List<Object>>(16);
        for (List<Object> list : fids) {
            if (list.isEmpty()) continue;
            String queryFid = this.stringJoin(list, ",");
            String querySql = "select " + parentTableName + "," + fidTableName + " from  " + tableName + " where " + parentTableName + " in (" + queryFid + ") order by " + parentTableName;
            Map<Object, List<Object>> temp = new HashMap<Object, List<Object>>();
            temp = this.getChildren(routeKey, fidType, querySql, temp);
            hasChildrenFid.putAll(temp);
        }
        return hasChildrenFid;
    }

    private Map<Object, List<Object>> getChildren(String routeKey, ISimpleProperty fidType, String querySql, Map<Object, List<Object>> temp) {
        try {
            temp = (Map)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)querySql, null, rs -> {
                HashMap<Object, List<Object>> map = new HashMap<Object, List<Object>>(16);
                if (fidType instanceof VarcharProp) {
                    this.handleVarcharProp(rs, map);
                } else if (fidType instanceof LongProp) {
                    this.handleLongProp(rs, map);
                }
                return map;
            });
        }
        catch (Exception e) {
            String msg = String.format(Locale.ROOT, "error:%s;  sql:%s ", e.getMessage(), querySql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return temp;
    }

    private void handleVarcharProp(ResultSet rs, Map<Object, List<Object>> map) throws SQLException {
        while (rs.next()) {
            String key = rs.getString(1);
            List<Object> objects = map.get(key);
            if (objects != null) {
                objects.add(rs.getString(2));
                continue;
            }
            ArrayList<String> list = new ArrayList<String>(16);
            list.add(rs.getString(2));
            map.put(key, list);
        }
    }

    private void handleLongProp(ResultSet rs, Map<Object, List<Object>> map) throws SQLException {
        while (rs.next()) {
            Long key = rs.getLong(1);
            if (map.containsKey(key)) {
                map.get(key).add(rs.getLong(2));
                continue;
            }
            ArrayList<Long> list = new ArrayList<Long>(16);
            list.add(rs.getLong(2));
            map.put(key, list);
        }
    }

    private List<Object> isNewData(List<List<Object>> fids, String tableName, String routeKey, String fidTableName, ISimpleProperty fidType) {
        ArrayList<Object> modifyFids = new ArrayList<Object>(16);
        for (List<Object> list : fids) {
            if (list.size() <= 0) continue;
            String queryFid = this.stringJoin(list, ",");
            String querySql = "select " + fidTableName + " from " + tableName + " where " + fidTableName + " in (" + queryFid + ")";
            ArrayList<Object> temp = new ArrayList<Object>(16);
            this.checkIsNewData(routeKey, fidType, modifyFids, querySql, temp);
        }
        return modifyFids;
    }

    private void checkIsNewData(String routeKey, ISimpleProperty fidType, List<Object> modifyFids, String querySql, List<Object> temp) {
        try {
            temp = (List)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)querySql, null, rs -> {
                ArrayList<Object> temp1;
                block3: {
                    block2: {
                        temp1 = new ArrayList<Object>(16);
                        if (!(fidType instanceof VarcharProp)) break block2;
                        while (rs.next()) {
                            String tempValue = rs.getString(1);
                            temp1.add(tempValue);
                        }
                        break block3;
                    }
                    if (!(fidType instanceof LongProp)) break block3;
                    while (rs.next()) {
                        Long tempValue = rs.getLong(1);
                        temp1.add(tempValue);
                    }
                }
                return temp1;
            });
        }
        catch (Exception e) {
            String msg = String.format(Locale.ROOT, "error:%s;  sql:%s", e.getMessage(), querySql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        modifyFids.addAll(temp);
    }

    private String stringJoin(List<Object> list, String spliter) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        boolean isString = false;
        for (Object object : list) {
            if (index == 0) {
                this.handleIndexEqualsZero(object, isString, sb);
            } else {
                this.handleIndexNotEqualsZero(object, isString, sb);
            }
            ++index;
        }
        return sb.toString();
    }

    private void handleIndexEqualsZero(Object object, boolean isString, StringBuilder sb) {
        if (object instanceof String) {
            isString = true;
        }
        if (isString) {
            sb.append('\'').append(object.toString()).append('\'');
        } else {
            sb.append(object);
        }
    }

    private void handleIndexNotEqualsZero(Object object, boolean isString, StringBuilder sb) {
        if (isString) {
            sb.append(",").append('\'').append(object).append('\'');
        } else {
            sb.append(",").append(object);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String oriParentId = this.getOriParentId(args);
        this.baseTreeHandle(args);
        this.longNumberHandle(args);
        super.beforeExecuteOperationTransaction(args);
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        String operateType = (String)operMeta.get("type");
        String selectField = "id,longnumber,fullname,level";
        if (StringUtils.isEmpty((CharSequence)operateType) || !operateType.equals("save")) {
            return;
        }
        DynamicObject[] list = args.getDataEntities();
        String longNumberDLM = ".";
        if (list.length > 0) {
            longNumberDLM = this.getLongNumberDLM(longNumberDLM, list[0]);
        }
        ORM orm = ORM.create();
        for (DynamicObject doj : list) {
            String number = doj.getString("number");
            String name = doj.getString("name");
            int level = 0 == doj.getInt("level") ? 1 : doj.getInt("level");
            Object parentId = doj.get("parent_id");
            if (doj.getDataEntityType().getProperties().get((Object)"parent") == null) continue;
            this.modifyParent(orm, selectField, list, longNumberDLM, doj, number, name, level, parentId);
        }
        try (TXHandle txHandle = TX.required();){
            try {
                this.doSave(list, args);
                if (HRStringUtils.isNotEmpty((String)oriParentId) && !HRStringUtils.equals((String)oriParentId, (String)"0")) {
                    this.resetOriParentIsLeaf(oriParentId);
                }
            }
            catch (Exception ex) {
                txHandle.markRollback();
            }
        }
    }

    private String getOriParentId(BeforeOperationArgs args) {
        String curId;
        HRBaseServiceHelper helper;
        DynamicObject dyna;
        if (args.getDataEntities().length > 0 && (dyna = (helper = new HRBaseServiceHelper("perm_rolegroup")).queryOne("parent.id", (Object)(curId = args.getDataEntities()[0].getString("id")))) != null) {
            return dyna.getString("parent.id");
        }
        return "";
    }

    private void resetOriParentIsLeaf(String oriParentId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_rolegroup");
        boolean hasSon = helper.isExists(new QFilter("parent.id", "=", (Object)oriParentId));
        String isLeaf = hasSon ? "0" : "1";
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)oriParentId);
        dynamicObject.set("isleaf", (Object)isLeaf);
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private void doSave(DynamicObject[] list, BeforeOperationArgs args) {
        DynamicObject dyObj = list[0];
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_rolegroup");
        String roleGrpId = dyObj.getString("id");
        Object[] query = helper.query("id,number,name,description,parent,level,isleaf,enable,longnumber,creator,createtime,modifier,modifytime,status", new QFilter[]{new QFilter("id", "=", (Object)dyObj.getString("id"))});
        Object roleGroup = ArrayUtils.isNotEmpty((Object[])query) ? query[0] : helper.generateEmptyDynamicObject();
        String number = dyObj.getString("number");
        if (Objects.isNull(number = this.checkRepeatNumber(helper, number, roleGrpId))) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002", (String)"HRRoleGrpSaveOp_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject newParent = dyObj.getDynamicObject("parent");
        this.setRoleGroupDy(dyObj, (DynamicObject)roleGroup, newParent, number);
        DynamicObject[] ids = HRStringUtils.isNotEmpty((String)roleGrpId) ? (DynamicObject[])helper.update(new DynamicObject[]{roleGroup}) : (DynamicObject[])helper.save(new DynamicObject[]{roleGroup});
        args.getDataEntities()[0].set("id", ids[0].get("id"));
    }

    private String checkRepeatNumber(HRBaseServiceHelper helper, String number, String roleGrpId) {
        DynamicObject[] dataDys = helper.query(new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (dataDys != null && dataDys.length > 1) {
            String dyStr = SerializationUtils.toJsonString((Object)dataDys);
            LOGGER.info(String.format(Locale.ROOT, "(number:%s)too many group exist:%s", number, dyStr));
            return null;
        }
        if (dataDys != null && dataDys.length == 1) {
            DynamicObject dataDy = dataDys[0];
            LOGGER.info(String.format(Locale.ROOT, "groupId:%s_%s;groupInfo:%s", roleGrpId, dataDy.getString("id"), dataDy));
            return HRStringUtils.isEmpty((String)roleGrpId) ? this.getNumber() : (dataDy.getString("id").equals(roleGrpId) ? number : null);
        }
        this.getNumber();
        LOGGER.info(String.format(Locale.ROOT, "group number %s does not exist.", number));
        return number;
    }

    private String getLongNumberDLM(String longNumberDLM, DynamicObject dynamicObject) {
        for (IDataEntityProperty dymProperty : dynamicObject.getDataEntityType().getProperties()) {
            if (!(dymProperty instanceof ParentBasedataProp)) continue;
            longNumberDLM = ((ParentBasedataProp)dymProperty).getLongNumberDLM();
            break;
        }
        return longNumberDLM;
    }

    private void setRoleGroupDy(DynamicObject dyObj, DynamicObject rolegroup, Object newParent, String number) {
        rolegroup.set("id", (Object)dyObj.getString("id"));
        rolegroup.set("number", (Object)number);
        rolegroup.set("name", (Object)dyObj.getString("name"));
        rolegroup.set("description", (Object)dyObj.getString("description"));
        rolegroup.set("parent", Objects.isNull(newParent) ? "0" : newParent);
        rolegroup.set("level", dyObj.get("level"));
        rolegroup.set("isleaf", dyObj.get("isleaf"));
        rolegroup.set("enable", dyObj.get("enable"));
        rolegroup.set("longnumber", dyObj.get("longnumber"));
        rolegroup.set("creator", dyObj.get("creator"));
        rolegroup.set("createtime", dyObj.get("createtime"));
        rolegroup.set("modifier", dyObj.get("modifier"));
        rolegroup.set("modifytime", dyObj.get("modifytime"));
        rolegroup.set("status", dyObj.get("status"));
    }

    private void modifyParent(ORM orm, String selectField, DynamicObject[] list, String longNumberDLM, DynamicObject doj, String number, String name, int level, Object parentId) {
        String parentLongName = doj.getString("parent.fullname");
        int parentLevel = doj.getInt("parent.level");
        if (StringUtils.isNotBlank((CharSequence)number)) {
            Object[] returnData = this.handleParentLongNumberNotBlank(orm, selectField, list, longNumberDLM, doj, number, parentId);
            parentLongName = (String)returnData[0];
            parentLevel = (Integer)returnData[1];
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            doj.set("fullname", (Object)(StringUtils.isNotBlank((CharSequence)parentLongName) ? parentLongName + longNumberDLM + name : name));
        }
        doj.set("level", (Object)(parentLevel != 0 ? parentLevel + 1 : level));
    }

    private Object[] handleParentLongNumberNotBlank(ORM orm, String selectField, DynamicObject[] list, String longNumberDLM, DynamicObject doj, String number, Object parentId) {
        Object[] returnData = new Object[2];
        String parentLongName = doj.getString("parent.fullname");
        String parentLongNumber = doj.getString("parent.longnumber");
        int parentLevel = doj.getInt("parent.level");
        if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
            doj.set("longnumber", (Object)(parentLongNumber + longNumberDLM + number));
        } else {
            for (DynamicObject dynamicObject : list) {
                if (!dynamicObject.get("id").equals(parentId)) continue;
                parentLongNumber = dynamicObject.getString("longnumber");
                parentLongName = dynamicObject.getString("fullname");
                parentLevel = dynamicObject.getInt("level");
                break;
            }
            if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
                doj.set("longnumber", (Object)(parentLongNumber + longNumberDLM + number));
            } else {
                Object[] detailReturnData = this.handleParentLongNumberDetail(orm, selectField, longNumberDLM, doj, number, parentId, parentLongName, parentLevel);
                parentLongName = (String)detailReturnData[0];
                parentLevel = (Integer)detailReturnData[1];
            }
        }
        returnData[0] = parentLongName;
        returnData[1] = parentLevel;
        return returnData;
    }

    private Object[] handleParentLongNumberDetail(ORM orm, String selectField, String longNumberDLM, DynamicObject doj, String number, Object parentId, String parentLongName, int parentLevel) {
        Object[] returnData = new Object[2];
        if (parentId != null) {
            QFilter filter = new QFilter("id", "=", parentId);
            DynamicObject tempDoj = orm.queryOne("perm_rolegroup", selectField, new QFilter[]{filter});
            if (tempDoj != null) {
                String parentLongNumber = tempDoj.getString("longnumber");
                parentLongName = tempDoj.getString("fullname");
                parentLevel = tempDoj.getInt("level");
                doj.set("longnumber", (Object)(StringUtils.isNotBlank((CharSequence)parentLongNumber) ? parentLongNumber + longNumberDLM + number : number));
            } else {
                doj.set("longnumber", (Object)number);
            }
        } else {
            doj.set("longnumber", (Object)number);
        }
        returnData[0] = parentLongName;
        returnData[1] = parentLevel;
        return returnData;
    }

    private void longNumberHandle(BeforeOperationArgs e) {
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        String operateType = (String)operMeta.get("type");
        if (StringUtils.isNotEmpty((CharSequence)"operateType") && (operateType.equals("save") || operateType.equals("submit"))) {
            DynamicObject[] list = e.getDataEntities();
            String longNumberDLM = ".";
            if (list.length > 0) {
                longNumberDLM = this.getLongNumberDLM(longNumberDLM, list[0]);
            }
            this.handleLongNumberModifyParent(list, longNumberDLM);
        }
    }

    private void handleLongNumberModifyParent(DynamicObject[] list, String longNumberDLM) {
        ORM orm = ORM.create();
        String selectField = "id,longnumber,fullname,level";
        for (DynamicObject doj : list) {
            String number = doj.getString("number");
            String name = doj.getString("name");
            int level = doj.getInt("level");
            Object parentId = doj.get("parent_id");
            if (doj.getDataEntityType().getProperties().get((Object)"parent") == null) continue;
            this.modifyParentLongNumber(orm, selectField, list, longNumberDLM, doj, number, name, level, parentId);
        }
    }

    private void modifyParentLongNumber(ORM orm, String selectField, DynamicObject[] list, String longNumberDLM, DynamicObject doj, String number, String name, int level, Object parentId) {
        String parentLongnumber = "";
        int countParentLevel = 0;
        parentLongnumber = doj.getString("parent.longnumber");
        countParentLevel = doj.getInt("parent.level");
        if (StringUtils.isNotBlank((CharSequence)number)) {
            if (StringUtils.isNotBlank((CharSequence)parentLongnumber)) {
                doj.set("longnumber", (Object)(parentLongnumber + longNumberDLM + number));
            } else {
                countParentLevel = this.handleLongNumberExist(orm, selectField, list, longNumberDLM, doj, number, parentId, parentLongnumber, countParentLevel);
            }
        }
        doj.set("fullname", (Object)name);
        if (countParentLevel != 0) {
            doj.set("level", (Object)(countParentLevel + 1));
        } else {
            doj.set("level", (Object)level);
        }
    }

    private int handleLongNumberExist(ORM orm, String selectField, DynamicObject[] list, String longNumberDLM, DynamicObject doj, String number, Object parentId, String parentLongnumber, int parentLevel) {
        for (DynamicObject dyo : list) {
            if (!dyo.get("id").equals(parentId)) continue;
            parentLongnumber = dyo.getString("longnumber");
            parentLevel = dyo.getInt("level");
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)parentLongnumber)) {
            doj.set("longnumber", (Object)(parentLongnumber + longNumberDLM + number));
        } else {
            parentLevel = this.queryByParent(orm, selectField, longNumberDLM, doj, number, parentId, parentLevel);
        }
        return parentLevel;
    }

    private int queryByParent(ORM orm, String selectField, String longNumberDLM, DynamicObject doj, String number, Object parentId, int parentLevel) {
        if (parentId != null) {
            QFilter filter = new QFilter("id", "=", parentId);
            DynamicObject tempDoj = orm.queryOne("perm_rolegroup", selectField, new QFilter[]{filter});
            if (tempDoj != null) {
                String parentLongnumber = tempDoj.getString("longnumber");
                parentLevel = tempDoj.getInt("level");
                if (StringUtils.isNotBlank((CharSequence)parentLongnumber)) {
                    doj.set("longnumber", (Object)(parentLongnumber + longNumberDLM + number));
                } else {
                    doj.set("longnumber", (Object)number);
                }
            } else {
                doj.set("longnumber", (Object)number);
            }
        } else {
            doj.set("longnumber", (Object)number);
        }
        return parentLevel;
    }

    private String getNumber() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_rolegroup");
        DynamicObject roleGroup = serviceHelper.generateEmptyDynamicObject();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"perm_rolegroup", (DynamicObject)roleGroup, null);
        LOGGER.info("coderule get number ");
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)roleGroup);
    }
}

