/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.perm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

@ExcludeFromJacocoGeneratedReport
public class PermFilesGrpSaveOp
extends HRDataBaseOp {
    private static final String FULLNAME = "fullname";
    private static final String ENTITYTYPE_HBSS_PERMFILEGRP = "hrcs_permfilegrp";

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        this.longNumberHandle(args);
        DynamicObject[] datas = args.getDataEntities();
        String key = args.getOperationKey();
        if (HRStringUtils.equals((String)key, (String)"save")) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DynamicObject data : datas) {
                if (!ObjectUtils.isEmpty((Object)data.get("parent"))) continue;
                ids.add(data.getLong("id"));
            }
            QFilter qfilter = new QFilter("parent", "in", (Object)ids.toArray());
            HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITYTYPE_HBSS_PERMFILEGRP);
            DynamicObjectCollection collection = helper.queryOriginalCollection("parent", new QFilter[]{qfilter});
            if (collection.size() == 0) {
                return;
            }
            HashSet idSet = new HashSet();
            collection.forEach(dynamicObject -> idSet.add(dynamicObject.getLong("parent")));
            for (DynamicObject data : datas) {
                if (!idSet.contains(data.getLong("id"))) continue;
                data.set("isleaf", (Object)0);
            }
        }
    }

    private void longNumberHandle(BeginOperationTransactionArgs args) {
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        ORM orm = ORM.create();
        String operateType = (String)operMeta.get("type");
        String selectField = "id,longnumber,fullname,level";
        if (StringUtils.isNotEmpty((CharSequence)"operateType") && (operateType.equals("save") || operateType.equals("submit"))) {
            DynamicObject[] list = args.getDataEntities();
            String longNumberDLM = ".";
            if (list.length > 0) {
                longNumberDLM = this.getLongNumber(list, longNumberDLM);
            }
            for (DynamicObject doj : list) {
                String number = doj.getString("number");
                String name = doj.getString("name");
                int level = doj.getInt("level");
                Object parentId = doj.get("parent_id");
                if (doj.getDataEntityType().getProperties().get((Object)"parent") == null) continue;
                this.modifyParentLongNumber(orm, selectField, list, longNumberDLM, doj, number, name, level, parentId);
            }
        }
    }

    private String getLongNumber(DynamicObject[] list, String longNumberDLM) {
        for (IDataEntityProperty dymProperty : list[0].getDataEntityType().getProperties()) {
            if (!(dymProperty instanceof ParentBasedataProp)) continue;
            longNumberDLM = ((ParentBasedataProp)dymProperty).getLongNumberDLM();
            break;
        }
        return longNumberDLM;
    }

    private void modifyParentLongNumber(ORM orm, String selectField, DynamicObject[] list, String longNumberDLM, DynamicObject doj, String number, String name, int level, Object parentId) {
        String parentLongnumber = "";
        int parentLevel = 0;
        parentLongnumber = doj.getString("parent.longnumber");
        parentLevel = doj.getInt("parent.level");
        if (StringUtils.isNotBlank((CharSequence)number)) {
            if (StringUtils.isNotBlank((CharSequence)parentLongnumber)) {
                doj.set("longnumber", (Object)(parentLongnumber + longNumberDLM + number));
            } else {
                parentLevel = this.handleLongNumberExist(orm, selectField, list, longNumberDLM, doj, number, parentId, parentLongnumber, parentLevel);
            }
        }
        doj.set(FULLNAME, (Object)name);
        if (parentLevel != 0) {
            doj.set("level", (Object)(parentLevel + 1));
        } else {
            doj.set("level", (Object)level);
        }
    }

    private int handleLongNumberExist(ORM orm, String selectField, DynamicObject[] list, String longNumberDLM, DynamicObject dyo, String number, Object parentId, String parentLongNum, int parentLevel) {
        for (DynamicObject dynamicObject : list) {
            if (!dynamicObject.get("id").equals(parentId)) continue;
            parentLongNum = dynamicObject.getString("longnumber");
            parentLevel = dynamicObject.getInt("level");
            break;
        }
        if (HRStringUtils.isNotEmpty((String)parentLongNum)) {
            dyo.set("longnumber", (Object)(parentLongNum + longNumberDLM + number));
        } else {
            parentLevel = this.queryByParent(orm, selectField, longNumberDLM, dyo, number, parentId, parentLevel);
        }
        return parentLevel;
    }

    private int queryByParent(ORM orm, String selectField, String longNumberDLM, DynamicObject doj, String number, Object parentId, int parentLevel) {
        if (parentId != null) {
            parentLevel = this.handleTempDoj(orm, selectField, longNumberDLM, doj, number, parentId, parentLevel);
        } else {
            doj.set("longnumber", (Object)number);
        }
        return parentLevel;
    }

    private int handleTempDoj(ORM orm, String selectField, String longNumberDLM, DynamicObject doj, String number, Object parentId, int parentLevel) {
        QFilter filter = new QFilter("id", "=", parentId);
        DynamicObject tempDoj = orm.queryOne(ENTITYTYPE_HBSS_PERMFILEGRP, selectField, new QFilter[]{filter});
        if (tempDoj != null) {
            String parentLongnumber = tempDoj.getString("longnumber");
            parentLevel = tempDoj.getInt("level");
            if (StringUtils.isNotBlank((CharSequence)parentLongnumber)) {
                doj.set("longnumber", (Object)(parentLongnumber + longNumberDLM + number));
            } else {
                doj.set("longnumber", (Object)number);
            }
        } else {
            doj.set("longnumber", (Object)number);
        }
        return parentLevel;
    }
}

