/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.calendar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class WorkingPlanServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(WorkingPlanServiceHelper.class);
    private static final char MONTH_CHINESE = '\u6708';
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String RANGE_TYPE = "rangeType";
    private static final String RANGE_HOLIDAY_TYPE = "rangeHolidayType";

    private static String workingHourIntToStr(int time) {
        int minute = (time /= 60) % 60;
        int hour = time / 60 % 24;
        return String.format("%02d:%02d", hour, minute);
    }

    public static String getWorkingHoursStr(IFormView view, String hoursId) {
        if (StringUtils.isBlank((CharSequence)hoursId)) {
            return null;
        }
        if (null == view) {
            return WorkingPlanServiceHelper.getWorkingHoursFromDb(Long.valueOf(hoursId));
        }
        String workingHours = view.getPageCache().get(hoursId);
        if (StringUtils.isBlank((CharSequence)workingHours)) {
            workingHours = WorkingPlanServiceHelper.getWorkingHoursFromDb(Long.valueOf(hoursId));
            view.getPageCache().put(hoursId, workingHours);
        }
        return workingHours;
    }

    private static String getWorkingHoursFromDb(Long hoursId) {
        DynamicObject hoursObject = WorkingPlanServiceHelper.getWorkHoursObj(hoursId);
        return hoursObject.getString("hourssummary");
    }

    public static DynamicObject getWorkHoursObj(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"working_hours", (String)"number,entryentity.starttime,entryentity.endtime,hourssummary,hours");
    }

    public static DynamicObject getWorkingPlanFromPlatform(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"working_plan");
    }

    public static boolean isExistsOtherWorkingPlan(String property, String value, Long wpId) {
        QFilter qFilter = new QFilter(property, "=", (Object)value);
        if (wpId != null && wpId > 0L) {
            qFilter.and("id", "!=", (Object)wpId);
        }
        return QueryServiceHelper.exists((String)"working_plan", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject newWorkingPlanObj() {
        HRBaseServiceHelper workingPlan = new HRBaseServiceHelper("working_plan");
        Long logPkId = ORM.create().genLongId("working_plan");
        DynamicObject wpObj = workingPlan.generateEmptyDynamicObject();
        wpObj.set("id", (Object)logPkId);
        wpObj.set("masterid", (Object)logPkId);
        wpObj.set("enable", (Object)"1");
        wpObj.set("status", (Object)"C");
        wpObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        wpObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return wpObj;
    }

    public static void saveWorkingPlanObj(DynamicObject wpObj) {
        HRBaseServiceHelper workingPlan = new HRBaseServiceHelper("working_plan");
        workingPlan.saveOne(wpObj);
    }

    public static int deleteWorkingPlanObj(Long[] ids) {
        HRBaseServiceHelper wpAll = new HRBaseServiceHelper("working_plan");
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return wpAll.deleteByFilter(new QFilter[]{qFilter});
    }

    public static DynamicObject[] loadWorkingPlanObj(Long[] ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return BusinessDataServiceHelper.load((String)"working_plan", (String)"id,enable,name,number", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject newScopeObj() {
        HRBaseServiceHelper wpAllRange = new HRBaseServiceHelper("hrcs_workingplanallrange");
        return wpAllRange.generateEmptyDynamicObject();
    }

    public static int deleteScopeObj(long[] ids) {
        HRBaseServiceHelper wpAllRange = new HRBaseServiceHelper("hrcs_workingplanallrange");
        QFilter qFilter = new QFilter("wpid", "in", (Object)ids);
        return wpAllRange.deleteByFilter(new QFilter[]{qFilter});
    }

    public static void copyScopeValueForWorkingPlan(DynamicObject saveScopeObj, DynamicObject entityObj, boolean forSave) {
        if (saveScopeObj == null || entityObj == null) {
            return;
        }
        DataEntityPropertyCollection properties = saveScopeObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection moduleProperties = entityObj.getDataEntityType().getProperties();
        properties.forEach(iDataEntityProperty -> {
            if (moduleProperties.containsKey((Object)iDataEntityProperty.getName()) && !"id".equals(iDataEntityProperty.getName())) {
                if (forSave) {
                    saveScopeObj.set(iDataEntityProperty.getName(), entityObj.get(iDataEntityProperty.getName()));
                } else {
                    entityObj.set(iDataEntityProperty.getName(), saveScopeObj.get(iDataEntityProperty.getName()));
                }
            }
        });
    }

    public static void copyBasicInfoForWorkingPlan(DynamicObject destObj, DynamicObject sourceObj) {
        destObj.set("number", sourceObj.get("number"));
        Object nameObj = sourceObj.get("name");
        if (nameObj instanceof OrmLocaleValue) {
            OrmLocaleValue nameLocal = (OrmLocaleValue)nameObj;
            destObj.set("name", (Object)(nameLocal.getLocaleValue() == null ? nameLocal.toString() : nameLocal.getLocaleValue()));
        } else {
            destObj.set("name", nameObj);
        }
        destObj.set("startdate", sourceObj.get("startdate"));
        destObj.set("enddate", sourceObj.get("enddate"));
        destObj.set("countryid", sourceObj.get("countryid"));
        if (sourceObj.getDataEntityType().getProperties().containsKey((Object)"cardentryentity")) {
            DynamicObjectCollection workingTimeColl = sourceObj.getDynamicObjectCollection("cardentryentity");
            if (!workingTimeColl.isEmpty()) {
                DynamicObject workingTime = ((DynamicObject)workingTimeColl.get(0)).getDynamicObject("workingtime");
                destObj.set("workingtime", (Object)workingTime);
            }
        } else if (destObj.getDataEntityType().getProperties().containsKey((Object)"cardentryentity")) {
            DynamicObject workingTime = sourceObj.getDynamicObject("workingtime");
            DynamicObjectCollection workingTimeColl = destObj.getDynamicObjectCollection("cardentryentity");
            DynamicObject workingTimeRow = workingTimeColl.isEmpty() ? workingTimeColl.addNew() : (DynamicObject)workingTimeColl.get(0);
            workingTimeRow.set("validity_startdate", sourceObj.get("startdate"));
            workingTimeRow.set("validity_enddate", sourceObj.get("enddate"));
            workingTimeRow.set("workingtime", (Object)workingTime);
        } else {
            destObj.set("workingtime", sourceObj.get("workingtime"));
        }
    }

    public static void copyEntryForWorkingPlan(DynamicObject destObj, DynamicObject sourceObj, boolean forSave, IFormView view) {
        if (sourceObj == null || destObj == null) {
            return;
        }
        DynamicObjectCollection holidaySourceRowList = sourceObj.getDynamicObjectCollection("entryentity2");
        DynamicObjectCollection holidayDesc = destObj.getDynamicObjectCollection("entryentity2");
        if (holidaySourceRowList != null && !holidaySourceRowList.isEmpty()) {
            holidayDesc.clear();
            holidaySourceRowList.forEach(holidayRow -> {
                DynamicObject holidayColObj = holidayRow.getDynamicObject("holiday1");
                if (holidayColObj != null) {
                    DynamicObject descRow = holidayDesc.addNew();
                    descRow.set("seq", holidayRow.get("seq"));
                    descRow.set("id", holidayRow.get("id"));
                    descRow.set("holiday1", (Object)holidayColObj);
                }
            });
        } else if (CollectionUtils.isEmpty((Collection)holidaySourceRowList)) {
            holidayDesc.clear();
        }
        DynamicObjectCollection otherSourceRowList = sourceObj.getDynamicObjectCollection("entryentity1");
        DynamicObjectCollection otherDesc = destObj.getDynamicObjectCollection("entryentity1");
        if (otherSourceRowList != null && !otherSourceRowList.isEmpty()) {
            otherDesc.clear();
            otherSourceRowList.forEach(sourceOtherRow -> {
                int seq = sourceOtherRow.getInt("seq");
                String dataType1 = sourceOtherRow.getString("datetype1");
                if (!StringUtils.isEmpty((CharSequence)dataType1)) {
                    DynamicObject descOtherRow = otherDesc.addNew();
                    descOtherRow.set("seq", (Object)seq);
                    descOtherRow.set("id", sourceOtherRow.get("id"));
                    descOtherRow.set("date1", sourceOtherRow.get("date1"));
                    if (descOtherRow.getDataEntityType().getProperties().containsKey((Object)"enddate1")) {
                        descOtherRow.set("enddate1", sourceOtherRow.get("date1"));
                    }
                    descOtherRow.set("datetype1", (Object)dataType1);
                    descOtherRow.set("specialdesc", sourceOtherRow.get("specialdesc"));
                    DynamicObject hours = sourceOtherRow.getDynamicObject("hours1");
                    if (forSave) {
                        descOtherRow.set("hours1", (Object)hours);
                    } else {
                        boolean isEnable = true;
                        if ("3".equals(dataType1)) {
                            isEnable = false;
                        } else {
                            descOtherRow.set("hours1", (Object)hours);
                            String summary1 = WorkingPlanServiceHelper.getWorkingHoursStr(view, hours == null ? null : String.valueOf(hours.get("id")));
                            descOtherRow.set("summary1", (Object)summary1);
                        }
                        view.setEnable(Boolean.valueOf(isEnable), seq - 1, new String[]{"hours1"});
                    }
                }
            });
        } else if (CollectionUtils.isEmpty((Collection)otherSourceRowList)) {
            otherDesc.clear();
        }
        destObj.set("entryentity2", (Object)holidayDesc);
        destObj.set("entryentity1", (Object)otherDesc);
    }

    public static DynamicObject loadScopeByWpId(Long wpId) {
        HRBaseServiceHelper workingPlan = new HRBaseServiceHelper("hrcs_workingplanallrange");
        QFilter qFilter = new QFilter("wpid", "=", (Object)wpId);
        return workingPlan.loadDynamicObject(qFilter);
    }

    public static void saveScopeObj(DynamicObject scopeObj) {
        HRBaseServiceHelper workingPlan = new HRBaseServiceHelper("hrcs_workingplanallrange");
        workingPlan.saveOne(scopeObj);
    }

    public static String getParamsCacheKey(IFormView view, String propertyName) {
        return String.format("%s_%s", view.getPageId(), propertyName);
    }

    public static String getDateByWeek(int year, int month, int weekOfMonth, int dayOfWeek) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        int calWeekDay = calendar.get(7) - 1;
        int actualWeekDay = calWeekDay == 0 ? 7 : calWeekDay;
        int sumDay = dayOfWeek >= actualWeekDay ? (weekOfMonth - 1) * 7 + dayOfWeek - (actualWeekDay - 1) : (weekOfMonth - 1) * 7 + (7 - actualWeekDay + 1) + dayOfWeek;
        calendar.set(5, sumDay);
        if (calendar.get(2) + 1 != month) {
            return "";
        }
        return HRDateTimeUtils.formatDate((Date)calendar.getTime());
    }

    public static int parseDayOfWeek(String dayOfWeek) {
        int newDayOfWeek = 0;
        switch (dayOfWeek) {
            case "\u661f\u671f\u4e00": {
                newDayOfWeek = 1;
                break;
            }
            case "\u661f\u671f\u4e8c": {
                newDayOfWeek = 2;
                break;
            }
            case "\u661f\u671f\u4e09": {
                newDayOfWeek = 3;
                break;
            }
            case "\u661f\u671f\u56db": {
                newDayOfWeek = 4;
                break;
            }
            case "\u661f\u671f\u4e94": {
                newDayOfWeek = 5;
                break;
            }
            case "\u661f\u671f\u516d": {
                newDayOfWeek = 6;
                break;
            }
            case "\u661f\u671f\u65e5": {
                newDayOfWeek = 7;
                break;
            }
        }
        return newDayOfWeek;
    }

    public static Map<String, Object> getCalendarData(Long wpId, Date rangeStart, Date rangeEnd) {
        DynamicObject wpObjFromPlatform = WorkingPlanServiceHelper.getWorkingPlanFromPlatform(wpId);
        long workingTimeId = 0L;
        if (wpObjFromPlatform.getDataEntityType().getProperties().containsKey((Object)"cardentryentity")) {
            DynamicObjectCollection workingTimeColl = wpObjFromPlatform.getDynamicObjectCollection("cardentryentity");
            if (!workingTimeColl.isEmpty()) {
                DynamicObject workingTime = ((DynamicObject)workingTimeColl.get(0)).getDynamicObject("workingtime");
                workingTimeId = workingTime.getLong("id");
            }
        } else {
            workingTimeId = wpObjFromPlatform.getDynamicObject("workingtime").getLong("id");
        }
        DynamicObject workingTime = BusinessDataServiceHelper.loadSingle((Object)workingTimeId, (String)"working_time");
        Date startDate = wpObjFromPlatform.getDate("startdate");
        Date endDate = wpObjFromPlatform.getDate("enddate");
        String startDateStr = HRDateTimeUtils.formatDate((Date)startDate);
        String endDateStr = HRDateTimeUtils.formatDate((Date)endDate);
        String startDateFull = wpObjFromPlatform.getString("startdate");
        Map<String, Object> workTypeList = WorkingPlanServiceHelper.processWorkType(workingTime, null, startDateFull);
        List<Map<String, String>> holidayList = WorkingPlanServiceHelper.processHoliday(startDate, endDate, wpObjFromPlatform.getDynamicObjectCollection("entryentity2"));
        List<Map<String, String>> otherDayList = WorkingPlanServiceHelper.processOtherDays(wpObjFromPlatform.getDynamicObjectCollection("entryentity1"), null);
        List<Map<String, String>> holidayRangeList = WorkingPlanServiceHelper.processHolidayRangeList(holidayList, otherDayList, startDate, endDate);
        List newOtherDayList = otherDayList.stream().filter(otherDayMap -> WorkingPlanServiceHelper.isInRangeByOtherDay(otherDayMap, rangeStart, rangeEnd)).collect(Collectors.toList());
        List newHolidayRangeList = holidayRangeList.stream().filter(rangeMap -> {
            try {
                return WorkingPlanServiceHelper.isInRangeByRange(rangeMap, rangeStart, rangeEnd);
            }
            catch (ParseException ex) {
                LOGGER.error(ex.getMessage());
                return false;
            }
        }).collect(Collectors.toList());
        List newHolidayList = holidayList.stream().filter(holidayMap -> WorkingPlanServiceHelper.isInRangeByHoliday(holidayMap, rangeStart, rangeEnd)).collect(Collectors.toList());
        HashMap calendarDataMap = Maps.newHashMapWithExpectedSize((int)6);
        calendarDataMap.put("startdate", startDateStr);
        calendarDataMap.put("enddate", endDateStr);
        calendarDataMap.put("workTypeList", workTypeList);
        calendarDataMap.put("holidayList", newHolidayList);
        calendarDataMap.put("otherDayList", newOtherDayList);
        calendarDataMap.put("holidayRangeList", newHolidayRangeList);
        return calendarDataMap;
    }

    public static Map<String, String> getCalendarDataWithDay(Long wpId, Date rangeStart, Date rangeEnd) {
        DynamicObjectCollection otherDays;
        Date workTimeStartDate;
        DynamicObject wpObjFromPlatform = WorkingPlanServiceHelper.getWorkingPlanFromPlatform(wpId);
        Date startDate = wpObjFromPlatform.getDate("startdate");
        Date endDate = wpObjFromPlatform.getDate("enddate");
        if (rangeStart.before(startDate)) {
            rangeStart = startDate;
        }
        if (rangeEnd.after(endDate)) {
            rangeEnd = endDate;
        }
        long workingTimeId = 0L;
        if (wpObjFromPlatform.getDataEntityType().getProperties().containsKey((Object)"cardentryentity")) {
            DynamicObjectCollection workingTimeColl = wpObjFromPlatform.getDynamicObjectCollection("cardentryentity");
            if (!workingTimeColl.isEmpty()) {
                DynamicObject workingTime = ((DynamicObject)workingTimeColl.get(0)).getDynamicObject("workingtime");
                workingTimeId = workingTime.getLong("id");
            }
        } else {
            workingTimeId = wpObjFromPlatform.getDynamicObject("workingtime").getLong("id");
        }
        DynamicObject workingTime = BusinessDataServiceHelper.loadSingle((Object)workingTimeId, (String)"working_time");
        String workTimeStartDateStr = workingTime.getString("startdate");
        if (HRStringUtils.isEmpty((String)workTimeStartDateStr)) {
            workTimeStartDateStr = wpObjFromPlatform.getString("startdate");
        }
        String cycleMode = workingTime.getString("cyclemode");
        DynamicObjectCollection workTypes = workingTime.getDynamicObjectCollection("entryentity");
        Map<Integer, DynamicObject> workTypeMap = workTypes.stream().collect(Collectors.toMap(workType -> workType.getInt("seq"), workType -> workType));
        List<Map<String, String>> holidayList = WorkingPlanServiceHelper.processHoliday(rangeStart, rangeEnd, wpObjFromPlatform.getDynamicObjectCollection("entryentity2"));
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            workTimeStartDate = HRDateTimeUtils.parseDate((String)workTimeStartDateStr, (String)DATE_FORMAT);
        }
        catch (ParseException ex) {
            LOGGER.error(ex.getMessage());
            return dataMap;
        }
        if (!workTimeStartDate.after(rangeStart)) {
            workTimeStartDate = rangeStart;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(workTimeStartDate);
        if ("A".equals(cycleMode)) {
            while (!calendar.getTime().after(rangeEnd)) {
                int seq = calendar.get(7) == 1 ? 7 : calendar.get(7) - 1;
                DynamicObject dynamicObject = workTypeMap.get(seq);
                String type = Objects.equals("3", dynamicObject.getString("datetype")) ? "2" : "1";
                dataMap.put(HRDateTimeUtils.formatDate((Date)calendar.getTime()), type);
                calendar.add(5, 1);
            }
        } else {
            int count = 1;
            while (!calendar.getTime().after(rangeEnd)) {
                DynamicObject dynamicObject;
                if (count > workTypeMap.size()) {
                    count = 1;
                }
                String type = Objects.equals("3", (dynamicObject = workTypeMap.get(count)).getString("datetype")) ? "2" : "1";
                dataMap.put(HRDateTimeUtils.formatDate((Date)calendar.getTime()), type);
                calendar.add(5, 1);
                ++count;
            }
        }
        if ((otherDays = wpObjFromPlatform.getDynamicObjectCollection("entryentity1")) != null) {
            otherDays.forEach(otherDay -> {
                Date date = otherDay.getDate("date1");
                String dateType = otherDay.getString("datetype1");
                if (!StringUtils.isEmpty((CharSequence)dateType)) {
                    dataMap.put(HRDateTimeUtils.formatDate((Date)date), Objects.equals("3", dateType) ? "2" : "1");
                }
            });
        }
        holidayList.forEach(holiday -> {
            String[] holidays;
            for (String day : holidays = ((String)holiday.get("holiday")).split(",")) {
                dataMap.put(day, StringUtils.isEmpty((CharSequence)((CharSequence)holiday.get("workHours"))) ? "3" : "1");
            }
        });
        return dataMap;
    }

    public static Map<String, Object> processWorkType(DynamicObject workingTime, IFormView view, String startDateStr) {
        HashMap workingTimeMap = Maps.newHashMapWithExpectedSize((int)16);
        if (workingTime == null) {
            return workingTimeMap;
        }
        ArrayList dayTypeList = Lists.newArrayListWithExpectedSize((int)16);
        workingTimeMap.put("cyclemode", workingTime.getString("cyclemode"));
        String dateStr = workingTime.getString("startdate");
        if (HRStringUtils.isEmpty((String)dateStr)) {
            dateStr = startDateStr;
        }
        workingTimeMap.put("startdate", dateStr);
        workingTimeMap.put("dayTypeList", dayTypeList);
        DynamicObjectCollection workTypes = workingTime.getDynamicObjectCollection("entryentity");
        workTypes.forEach(workType -> {
            HashMap dayTypesMap = Maps.newHashMapWithExpectedSize((int)16);
            dayTypesMap.put("day", workType.getString("day"));
            dayTypesMap.put("datetype", workType.getString("datetype"));
            DynamicObject hours = workType.getDynamicObject("hours");
            if (hours != null) {
                String workingHoursStr = WorkingPlanServiceHelper.getWorkingHoursStr(view, hours.getString("id"));
                dayTypesMap.put("workHours", workingHoursStr);
            }
            dayTypeList.add(dayTypesMap);
        });
        return workingTimeMap;
    }

    public static List<Map<String, String>> processHoliday(Date startDate, Date endDate, DynamicObjectCollection holidays) {
        if (holidays == null || holidays.isEmpty()) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        return WorkingPlanServiceHelper.getEffectiveHoliday(startDate, endDate, holidays);
    }

    public static List<Map<String, String>> processOtherDays(DynamicObjectCollection otherDays, IFormView view) {
        ArrayList otherDayList = Lists.newArrayListWithExpectedSize((int)16);
        if (otherDays == null || otherDays.isEmpty()) {
            return otherDayList;
        }
        otherDays.forEach(otherDayEntry -> {
            HashMap otherDayMap = Maps.newHashMapWithExpectedSize((int)16);
            Date date = otherDayEntry.getDate("date1");
            if (date == null) {
                return;
            }
            otherDayMap.put("date", HRDateTimeUtils.formatDate((Date)date));
            otherDayMap.put("datetype", otherDayEntry.getString("datetype1"));
            DynamicObject hours1 = otherDayEntry.getDynamicObject("hours1");
            if (hours1 != null) {
                String workingHoursStr = WorkingPlanServiceHelper.getWorkingHoursStr(view, hours1.getString("id"));
                otherDayMap.put("workHours", workingHoursStr);
            }
            otherDayList.add(otherDayMap);
        });
        return otherDayList;
    }

    public static List<Map<String, String>> processHolidayRangeList(List<Map<String, String>> holidayList, List<Map<String, String>> otherDayList, Date startDate, Date endDate) {
        ArrayList holidayRangeList = Lists.newArrayListWithExpectedSize((int)16);
        if (holidayList == null || holidayList.isEmpty()) {
            return holidayRangeList;
        }
        for (Map<String, String> holidayObj : holidayList) {
            HashSet holidayRangeArr;
            String name = holidayObj.get("name");
            String holidayType = holidayObj.get("type");
            String holidayRangeStr = holidayObj.get("holiday");
            if ("2".equals(holidayType)) {
                holidayRangeArr = Sets.newHashSet((Object[])holidayRangeStr.split(","));
                Map<String, List<String>> yearGroupMap = holidayRangeArr.stream().collect(Collectors.groupingBy(holiday -> holiday.substring(0, holiday.indexOf(45))));
                yearGroupMap.values().forEach(yearGroup -> {
                    yearGroup.sort(WorkingPlanServiceHelper::getSortNumber);
                    HashMap<String, String> range = new HashMap<String, String>();
                    range.put(RANGE_TYPE, name);
                    range.put(RANGE_HOLIDAY_TYPE, holidayType);
                    range.put("rangeStart", (String)yearGroup.get(0));
                    range.put("rangeEnd", (String)yearGroup.get(yearGroup.size() - 1));
                    holidayRangeList.add(range);
                });
                continue;
            }
            if (!"1".equals(holidayType) && !"3".equals(holidayType)) continue;
            holidayRangeArr = Sets.newHashSet((Object[])holidayRangeStr.split(","));
            holidayRangeArr.forEach(holiday -> {
                HashMap<String, String> range = new HashMap<String, String>();
                range.put(RANGE_TYPE, name);
                range.put(RANGE_HOLIDAY_TYPE, holidayType);
                range.put("rangeStart", (String)holiday);
                range.put("rangeEnd", (String)holiday);
                holidayRangeList.add(range);
            });
        }
        WorkingPlanServiceHelper.sortedHolidayRangeList(holidayRangeList);
        List<Map<String, String>> mergeHolidayRangeList = WorkingPlanServiceHelper.getMergeHolidayRangeList(holidayRangeList);
        WorkingPlanServiceHelper.processOtherDayForRange(mergeHolidayRangeList, otherDayList, startDate, endDate);
        return mergeHolidayRangeList;
    }

    public static FormShowParameter getShowForm(Date startDate, Date endDate, Map<String, Object> workTypeMap, List<Map<String, String>> holidayList, List<Map<String, String>> otherDayList) {
        String startDateStr = HRDateTimeUtils.formatDate((Date)startDate);
        String endDateStr = HRDateTimeUtils.formatDate((Date)endDate);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("hrcs_workingplanpreview");
        showParameter.setCustomParam("startDate", (Object)startDateStr);
        showParameter.setCustomParam("endDate", (Object)endDateStr);
        showParameter.setCustomParam("workTypeList", workTypeMap);
        showParameter.setCustomParam("holidayList", holidayList);
        showParameter.setCustomParam("otherDayList", otherDayList);
        List<Map<String, String>> holidayRangeList = WorkingPlanServiceHelper.processHolidayRangeList(holidayList, otherDayList, startDate, endDate);
        showParameter.setCustomParam("holidayRangeList", holidayRangeList);
        InteServiceImpl intService = new InteServiceImpl();
        Map userFormat = intService.getUserFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        showParameter.setCustomParam("calendarFormat", userFormat.get("calendarFormat"));
        return showParameter;
    }

    private static void processOtherDayForRange(List<Map<String, String>> holidayRangeList, List<Map<String, String>> otherDayList, Date startDate, Date endDate) {
        if (otherDayList == null || otherDayList.isEmpty()) {
            return;
        }
        ArrayList otherHolidays = Lists.newArrayListWithExpectedSize((int)16);
        for (Map<String, String> otherDayRow : otherDayList) {
            String dateType = otherDayRow.get("datetype");
            if (!"3".equals(dateType)) continue;
            try {
                Date date;
                String dateStr = otherDayRow.get("date");
                if (!StringUtils.isNotEmpty((CharSequence)dateStr) || startDate.after(date = HRDateTimeUtils.parseDate((String)dateStr, (String)DATE_FORMAT)) || endDate.before(date)) continue;
                otherHolidays.add(date);
            }
            catch (ParseException ex) {
                throw new KDBizException((Throwable)ex, null, new Object[0]);
            }
        }
        List<Date> sortedOtherHolidays = otherHolidays.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        long dayMilSeconds = 86400000L;
        sortedOtherHolidays.forEach(otherHoliday -> {
            try {
                for (Map range : holidayRangeList) {
                    if (range.get("rangeStart") == null) continue;
                    Date rangeStartDay = HRDateTimeUtils.parseDate((String)((String)range.get("rangeStart")), (String)DATE_FORMAT);
                    long startMinus = rangeStartDay.getTime() - otherHoliday.getTime();
                    long startDayMinus = startMinus / dayMilSeconds;
                    if (startMinus > 0L && startDayMinus == 1L) {
                        range.put("rangeStart", HRDateTimeUtils.formatDate((Date)otherHoliday));
                    } else {
                        Date rangeEndDay = HRDateTimeUtils.parseDate((String)((String)range.get("rangeEnd")), (String)DATE_FORMAT);
                        long endMinus = otherHoliday.getTime() - rangeEndDay.getTime();
                        long endDayMinus = endMinus / dayMilSeconds;
                        if (endMinus <= 0L || endDayMinus != 1L) continue;
                        range.put("rangeEnd", HRDateTimeUtils.formatDate((Date)otherHoliday));
                    }
                    break;
                }
            }
            catch (ParseException ex) {
                throw new KDBizException(ex.getMessage());
            }
        });
    }

    private static boolean isInRangeByRange(Map<String, String> otherDayMap, Date rangeStart, Date rangeEnd) throws ParseException {
        String holidayRangeStart = otherDayMap.get("rangeStart");
        String holidayRangeEnd = otherDayMap.get("rangeEnd");
        Date holidayRangeStartDate = HRDateTimeUtils.parseDate((String)holidayRangeStart, (String)DATE_FORMAT);
        Date holidayRangeEndDate = HRDateTimeUtils.parseDate((String)holidayRangeEnd, (String)DATE_FORMAT);
        return holidayRangeStartDate.after(rangeStart) && holidayRangeEndDate.before(rangeEnd);
    }

    private static boolean isInRangeByHoliday(Map<String, String> holidayMap, Date rangeStart, Date rangeEnd) {
        String holiday = holidayMap.get("holiday");
        Object[] dates = holiday.split(",");
        HashSet dateSet = Sets.newHashSet((Object[])dates);
        Set<String> newDateSet = dateSet.stream().filter(dateStr -> {
            Date date;
            try {
                date = HRDateTimeUtils.parseDate((String)dateStr, (String)DATE_FORMAT);
            }
            catch (ParseException ex) {
                LOGGER.error(ex.getMessage());
                return false;
            }
            return date.after(rangeStart) && date.before(rangeEnd);
        }).collect(Collectors.toSet());
        if (newDateSet.size() == 0) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        newDateSet.forEach(newDate -> stringBuilder.append((String)newDate).append(','));
        holidayMap.put("holiday", stringBuilder.substring(0, stringBuilder.length() - 1));
        return true;
    }

    private static boolean isInRangeByOtherDay(Map<String, String> otherDayMap, Date rangeStart, Date rangeEnd) {
        Date date;
        try {
            date = HRDateTimeUtils.parseDate((String)otherDayMap.get("date"), (String)DATE_FORMAT);
        }
        catch (ParseException ex) {
            LOGGER.error(ex.getMessage());
            return false;
        }
        return date.after(rangeStart) && date.before(rangeEnd);
    }

    private static List<Map<String, String>> getEffectiveHoliday(Date startDate, Date endDate, DynamicObjectCollection holidays) {
        Map<String, String> holidayMap;
        ArrayList effectiveHolidayList = Lists.newArrayListWithExpectedSize((int)holidays.size());
        ArrayList fixedDateIdList = Lists.newArrayListWithExpectedSize((int)holidays.size());
        ArrayList specifyDateIdList = Lists.newArrayListWithExpectedSize((int)holidays.size());
        ArrayList fixedWeekIdList = Lists.newArrayListWithExpectedSize((int)holidays.size());
        HashSet timePeriodSet = Sets.newHashSetWithExpectedSize((int)holidays.size());
        holidays.forEach(holiday -> {
            long id = holiday.getLong("holiday1.id");
            if (id != 0L) {
                String type = holiday.getString("holiday1.type");
                if ("1".equals(type)) {
                    fixedDateIdList.add(id);
                } else if ("2".equals(type)) {
                    specifyDateIdList.add(id);
                } else if ("3".equals(type)) {
                    fixedWeekIdList.add(id);
                }
                timePeriodSet.add(holiday.getDynamicObject("holiday1").getLong("timeperiod.id"));
            }
        });
        HRBaseServiceHelper fixedDateServiceHelper = new HRBaseServiceHelper("public_holiday_fixeddate");
        DynamicObject[] fixedDateResults = fixedDateServiceHelper.query("id,month,dayofmonth,extendrules,type,holidayclass,name,timeperiod,holidaytype", new QFilter[]{new QFilter("id", "in", (Object)fixedDateIdList)});
        HRBaseServiceHelper specifyDateServiceHelper = new HRBaseServiceHelper("public_holiday_appointday");
        DynamicObject[] specifyDateResults = specifyDateServiceHelper.query("id,entryentity,entryentity.startdate,entryentity.enddate,entryentity.text,type,holidayclass,name,timeperiod,holidaytype", new QFilter[]{new QFilter("id", "in", (Object)specifyDateIdList)});
        HRBaseServiceHelper fixedWeekServiceHelper = new HRBaseServiceHelper("public_holiday_fixedweek");
        DynamicObject[] fixedWeekResults = fixedWeekServiceHelper.query("id,month,weekofmonth,dayofweek,type,holidayclass,name,timeperiod,holidaytype", new QFilter[]{new QFilter("id", "in", (Object)fixedWeekIdList)});
        HRBaseServiceHelper hoursServiceHelper = new HRBaseServiceHelper("working_hours");
        DynamicObject[] hoursResults = hoursServiceHelper.query("id,hourssummary", new QFilter[]{new QFilter("id", "in", (Object)timePeriodSet)});
        Map<Long, String> hoursSummaryMap = Arrays.stream(hoursResults).collect(Collectors.toMap(hours -> hours.getLong("id"), hours -> hours.getString("hourssummary")));
        for (DynamicObject fixedDate : fixedDateResults) {
            holidayMap = WorkingPlanServiceHelper.getHolidayMap(fixedDate, hoursSummaryMap);
            String holidayByFixedDate = WorkingPlanServiceHelper.getHolidayByFixedDate(fixedDate.getString("month"), fixedDate.getString("dayofmonth"), startDate, endDate, fixedDate.getString("extendrules"));
            if (holidayByFixedDate.length() <= 0) continue;
            String newHolidayByFixedDate = WorkingPlanServiceHelper.sortedHoliday(holidayByFixedDate);
            holidayMap.put("holiday", newHolidayByFixedDate);
            int dayCount = 0;
            for (String dayofmonth : fixedDate.getString("dayofmonth").split(",")) {
                if (StringUtils.isEmpty((CharSequence)dayofmonth)) continue;
                ++dayCount;
            }
            if (dayCount > 1) {
                holidayMap.put("holidayStart", WorkingPlanServiceHelper.getHolidayStart(fixedDate.getString("month"), fixedDate.getString("dayofmonth"), startDate, endDate));
            } else {
                holidayMap.put("holidayStart", newHolidayByFixedDate);
            }
            effectiveHolidayList.add(holidayMap);
        }
        for (DynamicObject specifyDate : specifyDateResults) {
            Set<String> holidayBySpecifyDates = WorkingPlanServiceHelper.getHolidayBySpecifyDate(specifyDate.getDynamicObjectCollection("entryentity"), startDate, endDate);
            holidayBySpecifyDates.forEach(holidayBySpecifyDate -> {
                String newHolidayBySpecifyDate = WorkingPlanServiceHelper.sortedHoliday(holidayBySpecifyDate);
                Map<String, String> holidayMap = WorkingPlanServiceHelper.getHolidayMap(specifyDate, hoursSummaryMap);
                holidayMap.put("holiday", newHolidayBySpecifyDate);
                holidayMap.put("holidayStart", WorkingPlanServiceHelper.getHolidayStart(specifyDate.getDynamicObjectCollection("entryentity"), holidayBySpecifyDate));
                effectiveHolidayList.add(holidayMap);
            });
        }
        for (DynamicObject fixedWeek : fixedWeekResults) {
            holidayMap = WorkingPlanServiceHelper.getHolidayMap(fixedWeek, hoursSummaryMap);
            String holidayByFixedWeek = WorkingPlanServiceHelper.getHolidayByFixedWeek(fixedWeek.getString("month"), fixedWeek.getString("weekofmonth"), fixedWeek.getString("dayofweek"), startDate, endDate);
            if (StringUtils.isEmpty((CharSequence)holidayByFixedWeek)) continue;
            holidayMap.put("holiday", WorkingPlanServiceHelper.sortedHoliday(holidayByFixedWeek));
            effectiveHolidayList.add(holidayMap);
        }
        return effectiveHolidayList;
    }

    private static String getHolidayStart(DynamicObjectCollection ranges, String holidayRange) {
        for (DynamicObject range : ranges) {
            Date leftDate = range.getDate("startdate");
            Date rightDate = range.getDate("enddate");
            String leftDateStr = HRDateTimeUtils.formatDate((Date)leftDate);
            if (!holidayRange.contains(leftDateStr) && !holidayRange.contains(HRDateTimeUtils.formatDate((Date)rightDate))) continue;
            return leftDateStr;
        }
        return "";
    }

    private static String getHolidayStart(String month, String dayOfMonth, Date startDate, Date endDate) {
        Set daySet = Arrays.stream(dayOfMonth.split(",")).filter(day -> !StringUtils.isEmpty((CharSequence)day)).map(Integer::parseInt).collect(Collectors.toSet());
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int startYear = calendar.get(1);
        calendar.setTime(endDate);
        int endYear = calendar.get(1);
        int i = startYear;
        while (i <= endYear) {
            int finalI = i++;
            daySet.stream().min(Comparator.naturalOrder()).ifPresent(day -> {
                calendar.set(finalI, Integer.parseInt(month) - 1, (int)day);
                if (daySet.size() > 1 || startDate.before(calendar.getTime()) && endDate.after(calendar.getTime())) {
                    stringBuilder.append(HRDateTimeUtils.formatDate((Date)calendar.getTime())).append(',');
                }
            });
        }
        return stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : "";
    }

    private static Map<String, String> getHolidayMap(DynamicObject holiday, Map<Long, String> hoursSummaryMap) {
        HashMap holidayMap = Maps.newHashMapWithExpectedSize((int)16);
        holidayMap.put("name", holiday.getString("name"));
        holidayMap.put("type", holiday.getString("type"));
        if (holiday.getBoolean("holidaytype")) {
            long hoursId = holiday.getLong("timeperiod.id");
            holidayMap.put("workHours", hoursSummaryMap.get(hoursId) == null ? "" : hoursSummaryMap.get(hoursId));
        }
        return holidayMap;
    }

    private static Set<String> getHolidayBySpecifyDate(DynamicObjectCollection holidayRanges, Date startDate, Date endDate) {
        ArrayList dateRangeList = Lists.newArrayListWithExpectedSize((int)holidayRanges.size());
        holidayRanges.sort(Comparator.comparing(x -> x.getDate("startdate")));
        Calendar calendar = Calendar.getInstance();
        DynamicObject dynamicObject = (DynamicObject)holidayRanges.get(0);
        Date leftDateZero = dynamicObject.getDate("startdate");
        Date rightDatZero = dynamicObject.getDate("enddate");
        HashSet dateRangeSetZero = Sets.newHashSetWithExpectedSize((int)holidayRanges.size());
        calendar.setTime(leftDateZero);
        while (!calendar.getTime().after(rightDatZero)) {
            dateRangeSetZero.add(HRDateTimeUtils.format((Date)calendar.getTime(), (String)DATE_FORMAT));
            calendar.add(5, 1);
        }
        dateRangeList.add(dateRangeSetZero);
        if (holidayRanges.size() > 1) {
            for (int i = 1; i < holidayRanges.size(); ++i) {
                DynamicObject holidayRange = (DynamicObject)holidayRanges.get(i);
                Date leftDate = holidayRange.getDate("startdate");
                Date rightDate = holidayRange.getDate("enddate");
                DynamicObject lastRange = (DynamicObject)holidayRanges.get(i - 1);
                Date lastRightDate = lastRange.getDate("enddate");
                calendar.setTime(lastRightDate);
                calendar.add(5, 1);
                Set dateRangeSet2 = calendar.getTime().before(leftDate) ? Sets.newHashSetWithExpectedSize((int)holidayRanges.size()) : (Set)dateRangeList.get(dateRangeList.size() - 1);
                calendar.setTime(leftDate);
                while (!calendar.getTime().after(rightDate)) {
                    dateRangeSet2.add(HRDateTimeUtils.format((Date)calendar.getTime(), (String)DATE_FORMAT));
                    calendar.add(5, 1);
                }
                dateRangeList.add(dateRangeSet2);
            }
        }
        HashSet holidayResultSet = Sets.newHashSetWithExpectedSize((int)dateRangeList.size());
        dateRangeList.forEach(dateRangeSet -> {
            StringBuilder stringBuilder = new StringBuilder();
            dateRangeSet.stream().filter(holidayDate -> {
                Date date;
                try {
                    date = HRDateTimeUtils.parseDate((String)holidayDate, (String)DATE_FORMAT);
                }
                catch (ParseException ex) {
                    LOGGER.error(ex.getMessage());
                    return false;
                }
                return !startDate.after(date) && !endDate.before(date);
            }).forEach(holidayDate -> stringBuilder.append((String)holidayDate).append(','));
            if (stringBuilder.length() > 0) {
                holidayResultSet.add(stringBuilder.substring(0, stringBuilder.length() - 1));
            }
        });
        return holidayResultSet;
    }

    private static String getHolidayByFixedDate(String month, String dayOfMonth, Date startDate, Date endDate, String extendRule) {
        int startYear;
        int mon = Integer.parseInt(month);
        Set<String> daySet = Arrays.stream(dayOfMonth.split(",")).filter(day -> !StringUtils.isEmpty((CharSequence)day)).collect(Collectors.toSet());
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        int endYear = calendar.get(1);
        calendar.setTime(startDate);
        for (int i = startYear = calendar.get(1); i <= endYear; ++i) {
            WorkingPlanServiceHelper.calActualFixedDayByYear(i, mon, daySet, extendRule, calendar, startDate, endDate, stringBuilder);
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private static void calActualFixedDayByYear(int year, int mon, Set<String> daySet, String extendRule, Calendar calendar, Date startDate, Date endDate, StringBuilder stringBuilder) {
        int newYear = year;
        int newMonth = mon;
        for (String dayStr : daySet) {
            int day;
            int newDay = day = Integer.parseInt(dayStr);
            if (!StringUtils.isEmpty((CharSequence)extendRule)) {
                String[] extendRules;
                for (String rule : extendRules = extendRule.split(",")) {
                    int plusIndex = rule.indexOf(43);
                    calendar.set(year, mon - 1, day);
                    int weekDay = calendar.get(7) - 1;
                    if (weekDay == 0) {
                        weekDay = 7;
                    }
                    if (Integer.parseInt(rule.substring(0, 1)) != weekDay) continue;
                    int calDay = Integer.parseInt(rule.substring(rule.length() - 1));
                    if (plusIndex != -1) {
                        calendar.add(5, calDay);
                    } else {
                        calendar.add(5, -calDay);
                    }
                    newMonth = calendar.get(2) + 1;
                    newDay = calendar.get(5);
                    newYear = calendar.get(1);
                    break;
                }
            }
            if (2 == newMonth && newDay == 29 && (newYear % 4 != 0 || newYear % 100 == 0) && newYear % 400 != 0) continue;
            calendar.set(newYear, newMonth - 1, newDay);
            String fixDay = HRDateTimeUtils.formatDate((Date)calendar.getTime());
            WorkingPlanServiceHelper.appendDate(fixDay, startDate, endDate, stringBuilder);
        }
    }

    private static String getHolidayByFixedWeek(String month, String weekOfMonth, String dayOfWeek, Date startDate, Date endDate) {
        int startYear;
        int week;
        if ("last".equals(weekOfMonth)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, Integer.parseInt(month) - 1);
            week = calendar.getActualMaximum(4) - 1;
        } else {
            week = Integer.parseInt(weekOfMonth);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        int endYear = calendar.get(1);
        calendar.setTime(startDate);
        for (int i = startYear = calendar.get(1); i <= endYear; ++i) {
            String dateByWeek = WorkingPlanServiceHelper.getDateByWeek(i, Integer.parseInt(month), week, WorkingPlanServiceHelper.parseDayOfWeek(dayOfWeek));
            if (StringUtils.isEmpty((CharSequence)dateByWeek)) continue;
            WorkingPlanServiceHelper.appendDate(dateByWeek, startDate, endDate, stringBuilder);
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private static void appendDate(String dateString, Date startDate, Date endDate, StringBuilder stringBuilder) {
        Date date;
        try {
            date = HRDateTimeUtils.parseDate((String)dateString, (String)DATE_FORMAT);
        }
        catch (ParseException ex) {
            LOGGER.error(ex.getMessage());
            return;
        }
        if (startDate.after(date) || endDate.before(date)) {
            return;
        }
        stringBuilder.append(dateString).append(',');
    }

    private static void sortedHolidayRangeList(List<Map<String, String>> holidayRangeList) {
        holidayRangeList.sort((x1, x2) -> {
            String rangeStart = (String)x1.get("rangeStart");
            String rangeStart2 = (String)x2.get("rangeStart");
            return WorkingPlanServiceHelper.getSortNumber(rangeStart, rangeStart2);
        });
    }

    private static String sortedHoliday(String holiday) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Objects.isNull(holiday)) {
            String[] holidays = holiday.split(",");
            Arrays.sort(holidays, WorkingPlanServiceHelper::getSortNumber);
            for (String string : holidays) {
                stringBuilder.append(string).append(',');
            }
        }
        return stringBuilder.length() == 0 ? holiday : stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private static int getSortNumber(String frontDate, String nextDate) {
        Date date2;
        Date date;
        try {
            date = HRDateTimeUtils.parseDate((String)frontDate, (String)DATE_FORMAT);
            date2 = HRDateTimeUtils.parseDate((String)nextDate, (String)DATE_FORMAT);
        }
        catch (ParseException ex) {
            LOGGER.error(ex.getMessage());
            return 0;
        }
        if (date.after(date2)) {
            return 1;
        }
        return -1;
    }

    private static List<Map<String, String>> getMergeHolidayRangeList(List<Map<String, String>> holidayRangeList) {
        ArrayList mergeHolidayRangeList = Lists.newArrayListWithExpectedSize((int)holidayRangeList.size());
        if (holidayRangeList.size() > 1) {
            WorkingPlanServiceHelper.calMerge(holidayRangeList, mergeHolidayRangeList);
        } else {
            Map<String, String> holidayRange = holidayRangeList.get(0);
            Map<String, String> range = WorkingPlanServiceHelper.getRange(holidayRange.get(RANGE_TYPE), holidayRange.get(RANGE_HOLIDAY_TYPE), holidayRange.get("rangeStart"), holidayRangeList.get(0).get("rangeEnd"));
            mergeHolidayRangeList.add(range);
        }
        return mergeHolidayRangeList;
    }

    private static void calMerge(List<Map<String, String>> holidayRangeList, List<Map<String, String>> mergeHolidayRangeList) {
        ArrayList holidayNameList = Lists.newArrayListWithExpectedSize((int)holidayRangeList.size());
        int start = 0;
        String maxRangeEnd = holidayRangeList.get(0).get("rangeEnd");
        for (int i = 0; i < holidayRangeList.size() - 1; ++i) {
            Date rangeEndNext;
            Date rangeStartNext;
            Date rangeEnd;
            Map<String, String> holidayRange = holidayRangeList.get(i);
            Map<String, String> holidayRangeNext = holidayRangeList.get(i + 1);
            holidayNameList.add(holidayRange.get(RANGE_TYPE));
            try {
                rangeEnd = HRDateTimeUtils.parseDate((String)holidayRange.get("rangeEnd"), (String)DATE_FORMAT);
                rangeStartNext = HRDateTimeUtils.parseDate((String)holidayRangeNext.get("rangeStart"), (String)DATE_FORMAT);
                rangeEndNext = HRDateTimeUtils.parseDate((String)holidayRangeNext.get("rangeEnd"), (String)DATE_FORMAT);
            }
            catch (ParseException ex) {
                LOGGER.error(ex.getMessage());
                continue;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(rangeEnd);
            calendar.add(5, 1);
            if (!(rangeStartNext.before(rangeEnd) || rangeStartNext.equals(rangeEnd) || rangeStartNext.equals(calendar.getTime()))) {
                Map<String, String> startRange = holidayRangeList.get(start);
                StringBuilder stringBuilder = new StringBuilder();
                holidayNameList.stream().distinct().forEach(holidayName -> stringBuilder.append((String)holidayName).append('\u3001'));
                Map<String, String> range = WorkingPlanServiceHelper.getRange(stringBuilder.substring(0, stringBuilder.length() - 1), startRange.get(RANGE_HOLIDAY_TYPE), startRange.get("rangeStart"), maxRangeEnd);
                mergeHolidayRangeList.add(range);
                start = i + 1;
                maxRangeEnd = holidayRangeNext.get("rangeEnd");
                holidayNameList.clear();
                continue;
            }
            maxRangeEnd = rangeEnd.before(rangeEndNext) ? holidayRangeNext.get("rangeEnd") : holidayRange.get("rangeEnd");
        }
        Map<String, String> lastHolidayRange = holidayRangeList.get(holidayRangeList.size() - 1);
        if (start == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            holidayNameList.add(lastHolidayRange.get(RANGE_TYPE));
            holidayNameList.stream().distinct().forEach(holidayName -> stringBuilder.append((String)holidayName).append('\u3001'));
            Map<String, String> holidayRange = holidayRangeList.get(start);
            Map<String, String> range = WorkingPlanServiceHelper.getRange(stringBuilder.substring(0, stringBuilder.length() - 1), holidayRange.get(RANGE_HOLIDAY_TYPE), holidayRange.get("rangeStart"), maxRangeEnd);
            mergeHolidayRangeList.add(range);
        } else {
            String name = lastHolidayRange.get(RANGE_TYPE);
            if (!holidayNameList.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                holidayNameList.add(lastHolidayRange.get(RANGE_TYPE));
                holidayNameList.stream().distinct().forEach(holidayName -> stringBuilder.append((String)holidayName).append('\u3001'));
                name = stringBuilder.substring(0, stringBuilder.length() - 1);
            }
            Map<String, String> lastRange = WorkingPlanServiceHelper.getRange(name, lastHolidayRange.get(RANGE_HOLIDAY_TYPE), holidayRangeList.get(start).get("rangeStart"), maxRangeEnd);
            mergeHolidayRangeList.add(lastRange);
        }
    }

    private static Map<String, String> getRange(String rangeType, String rangeHolidayType, String rangeStart, String rangeEnd) {
        HashMap<String, String> range = new HashMap<String, String>();
        range.put(RANGE_TYPE, rangeType);
        range.put(RANGE_HOLIDAY_TYPE, rangeHolidayType);
        range.put("rangeStart", rangeStart);
        range.put("rangeEnd", rangeEnd);
        return range;
    }
}

