/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.repository.perm;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

public class HROrgTeamStructRepository {
    public static DynamicObjectCollection getAllOrgTeamListByStructStd(Set<Long> structProjectSet, Date effStartDate, Date effEndDate) {
        return HROrgTeamStructRepository.getAllOrgTeamListByStruct(structProjectSet, effStartDate, effEndDate, "haos_adminorgstructure");
    }

    public static DynamicObjectCollection getAllOrgTeamListByStructCustom(Set<Long> structProjectSet, Date effStartDate, Date effEndDate) {
        return HROrgTeamStructRepository.getAllOrgTeamListByStruct(structProjectSet, effStartDate, effEndDate, "haos_customotstruct");
    }

    public static DynamicObjectCollection getAllOrgTeamListByStruct(Set<Long> structProjectSet, Date effStartDate, Date effEndDate, String structEntityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityNumber);
        QFilter qFilter = new QFilter("structproject", "in", structProjectSet);
        QFilter dateQFilter = HROrgTeamStructRepository.buildEffDateQFilter(effStartDate, effEndDate);
        if (dateQFilter != null) {
            qFilter.and(dateQFilter);
        }
        DynamicObjectCollection dyColl = serviceHelper.queryOriginalCollection("orgteam.id orgteam,parentorgteam parent,orgteam.otclassify.id otclassify,bsed,bsled,orgteamhisid, structlongnumber,structproject", new QFilter[]{qFilter}, null);
        return dyColl;
    }

    public static DynamicObjectCollection getAllOrgTeamListByBoIdStd(Set<Long> boIdSet, Date effStartDate, Date effEndDate) {
        return HROrgTeamStructRepository.getAllOrgTeamListByBoId(boIdSet, effStartDate, effEndDate, "haos_adminorgstructure");
    }

    public static DynamicObjectCollection getAllOrgTeamListByBoIdCustom(Set<Long> boIdSet, Date effStartDate, Date effEndDate) {
        return HROrgTeamStructRepository.getAllOrgTeamListByBoId(boIdSet, effStartDate, effEndDate, "haos_customotstruct");
    }

    public static DynamicObjectCollection getAllOrgTeamListByBoId(Set<Long> boIdSet, Date effStartDate, Date effEndDate, String structEntityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityNumber);
        QFilter orgIdFilter = new QFilter("orgteam.boid", "in", boIdSet);
        QFilter dateQFilter = HROrgTeamStructRepository.buildEffDateQFilter(effStartDate, effEndDate);
        if (dateQFilter != null) {
            orgIdFilter.and(dateQFilter);
        }
        DynamicObjectCollection dyColl = serviceHelper.queryOriginalCollection("orgteam.id orgteam,parentorgteam parent,orgteam.otclassify.id otclassify,bsed,bsled,orgteamhisid, structlongnumber,structproject", new QFilter[]{orgIdFilter}, null);
        return dyColl;
    }

    public static DynamicObjectCollection getOrgTeamDyCollection(Set<Long> orgIdSet, boolean isContainSub, Long structProject, Date effStartDate, Date effEndDate) {
        QFilter dateQFilter;
        DynamicObject[] longNumberDys;
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter orgIdFilter = new QFilter("orgteam.id", "in", orgIdSet);
        if (isContainSub && Objects.nonNull(longNumberDys = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgIdFilter})) && longNumberDys.length > 0) {
            HROrgTeamStructRepository.initLongNumberParams(orgIdFilter, longNumberDys);
        }
        if (structProject != null && structProject != 0L) {
            orgIdFilter.and(new QFilter("structproject", "=", (Object)structProject));
        }
        if ((dateQFilter = HROrgTeamStructRepository.buildEffDateQFilter(effStartDate, effEndDate)) != null) {
            orgIdFilter.and(dateQFilter);
        }
        DynamicObjectCollection dyColl = serviceHelper.queryOriginalCollection("orgteam.id orgteam,parentorgteam parent,orgteam.otclassify.id otclassify,bsed,bsled,orgteamhisid, structlongnumber,structproject", new QFilter[]{orgIdFilter}, null);
        return dyColl;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void initLongNumberParams(QFilter orgIdFilter, DynamicObject[] longNumberDys) {
        List longNumList = Arrays.stream(longNumberDys).map(it -> it.getString("structlongnumber")).sorted().collect(Collectors.toList());
        HashSet longNumSet = Sets.newHashSetWithExpectedSize((int)longNumberDys.length);
        for (String longNumber : longNumList) {
            if (!HRStringUtils.isNotEmpty((String)longNumber)) continue;
            if (!longNumSet.stream().noneMatch(longNumber::startsWith)) continue;
            longNumSet.add(longNumber);
        }
        if (longNumSet.size() > 0) {
            for (String longNum : longNumSet) {
                QFilter longNumberFilter = new QFilter("structlongnumber", "like", (Object)(longNum + "!" + "%"));
                orgIdFilter.or(longNumberFilter);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static QFilter buildEffDateQFilter(Date effStartDate, Date effEndDate) {
        if (effStartDate == null && effEndDate == null) {
            return null;
        }
        if (effStartDate == null && effEndDate != null) {
            QFilter dateQFilter = new QFilter("bsed", "<=", (Object)effEndDate);
            dateQFilter.and(new QFilter("bsled", ">=", (Object)effEndDate));
            return dateQFilter;
        }
        if (effStartDate != null && effEndDate == null) {
            QFilter dateQFilter = new QFilter("bsed", "<=", (Object)effStartDate);
            dateQFilter.and(new QFilter("bsled", ">=", (Object)effStartDate));
            return dateQFilter;
        }
        if (effStartDate != null && effEndDate != null) {
            if (effStartDate.getTime() == effEndDate.getTime()) {
                QFilter dateQFilter = new QFilter("bsed", "<=", (Object)effStartDate);
                dateQFilter.and(new QFilter("bsled", ">=", (Object)effStartDate));
                return dateQFilter;
            }
            QFilter dateBeforeBsedQFilter = new QFilter("bsed", ">=", (Object)effStartDate);
            dateBeforeBsedQFilter.and(new QFilter("bsed", "<=", (Object)effEndDate));
            QFilter dateBetweenBsedAndBsledQFilter = new QFilter("bsed", "<=", (Object)effStartDate);
            dateBetweenBsedAndBsledQFilter.and(new QFilter("bsled", ">=", (Object)effStartDate));
            return dateBeforeBsedQFilter.or(dateBetweenBsedAndBsledQFilter);
        }
        return null;
    }
}

