/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.Conditional;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.repository.hismodel.EventEntityRepository;
import kd.hr.hrcs.bussiness.service.hismodel.model.constant.HisSystemConstants;

public class HisEventEntityService
implements HisSystemConstants {
    private static final Integer INITSIZE = 3;
    private static volatile HisEventEntityService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisEventEntityService getInstance() {
        if (service != null) return service;
        Class<HisEventEntityService> clazz = HisEventEntityService.class;
        synchronized (HisEventEntityService.class) {
            if (service != null) return service;
            service = new HisEventEntityService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public QFilter setF7QFilter(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        QFilter qFilter = QFilter.of((String)"1==1", (Object[])new Object[0]);
        switch (fieldKey) {
            case "evententity": {
                qFilter.and(new QFilter("number", "=", (Object)"hbp_eventtpl"));
                break;
            }
            case "busevententity": {
                qFilter.and(new QFilter("number", "=", (Object)"hbp_busieventreltpl"));
                break;
            }
            case "hisevententity": {
                qFilter.and(new QFilter("number", "=", (Object)"hbp_eventrelhistpl"));
                break;
            }
        }
        DynamicObject dy = EventEntityRepository.getOriginalDynamicObject("bos_entitymeta", qFilter, "id");
        String parentId = dy.getString("id");
        QFilter inheritpath = QFilter.like((String)"inheritpath", (String)parentId);
        DynamicObject[] dys = EventEntityRepository.getOriginalDynamicObjects("bos_entitymeta", inheritpath, "id");
        List fidList = Arrays.stream(dys).map(dynamicObject -> dynamicObject.getString("id")).collect(Collectors.toList());
        return new QFilter("dentityid", "in", fidList);
    }

    public boolean checkModify(boolean fromDatabase, DynamicObject buseventDy, DynamicObject eventDy, DynamicObject hiseventDy, Long id) {
        if (fromDatabase) {
            QFilter ffid = new QFilter("id", "=", (Object)id);
            DynamicObject dy = EventEntityRepository.getOriginalDynamicObject("hrcs_evententityreg", ffid, "name,number,evententity,busevententity,hisevententity");
            String eventOldId = dy.getString("evententity");
            String buseventOldId = dy.getString("busevententity");
            String hiseventOldId = dy.getString("hisevententity");
            String eventNewId = eventDy.getString("id");
            String buseventNewId = buseventDy.getString("id");
            String hiseventNewId = hiseventDy.getString("id");
            if (eventOldId.equals(eventNewId) && buseventOldId.equals(buseventNewId) && hiseventOldId.equals(hiseventNewId)) {
                return false;
            }
            String buseventEntity = dy.getString("busevententity");
            DynamicObject dynamicObject = EventEntityRepository.getDynamicObjectById(buseventEntity, "bos_entityobject");
            String entity = dynamicObject.getString("number");
            QFilter qFilter = QFilter.of((String)"1==1", (Object[])new Object[0]);
            return EventEntityRepository.isExists(entity, qFilter);
        }
        return false;
    }

    public List<String> checkRepeat(Long id, DynamicObject buseventEntity, DynamicObject eventEntity, DynamicObject hiseventEntity) {
        String eventGroupName;
        ArrayList<String> errMsgList = new ArrayList<String>(10);
        QFilter qFilter = new QFilter("id", "!=", (Object)id);
        DynamicObject[] result = EventEntityRepository.getOriginalDynamicObjects("hrcs_evententityreg", qFilter, "name,number,evententity,busevententity,hisevententity");
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)(result.length * INITSIZE));
        Arrays.stream(result).forEach(data -> {
            dataList.add(data.getString("busevententity"));
            dataList.add(data.getString("evententity"));
            dataList.add(data.getString("hisevententity"));
        });
        String buseventEntityId = buseventEntity.getString("id");
        String eventEntityId = eventEntity.getString("id");
        String hiseventEntityId = hiseventEntity.getString("id");
        if (dataList.contains(buseventEntityId) && StringUtils.isNotEmpty((String)(eventGroupName = this.getEventEntityName(buseventEntityId, result)))) {
            String buseventEntityMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e1a\u52a1\u4e8b\u52a1\u5173\u7cfb\u5b9e\u4f53 \u5df2\u88ab \u201c%s\u201d \u4e8b\u52a1\u7ec4\u5f15\u7528\uff0c", (String)"HisEventEntityService_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]), eventGroupName);
            errMsgList.add(buseventEntityMsg);
        }
        if (dataList.contains(eventEntityId) && StringUtils.isNotEmpty((String)(eventGroupName = this.getEventEntityName(eventEntityId, result)))) {
            String eventEntityMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u5b9e\u4f53 \u5df2\u88ab \u201c%s\u201d \u4e8b\u52a1\u7ec4\u5f15\u7528\uff0c", (String)"HisEventEntityService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]), eventGroupName);
            errMsgList.add(eventEntityMsg);
        }
        if (dataList.contains(hiseventEntityId) && StringUtils.isNotEmpty((String)(eventGroupName = this.getEventEntityName(hiseventEntityId, result)))) {
            String hiseventEntityMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5386\u53f2\u7248\u672c\u4e8b\u52a1\u5173\u7cfb\u5b9e\u4f53 \u5df2\u88ab \u201c%s\u201d \u4e8b\u52a1\u7ec4\u5f15\u7528\uff0c", (String)"HisEventEntityService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]), eventGroupName);
            errMsgList.add(hiseventEntityMsg);
        }
        return errMsgList;
    }

    private String getEventEntityName(String tableId, DynamicObject[] result) {
        for (DynamicObject data : result) {
            if (!tableId.equals(data.getString("busevententity")) && !tableId.equals(data.getString("evententity")) && !tableId.equals(data.getString("hisevententity"))) continue;
            return data.getString("name");
        }
        return null;
    }

    public String checkIsRef(Long id, String name) {
        QFilter entityFilter = new QFilter("evententity", "=", (Object)id);
        DynamicObject[] entityResult = EventEntityRepository.getDynamicObjects("hrcs_entityevent", entityFilter, "entity.name");
        Set<String> entityNames = Arrays.stream(entityResult).map(dy -> dy.getString("entity.name")).collect(Collectors.toSet());
        QFilter appFilter = new QFilter("evententity", "=", (Object)id);
        DynamicObject[] appResult = EventEntityRepository.getDynamicObjects("hrcs_appdefaultevent", appFilter, "actionapp.name");
        Set<String> appNames = Arrays.stream(appResult).map(dy -> dy.getString("actionapp.name")).collect(Collectors.toSet());
        return this.assemleMsg(appNames, entityNames, name);
    }

    private String assemleMsg(Set<String> appNames, Set<String> entityNames, String name) {
        StringBuilder appMsg = new StringBuilder();
        StringBuilder entityMsg = new StringBuilder();
        String msg = "";
        if (appNames.size() > 0) {
            for (String appName : appNames) {
                appName = "\u201c" + appName + "\u201d\u3001";
                appMsg.append(appName);
            }
            appMsg.deleteCharAt(appMsg.length() - 1).append(ResManager.loadKDString((String)"\u5e94\u7528", (String)"HisEventEntityService_20", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (entityNames.size() > 0) {
            for (String entityName : entityNames) {
                entityName = "\u201c" + entityName + "\u201d\u3001";
                entityMsg.append(entityName);
            }
            entityMsg.deleteCharAt(entityMsg.length() - 1).append(ResManager.loadKDString((String)"\u5b9e\u4f53", (String)"HisEventEntityService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (appMsg.length() > 0) {
            msg = entityMsg.length() > 0 ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e8b\u52a1\u7ec4\uff1a\u5220\u9664\u5931\u8d25\uff0c\u5df2\u88ab%2$s\u3001%3$s\u5f15\u7528\u3002", (String)"HisEventEntityService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]), name, appMsg, entityMsg) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e8b\u52a1\u7ec4\uff1a\u5220\u9664\u5931\u8d25\uff0c\u5df2\u88ab%2$s\u5f15\u7528\u3002", (String)"HisEventEntityService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]), name, appMsg);
        } else if (entityMsg.length() > 0) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e8b\u52a1\u7ec4\uff1a\u5220\u9664\u5931\u8d25\uff0c\u5df2\u88ab%2$s\u5f15\u7528\u3002", (String)"HisEventEntityService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]), name, entityMsg);
        }
        return msg;
    }

    public boolean checkBizApp(DynamicObject buseventEntity, DynamicObject eventEntity, DynamicObject hiseventEntity) {
        DynamicObject busDy = buseventEntity.getDynamicObject("bizappid");
        DynamicObject evnDy = eventEntity.getDynamicObject("bizappid");
        DynamicObject hisDy = hiseventEntity.getDynamicObject("bizappid");
        String busApp = busDy.getString("number");
        String evnApp = evnDy.getString("number");
        String hisApp = hisDy.getString("number");
        return busApp.equals(evnApp) && busApp.equals(hisApp);
    }

    public boolean checkMustFill(String name, String number, DynamicObject busevententity, DynamicObject evententity, DynamicObject hisevententity) {
        if (ObjectUtils.isEmpty((Object)busevententity) || ObjectUtils.isEmpty((Object)evententity) || ObjectUtils.isEmpty((Object)hisevententity)) {
            return true;
        }
        return Conditional.getNew(() -> HRStringUtils.isEmpty((String)number)).or(() -> HRStringUtils.isEmpty((String)name)).or(() -> HRStringUtils.isEmpty((String)busevententity.getString("number"))).or(() -> HRStringUtils.isEmpty((String)evententity.getString("number"))).or(() -> HRStringUtils.isEmpty((String)hisevententity.getString("number"))).getValue();
    }
}

