/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.formula;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRMapUtils;

@ExcludeFromJacocoGeneratedReport
public class FormulaDBHelper {
    public static Map<String, Set<String>> queryOneToManyKeyRel(String sql, String oneKey, String manyKey, DBRoute dbRoute) {
        ResultSetHandler callBackHanlder = rs -> {
            HashMap resultMap = HRMapUtils.newHashMap();
            try {
                while (rs.next()) {
                    String key = rs.getString(oneKey);
                    Set manyValues = resultMap.computeIfAbsent(key, val -> new HashSet(8));
                    manyValues.add(rs.getString(manyKey));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("QUERY FAIL:%s", e.getMessage())});
            }
            return resultMap;
        };
        return (Map)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)callBackHanlder);
    }

    public static List<String> queryPkIds(String tableName, DBRoute dbRoute, boolean isDistinct) {
        ResultSetHandler callBackHanlder = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (rs.next()) {
                    list.add(rs.getString("ID"));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("QUERY FAIL:%s", e.getMessage())});
            }
            return list;
        };
        String sql = isDistinct ? "SELECT DISTINCT FID ID FROM ".concat(tableName) : "SELECT FID ID FROM ".concat(tableName);
        return (List)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)callBackHanlder);
    }

    public static List<String> queryEntryIds(String tableName, String pkId, DBRoute dbRoute, boolean isDistinct) {
        ResultSetHandler callBackHanlder = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (rs.next()) {
                    list.add(rs.getString("entryId"));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("QUERY FAIL:%s", e.getMessage())});
            }
            return list;
        };
        String sql = isDistinct ? "SELECT DISTINCT fbasedataid entryId FROM ".concat(tableName).concat(" WHERE FID =").concat(pkId) : "SELECT fbasedataid entryId FROM ".concat(tableName).concat(" WHERE FID =").concat(pkId);
        return (List)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)callBackHanlder);
    }

    public static Map<String, Set<String>> queryFunctiontypeMapBusinessfield() {
        String sql = "select FID functiontypeid, fbasedataid businessfieldid FROM t_hrcs_functiontypehrbf";
        return FormulaDBHelper.queryOneToManyKeyRel(sql, "functiontypeid", "businessfieldid", new DBRoute("HMP"));
    }

    public static Map<String, Set<String>> queryBusinessFieldMapApp() {
        String sql = "SELECT A.fappid app, A.fbusinesstypeid businesstype, N.fbusinessfieldid businessfieldid FROM t_hbss_appbusinesstype A, t_hbss_bussinessfield N WHERE A.fstatus = 'C' AND A.fenable = '1' AND N.fstatus = 'C' AND N.fenable = '1' AND A.fbusinesstypeid = N.fid";
        return FormulaDBHelper.queryOneToManyKeyRel(sql, "businessfieldid", "app", new DBRoute("HMP"));
    }

    public static Map<String, Set<String>> queryBusinessFieldMapType() {
        String sql = "SELECT N.fid businesstype, N.fbusinessfieldid businessfieldid FROM t_hbss_bussinessfield N WHERE N.fstatus = 'C'  AND N.fenable = '1'";
        return FormulaDBHelper.queryOneToManyKeyRel(sql, "businessfieldid", "businesstype", new DBRoute("HMP"));
    }

    private static Map<String, Set<String>> queryBusinessTypeMapApp() {
        String sql = "SELECT A.fappid app, A.fbusinesstypeid businesstype FROM t_hbss_appbusinesstype A WHERE A.fstatus = 'C' AND A.fenable = '1'";
        return FormulaDBHelper.queryOneToManyKeyRel(sql, "businesstype", "app", new DBRoute("HMP"));
    }
}

