/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.log.AppLogInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class StrategyLogServiceHelper {
    private static final Log LOG = LogFactory.getLog(StrategyLogServiceHelper.class);

    public static void writeLog(DynamicObject[] dys, DynamicObject[] oldDys, StrategyLogEnum strategyLogEnum, boolean isEntry, DynamicObjectType ... dynamicObjectType) {
        try {
            if (dys.length == 0) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            HRBaseServiceHelper logview = new HRBaseServiceHelper("hbss_logview");
            List<AppLogInfo> appLogInfos = StrategyLogServiceHelper.buildAppLogInfo(dys, oldDys, strategyLogEnum, isEntry, dynamicObjectType);
            for (AppLogInfo appLogInfo : appLogInfos) {
                DynamicObject dyn = logview.generateEmptyDynamicObject();
                dyn.set("user", (Object)appLogInfo.getUserID());
                dyn.set("bizapp", (Object)appLogInfo.getBizAppID());
                dyn.set("bizobj", (Object)appLogInfo.getBizObjID());
                dyn.set("modifybillid", (Object)appLogInfo.getModifyBillID());
                dyn.set("modifybillno", (Object)appLogInfo.getModifyBillNo());
                dyn.set("modifyContent", (Object)appLogInfo.getModifyContent());
                dyn.set("optime", (Object)appLogInfo.getOpTime());
                dynamicObjectCollection.add((Object)dyn);
            }
            logview.save(dynamicObjectCollection);
        }
        catch (Exception exception) {
            LOG.error("StrategyLogServiceHelper-writeLog():{}", (Object)exception.getMessage());
        }
    }

    public static List<AppLogInfo> buildAppLogInfo(DynamicObject[] dys, DynamicObject[] oldDys, StrategyLogEnum strategyLogEnum, boolean isEntry, DynamicObjectType ... dynamicObjectType) {
        Map<Long, DynamicObject> idToDy = Arrays.stream(oldDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dys.length);
        Date now = TimeServiceHelper.now();
        for (DynamicObject dynamicObject : dys) {
            int count;
            Object pkValObj = dynamicObject.getPkValue();
            if (pkValObj == null) continue;
            HashMap entityModifyInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            entityModifyInfoMap.put("k", isEntry ? dynamicObject.get("parent") : pkValObj);
            AppLogInfo logInfo = StrategyLogServiceHelper.newAppLogInfo(now, dynamicObject, dynamicObjectType);
            logInfo.setModifyBillID((isEntry ? dynamicObject.get("parent") : pkValObj) + strategyLogEnum.getOpFlag());
            entityModifyInfoMap.put("f", strategyLogEnum.getOpFlag());
            String number = dynamicObject.getString("orgteam.number");
            logInfo.setModifyBillNo(number);
            entityModifyInfoMap.put("c", number);
            int n = count = isEntry ? StrategyLogServiceHelper.getEntryModifyContent(strategyLogEnum, idToDy, dynamicObject, entityModifyInfoMap) : StrategyLogServiceHelper.getModifyContent(strategyLogEnum, idToDy, dynamicObject, entityModifyInfoMap);
            if (count <= 0) continue;
            logInfo.setModifyContent(JSONObject.toJSONString((Object)entityModifyInfoMap));
            list.add(logInfo);
        }
        return list;
    }

    private static int getEntryModifyContent(StrategyLogEnum strategyLogEnum, Map<Long, DynamicObject> idToDy, DynamicObject dynamicObject, HashMap<String, Object> entityModifyInfoMap) {
        HashMap entryModifyInfo = Maps.newHashMapWithExpectedSize((int)4);
        entryModifyInfo.put("o", StrategyLogServiceHelper.splicingEntryContent(idToDy.get(dynamicObject.getLong("id"))));
        entryModifyInfo.put("n", StrategyLogServiceHelper.splicingEntryContent(dynamicObject));
        entryModifyInfo.put("c", dynamicObject.getString("bussinessfield.name"));
        entryModifyInfo.put("t", strategyLogEnum.getChangeType());
        if (!((String)entryModifyInfo.get("o")).equals(entryModifyInfo.get("n"))) {
            entityModifyInfoMap.put(dynamicObject.getString("id"), entryModifyInfo);
            return 1;
        }
        return 0;
    }

    private static int getModifyContent(StrategyLogEnum strategyLogEnum, Map<Long, DynamicObject> idToDy, DynamicObject dynamicObject, HashMap<String, Object> entityModifyInfoMap) {
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection oldEntryentity = idToDy.get(dynamicObject.getPkValue()).getDynamicObjectCollection("entryentity");
        Map idToEntry = oldEntryentity.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        int count = 0;
        for (DynamicObject entry : entryentity) {
            HashMap entryModifyInfo = Maps.newHashMapWithExpectedSize((int)4);
            if (strategyLogEnum.getChangeType().equals("4")) {
                entryModifyInfo.put("o", (String)strategyLogEnum.getFunction().apply(false));
                entryModifyInfo.put("n", (String)strategyLogEnum.getFunction().apply(true));
            } else if (strategyLogEnum.getChangeType().equals("5")) {
                entryModifyInfo.put("o", (String)strategyLogEnum.getFunction().apply(true));
                entryModifyInfo.put("n", (String)strategyLogEnum.getFunction().apply(false));
            } else {
                entryModifyInfo.put("o", (String)strategyLogEnum.getFunction().apply(idToEntry.get(entry.getLong("id"))));
                entryModifyInfo.put("n", (String)strategyLogEnum.getFunction().apply(entry));
            }
            entryModifyInfo.put("c", entry.getString("bussinessfield.name"));
            entryModifyInfo.put("t", strategyLogEnum.getChangeType());
            if (((String)entryModifyInfo.get("o")).equals(entryModifyInfo.get("n"))) continue;
            ++count;
            entityModifyInfoMap.put(entry.getString("id"), entryModifyInfo);
        }
        return count;
    }

    private static AppLogInfo newAppLogInfo(Date now, DynamicObject dynamicObject, DynamicObjectType ... dynamicObjectType) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        String formId = dynamicObjectType.length > 0 ? dynamicObjectType[0].getName() : dynamicObject.getDynamicObjectType().getName();
        logInfo.setBizObjID(formId);
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)formId));
        logInfo.setOpTime(now);
        logInfo.setOpName("save");
        return logInfo;
    }

    public static String splicingStatusContent(boolean bussinessType) {
        if (bussinessType) {
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\uff1a\u542f\u7528\u3002", (String)"StrategyLogServiceHelper_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\uff1a\u7981\u7528\u3002", (String)"StrategyLogServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public static String splicingContent(DynamicObject dynamicObject) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM--dd");
        StringBuilder stringBuilder = new StringBuilder();
        if (Objects.isNull(dynamicObject)) {
            return "";
        }
        stringBuilder.append(ResManager.loadKDString((String)"\u25cf \u7b56\u7565\uff1a", (String)"StrategyLogServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(dynamicObject.getString("entrydefstrategy.name")).append(System.getProperty("line.separator")).append(ResManager.loadKDString((String)"\u25cf \u9ed8\u8ba4HR\u7ba1\u7406\u7ec4\u7ec7\uff1a", (String)"StrategyLogServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(dynamicObject.getString("entryhrbu.name")).append(System.getProperty("line.separator")).append(ResManager.loadKDString((String)"\u25cf \u53c2\u7167\u7ec4\u7ec7\uff1a", (String)"StrategyLogServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(dynamicObject.getString("entryinheritedorg.name")).append(System.getProperty("line.separator")).append(ResManager.loadKDString((String)"\u25cf \u751f\u6548\u65e5\u671f\uff1a", (String)"StrategyLogServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(simpleDateFormat.format(dynamicObject.getDate("entryeffdt")));
        return stringBuilder.toString().replaceAll("null", " ");
    }

    public static String splicingEntryContent(DynamicObject dynamicObject) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM--dd");
        StringBuilder stringBuilder = new StringBuilder();
        if (Objects.isNull(dynamicObject)) {
            return "";
        }
        stringBuilder.append(ResManager.loadKDString((String)"\u25cf \u7b56\u7565\uff1a", (String)"StrategyLogServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(dynamicObject.getString("strategy.name")).append(System.getProperty("line.separator")).append(ResManager.loadKDString((String)"\u25cf \u9ed8\u8ba4HR\u7ba1\u7406\u7ec4\u7ec7\uff1a", (String)"StrategyLogServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(dynamicObject.getString("hrbu.name")).append(System.getProperty("line.separator")).append(ResManager.loadKDString((String)"\u25cf \u53c2\u7167\u7ec4\u7ec7\uff1a", (String)"StrategyLogServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(dynamicObject.getString("inheritedorg.name")).append(System.getProperty("line.separator")).append(ResManager.loadKDString((String)"\u25cf \u751f\u6548\u65e5\u671f\uff1a", (String)"StrategyLogServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(simpleDateFormat.format(dynamicObject.getDate("effdt")));
        return stringBuilder.toString().replaceAll("null", " ");
    }

    public static void writeModifyLog(Map<Long, DynamicObject> toBeModify, DynamicObject[] strategies) {
        ThreadPools.executeOnce((String)("StrategyLogServiceHelper-orgModify-" + new Date().getTime()), () -> StrategyLogServiceHelper.writeLog(toBeModify.values().toArray(new DynamicObject[0]), strategies, StrategyLogEnum.ORG_MODIFY, false, new DynamicObjectType[0]));
    }

    public static enum StrategyLogEnum {
        USER_NEW("1", "+", dy -> StrategyLogServiceHelper.splicingContent((DynamicObject)dy)),
        USER_MODIFY("1", "", dy -> StrategyLogServiceHelper.splicingContent((DynamicObject)dy)),
        INHERITEDORG_MODIFY("2", "", dy -> StrategyLogServiceHelper.splicingContent((DynamicObject)dy)),
        ORG_MODIFY("3", "", dy -> StrategyLogServiceHelper.splicingContent((DynamicObject)dy)),
        ORG_ENABLE("4", "", flag -> StrategyLogServiceHelper.splicingStatusContent((Boolean)flag)),
        ORG_DISABLE("5", "", flag -> StrategyLogServiceHelper.splicingStatusContent((Boolean)flag));

        private final String changeType;
        private final String opFlag;
        private final Function function;

        private StrategyLogEnum(String changeType, String opFlag, Function<Object, String> function) {
            this.changeType = changeType;
            this.opFlag = opFlag;
            this.function = function;
        }

        public String getChangeType() {
            return this.changeType;
        }

        public String getOpFlag() {
            return this.opFlag;
        }

        public Function getFunction() {
            return this.function;
        }
    }
}

