/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ChargeMessageServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ChargeMessageServiceHelper.class);
    private static final String REGEX = "\\{(.+?)\\}";
    private static final Pattern PATTERN = Pattern.compile("\\{(.+?)\\}");

    public static String sendSms(String messageTemplateNumber, DynamicObject chargeCompanyDy, Map<String, Object> selectedBosUserMap) {
        Map messageTemplateMap = MessageUtils.getMessageTemplateLocalByNumber((String)messageTemplateNumber);
        if (CollectionUtils.isEmpty((Map)messageTemplateMap)) {
            return "";
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
        HashSet<String> userStatusSet = new HashSet<String>();
        userStatusSet.add("0");
        userStatusSet.add("1");
        DynamicObject dbChargeCompanyDy = helper.loadDynamicObject(new QFilter("userstatus", "in", userStatusSet));
        String tplContent = messageTemplateMap.get("tplContent").toString();
        JSONObject allLangTplContentJSONObj = JSON.parseObject((String)tplContent);
        String lang = RequestContext.get().getLang().toString();
        if (!allLangTplContentJSONObj.containsKey((Object)lang)) {
            lang = "commonlang";
        }
        JSONObject contentJSONObj = JSON.parseObject((String)allLangTplContentJSONObj.get((Object)lang).toString());
        String contentTpl = contentJSONObj.getString("content");
        Matcher matcher = PATTERN.matcher(contentTpl);
        while (matcher.find()) {
            String group = matcher.group();
            String property = group.replace("{", "").replace("}", "");
            String paramValue = "";
            if (chargeCompanyDy.containsProperty(property)) {
                paramValue = chargeCompanyDy.getString(property);
            } else if (property.equals("currlinkname")) {
                paramValue = dbChargeCompanyDy.getLocaleString("linkuser.name").getLocaleValue();
            } else if (property.equals("targetlinkname") && selectedBosUserMap != null && selectedBosUserMap.containsKey("bosUserName")) {
                paramValue = selectedBosUserMap.get("bosUserName").toString();
            }
            if (!HRStringUtils.isNotEmpty((String)paramValue)) continue;
            contentTpl = contentTpl.replace(group, paramValue);
        }
        String phone = chargeCompanyDy.getString("linkuser.phone");
        if (selectedBosUserMap != null && selectedBosUserMap.containsKey("bosUserPhone")) {
            phone = selectedBosUserMap.get("bosUserPhone").toString();
        }
        ChargeMessageServiceHelper.sendSmsMsg(messageTemplateNumber, phone, contentTpl, dbChargeCompanyDy);
        return contentTpl;
    }

    private static void sendSmsMsg(String messageTemplateNumber, String phone, String content, DynamicObject dynamicObject) {
        try {
            phone = phone.replace("+", "");
            String notifyType = MessageChannels.SMS.getNumber();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("msg_template");
            DynamicObject item = serviceHelper.queryOriginalOne("msgchannel", new QFilter("number", "=", (Object)messageTemplateNumber));
            if (null != item) {
                notifyType = item.getString("msgchannel");
            }
            MessageInfo message = new MessageInfo();
            message.setType("message");
            message.setContent(content);
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setNotifyType(notifyType);
            message.setTemplateNumber(messageTemplateNumber);
            message.setEntityNumber("hrcs_chargeregister");
            message.setBizDataId((Long)dynamicObject.getPkValue());
            message.addParam("phone", Collections.singletonList(phone));
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
        catch (Exception ex) {
            LOGGER.error("invokeMsgServiceError:{}", (Object)ex.getMessage());
        }
    }
}

