/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.HttpClientUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ChargeTokenCallbackServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.EcontractChargeServiceHelper;
import org.apache.http.conn.ConnectTimeoutException;

public class ChargeSiteService {
    private static final Log LOGGER = LogFactory.getLog(ChargeSiteService.class);
    private static int DEFAULT_CONNECTIONTIMEOUT = Integer.getInteger("httpclient.connectionTimeout", 3000);
    private static int DEFAULT_READTIMEOUT = 65000;
    private static final String RESUME_SITE_URL = "/ctrl/record/reducecount/resume";
    private static final String REDUCE_SITE_URL = "/ctrl/record/reduceSite";
    private static final String REDUCE_CNT_URL = "/ctrl/site/card/";

    public static Map<String, Object> resumeSite(String requestId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (HRStringUtils.isEmpty((String)requestId)) {
            resultMap.put("success", false);
            resultMap.put("msg", ResManager.loadKDString((String)"\u64cd\u4f5cID\u4e3a\u7a7a", (String)"ChargeReduceSiteService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("requestId is null");
            return resultMap;
        }
        DynamicObject dynamicObject = ChargeSiteService.getDynamicObject();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("requestId", requestId);
        if (ChargeSiteService.invokeSiteService(dynamicObject, resultMap, paramMap, RESUME_SITE_URL)) {
            resultMap.put("msg", ResManager.loadKDString((String)"\u7ad9\u70b9\uff08\u6d41\u91cf\uff09\u56de\u8865\u5931\u8d25\u3002", (String)"ChargeReduceSiteService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return resultMap;
        }
        return resultMap;
    }

    public static Map<String, Object> reduceSite(String contractNum, String requestId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (HRStringUtils.isEmpty((String)contractNum)) {
            resultMap.put("success", false);
            resultMap.put("msg", ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a", (String)"ChargeReduceSiteService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("reduceSite contractNum is null");
            return resultMap;
        }
        DynamicObject dynamicObject = ChargeSiteService.getDynamicObject();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantId", dynamicObject.getString("serviceid"));
        paramMap.put("requestURI", "/kdcontract/sign/signSingle");
        paramMap.put("clientIP", ChargeSiteService.getClientIP());
        paramMap.put("requestId", requestId);
        if (ChargeSiteService.invokeSiteService(dynamicObject, resultMap, paramMap, REDUCE_SITE_URL)) {
            resultMap.put("msg", ResManager.loadKDString((String)"\u6263\u51cf\u5931\u8d25", (String)"ChargeReduceSiteService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return resultMap;
        }
        return resultMap;
    }

    private static String getClientIP() {
        String loginIP = RequestContext.get().getLoginIP();
        if (loginIP == null) {
            LOGGER.info("get login ip null.");
            loginIP = "unknown";
        } else {
            loginIP = loginIP.split(",")[0];
        }
        return loginIP;
    }

    private static boolean invokeSiteService(DynamicObject dynamicObject, Map<String, Object> resultMap, Map<String, Object> paramMap, String url) {
        String token = ChargeTokenCallbackServiceHelper.getToken(dynamicObject);
        if (!ChargeSiteService.isValide(resultMap, dynamicObject, token)) {
            return true;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("access_token", token);
        String result = "";
        String chargeDomain = EcontractChargeServiceHelper.getChargeDoman();
        url = chargeDomain + url;
        LOGGER.info(MessageFormat.format("begin to invoke site service, paramMap : {0}, chargeUrl : {1}", JSON.toJSONString(paramMap), url));
        try {
            if (ChargeSiteService.isChargeTimeoutMock("reduceSite")) {
                LOGGER.info("invoke site service chargeTimeoutMockStart,is ready to sleep {}ms", (Object)DEFAULT_READTIMEOUT);
                Thread.sleep(DEFAULT_READTIMEOUT);
                LOGGER.info("invoke site service chargeTimeoutMockEnd", (Object)DEFAULT_READTIMEOUT);
            } else {
                result = HttpClientUtils.post((String)url, headerMap, paramMap, (int)DEFAULT_CONNECTIONTIMEOUT, (int)DEFAULT_READTIMEOUT);
            }
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            throw new KDBizException(new ErrorCode("1119", ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])});
        }
        catch (Exception exception) {
            LOGGER.error("ChargeReduceSiteService http post error :", (Throwable)exception);
            resultMap.put("success", false);
            resultMap.put("msg", "Http IOException");
            return true;
        }
        LOGGER.info(MessageFormat.format("end to invoke site service, result : {0}", result));
        if (HRStringUtils.isEmpty((String)result) || result.equals("null")) {
            resultMap.put("success", false);
            resultMap.put("msg", "Http result is null");
            return true;
        }
        String code = JSON.parseObject((String)result).getString("code");
        if (!"0".equals(code)) {
            resultMap.put("success", false);
            return true;
        }
        resultMap.put("success", true);
        resultMap.put("orgsimplename", dynamicObject.getString("orgsimplename"));
        return false;
    }

    public static Map<String, Object> getSiteDetail() {
        return ChargeSiteService.getSiteInfo(true);
    }

    private static Map<String, Object> getSiteInfo(boolean isDetail) {
        DynamicObject dynamicObject = ChargeSiteService.getDynamicObject();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("apiSuccess", false);
        String token = ChargeTokenCallbackServiceHelper.getToken(dynamicObject);
        if (!ChargeSiteService.isValide(map, dynamicObject, token)) {
            return map;
        }
        map.put("chargeServiceId", dynamicObject.getLong("id"));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("access_token", token);
        JSONObject jsonObject = ChargeSiteService.invokeSiteService(dynamicObject, headerMap, REDUCE_CNT_URL);
        if (jsonObject == null) {
            map.put("success", false);
            map.put("msg", "getReduceCount result is null");
            return map;
        }
        String code = jsonObject.getString("code");
        map.put("apiSuccess", true);
        if ("0".equals(code)) {
            JSONArray data = jsonObject.getJSONArray("data");
            for (Object item : data) {
                Map objectMap = (Map)SerializationUtils.fromJsonString((String)item.toString(), Map.class);
                int cloudServiceId = objectMap.getOrDefault("cloudServiceId", 0);
                if (cloudServiceId != 8) continue;
                return ChargeSiteService.getResultMap(isDetail, dynamicObject, map, objectMap);
            }
            map.put("success", false);
            map.put("msg", ResManager.loadKDString((String)"\u672a\u627e\u5230\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1\u3002", (String)"ChargeReduceSiteService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        } else {
            map.put("success", false);
            map.put("msg", jsonObject.getString("errorMessage"));
        }
        LOGGER.info(MessageFormat.format("getReduceCount return map: {0}", map));
        return map;
    }

    private static Map<String, Object> getResultMap(boolean isDetail, DynamicObject dynamicObject, Map<String, Object> map, Map<String, Object> objectMap) {
        map.put("success", true);
        map.put("reduceCount", objectMap.get("reduceCount"));
        map.put("totalSite", objectMap.get("totalSite"));
        map.put("availabledSite", objectMap.get("availabledSite"));
        map.put("cloudServiceId", objectMap.get("cloudServiceId"));
        map.put("serviceName", objectMap.get("serviceName"));
        map.put("serviceid", dynamicObject.getString("serviceid"));
        map.put("orgsimplename", dynamicObject.getString("orgsimplename"));
        if (isDetail) {
            map.put("siteSubTotalInfos", objectMap.get("siteSubTotalInfos"));
        }
        return map;
    }

    private static JSONObject invokeSiteService(DynamicObject dynamicObject, Map<String, String> headerMap, String url) {
        String result = "";
        String chargeDomain = EcontractChargeServiceHelper.getChargeDoman();
        url = chargeDomain + url + dynamicObject.getString("serviceid");
        JSONObject jsonObject = null;
        try {
            if (ChargeSiteService.isChargeTimeoutMock("getReduceCount")) {
                LOGGER.info("getReduceCount chargeTimeoutMockStart,is ready to sleep {}ms", (Object)DEFAULT_READTIMEOUT);
                Thread.sleep(DEFAULT_READTIMEOUT);
                LOGGER.info("getReduceCount chargeTimeoutMockEnd", (Object)DEFAULT_READTIMEOUT);
            } else {
                result = HttpClientUtils.get((String)url, headerMap, null, (int)DEFAULT_CONNECTIONTIMEOUT, (int)DEFAULT_READTIMEOUT);
                LOGGER.info(MessageFormat.format("invokeSiteService result : {0}", result));
                jsonObject = JSON.parseObject((String)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("httpGetError,url={},{}", (Object)url, (Object)e.getMessage());
        }
        return jsonObject;
    }

    private static boolean isValide(Map<String, Object> map, DynamicObject dynamicObject, String token) {
        if (dynamicObject == null) {
            map.put("success", false);
            map.put("msg", ResManager.loadKDString((String)"\u7528\u6237\u672a\u6ce8\u518c", (String)"ChargeReduceSiteService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("reduceSite user is not register");
            return false;
        }
        if (dynamicObject.getString("userstatus").equals("0")) {
            map.put("success", false);
            map.put("msg", ResManager.loadKDString((String)"\u7528\u6237\u5df2\u89e3\u7ed1", (String)"ChargeReduceSiteService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("reduceSite user is unbound");
            return false;
        }
        if (HRStringUtils.isEmpty((String)token)) {
            map.put("success", false);
            map.put("msg", ResManager.loadKDString((String)"token\u83b7\u53d6\u5931\u8d25", (String)"ChargeReduceSiteService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("reduceSite token is not find");
            return false;
        }
        return true;
    }

    public static DynamicObject getDynamicObject() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
        HashSet<String> userStatusSet = new HashSet<String>();
        userStatusSet.add("0");
        userStatusSet.add("1");
        return helper.loadDynamicObject(new QFilter("userstatus", "in", userStatusSet));
    }

    private static boolean isChargeTimeoutMock(String key) {
        boolean isChargeTimeout = false;
        String updatecharge = SystemPropertyUtils.getProptyByTenant((String)("kd.hr.hrcs.chargeapi.mock." + key + ".enable"), (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)updatecharge)) {
            isChargeTimeout = Boolean.parseBoolean(updatecharge);
        }
        return isChargeTimeout;
    }
}

