/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.RevProxyUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.HRAppCacheImpl;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ChargeMessageServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.EcontractChargeServiceHelper;

public class ChargeTokenCallbackServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ChargeTokenCallbackServiceHelper.class);
    private static final HRAppCacheImpl APP_CACHE = (HRAppCacheImpl)HRAppCache.get((String)"hrcs");
    private static final HRBaseServiceHelper TOKEN_EXCEPTION_LOG_HELPER = new HRBaseServiceHelper("hrcs_tokenexceptionlog");
    private static ThreadPool tokenInvokerThreadPool = ThreadPools.newFixedThreadPool((String)"TokenInvoker", (int)1);
    private static ThreadPool tokenHandlerThreadPool = ThreadPools.newFixedThreadPool((String)"TokenHandler", (int)1);
    private static final String HRCS_CHARGE_TOKEN = "hrcs_chargeToken";
    private static final String HRCS_LONG_CHARGE_TOKEN = "hrcs_long_chargeToken";
    private static final String ALARM_MESSAGE_PREFIX = "hrcs_alarm_message_";
    private static final String HRCS_ALARM_MESSAGE = "S";
    private static final String HRCS_TOKEN_ALARM_MESSAGE = "hrcs_token_alarm_message";
    private static int DEFAULT_CONNECTIONTIMEOUT = Integer.getInteger("httpclient.connectionTimeout", 3000);
    private static int DEFAULT_READTIMEOUT = 65000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveToken(Map<String, Object> data) {
        Date stopTime;
        String accountId = (String)data.get("accountId");
        if (!RequestContext.get().getAccountId().equals(accountId)) {
            return ResManager.loadKDString((String)"\u975e\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"ChargeTokenCallbackServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        }
        String accessToken = (String)data.get("access_token");
        if (HRStringUtils.isEmpty((String)accessToken) || accessToken.equals("null")) {
            LOGGER.info(MessageFormat.format("ShrGetTokenServiceHelper accessToken is {0}", accessToken));
            return ResManager.loadKDString((String)"token\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChargeTokenCallbackServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        }
        String stopTimeStr = String.valueOf(data.get("stop_time"));
        if (HRStringUtils.isEmpty((String)stopTimeStr) || stopTimeStr.equals("null")) {
            LOGGER.info(MessageFormat.format("ShrGetTokenServiceHelper Time is {0}", stopTimeStr));
            return ResManager.loadKDString((String)"token\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChargeTokenCallbackServiceHelper_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        }
        Date now = new Date();
        try {
            stopTime = HRDateTimeUtils.parseDate((String)stopTimeStr);
        }
        catch (ParseException e) {
            LOGGER.error(MessageFormat.format("ShrGetTokenServiceHelper Time parse is fail, {}", e.getMessage()), (Throwable)e);
            return ResManager.loadKDString((String)"\u5230\u671f\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff0c\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002", (String)"ChargeTokenCallbackServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        }
        if (stopTime.compareTo(now) <= 0) {
            LOGGER.info(MessageFormat.format("ShrGetTokenServiceHelper stopTime is bad, stop_time is {0}", data.get("stop_time")));
            return ResManager.loadKDString((String)"Token\u5df2\u8fc7\u671f", (String)"ChargeTokenCallbackServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        }
        int dateDiff = Math.toIntExact(HRDateTimeUtils.dateDiff((String)"s", (Date)now, (Date)stopTime));
        APP_CACHE.put(HRCS_LONG_CHARGE_TOKEN, (Object)accessToken, dateDiff);
        if (dateDiff > 600) {
            dateDiff = 600;
        }
        APP_CACHE.put(HRCS_CHARGE_TOKEN, (Object)accessToken, dateDiff);
        Class<ChargeTokenCallbackServiceHelper> clazz = ChargeTokenCallbackServiceHelper.class;
        synchronized (ChargeTokenCallbackServiceHelper.class) {
            ChargeTokenCallbackServiceHelper.class.notifyAll();
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return null;
        }
    }

    public static String getToken(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        String oldToken = (String)APP_CACHE.get(HRCS_CHARGE_TOKEN, String.class);
        if (!HRStringUtils.isEmpty((String)oldToken) && !"null".equals(oldToken)) {
            return oldToken;
        }
        Future futureResult = tokenInvokerThreadPool.submit(() -> ChargeTokenCallbackServiceHelper.invokeRemoteToGetToken(), RequestContext.get());
        Date sendTokenTime = new Date();
        oldToken = (String)APP_CACHE.get(HRCS_LONG_CHARGE_TOKEN, String.class);
        if (!HRStringUtils.isEmpty((String)oldToken) && !"null".equals(oldToken)) {
            TokenWaiter tokenWaiter = new TokenWaiter(futureResult, dynamicObject, sendTokenTime);
            tokenHandlerThreadPool.execute((Runnable)tokenWaiter, RequestContext.get());
        } else {
            oldToken = ChargeTokenCallbackServiceHelper.getTokenWhenReady(futureResult);
            LOGGER.info("oldToken==null?{} ", (Object)(oldToken == null ? 1 : 0));
            Date receiveTokenTime = new Date();
            if (HRStringUtils.isEmpty((String)oldToken) || "null".equals(oldToken)) {
                TokenExceptionHandler tokenExceptionHandler = new TokenExceptionHandler(dynamicObject, sendTokenTime, receiveTokenTime);
                tokenHandlerThreadPool.execute((Runnable)tokenExceptionHandler, RequestContext.get());
            }
        }
        return oldToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTokenWhenReady(Future<Integer> futureResult) {
        int code = 0;
        try {
            code = futureResult.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOGGER.error("tokenWaitObject is interrupted");
        }
        LOGGER.info("getTokenWhenReady code=" + code);
        if (code != 0) {
            return null;
        }
        String oldToken = null;
        int timeoutSecond = 100;
        int currSecond = 0;
        Class<ChargeTokenCallbackServiceHelper> clazz = ChargeTokenCallbackServiceHelper.class;
        synchronized (ChargeTokenCallbackServiceHelper.class) {
            while (currSecond <= timeoutSecond && !HRStringUtils.isNotEmpty((String)(oldToken = (String)APP_CACHE.get(HRCS_CHARGE_TOKEN, String.class)))) {
                try {
                    ChargeTokenCallbackServiceHelper.class.wait(100L);
                    ++currSecond;
                }
                catch (InterruptedException e) {
                    LOGGER.error("tokenWaitObject is interrupted");
                }
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return oldToken;
        }
    }

    private static void handleTokenException(DynamicObject dynamicObject, Date sendTokenTime, Date receiveTokenTime) {
        LOGGER.info("handleTokenException in.");
        String enterpriseId = dynamicObject.getString("serviceid");
        String cacheKey = ALARM_MESSAGE_PREFIX + enterpriseId;
        String alarmMessage = (String)APP_CACHE.get(cacheKey, String.class);
        Date now = null;
        if (!HRCS_ALARM_MESSAGE.equals(alarmMessage)) {
            LOGGER.info("handleTokenException send sms.");
            ChargeMessageServiceHelper.sendSms(HRCS_TOKEN_ALARM_MESSAGE, dynamicObject, null);
            now = new Date();
            LocalTime localTime = LocalTime.now();
            APP_CACHE.put(cacheKey, (Object)HRCS_ALARM_MESSAGE, (int)Duration.between(localTime, LocalTime.of(localTime.getHour(), 59, 59)).getSeconds() + 1);
        }
        String linkUser = dynamicObject.getString("linkuser.name");
        DynamicObject tokenInfo = TOKEN_EXCEPTION_LOG_HELPER.generateEmptyDynamicObject();
        tokenInfo.set("id", (Object)DB.genLongId((String)"hrcs_tokenexceptionlog"));
        tokenInfo.set("enterpriseid", (Object)enterpriseId);
        tokenInfo.set("sendtokentime", (Object)sendTokenTime);
        tokenInfo.set("receivetokentime", (Object)receiveTokenTime);
        tokenInfo.set("operationstatus", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"ChargeTokenCallbackServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        tokenInfo.set("contactuser", (Object)linkUser);
        if (now != null) {
            tokenInfo.set("sendalarmtime", (Object)now);
        }
        TOKEN_EXCEPTION_LOG_HELPER.saveOne(tokenInfo);
        LOGGER.info("handleTokenException out.");
    }

    private static boolean getTokenMock(String key) {
        boolean isChargeTimeout = false;
        String updatecharge = SystemPropertyUtils.getProptyByTenant((String)("kd.hr.hrcs.chargeapi.mock." + key + ".enable"), (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)updatecharge)) {
            isChargeTimeout = Boolean.parseBoolean(updatecharge);
        }
        return isChargeTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer invokeRemoteToGetToken() {
        if (ChargeTokenCallbackServiceHelper.getTokenMock("getToken")) {
            return -1;
        }
        String oldToken = (String)APP_CACHE.get(HRCS_CHARGE_TOKEN, String.class);
        if (!HRStringUtils.isEmpty((String)oldToken) && !"null".equals(oldToken)) {
            return 0;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
        DynamicObject dynamicObject = helper.loadDynamicObject(new QFilter("userstatus", "=", (Object)"1"));
        Integer code = -1;
        if (dynamicObject == null) {
            return code;
        }
        DLock lock = DLock.create((String)"tdcs_getChargeToken", (String)dynamicObject.getString("username"));
        lock.lock();
        try {
            String result;
            String chargeDomain = EcontractChargeServiceHelper.getChargeDoman();
            String url = chargeDomain + "/tenant/cloud_auth/get_access_token.do?from=2&";
            url = url + "redirect_url=" + ChargeTokenCallbackServiceHelper.getRedirectUrl() + "&service_id=" + dynamicObject.getString("serviceid") + "&service_key=" + dynamicObject.getString("servicekey");
            try {
                result = HttpClientUtils.get((String)url, (int)DEFAULT_CONNECTIONTIMEOUT, (int)DEFAULT_READTIMEOUT);
            }
            catch (Exception exception) {
                LOGGER.error(MessageFormat.format("ChargeRegisterPlugin http get error : {0}", url), (Throwable)exception);
                Integer n = code;
                lock.unlock();
                return n;
            }
            LOGGER.info(MessageFormat.format("ChargeRegisterPlugin http get end, result: {0}", result));
            if (HRStringUtils.isEmpty((String)result) || result.equals("null")) {
                Integer n = code;
                return n;
            }
            code = JSON.parseObject((String)result).getInteger("code");
            if (code == null || !code.equals(0)) {
                Integer n = code;
                return n;
            }
        }
        finally {
            lock.unlock();
        }
        return code;
    }

    private static String getRedirectUrl() {
        String domainUrl;
        String redirectUrl = RequestContext.get().getClientFullContextPath();
        if (HRStringUtils.isEmpty((String)redirectUrl) && !(domainUrl = UrlService.getDomainContextUrl()).endsWith("/")) {
            redirectUrl = RevProxyUtil.addSlash((String)domainUrl);
        }
        return redirectUrl;
    }

    private static class TokenExceptionHandler
    implements Runnable {
        private DynamicObject dynamicObject;
        private Date sendTokenTime;
        private Date receiveTokenTime;

        public TokenExceptionHandler(DynamicObject dynamicObject, Date sendTokenTime, Date receiveTokenTime) {
            this.dynamicObject = dynamicObject;
            this.sendTokenTime = sendTokenTime;
            this.receiveTokenTime = receiveTokenTime;
        }

        @Override
        public void run() {
            ChargeTokenCallbackServiceHelper.handleTokenException(this.dynamicObject, this.sendTokenTime, this.receiveTokenTime);
        }
    }

    private static class TokenWaiter
    implements Runnable {
        private Future<Integer> futureResult;
        private DynamicObject dynamicObject;
        Date sendTokenTime;

        public TokenWaiter(Future<Integer> futureResult, DynamicObject dynamicObject, Date sendTokenTime) {
            this.futureResult = futureResult;
            this.dynamicObject = dynamicObject;
            this.sendTokenTime = sendTokenTime;
        }

        @Override
        public void run() {
            String token = ChargeTokenCallbackServiceHelper.getTokenWhenReady(this.futureResult);
            Date receiveTokenTime = new Date();
            if (HRStringUtils.isEmpty((String)token) || "null".equals(token)) {
                ChargeTokenCallbackServiceHelper.handleTokenException(this.dynamicObject, this.sendTokenTime, receiveTokenTime);
            }
        }
    }
}

