/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ECPersonAuthRecordService {
    private static final Log LOGGER = LogFactory.getLog(ECPersonAuthRecordService.class);
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perauthrecord");
    public static final String STATUS_VALID = "0";
    public static final String STATUS_INVALID = "1";
    public static final String STATUS_AUTHING = "2";

    public static String queryUserId(SignReqParam signReqParam, String status) {
        QFilter[] authQf = ECPersonAuthRecordService.genQfilter(signReqParam, status);
        DynamicObject authDyo = serviceHelper.queryOriginalOne("userid", authQf);
        if (authDyo == null) {
            return null;
        }
        return authDyo.getString("userid");
    }

    public static DynamicObject queryAuthUserInfo(SignReqParam signReqParam, String status) {
        String selectField = "id,userid,personid,hcfperid,successtime,enable,cloud,appnum,authurl,modifier,modifytime,namemd5val,mobilemd5val,identitymd5val";
        QFilter[] authQf = ECPersonAuthRecordService.genQfilter(signReqParam, status);
        return serviceHelper.queryOne(selectField, authQf);
    }

    private static boolean longIsEmpty(Long naturalId) {
        return naturalId == null || naturalId == 0L;
    }

    public static boolean userIdExists(String userId) {
        QFilter qFilter = new QFilter("userid", "=", (Object)userId);
        return serviceHelper.isExists(qFilter);
    }

    private static QFilter[] genQfilter(SignReqParam signReqParam, String status) {
        Long aLong;
        String identityType = signReqParam.getIdentityType();
        Long identityTypeL = HRStringUtils.isEmpty((String)identityType) ? Long.valueOf(1010L) : ((aLong = Long.valueOf(identityType)) == null || aLong == 0L ? Long.valueOf(1010L) : aLong);
        QFilter[] authQf = !ECPersonAuthRecordService.longIsEmpty(signReqParam.getNaturalId()) ? new QFilter[]{new QFilter("personid", "=", (Object)signReqParam.getNaturalId()), new QFilter("namemd5val", "=", (Object)signReqParam.getNameMd5Val()), new QFilter("mobilemd5val", "=", (Object)signReqParam.getMobileMd5Val()), new QFilter("identitymd5val", "=", (Object)signReqParam.getIdentityMd5Val()), new QFilter("enable", "=", (Object)status), new QFilter("identityType", "=", (Object)identityTypeL)} : (!ECPersonAuthRecordService.longIsEmpty(signReqParam.getCandidateId()) ? new QFilter[]{new QFilter("hcfperid", "=", (Object)signReqParam.getCandidateId()), new QFilter("namemd5val", "=", (Object)signReqParam.getNameMd5Val()), new QFilter("mobilemd5val", "=", (Object)signReqParam.getMobileMd5Val()), new QFilter("identitymd5val", "=", (Object)signReqParam.getIdentityMd5Val()), new QFilter("enable", "=", (Object)status), new QFilter("identityType", "=", (Object)identityTypeL)} : new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])});
        return authQf;
    }

    public static void invalidAuthRecord(Long naturalId, Long candidateId) {
        DynamicObject[] enables;
        ArrayList<String> list = new ArrayList<String>();
        list.add(STATUS_VALID);
        list.add(STATUS_AUTHING);
        QFilter[] authQf = naturalId != null && naturalId != 0L ? new QFilter[]{new QFilter("personid", "=", (Object)naturalId), new QFilter("enable", "in", list)} : new QFilter[]{new QFilter("hcfperid", "=", (Object)candidateId), new QFilter("enable", "in", list)};
        for (DynamicObject dyo : enables = serviceHelper.query("enable,modifier,modifytime", authQf)) {
            dyo.set("enable", (Object)STATUS_INVALID);
            HRBaseUtils.setModifyField((DynamicObject)dyo);
        }
        serviceHelper.update(enables);
    }

    public static void saveAuthRecord(SignReqParam signReqParam, String userId, String authUrl) {
        DynamicObject oldAuthRecord = ECPersonAuthRecordService.queryAuthUserInfo(signReqParam, STATUS_VALID);
        LOGGER.info("oldAuthRecord==null?{}", (Object)(oldAuthRecord == null ? 1 : 0));
        if (oldAuthRecord != null) {
            oldAuthRecord.set("enable", (Object)STATUS_INVALID);
            ECPersonAuthRecordService.updateOneDyo(oldAuthRecord);
        }
        DynamicObject newAuthRecord = serviceHelper.generateEmptyDynamicObject();
        newAuthRecord.set("userid", (Object)userId);
        newAuthRecord.set("personid", (Object)signReqParam.getNaturalId());
        newAuthRecord.set("hcfperid", (Object)signReqParam.getCandidateId());
        newAuthRecord.set("createuseridtime", (Object)new Date());
        newAuthRecord.set("enable", (Object)STATUS_AUTHING);
        newAuthRecord.set("authurl", (Object)authUrl);
        newAuthRecord.set("cloud", (Object)signReqParam.getCloud());
        newAuthRecord.set("appnum", (Object)signReqParam.getAppNum());
        newAuthRecord.set("namemd5val", (Object)signReqParam.getNameMd5Val());
        newAuthRecord.set("mobilemd5val", (Object)signReqParam.getMobileMd5Val());
        newAuthRecord.set("identitymd5val", (Object)signReqParam.getIdentityMd5Val());
        newAuthRecord.set("identitytype", (Object)Long.valueOf(signReqParam.getIdentityType()));
        Object result = serviceHelper.saveOne(newAuthRecord);
        LOGGER.info("saveAuthRecord result={}", result == null ? null : ((DynamicObject)result).getString("id"));
    }

    public static DynamicObject queryUserInfo(String userId) {
        String selectField = "id,userid,personid,hcfperid,successtime,enable,cloud,appnum,modifier,modifytime";
        QFilter qFilter = new QFilter("userid", "=", (Object)userId);
        return serviceHelper.queryOne(selectField, qFilter);
    }

    public static void authSuccess(DynamicObject dyo) {
        dyo.set("successtime", (Object)new Date());
        dyo.set("enable", (Object)STATUS_VALID);
        ECPersonAuthRecordService.updateOneDyo(dyo);
    }

    private static void updateOneDyo(DynamicObject dyo) {
        HRBaseUtils.setModifyField((DynamicObject)dyo);
        serviceHelper.updateOne(dyo);
    }
}

