/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.common.model.econtract.ContractView;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.CompanySingleSign;
import kd.hr.hrcs.bussiness.service.econtract.DoubleSign;
import kd.hr.hrcs.bussiness.service.econtract.ECPersonAuthRecordService;
import kd.hr.hrcs.bussiness.service.econtract.EContApiBase;
import kd.hr.hrcs.bussiness.service.econtract.EContLicenseService;
import kd.hr.hrcs.bussiness.service.econtract.EContemplateService;
import kd.hr.hrcs.bussiness.service.econtract.EContractService;
import kd.hr.hrcs.bussiness.service.econtract.EContractServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.PersonSignleSign;
import kd.hr.hrcs.bussiness.service.econtract.Sign;
import kd.hr.hrcs.bussiness.service.econtract.UserAuthApiService;
import kd.hr.hrcs.common.model.econtract.SignCloudReqParam;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class EContractSignApiService
extends EContApiBase {
    private static final Log LOGGER = LogFactory.getLog(EContractSignApiService.class);
    private boolean checkLicense = true;

    public EContractSignApiService(Long fiorg) {
        super(fiorg);
    }

    public EContractSignApiService(DynamicObject contractSubject) {
        super(contractSubject);
    }

    public SignRespParam upLoadContract(SignReqParam signReqParam, boolean checkLicense) {
        this.checkLicense = checkLicense;
        return this.upLoadContract(signReqParam);
    }

    public SignRespParam upLoadContract(SignReqParam signReqParam) {
        UserAuthApiService apiService;
        DynamicObject contTplDyo = this.getDynamiTplDyo(signReqParam);
        if (contTplDyo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u4e3a\u7a7a", (String)"EContractSignApiService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        EContractService eContractService = new EContractService();
        String contractNo = eContractService.genContractNo();
        String templateId = contTplDyo.getString("cloudtemp");
        if (StringUtils.isEmpty((String)templateId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677fID\u65e0\u6548\u3002", (String)"EContractSignApiService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        Sign sign = this.genSign(signReqParam, contTplDyo);
        String signtype = contTplDyo.getString("signtype");
        LOGGER.info("econt*** upLoadContract signtype\uff1a{} , template\uff1a{}", (Object)signtype, (Object)(this.longIsEmpty(signReqParam.getTemplateId()) ? signReqParam.getTemplateTypeId() : signReqParam.getTemplateId()));
        if (("2".equals(signtype) || "3".equals(signtype)) && !"1010".equals(signReqParam.getIdentityType()) && "1".equals((apiService = new UserAuthApiService(signReqParam.getFiorg())).getAuthResult(signReqParam))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u7684\u4e2a\u4eba\u8eab\u4efd\u8ba4\u8bc1\u4fe1\u606f\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u5b98\u65b9\u5ba1\u6838\u5927\u7ea6\u9700\u89811-2\u5929\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u5ba1\u6838\u7ed3\u679c\uff0c\u5ba1\u6838\u901a\u8fc7\u540e\u518d\u8fdb\u884c\u7b7e\u7f72\u3002", (String)"EContractSignApiService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return sign.doSign(contractNo, contTplDyo, true, this.checkLicense, signReqParam);
    }

    private DynamicObject getDynamiTplDyo(SignReqParam signReqParam) {
        DynamicObject contTplDyo;
        if (this.longIsEmpty(signReqParam.getTemplateTypeId()) && this.longIsEmpty(signReqParam.getTemplateId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7f72\u914d\u7f6e\u548c\u7b7e\u7f72\u7c7b\u578b\u90fd\u4e3a\u7a7a", (String)"EContractSignApiService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (this.longIsEmpty(signReqParam.getTemplateTypeId())) {
            contTplDyo = EContemplateService.queryEContplInfo(signReqParam.getTemplateId());
        } else {
            DynamicObject econtemplatetype = EContractServiceHelper.getSignConfig(signReqParam.getTemplateTypeId());
            contTplDyo = EContemplateService.queryEContplInfo(econtemplatetype.getDynamicObject("template").getLong("id"));
        }
        return contTplDyo;
    }

    private Sign genSign(SignReqParam signReqParam, DynamicObject contTplDyo) {
        String signtype = contTplDyo.getString("signtype");
        Sign sign = null;
        if ("1".equals(signtype)) {
            sign = new CompanySingleSign(this.getApiService(), signReqParam);
        } else if ("2".equals(signtype)) {
            sign = new PersonSignleSign(this.getApiService(), signReqParam);
        } else if ("3".equals(signtype)) {
            sign = new DoubleSign(this.getApiService(), signReqParam);
        }
        if (sign == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7f72\u7c7b\u578b\u9519\u8bef", (String)"EContractSignApiService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return sign;
    }

    public SignRespParam repeatToHandSign(String contractNo, SignReqParam signReqParam, boolean checkLicense) {
        this.checkLicense = checkLicense;
        return this.repeatToHandSign(contractNo, signReqParam);
    }

    public SignRespParam repeatToHandSign(String contractNo, SignReqParam signReqParam) {
        EContractService eContractService = new EContractService();
        DynamicObject contractInfo = eContractService.queryContractInfo(contractNo);
        if (contractInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u7f16\u7801\u9519\u8bef", (String)"EContractSignApiService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        Long econtplId = contractInfo.getLong("econtemplateid.id");
        DynamicObject contTplInfo = EContemplateService.queryEContplInfo(econtplId);
        Sign sign = this.genSign(signReqParam, contTplInfo);
        String status = contractInfo.getString("signstatus");
        if ("1".equals(status)) {
            return sign.doSign(contractNo, contTplInfo, false, this.checkLicense, signReqParam);
        }
        String userId = sign.tryGetUserId(contTplInfo, false);
        SignCloudReqParam signCloudReqParam = sign.genReqParam(userId, contractNo, contTplInfo);
        signCloudReqParam.setIdentityType(signReqParam.getIdentityType());
        String handSignUrl = this.getHandSignUrl(signCloudReqParam);
        SignRespParam resp = new SignRespParam(contractNo);
        resp.setHandSignUrl(handSignUrl);
        return resp;
    }

    public String getHandSignUrl(SignCloudReqParam signCloudReqParam) {
        Map<String, Object> returnData = this.getApiService().getHandSignURL(signCloudReqParam);
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code == 0) {
            Map data = (Map)returnData.get("data");
            return (String)data.get("handSignUrl");
        }
        String msg = String.valueOf(returnData.get("msg"));
        LOGGER.error("econt*** gethandSignUrl fail\uff1a{},error msg\uff1a{}", (Object)signCloudReqParam.getContractNo(), (Object)msg);
        throw new KDBizException(msg);
    }

    public boolean querySignStatus(String contractNo) {
        EContractService eContractService = new EContractService();
        DynamicObject contractInfo = eContractService.queryContractInfo(contractNo);
        String hrSignStatus = contractInfo.getString("signstatus");
        if ("3".equals(hrSignStatus)) {
            return true;
        }
        Map<String, Object> returnData = this.getApiService().getSignStatus(contractNo);
        LOGGER.info("querySignStatus returnData={}", returnData);
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code == 0) {
            Map data = (Map)returnData.get("data");
            String signStatus = (String)data.get("signStatus");
            if ("1".equals(signStatus)) {
                eContractService.finish(contractInfo);
                return true;
            }
        } else {
            String msg = String.valueOf(returnData.get("msg"));
            LOGGER.error("econt*** get signstatus fail contractno\uff1a{},error msg\uff1a{}", (Object)contractNo, (Object)msg);
            throw new KDBizException(msg);
        }
        return false;
    }

    public boolean querySignStatus(String contractNo, SignReqParam signReqParam) {
        DynamicObject validUser = ECPersonAuthRecordService.queryAuthUserInfo(signReqParam, "0");
        if (validUser == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u8ba4\u8bc1\u901a\u8fc7\u7684\u7528\u6237\u4fe1\u606f", (String)"EContractSignApiService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        EContractService eContractService = new EContractService();
        DynamicObject contractInfo = eContractService.queryContractInfo(contractNo);
        String hrSignStatus = contractInfo.getString("signstatus");
        if ("3".equals(hrSignStatus)) {
            return true;
        }
        String userId = validUser.getString("userid");
        Map<String, Object> returnData = this.getApiService().getSignStatus(contractNo, userId);
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code == 0) {
            Map data = (Map)returnData.get("data");
            String signStatus = (String)data.get("signStatus");
            return "1".equals(signStatus);
        }
        String msg = String.valueOf(returnData.get("msg"));
        LOGGER.error("econt*** get signstatus fail contractno\uff1a{},userId\uff1a{},error msg\uff1a{}", new Object[]{contractNo, userId, msg});
        throw new KDBizException(msg);
    }

    public SignRespParam companySign(Long fiorg, String contractNo, Long templateId, Long templateTypeId) {
        DynamicObject contTplInfo;
        this.checkContSubject();
        if (this.longIsEmpty(templateId) && this.longIsEmpty(templateTypeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7f72\u914d\u7f6e\u548c\u7b7e\u7f72\u7c7b\u578b\u90fd\u4e3a\u7a7a", (String)"EContractSignApiService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (this.longIsEmpty(templateId)) {
            DynamicObject econtemplatetype = EContractServiceHelper.getSignConfig(templateTypeId);
            contTplInfo = EContemplateService.queryEContplInfo(econtemplatetype.getDynamicObject("template").getLong("id"));
        } else {
            contTplInfo = EContemplateService.queryEContplInfo(templateId);
        }
        SignReqParam signReqParam = new SignReqParam(fiorg, templateId, templateTypeId, false);
        CompanySingleSign sign = new CompanySingleSign(this.getApiService(), signReqParam);
        Map<String, Object> map = sign.companySign(contractNo, contTplInfo, signReqParam);
        SignRespParam resp = new SignRespParam(contractNo);
        resp.setSealInfo(ContractView.mapToContractView((Map)((Map)map.get("sealInfo"))));
        LOGGER.info("companySign map={}", (Object)JSON.toJSONString(map));
        return resp;
    }

    private void checkContSubject() {
        boolean defaultFlag;
        Object defaultsignature;
        Long signatureId = this.getCSSignatureId();
        Map paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(RequestContext.get().getOrgId())));
        if (paramsMap != null && ObjectUtils.isNotEmpty(defaultsignature = paramsMap.get("defaultsignature")) && (defaultFlag = ((Boolean)defaultsignature).booleanValue())) {
            return;
        }
        if (this.longIsEmpty(signatureId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u4e3b\u4f53\u672a\u4e0a\u4f20\u5370\u7ae0\uff0c\u8bf7\u5148\u4e0a\u4f20\u5370\u7ae0\u3002", (String)"sign_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
    }

    public SignRespParam contPrevOrDld(String contractNo) {
        Map<String, Object> returnData = this.getApiService().refresh(contractNo);
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code == 0) {
            List dataList = (List)returnData.get("data");
            SignRespParam signRespParam = new SignRespParam(contractNo);
            Map sealInfo = (Map)((Map)dataList.get(0)).get("sealInfo");
            Map nosealInfo = (Map)((Map)dataList.get(0)).get("nosealInfo");
            signRespParam.setSealInfo(ContractView.mapToContractView((Map)sealInfo));
            signRespParam.setNosealInfo(ContractView.mapToContractView((Map)nosealInfo));
            return signRespParam;
        }
        String msg = String.valueOf(returnData.get("msg"));
        LOGGER.error("econt*** get download or prev url fail contractno\uff1a{},error msg\uff1a{}", (Object)contractNo, (Object)msg);
        throw new KDBizException(msg);
    }

    public boolean cancel(String contractNo) {
        EContractService eContractService = new EContractService();
        DynamicObject contractInfo = eContractService.queryContractInfo(contractNo);
        String signstatus = contractInfo.getString("signstatus");
        if (!"2".equals(signstatus)) {
            return false;
        }
        Map<String, Object> returnData = this.getApiService().cancel(contractNo);
        LOGGER.info("econt*** contract cancel info contractno\uff1a{},respone msg\uff1a{}", (Object)contractNo, returnData);
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code == 0) {
            String requestId = contractInfo.getString("requestid");
            if (HRStringUtils.isNotEmpty((String)requestId)) {
                Map<String, Object> siteMap = EContLicenseService.resumeSite(requestId);
                eContractService.cancle(contractInfo, (Boolean)siteMap.get("success"));
            }
            return true;
        }
        String msg = String.valueOf(returnData.get("msg"));
        LOGGER.error("econt*** contract cancel fail contractno\uff1a{},error msg\uff1a{}", (Object)contractNo, (Object)msg);
        return false;
    }
}

