/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.HttpClientUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ChargeSiteService;
import kd.hr.hrcs.bussiness.service.econtract.ChargeTokenCallbackServiceHelper;

public class EcontractChargeServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(EcontractChargeServiceHelper.class);
    private static int DEFAULT_CONNECTIONTIMEOUT = Integer.getInteger("httpclient.connectionTimeout", 3000);
    private static int DEFAULT_READTIMEOUT = 65000;
    private static final String FIND_TID_INFO_URL = "/ctrl/tenantobtain/findKBCOrderInfo";
    private static final String SEND_SMS_URL = "/tenant/cloud_auth/sendVerCodeForBind";
    private static final String BIND_TID_URL = "/tenant/cloud_auth/bind_tid";
    private static final String UNBIND_TID_URL = "/ctrl/tenantobtain/unbindKBCOrder";

    public static String getChargeDoman() {
        return SystemPropertyUtils.getProptyByTenant((String)"kd.hr.hrcs.econtract.chargeDomain", (String)RequestContext.get().getTenantId());
    }

    public static JSONObject unBindTid(String tid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject dynamicObject = ChargeSiteService.getDynamicObject();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tid", tid);
        paramMap.put("serviceId", dynamicObject.getString("serviceid"));
        if (EcontractChargeServiceHelper.invokeSiteService(dynamicObject, resultMap, paramMap, UNBIND_TID_URL)) {
            String msg = resultMap.get("msg") == null ? "" : (String)resultMap.get("msg");
            Object result = resultMap.get("result");
            if (result != null && !"".equals(result)) {
                JSONObject jsonResult = JSON.parseObject((String)((String)result));
                msg = jsonResult.getString("errorMessage");
            }
            return EcontractChargeServiceHelper.getJSONObjectResult(false, msg, null);
        }
        return EcontractChargeServiceHelper.getJSONObjectResult(true, null, null);
    }

    public static JSONObject bindTid(String tid, String phone, String smsCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject dynamicObject = ChargeSiteService.getDynamicObject();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tid", tid);
        paramMap.put("phone", phone);
        paramMap.put("verCode", smsCode);
        paramMap.put("tenantId", dynamicObject.getString("serviceid"));
        if (EcontractChargeServiceHelper.invokeSiteService(dynamicObject, resultMap, paramMap, BIND_TID_URL)) {
            String msg = resultMap.get("msg") == null ? "" : (String)resultMap.get("msg");
            Object result = resultMap.get("result");
            if (result != null && !"".equals(result)) {
                JSONObject jsonResult = JSON.parseObject((String)((String)result));
                msg = jsonResult.getString("info");
            }
            return EcontractChargeServiceHelper.getJSONObjectResult(false, msg, null);
        }
        return EcontractChargeServiceHelper.getJSONObjectResult(true, null, null);
    }

    public static JSONObject sendSmsCode(String phone) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject dynamicObject = ChargeSiteService.getDynamicObject();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("phone", phone);
        paramMap.put("tenantId", dynamicObject.getString("serviceid"));
        if (EcontractChargeServiceHelper.invokeSiteService(dynamicObject, resultMap, paramMap, SEND_SMS_URL)) {
            String msg = resultMap.get("msg") == null ? "" : (String)resultMap.get("msg");
            Object result = resultMap.get("result");
            if (result != null && !"".equals(result)) {
                JSONObject jsonResult = JSON.parseObject((String)((String)result));
                msg = jsonResult.getString("errorMessage");
            }
            return EcontractChargeServiceHelper.getJSONObjectResult(false, msg, null);
        }
        return EcontractChargeServiceHelper.getJSONObjectResult(true, null, null);
    }

    public static JSONObject getTidInfo(String tid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject dynamicObject = ChargeSiteService.getDynamicObject();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tid", tid);
        if (EcontractChargeServiceHelper.invokeSiteService(dynamicObject, resultMap, paramMap, FIND_TID_INFO_URL)) {
            String msg = resultMap.get("msg") == null ? "" : (String)resultMap.get("msg");
            Object result = resultMap.get("result");
            if (result != null && !"".equals(result)) {
                JSONObject jsonResult = JSON.parseObject((String)((String)result));
                msg = jsonResult.getString("errorMessage");
            }
            return EcontractChargeServiceHelper.getJSONObjectResult(false, msg, null);
        }
        JSONObject data = new JSONObject();
        Object result = resultMap.get("result");
        if (result != null && !"".equals(result)) {
            JSONObject jsonResult = JSON.parseObject((String)((String)result));
            data = jsonResult.getJSONObject("data");
        }
        return EcontractChargeServiceHelper.getJSONObjectResult(true, null, data);
    }

    private static JSONObject getJSONObjectResult(boolean success, String msg, JSONObject data) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("success", (Object)success);
        jsonObject.put("msg", (Object)msg);
        jsonObject.put("data", (Object)data);
        return jsonObject;
    }

    private static boolean invokeSiteService(DynamicObject dynamicObject, Map<String, Object> resultMap, Map<String, Object> paramMap, String url) {
        String token = ChargeTokenCallbackServiceHelper.getToken(dynamicObject);
        if (!EcontractChargeServiceHelper.isValide(resultMap, dynamicObject, token)) {
            return true;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        headerMap.put("access_token", token);
        headerMap.put("tenantId", dynamicObject.getString("serviceid"));
        String result = "";
        String chargeDomain = EcontractChargeServiceHelper.getChargeDoman();
        url = chargeDomain + url;
        LOGGER.info(MessageFormat.format("begin to invoke site service, paramMap : {0}, chargeUrl : {1}, headerMap : {2}", JSON.toJSONString(paramMap), url, JSON.toJSONString(headerMap)));
        try {
            result = HttpClientUtils.postjson((String)url, headerMap, (String)JSON.toJSONString(paramMap), (int)DEFAULT_CONNECTIONTIMEOUT, (int)DEFAULT_READTIMEOUT);
        }
        catch (Exception exception) {
            LOGGER.error("ChargeReduceSiteService http post error :", (Throwable)exception);
            resultMap.put("success", false);
            resultMap.put("msg", "Http IOException");
            return true;
        }
        LOGGER.info(MessageFormat.format("end to invoke site service, result : {0}", result));
        if (HRStringUtils.isEmpty((String)result) || result.equals("null")) {
            resultMap.put("success", false);
            resultMap.put("msg", "Http result is null");
            return true;
        }
        String code = JSON.parseObject((String)result).getString("code");
        if (!"0".equals(code)) {
            resultMap.put("success", false);
            resultMap.put("result", result);
            return true;
        }
        resultMap.put("success", true);
        resultMap.put("msg", "");
        resultMap.put("result", result);
        return false;
    }

    private static boolean isChargeTimeoutMock(String key) {
        boolean isChargeTimeout = false;
        String updatecharge = SystemPropertyUtils.getProptyByTenant((String)("kd.hr.hrcs.chargeapi.mock." + key + ".enable"), (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)updatecharge)) {
            isChargeTimeout = Boolean.parseBoolean(updatecharge);
        }
        return isChargeTimeout;
    }

    private static boolean isValide(Map<String, Object> map, DynamicObject dynamicObject, String token) {
        if (dynamicObject == null) {
            map.put("success", false);
            map.put("msg", ResManager.loadKDString((String)"\u7528\u6237\u672a\u6ce8\u518c", (String)"ChargeReduceSiteService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("reduceSite user is not register");
            return false;
        }
        if (dynamicObject.getString("userstatus").equals("0")) {
            map.put("success", false);
            map.put("msg", ResManager.loadKDString((String)"\u7528\u6237\u5df2\u89e3\u7ed1", (String)"ChargeReduceSiteService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("reduceSite user is unbound");
            return false;
        }
        if (HRStringUtils.isEmpty((String)token)) {
            map.put("success", false);
            map.put("msg", ResManager.loadKDString((String)"token\u83b7\u53d6\u5931\u8d25", (String)"ChargeReduceSiteService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.info("reduceSite token is not find");
            return false;
        }
        return true;
    }

    public static DynamicObject getChargeInfo(Object id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_chargeregister");
        DynamicObject dynamicObject = serviceHelper.queryOne(id);
        return dynamicObject;
    }

    public static void updateChargeTid(Object id, String tid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_chargeregister");
        DynamicObject dynamicObject = serviceHelper.queryOne(id);
        dynamicObject.set("tid", (Object)tid);
        serviceHelper.updateOne(dynamicObject);
    }
}

