/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.econtract.HRCloudApiReqServiceHelper;
import kd.hr.hrcs.common.model.econtract.SignCloudReqParam;

public class HRContractApiService {
    private HRCloudApiReqServiceHelper apiServiceHelper;

    public HRContractApiService(String kdAppid, String key) {
        this.apiServiceHelper = new HRCloudApiReqServiceHelper(kdAppid, key);
    }

    public Map<String, Object> uploadTemplate(String templateName, String position, String provider, String signType) {
        String url = "/api/contract/uploadTemplate";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("templateName", templateName);
        data.put("position", position);
        data.put("provider", provider);
        data.put("signType", signType);
        data.put("toolbar", "1");
        data.put("type", "1");
        data.put("showDownload", "1");
        return this.apiServiceHelper.doPostByMultipart(url, data, null, "");
    }

    public Map<String, Object> mobileAuthUrl(String name, String identityType, String identity, String mobile, String appId, String verifyNotifyUrl, String returnUrl, String verifyedWay, String provider) {
        String api = "/api/contract/mobileAuthUrl";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", name);
        data.put("identityType", identityType);
        data.put("identity", identity);
        data.put("mobile", mobile);
        data.put("isKdApp", Boolean.TRUE);
        data.put("appId", appId);
        data.put("verifyNotifyUrl", verifyNotifyUrl);
        data.put("returnUrl", returnUrl);
        data.put("verifyedWay", verifyedWay);
        data.put("provider", provider);
        data.put("forwardVersion", "1");
        return this.apiServiceHelper.doPost(api, data);
    }

    public Map<String, Object> queryAuthResult(String userId, String provider) {
        String api = "/api/contract/authResult";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("userId", userId);
        data.put("provider", provider);
        return this.apiServiceHelper.doPost(api, data);
    }

    public Map<String, Object> queryAuthResult(String identity, String name, String mobile, String provider) {
        String api = "/api/contract/authResult";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", identity);
        data.put("name", name);
        data.put("mobile", mobile);
        data.put("provider", provider);
        return this.apiServiceHelper.doPost(api, data);
    }

    public Map<String, Object> uploadContract(String contractNo, String templateId, String provider, String fileName, InputStream inputStream) {
        String url = "/api/contract/upload";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        data.put("templateID", templateId);
        data.put("provider", provider);
        return this.apiServiceHelper.doPostByMultipart(url, data, inputStream, fileName);
    }

    public Map<String, Object> toHandSign(SignCloudReqParam signCloudReqParam, String provider, DynamicObject contTplDyo) {
        String url = "/api/contract/toHandSign";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", signCloudReqParam.getContractNo());
        data.put("needHandSign", signCloudReqParam.getNeedHandSign());
        data.put("selfSign", signCloudReqParam.getSelfSign());
        data.put("userIds", signCloudReqParam.getUserIds());
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getNotifyUrl())) {
            data.put("notifyUrl", signCloudReqParam.getNotifyUrl());
        }
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getFrontUrl())) {
            data.put("frontUrl", signCloudReqParam.getFrontUrl());
        }
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getSignatureId())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getSignatureShowTime())) {
            data.put("signatureShowTime", signCloudReqParam.getSignatureShowTime());
        }
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getWritingTrack())) {
            data.put("writingTrack", signCloudReqParam.getWritingTrack());
        }
        data.put("provider", provider);
        data.put("verifyWayFlag", "1");
        if (!"1010".equals(signCloudReqParam.getIdentityType())) {
            data.put("signVerifyWay", "1");
        } else {
            data.put("signVerifyWay", "3");
        }
        String personsignway = contTplDyo.getString("personsignway");
        if (HRStringUtils.isNotEmpty((String)personsignway) && "1".equals(personsignway)) {
            data.put("pcHandSignature", "1");
        } else if (HRStringUtils.isNotEmpty((String)personsignway) && "3".equals(personsignway)) {
            data.put("writingTrack", "1");
        } else {
            data.put("pcHandSignature", "2");
        }
        return this.apiServiceHelper.doPost(url, data);
    }

    public Map<String, Object> sign(String contractNo, Long signatureId, Boolean acrosspageSign, String signatureShowTime) {
        String api = "/api/contract/sign";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        data.put("signatureId", signatureId);
        data.put("acrosspageSign", acrosspageSign);
        data.put("signatureShowTime", signatureShowTime);
        return this.apiServiceHelper.doPost(api, data);
    }

    public Map<String, Object> defaultSign(String contractNo, Long signatureId, Boolean acrosspageSign, String signatureShowTime) {
        String api = "/api/contract/sign";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        data.put("acrosspageSign", acrosspageSign);
        data.put("signatureShowTime", signatureShowTime);
        return this.apiServiceHelper.doPost(api, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> signPDF(String contractNo, String templateID, File file) {
        String api = "/api/contract/signPDF";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        data.put("templateID", templateID);
        String name = file.getName();
        try (FileInputStream ins = new FileInputStream(file);){
            Map<String, Object> map = this.apiServiceHelper.doPostByMultipart(api, data, ins, name);
            return map;
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    public Map<String, Object> getHandSignURL(SignCloudReqParam signCloudReqParam) {
        String url = "/api/contract/getHandSignURL";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", signCloudReqParam.getContractNo());
        data.put("userIds", signCloudReqParam.getUserIds());
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getFrontUrl())) {
            data.put("frontUrl", signCloudReqParam.getFrontUrl());
        }
        if (signCloudReqParam.getAcrosspageSign().booleanValue()) {
            data.put("acrosspageSign", signCloudReqParam.getAcrosspageSign());
        }
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getSignatureShowTime())) {
            data.put("signatureShowTime", signCloudReqParam.getSignatureShowTime());
        }
        if (StringUtils.isNotEmpty((String)signCloudReqParam.getWritingTrack())) {
            data.put("writingTrack", signCloudReqParam.getWritingTrack());
        }
        data.put("verifyWayFlag", "1");
        if (!"1010".equals(signCloudReqParam.getIdentityType())) {
            data.put("signVerifyWay", "1");
        } else {
            data.put("signVerifyWay", "3");
        }
        return this.apiServiceHelper.doPost(url, data);
    }

    public Map<String, Object> getSignStatus(String contractNo, String userId) {
        String apiUrl = "/api/contract/getSignStatus";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        data.put("userId", userId);
        return this.apiServiceHelper.doPost(apiUrl, data);
    }

    public Map<String, Object> getSignStatus(String contractNo) {
        String apiUrl = "/api/contract/getSignStatus";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        return this.apiServiceHelper.doPost(apiUrl, data);
    }

    public Map<String, Object> refresh(String contractNo) {
        String apiUrl = "/api/contract/refresh";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        return this.apiServiceHelper.doGet(apiUrl, data);
    }

    public Map<String, Object> cancel(String contractNo) {
        String api = "/api/contract/cancel";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contractNo", contractNo);
        return this.apiServiceHelper.doPost(api, data);
    }
}

