/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import org.apache.commons.lang.RandomStringUtils;

public class SignFileService {
    private static final Log logger = LogFactory.getLog(SignFileService.class);
    public static final String FIELD_SIGNFILE_ENTRY = "entryentity";
    public static final String FIELD_SIGNFILE_ENTRY_KEY = "KEY";
    public static final String FIELD_SIGNFILE_ENTRY_VALUE = "VALUE";
    private final HRBaseServiceHelper signFileServiceHelper = new HRBaseServiceHelper("hrcs_signfile");
    private static final String QUERY_SIGNFILE_SELECT_PROPERTIES = "id,billno,billstatus,cloud,businesstype,businessid,signconfig.id,appnum,entryentity.key,entryentity.value";
    public static final char CONTRACTNO_PREX = 'E';

    public String saveSignFile(SignReqParam signReqParam) {
        signReqParam.setContractNo(this.genContractNo());
        DynamicObject dyo = this.signFileServiceHelper.generateEmptyDynamicObject();
        dyo.set("billno", (Object)signReqParam.getContractNo());
        dyo.set("cloud", (Object)signReqParam.getCloud());
        dyo.set("appnum", (Object)signReqParam.getAppNum());
        dyo.set("signconfig", (Object)this.getCurrentSignConfig(signReqParam));
        dyo.set("businessid", (Object)signReqParam.getBusinessId());
        dyo.set("billstatus", (Object)"C");
        this.signFileServiceHelper.saveOne(dyo);
        return signReqParam.getContractNo();
    }

    public String saveSignFile(SignReqParam signReqParam, String contractNo) {
        signReqParam.setContractNo(this.genContractNo());
        DynamicObject dyo = this.signFileServiceHelper.generateEmptyDynamicObject();
        dyo.set("billno", (Object)signReqParam.getContractNo());
        dyo.set("cloud", (Object)signReqParam.getCloud());
        dyo.set("appnum", (Object)signReqParam.getAppNum());
        dyo.set("signconfig", (Object)this.getSignConfigByContractNo(contractNo));
        dyo.set("businessid", (Object)signReqParam.getBusinessId());
        dyo.set("billstatus", (Object)"C");
        this.signFileServiceHelper.saveOne(dyo);
        return signReqParam.getContractNo();
    }

    public Long getSignConfigByContractNo(String contractNo) {
        SignFlowService signFlowService;
        DynamicObject flowSignDyn;
        if (HRStringUtils.isNotEmpty((String)contractNo) && (flowSignDyn = (signFlowService = new SignFlowService()).queryOneByNo(contractNo)) != null && flowSignDyn.getLong("signconfig.id") != 0L) {
            ESignAppInfo eSignAppInfo = ESignAppCfgUtil.getESignAppInfo(flowSignDyn.getLong("signconfig.id"));
            return Long.parseLong(eSignAppInfo.getConfigId());
        }
        return 0L;
    }

    private Long getCurrentSignConfig(SignReqParam signReqParam) {
        ESignAppInfo signAppInfo = ESignAppCfgUtil.getOnlineAppInfoByCorpId(signReqParam.getLawEntityId());
        return Long.parseLong(signAppInfo.getConfigId());
    }

    public void saveExtMap(String billNo, Map<String, String> params) {
        DynamicObject dyn = this.queryOneByNo(billNo);
        if (dyn != null) {
            Map<String, String> preParams = this.getExtMap(dyn);
            preParams.putAll(params);
            DynamicObjectCollection entry = dyn.getDynamicObjectCollection(FIELD_SIGNFILE_ENTRY);
            entry.clear();
            for (Map.Entry<String, String> mapEntry : preParams.entrySet()) {
                DynamicObject row = entry.addNew();
                row.set(FIELD_SIGNFILE_ENTRY_KEY, (Object)mapEntry.getKey());
                row.set(FIELD_SIGNFILE_ENTRY_VALUE, (Object)mapEntry.getValue());
            }
            this.signFileServiceHelper.saveOne(dyn);
        }
    }

    private String genContractNo() {
        String dataStr = HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        for (int i = 0; i < 5; ++i) {
            StringBuilder contNumBuilder = new StringBuilder();
            String random = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
            contNumBuilder.append('E').append(dataStr).append(random);
            String contNum = contNumBuilder.toString();
            boolean exists = this.isExists(contNum);
            if (exists) continue;
            return contNum;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u6709\u6548\u7684\u5408\u540c\u7f16\u7801\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EContractService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
    }

    public DynamicObject queryOneById(Object pkId) {
        return this.signFileServiceHelper.queryOne(QUERY_SIGNFILE_SELECT_PROPERTIES, pkId);
    }

    public DynamicObject queryOneByNo(String billNo) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        return this.signFileServiceHelper.queryOne(QUERY_SIGNFILE_SELECT_PROPERTIES, filter);
    }

    public boolean isExists(String billNo) {
        return this.signFileServiceHelper.isExists(new QFilter("billno", "=", (Object)billNo));
    }

    public Map<String, String> getExtMap(DynamicObject signFile) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        if (signFile != null && "hrcs_signfile".equalsIgnoreCase(signFile.getDataEntityType().getName())) {
            DynamicObjectCollection entry = signFile.getDynamicObjectCollection(FIELD_SIGNFILE_ENTRY);
            for (DynamicObject row : entry) {
                resultMap.put(row.getString(FIELD_SIGNFILE_ENTRY_KEY), row.getString(FIELD_SIGNFILE_ENTRY_VALUE));
            }
        }
        return resultMap;
    }
}

