/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.esign.SignFileService;

public class SignFlowService {
    private static final Log logger = LogFactory.getLog(SignFlowService.class);
    public static final String FIELD_SIGNFLOW_ENTRY = "entryentity";
    public static final String FIELD_SIGNFLOW_ENTRY_KEY = "KEY";
    public static final String FIELD_SIGNFLOW_ENTRY_VALUE = "VALUE";
    private final SignFileService signFileService = new SignFileService();
    private final HRBaseServiceHelper signFlowServiceHelper = new HRBaseServiceHelper("hrcs_signflow");
    private static final String QUERY_SIGNFLOW_SELECT_PROPERTIES = "id,billno,billstatus,signfile,signstatus,entryentityorg.signorg,entryentityorg.orgsignstatus,entryentityorg.orgmsg,signconfig.id,entryentity.key,entryentity.value,entryentityperson.naturalid,entryentityperson.candidateid,entryentityperson.personsignstatus,entryentityperson.personmsg";

    public void saveExtMap(String billNo, Map<String, String> params) {
        DynamicObject dyn = this.queryOneByNo(billNo);
        if (dyn != null) {
            Map<String, String> preParams = this.getExtMap(dyn);
            preParams.putAll(params);
            DynamicObjectCollection entry = dyn.getDynamicObjectCollection(FIELD_SIGNFLOW_ENTRY);
            entry.clear();
            for (Map.Entry<String, String> mapEntry : preParams.entrySet()) {
                DynamicObject row = entry.addNew();
                row.set(FIELD_SIGNFLOW_ENTRY_KEY, (Object)mapEntry.getKey());
                row.set(FIELD_SIGNFLOW_ENTRY_VALUE, (Object)mapEntry.getValue());
            }
            this.signFlowServiceHelper.saveOne(dyn);
        }
    }

    public void updatePerosnSignStatus(String contractNo, boolean signStatus) {
        if (signStatus) {
            boolean updateFlag = false;
            DynamicObject flowSignDyn = this.queryOneByNo(contractNo);
            for (DynamicObject person : flowSignDyn.getDynamicObjectCollection("entryentityperson")) {
                if ("signed".equals(person.getString("personsignstatus")) || "sign_rejected".equals(person.getString("personsignstatus"))) continue;
                person.set("personsignstatus", (Object)"signed");
                updateFlag = true;
            }
            if (updateFlag) {
                this.updateOrgSignStatus(flowSignDyn);
            }
        }
    }

    public void updateContractSignStatus(String contractNo, boolean signStatus) {
        if (signStatus) {
            boolean updateFlag = false;
            DynamicObject flowSignDyn = this.queryOneByNo(contractNo);
            for (DynamicObject org : flowSignDyn.getDynamicObjectCollection("entryentityorg")) {
                if ("signed".equals(org.getString("orgsignstatus")) || "sign_rejected".equals(org.getString("orgsignstatus"))) continue;
                org.set("orgsignstatus", (Object)"signed");
                updateFlag = true;
            }
            for (DynamicObject person : flowSignDyn.getDynamicObjectCollection("entryentityperson")) {
                if ("signed".equals(person.getString("personsignstatus")) || "sign_rejected".equals(person.getString("personsignstatus"))) continue;
                person.set("personsignstatus", (Object)"signed");
                updateFlag = true;
            }
            if (!"signed".equals(flowSignDyn.getString("signstatus")) && !"sign_rejected".equals(flowSignDyn.getString("signstatus"))) {
                flowSignDyn.set("signstatus", (Object)"signed");
                updateFlag = true;
            }
            if (updateFlag) {
                this.updateOrgSignStatus(flowSignDyn);
            }
        }
    }

    private void updateOrgSignStatus(DynamicObject flowSignDyn) {
        HRBaseServiceHelper signFlowServiceHelper = new HRBaseServiceHelper("hrcs_signflow");
        signFlowServiceHelper.updateOne(flowSignDyn);
    }

    public void saveSignFlow(SignReqParam signReqParam, String billNo) {
        DynamicObject signPerosnRow;
        DynamicObject signFile = this.signFileService.queryOneByNo(billNo);
        if (signFile == null) {
            throw new KDBizException("contract No is not exists, please check.");
        }
        DynamicObject dyo = this.queryOneByNo(billNo);
        if (dyo == null) {
            dyo = this.signFlowServiceHelper.generateEmptyDynamicObject();
            dyo.set("signstatus", (Object)"wait_sign");
        }
        dyo.set("billno", (Object)billNo);
        dyo.set("signfile", (Object)signFile.getLong("id"));
        dyo.set("signconfig", signFile.get("signconfig"));
        dyo.set("templatetypeid", (Object)signReqParam.getTemplateTypeId());
        dyo.set("econttmp", (Object)signReqParam.getTemplateId());
        DynamicObjectCollection doc = dyo.getDynamicObjectCollection("entryentityperson");
        if (signReqParam.getNaturalId() != null) {
            signPerosnRow = doc.addNew();
            signPerosnRow.set("naturalid", (Object)signReqParam.getNaturalId());
        }
        if (signReqParam.getCandidateId() != null) {
            signPerosnRow = doc.addNew();
            signPerosnRow.set("candidateid", (Object)signReqParam.getCandidateId());
        }
        if (signReqParam.getFiorg() != null) {
            DynamicObjectCollection docOrg = dyo.getDynamicObjectCollection("entryentityorg");
            DynamicObject signOrgRow = docOrg.addNew();
            signOrgRow.set("signorg", (Object)signReqParam.getLawEntityId());
        }
        this.signFlowServiceHelper.saveOne(dyo);
    }

    public DynamicObject queryOneById(Object pkId) {
        return this.signFlowServiceHelper.queryOne(QUERY_SIGNFLOW_SELECT_PROPERTIES, pkId);
    }

    public DynamicObject queryOneByNo(String billNo) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        return this.signFlowServiceHelper.queryOne(QUERY_SIGNFLOW_SELECT_PROPERTIES, filter);
    }

    public List<String> querySignTaskIdsByNo(List<String> contractNos) {
        QFilter filter = new QFilter("billno", "in", contractNos);
        DynamicObject[] signFlowDys = this.signFlowServiceHelper.query("entryentity.key,entryentity.value", new QFilter[]{filter});
        ArrayList signTaskIds = Lists.newArrayListWithCapacity((int)signFlowDys.length);
        for (DynamicObject signFlowDy : signFlowDys) {
            DynamicObjectCollection entry = signFlowDy.getDynamicObjectCollection(FIELD_SIGNFLOW_ENTRY);
            entry.stream().filter(row -> HRStringUtils.equals((String)row.getString(FIELD_SIGNFLOW_ENTRY_KEY), (String)"signTaskId")).map(row -> row.getString(FIELD_SIGNFLOW_ENTRY_VALUE)).findFirst().ifPresent(signTaskIds::add);
        }
        return signTaskIds;
    }

    public Object save(DynamicObject dyn) {
        return this.signFlowServiceHelper.saveOne(dyn);
    }

    public Map<String, String> getExtMap(DynamicObject signFlow) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        if (signFlow != null && "hrcs_signflow".equalsIgnoreCase(signFlow.getDataEntityType().getName())) {
            DynamicObjectCollection entry = signFlow.getDynamicObjectCollection(FIELD_SIGNFLOW_ENTRY);
            for (DynamicObject row : entry) {
                resultMap.put(row.getString(FIELD_SIGNFLOW_ENTRY_KEY), row.getString(FIELD_SIGNFLOW_ENTRY_VALUE));
            }
        }
        return resultMap;
    }
}

