/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.bo;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.EncryptionSchemeUtil;

public class ESignAppInfo {
    private final String configId;
    private final String spId;
    private final String corporateId;
    private final String appId;
    private final String appSecret;
    private final String serverUrl;
    private final String thirdCorpId;
    private final Long cfgDateTime;
    private final Map<String, String> extParam = new HashMap<String, String>(4);

    private ESignAppInfo(String spId, String corporateId, String appId, String appSecret, String serverUrl, String thirdCorpId, String configId, Long cfgDateTime, String appSecretEn) {
        JSONObject decodeData;
        this.spId = spId;
        this.corporateId = corporateId;
        this.appId = appId;
        this.serverUrl = serverUrl;
        this.thirdCorpId = thirdCorpId;
        this.configId = configId;
        this.cfgDateTime = cfgDateTime;
        long enSchemeId = EncryptionSchemeUtil.getEncryptionSchemeId();
        this.appSecret = HRStringUtils.isNotEmpty((String)appSecretEn) && enSchemeId != 0L ? ((decodeData = PermissionServiceHelper.decryptData((long)enSchemeId, (String)appSecretEn)).getBoolean("success").booleanValue() ? decodeData.getString("data") : appSecret) : appSecret;
    }

    public static ESignAppInfo build(String spId, String corporateId, String appId, String appSecret, String serverUrl, String thirdCorpId, String configId, Long cfgDateTime) {
        String appSecretEn = null;
        if ("******".equals(appSecret)) {
            DynamicObject dynamicObject = ESignAppCfgUtil.getTargetAppCfgDyn(Long.parseLong(spId), Long.parseLong(corporateId));
            appSecretEn = dynamicObject.getString("appsecreten");
        }
        return ESignAppInfo.build(spId, corporateId, appId, appSecret, serverUrl, thirdCorpId, configId, cfgDateTime, appSecretEn);
    }

    public static ESignAppInfo build(String spId, String corporateId, String appId, String appSecret, String serverUrl, String thirdCorpId, String configId, Long cfgDateTime, String appSecretEn) {
        return new ESignAppInfo(spId, corporateId, appId, appSecret, serverUrl, thirdCorpId, configId, cfgDateTime, appSecretEn);
    }

    public String getSpId() {
        return this.spId;
    }

    public String getCorporateId() {
        return this.corporateId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public Map<String, String> getExtParam() {
        return this.extParam;
    }

    public Map<String, String> setExtParam(String key, String value) {
        this.extParam.put(key, value);
        return this.extParam;
    }

    public Map<String, String> setExtParams(Map<String, String> params) {
        this.extParam.putAll(params);
        return this.extParam;
    }

    public String getConfigId() {
        return this.configId;
    }

    public Long getCfgDateTime() {
        return this.cfgDateTime;
    }

    public String getThirdCorpId() {
        return this.thirdCorpId;
    }
}

