/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.factory;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.factory.BaseESignSrvFactory;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import org.apache.commons.lang3.ObjectUtils;

public class ESignFactoryRegister {
    private static final Log LOGGER = LogFactory.getLog(ESignFactoryRegister.class);
    private static final int CACHE_TIMEOUT = 1440;
    public static final Table<String, String, BaseESignSrvFactory> factoryRegTable = HashBasedTable.create();

    public static Table<String, String, BaseESignSrvFactory> getRegister() {
        return factoryRegTable;
    }

    protected static BaseESignSrvFactory getESignFactory(String spId, String corporateId) {
        BaseESignSrvFactory baseESignSrvFactory;
        LOGGER.info("getESignFactory reqParams:spId={}  corporateId={}", (Object)spId, (Object)corporateId);
        ESignAppInfo eSignSPAppInfo = ESignAppCfgUtil.obtainESignSPAppInfo(Long.parseLong(spId), Long.parseLong(corporateId));
        String targetCorpId = eSignSPAppInfo.getCorporateId();
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hrcs");
        String cacheKey = spId + ":" + targetCorpId;
        Long appUpdTime = (Long)ihrAppCache.get(cacheKey, Long.class);
        if (ObjectUtils.isEmpty((Object)appUpdTime)) {
            LOGGER.info("esign cache invalid, refresh local cache.spId={}  targetCorpId={}", (Object)spId, (Object)targetCorpId);
            appUpdTime = eSignSPAppInfo.getCfgDateTime();
        }
        if (appUpdTime.compareTo((baseESignSrvFactory = ESignFactoryRegister.getBaseESignSrvFactory(spId, targetCorpId)).geteSignAppInfo().getCfgDateTime()) == 0) {
            return baseESignSrvFactory;
        }
        LOGGER.info("esign cache change, refresh local cache.spId={} targetCorpId={}", (Object)spId, (Object)targetCorpId);
        ihrAppCache.put(cacheKey, (Object)appUpdTime, 1440);
        ESignFactoryRegister.forceRegESignFactory(spId, targetCorpId);
        return ESignFactoryRegister.getBaseESignSrvFactory(spId, targetCorpId);
    }

    private static BaseESignSrvFactory getBaseESignSrvFactory(String spId, String corporateId) {
        BaseESignSrvFactory baseESignSrvFactory = (BaseESignSrvFactory)factoryRegTable.get((Object)spId, (Object)corporateId);
        if (baseESignSrvFactory == null) {
            return ESignFactoryRegister.regESignFactory(spId, corporateId);
        }
        return baseESignSrvFactory;
    }

    private static BaseESignSrvFactory regESignFactory(String spId, String corporateId) {
        BaseESignSrvFactory factory = new BaseESignSrvFactory(spId, corporateId);
        factoryRegTable.put((Object)spId, (Object)corporateId, (Object)factory);
        return factory;
    }

    private static BaseESignSrvFactory forceRegESignFactory(String spId, String corporateId) {
        return ESignFactoryRegister.regESignFactory(spId, corporateId);
    }
}

