/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.EContNotifyService;
import kd.hr.hrcs.bussiness.service.esign.SignFileService;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.CallBackEvent;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.CallBackEventType;
import kd.hr.hrcs.bussiness.service.esign.util.CallBackUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;

public class FddCallBackEvent
extends FddBaseService<FddConfig>
implements CallBackEvent {
    private static final Log LOGGER = LogFactory.getLog(FddCallBackEvent.class);
    public static final String SEAL_ID = "sealId";
    public static final String SUCESS_MSG = "{\"msg\":\"success\"}";

    @Override
    public String sealCreate(String bizContent) {
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        Long sealId = reqParam.getLong(SEAL_ID);
        String callBackKey = CallBackUtil.getSealCreateCallBackKey(reqParam);
        Long pkId = CallBackUtil.queryRelDataIdByCallBackKey(callBackKey);
        HRBaseServiceHelper service = HRBaseServiceHelper.create((String)"hrcs_esigncoseal");
        DynamicObject dyn = service.loadSingle((Object)pkId);
        dyn.set("sealid", (Object)sealId);
        service.updateOne(dyn);
        return SUCESS_MSG;
    }

    @Override
    public String sealVerify(String bizContent, CallBackEventType callBackEventType) {
        switch (callBackEventType) {
            case SEAL_VERIFY_SUCCESSED: {
                return this.sealVerifySuccessed(bizContent);
            }
            case SEAL_VERIFY_FAILED: {
                return this.sealVerifyFailed(bizContent);
            }
        }
        return SUCESS_MSG;
    }

    private String sealVerifySuccessed(String bizContent) {
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        Long sealId = reqParam.getLong(SEAL_ID);
        String callBackKey = CallBackUtil.getSealCreateCallBackKey(reqParam);
        Long pkId = CallBackUtil.queryRelDataIdByCallBackKey(callBackKey);
        HRBaseServiceHelper service = HRBaseServiceHelper.create((String)"hrcs_esigncoseal");
        DynamicObject dyn = service.loadSingle((Object)pkId);
        dyn.set("sealid", (Object)sealId);
        dyn.set("thirdauditstatus", (Object)"1");
        service.updateOne(dyn);
        return SUCESS_MSG;
    }

    private String sealVerifyFailed(String bizContent) {
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String callBackKey = CallBackUtil.getSealCreateCallBackKey(reqParam);
        Long pkId = CallBackUtil.queryRelDataIdByCallBackKey(callBackKey);
        HRBaseServiceHelper service = HRBaseServiceHelper.create((String)"hrcs_esigncoseal");
        DynamicObject dyn = service.loadSingle((Object)pkId);
        dyn.set("thirdauditstatus", (Object)"2");
        service.updateOne(dyn);
        return SUCESS_MSG;
    }

    @Override
    public void corporateAuth(String bizContent) {
        LOGGER.info("corporateAuth start");
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String clientCorpId = reqParam.getString("clientCorpId");
        String authResult = reqParam.getString("authResult");
        String openCorpId = reqParam.getString("openCorpId");
        LOGGER.info("corporateAuth clientCorpId={}\uff0cauthResult={}", (Object)clientCorpId, (Object)authResult);
        if ("success".equals(authResult)) {
            CallBackUtil.updateCorAuthStatus(clientCorpId, openCorpId);
        }
    }

    @Override
    public void signTaskSigned(String bizContent) {
        LOGGER.info("signTaskSigned, bizContent={}", (Object)bizContent);
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String contractNo = reqParam.getString("transReferenceId");
        String actorId = reqParam.getString("actorId");
        this.updateSignStatus(contractNo, actorId, "signed", null);
    }

    @Override
    public void signTaskSignFailed(String bizContent) {
        LOGGER.info("signTaskSignFailed, bizContent={}", (Object)bizContent);
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String contractNo = reqParam.getString("transReferenceId");
        String actorId = reqParam.getString("actorId");
        String signFailedReason = reqParam.getString("signFailedReason");
        this.updateSignStatus(contractNo, actorId, "sign_failed", signFailedReason);
    }

    @Override
    public void signTaskSignRejected(String bizContent) {
        LOGGER.info("signTaskSignRejected, bizContent={}", (Object)bizContent);
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String contractNo = reqParam.getString("transReferenceId");
        String actorId = reqParam.getString("actorId");
        this.updateSignStatus(contractNo, actorId, "sign_rejected", null);
    }

    @Override
    public void signTaskSignFinished(String bizContent) {
        LOGGER.info("signTaskSignFinished, bizContent={}", (Object)bizContent);
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String contractNo = reqParam.getString("transReferenceId");
        this.updateSignStatus(contractNo, null, "signed", null);
    }

    @Override
    public void sealAuthorizeFreeSign(String bizContent) {
        LOGGER.info("sealAuthorizeFreeSign, bizContent={}", (Object)bizContent);
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String callBackKey = CallBackUtil.getSealAuthorizeFreeSignCallBackKey2(reqParam);
        Long pkId = CallBackUtil.queryRelDataIdByCallBackKey(callBackKey);
        DynamicObject dyn = ESignDBServiceUtil.eSignSealAuthService.loadSingle((Object)pkId);
        dyn.set("authstatus", (Object)"1");
        Long expiresTime = Long.valueOf(reqParam.getString("expiresTime"));
        Date endTime = HRDateTimeUtils.convertDate((Long)expiresTime);
        Date startTime = HRDateTimeUtils.convertBefore365DayDate((Long)expiresTime);
        dyn.set("starttime", (Object)startTime);
        dyn.set("endtime", (Object)endTime);
        ESignDBServiceUtil.eSignSealAuthService.updateOne(dyn);
    }

    @Override
    public void cancelTask(String bizContent) {
        LOGGER.info("cancelTask, bizContent={}", (Object)bizContent);
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String contractNo = reqParam.getString("transReferenceId");
        this.updateSignStatus(contractNo, null, "sign_canceled", null);
    }

    @Override
    public void abolishTask(String bizContent) {
        LOGGER.info("abolishTask, bizContent={}", (Object)bizContent);
        JSONObject reqParam = JSON.parseObject((String)bizContent);
        String contractNo = reqParam.getString("transReferenceId");
        String abolishSignTaskId = reqParam.getString("abolishedSignTaskId");
        this.updateSignStatus(contractNo, null, "signed", null);
        HRBaseServiceHelper signFlowServiceHelper = new HRBaseServiceHelper("hrcs_signflow");
        DynamicObject[] query = signFlowServiceHelper.query(new QFilter[0]);
        SignFlowService signFlowService = new SignFlowService();
        for (DynamicObject dynamicObject : query) {
            Map<String, String> signFlowExtMap = signFlowService.getExtMap(dynamicObject);
            String signTaskId = signFlowExtMap.get("signTaskId");
            if (!signTaskId.equals(abolishSignTaskId)) continue;
            dynamicObject.set("signstatus", (Object)"revoked");
            signFlowServiceHelper.updateOne(dynamicObject);
            return;
        }
    }

    private void updateSignStatus(String contractNo, String actorId, String signTaskStatus, String signFailedReason) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject dynamicObject = signFlowService.queryOneByNo(contractNo);
        if (dynamicObject != null) {
            if (HRStringUtils.isEmpty((String)actorId)) {
                dynamicObject.set("signstatus", (Object)signTaskStatus);
            } else if ("person".equals(actorId)) {
                DynamicObjectCollection docOrg = dynamicObject.getDynamicObjectCollection("entryentityperson");
                for (int i = 0; i < docOrg.size(); ++i) {
                    DynamicObject orgDyn = (DynamicObject)docOrg.get(i);
                    orgDyn.set("personsignstatus", (Object)signTaskStatus);
                    orgDyn.set("personmsg", (Object)signFailedReason);
                }
                if ("signed".equals(signTaskStatus)) {
                    this.notifyBiz(contractNo, "signNotify");
                } else {
                    this.failNotifyBiz(contractNo, this.getDataMap(contractNo, actorId, signFailedReason), "signFailNotify");
                }
            } else if ("corp".equals(actorId)) {
                DynamicObjectCollection docOrg = dynamicObject.getDynamicObjectCollection("entryentityorg");
                for (int i = 0; i < docOrg.size(); ++i) {
                    DynamicObject orgDyn = (DynamicObject)docOrg.get(i);
                    orgDyn.set("orgsignstatus", (Object)signTaskStatus);
                    orgDyn.set("orgmsg", (Object)signFailedReason);
                }
                if ("signed".equals(signTaskStatus)) {
                    this.notifyBiz(contractNo, "companySignNotify");
                } else {
                    this.failNotifyBiz(contractNo, this.getDataMap(contractNo, null, signFailedReason), "companySignFailNotify");
                }
            }
            signFlowService.save(dynamicObject);
        }
    }

    private Map<String, Object> getDataMap(String contractNo, String userId, String signFailedReason) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("contractNo", contractNo);
        result.put("userId", userId);
        result.put("createTime", String.valueOf(new Date().getTime()));
        result.put("resultCode", "0");
        result.put("resultDesc", signFailedReason);
        return result;
    }

    private void notifyBiz(String contractNo, String methodName) {
        SignFileService signFileService = new SignFileService();
        DynamicObject dynamicObject = signFileService.queryOneByNo(contractNo);
        if (dynamicObject == null) {
            return;
        }
        String cloud = dynamicObject.getString("cloud");
        String appNum = dynamicObject.getString("appnum");
        if (HRStringUtils.isEmpty((String)cloud) || HRStringUtils.isEmpty((String)appNum)) {
            return;
        }
        String servName = EContNotifyService.querySignNotifyServName(cloud, appNum);
        if (HRStringUtils.isEmpty((String)servName)) {
            return;
        }
        LOGGER.info("kd-contract-api-handsignnotify to notify biz cloud:{}, appNum:{}, servName{},methodName{}, contractNo{}", new Object[]{cloud, appNum, servName, methodName, contractNo});
        try {
            HRMServiceHelper.invokeBizService((String)cloud, (String)appNum, (String)servName, (String)methodName, (Object[])new Object[]{contractNo});
        }
        catch (Exception e) {
            LOGGER.info("kd-contract-api-handsignnotify to notify biz err {}", (Object)e.getMessage());
        }
    }

    private void failNotifyBiz(String contractNo, Map<String, Object> data, String methodName) {
        SignFileService signFileService = new SignFileService();
        DynamicObject dynamicObject = signFileService.queryOneByNo(contractNo);
        if (dynamicObject == null) {
            return;
        }
        String cloud = dynamicObject.getString("cloud");
        String appNum = dynamicObject.getString("appnum");
        if (HRStringUtils.isEmpty((String)cloud) || HRStringUtils.isEmpty((String)appNum)) {
            return;
        }
        String servName = EContNotifyService.querySignNotifyServName(cloud, appNum);
        if (HRStringUtils.isEmpty((String)servName)) {
            return;
        }
        LOGGER.info("kd-contract-api-handsignnotify to notify biz cloud:{}, appNum:{}, servName{},methodName{}, data{}", new Object[]{cloud, appNum, servName, methodName, JSON.toJSONString(data)});
        try {
            HRMServiceHelper.invokeBizService((String)cloud, (String)appNum, (String)servName, (String)methodName, (Object[])new Object[]{data});
        }
        catch (Exception e) {
            LOGGER.info("kd-contract-api-handsignnotify to notify biz err {}", (Object)e.getMessage());
        }
    }
}

