/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrcs.bussiness.service.esign.api.CallBackEvent;
import kd.hr.hrcs.bussiness.service.esign.factory.ESignSrvFactory;
import kd.hr.hrcs.bussiness.service.esign.factory.ServiceRouter;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.CallBackEventType;
import kd.hr.hrcs.bussiness.service.esign.util.CallBackUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.esign3rd.fadada.utils.crypt.FddCryptUtil;
import org.apache.commons.lang3.ObjectUtils;

public class FddCallBackService {
    private static final Log LOGGER = LogFactory.getLog(FddCallBackService.class);
    public static final String SUCESS_MSG = "{\"msg\":\"success\"}";
    public static final String FAIL_MSG = "{\"msg\":\"fail\"}";
    private final Map<String, String> paramMap;
    private final String sign;
    private final String timestamp;
    private final ESignSrvFactory onlineSrvFactory;
    private CallBackEvent callBackEvent;
    private final CallBackEventType callBackEventType;

    public CallBackEventType getCallBackEventType() {
        return this.callBackEventType;
    }

    public FddCallBackService(Map<String, String> paramMap, String sign, String timestamp, CallBackEventType callBackEventType) {
        this.paramMap = paramMap;
        this.sign = sign;
        this.timestamp = timestamp;
        this.callBackEventType = callBackEventType;
        this.onlineSrvFactory = this.getESignSrvFactory();
        if (this.onlineSrvFactory != null) {
            this.callBackEvent = this.onlineSrvFactory.getCallBackEvent();
        }
    }

    public Map<String, String> getParamMap() {
        return this.paramMap;
    }

    public ESignSrvFactory getESignSrvFactory() {
        String appId = this.paramMap.get("X-FASC-App-Id");
        try {
            Long corporateId = ESignAppCfgUtil.getFddCorpIdByAppId(appId);
            if (ObjectUtils.isEmpty((Object)corporateId)) {
                LOGGER.warn("corporateIds is null, appId={}", (Object)appId);
                CallBackUtil.updateInvokeFail(this.callBackEventType, this.paramMap, "corporateIds is null, appId= " + appId);
                return null;
            }
            return ServiceRouter.getOnlineSrvFactory(corporateId);
        }
        catch (Exception e) {
            CallBackUtil.updateInvokeFail(this.callBackEventType, this.paramMap, "corporateIds is null, appId= " + appId + " e=" + e.getMessage());
            LOGGER.warn("getESignSrvFactory is err, appId={}", (Object)appId, (Object)e);
            return null;
        }
    }

    public boolean checkService() {
        return this.checkESignSrvFactory() && this.checkSign(this.paramMap, this.sign, this.timestamp, this.onlineSrvFactory.getConfig().getAppSecret());
    }

    private boolean checkESignSrvFactory() {
        if (this.onlineSrvFactory == null) {
            LOGGER.warn("fdd callbackevent getESignSrvFactory fail, paramMap={}, sign={}, timestamp={}", new Object[]{this.paramMap, this.sign, this.timestamp});
            CallBackUtil.updateInvokeFail(this.callBackEventType, this.paramMap, "fdd callbackevent getESignSrvFactory fail,  sign=" + this.sign + ", timestamp=" + this.timestamp);
            return false;
        }
        return true;
    }

    private boolean checkSign(Map<String, String> paramMap, String sign, String timestamp, String appSecret) {
        String sortParam = FddCryptUtil.sortParameters(paramMap);
        String signature = null;
        try {
            signature = FddCryptUtil.sign((String)sortParam, (String)timestamp, (String)appSecret);
            if (!signature.equalsIgnoreCase(sign)) {
                LOGGER.warn("fdd callbackevent sign fail, sourSign={}, curSign={}", (Object)sign, (Object)signature);
                CallBackUtil.updateInvokeFail(this.callBackEventType, paramMap, "corporateIds is null, sourSign= " + sign + " curSign=" + signature);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.warn("fdd callbackevent fail, sourSign={}, curSign={}", new Object[]{sign, signature, e});
            CallBackUtil.updateInvokeFail(this.callBackEventType, paramMap, "corporateIds is null, sourSign= " + sign + " curSign=" + signature + " e=" + e.getMessage());
            return false;
        }
        return true;
    }

    public String sealCreate() {
        this.callBackEvent.sealCreate(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String sealVerify() {
        this.callBackEvent.sealVerify(this.paramMap.get("bizContent"), this.getCallBackEventType());
        return SUCESS_MSG;
    }

    public String corporateAuth() {
        this.callBackEvent.corporateAuth(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String signTaskSigned() {
        this.callBackEvent.signTaskSigned(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String signTaskSignFailed() {
        this.callBackEvent.signTaskSignFailed(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String signTaskSignReject() {
        this.callBackEvent.signTaskSignRejected(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String signTaskFinished() {
        this.callBackEvent.signTaskSignFinished(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String sealAuthorizeFreeSign() {
        this.callBackEvent.sealAuthorizeFreeSign(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String cancelTask() {
        this.callBackEvent.cancelTask(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }

    public String abolishTask() {
        this.callBackEvent.abolishTask(this.paramMap.get("bizContent"));
        return SUCESS_MSG;
    }
}

