/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRMD5Util;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealCUD;
import kd.hr.hrcs.bussiness.service.esign.bo.SealInfo;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.SealTypeMappingEnum;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.mock.FddSealMock;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.DealUtil;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.bussiness.service.esign.util.CallBackUtil;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseReq;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SealClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.CreateLegalRepresentativeSealByImageReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.CreateSealByImageReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.ModifySealReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.SealDeleteReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.SetSealStatusReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.seal.CreateLegalRepresentativeSealByImageRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.seal.CreateSealByImageRes;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FddCorporateSealCUD
extends FddBaseService<FddConfig>
implements CorporateSealCUD {
    private static final Log LOGGER = LogFactory.getLog(FddCorporateSealCUD.class);

    private SealClient getSealClient(OpenApiClient openApiClient) {
        return new SealClient(openApiClient);
    }

    @Override
    public ResponseData createSeal(SealInfo sealInfo) {
        String sealPicBase64;
        OpenApiClient openApiClient = this.getOpenApiClient();
        FileService service = FileServiceFactory.getImageFileService();
        try (InputStream ins = service.getInputStream(sealInfo.getPicFileUrl());){
            byte[] src = IOUtils.toByteArray((InputStream)ins);
            LOGGER.info("image size={} url={}", (Object)src.length, (Object)sealInfo.getPicFileUrl());
            sealPicBase64 = Base64.getEncoder().encodeToString(src);
        }
        catch (IOException e) {
            LOGGER.warn("Base64.getEncoder().encodeToString execution occurred exception", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(e.getMessage());
        }
        SealClient sealClient = this.getSealClient(openApiClient);
        String sealType = SealTypeMappingEnum.findFddSealTypeEnum(sealInfo.getSealType()).getCategoryType();
        if (SealTypeMappingEnum.isLegalRepresentativeSeal(sealType)) {
            return this.createLegalRepresentativeSealByImage(sealInfo, sealPicBase64, openApiClient, sealClient);
        }
        return this.createSealByImage(sealInfo, sealPicBase64, openApiClient, sealClient, sealType);
    }

    private ResponseData<BaseRes<CreateSealByImageRes>> createSealByImage(SealInfo sealInfo, String sealPicBase64, OpenApiClient openApiClient, SealClient sealClient, String sealType) {
        CreateSealByImageReq req = new CreateSealByImageReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        req.setOpenCorpId(sealInfo.getOpenCorpId());
        req.setSealName(sealInfo.getSealName());
        req.setCategoryType(sealType);
        req.setSealImage(sealPicBase64);
        String createSerialNo = "";
        req.setCreateSerialNo(createSerialNo);
        try {
            ResponseData responseData = this.isDevLocalEnv ? FddSealMock.createSealByImage((BaseReq)req, openApiClient) : DealUtil.execute("createSealByImage", req, () -> sealClient.createSealByImage(req), openApiClient);
            if (responseData.isFail()) {
                return responseData;
            }
            BaseRes res = (BaseRes)responseData.getData();
            Long verifyId = ((CreateSealByImageRes)res.getData()).getVerifyId();
            String callBackKey = CallBackUtil.getSealCreateCallBackKey(verifyId, createSerialNo);
            responseData.setCallBackKey(callBackKey);
            responseData.setCallBackKeyDetail("verifyId=" + verifyId + " createSerialNo=" + createSerialNo);
            if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
                String callBackKeyDetail = responseData.getCallBackKeyDetail();
                CallBackUtil.insert(callBackKey, callBackKeyDetail, sealInfo.getRelDataId());
            }
            return responseData;
        }
        catch (Exception e) {
            ResponseData<BaseRes<CreateSealByImageRes>> responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u5370\u7ae0\u65b0\u589e\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddCorporateSealCUD_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd createSealByImage execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    private ResponseData<BaseRes<CreateLegalRepresentativeSealByImageRes>> createLegalRepresentativeSealByImage(SealInfo sealInfo, String sealPicBase64, OpenApiClient openApiClient, SealClient sealClient) {
        CreateLegalRepresentativeSealByImageReq req = new CreateLegalRepresentativeSealByImageReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        req.setOpenCorpId(sealInfo.getOpenCorpId());
        long currUserId = RequestContext.get().getCurrUserId();
        req.setOpenUserId(String.valueOf(currUserId));
        req.setSealName(sealInfo.getSealName());
        req.setSealImage(sealPicBase64);
        String createSerialNo = "";
        req.setCreateSerialNo(createSerialNo);
        req.setOpenUserId(String.valueOf(RequestContext.getOrCreate().getCurrUserId()));
        try {
            ResponseData responseData = this.isDevLocalEnv ? FddSealMock.createLegalRepresentativeSealByImage((BaseReq)req, openApiClient) : DealUtil.execute("createLegalRepresentativeSealByImage", req, () -> sealClient.createLegalRepresentativeSealByImage(req), openApiClient);
            if (responseData.isFail()) {
                return responseData;
            }
            BaseRes res = (BaseRes)responseData.getData();
            if (!ObjectUtils.isEmpty((Object)res)) {
                CreateLegalRepresentativeSealByImageRes data = (CreateLegalRepresentativeSealByImageRes)res.getData();
                Long verifyId = data.getVerifyId();
                String callBackKey = HRMD5Util.getMD5String((String)(createSerialNo + verifyId));
                return ResponseData.success(res, callBackKey, "verifyId=" + verifyId + " createSerialNo=" + createSerialNo);
            }
            return responseData;
        }
        catch (Exception e) {
            ResponseData<BaseRes<CreateLegalRepresentativeSealByImageRes>> responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u5370\u7ae0\u65b0\u589e\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddCorporateSealCUD_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd createLegalRepresentativeSealByImage execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    @Override
    public ResponseData deleteSeal(SealInfo sealInfo) {
        OpenApiClient openApiClient = this.getOpenApiClient();
        SealClient sealClient = this.getSealClient(openApiClient);
        SealDeleteReq req = new SealDeleteReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        req.setOpenCorpId(sealInfo.getOpenCorpId());
        req.setSealId(sealInfo.getSealId());
        try {
            if (this.isDevLocalEnv) {
                return FddSealMock.deleteSeal((BaseReq)req, openApiClient);
            }
            return DealUtil.execute("deleteSeal", req, () -> sealClient.deleteSeal(req), openApiClient);
        }
        catch (Exception e) {
            ResponseData responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u5370\u7ae0\u5220\u9664\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddCorporateSealCUD_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd deleteSeal execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    @Override
    public ResponseData setSealStatus(SealInfo sealInfo) {
        OpenApiClient openApiClient = this.getOpenApiClient();
        SealClient sealClient = this.getSealClient(openApiClient);
        SetSealStatusReq req = new SetSealStatusReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        req.setOpenCorpId(sealInfo.getOpenCorpId());
        req.setSealId(sealInfo.getSealId());
        req.setSealStatus(sealInfo.getSealStatus());
        try {
            if (this.isDevLocalEnv) {
                return FddSealMock.setSealStatus((BaseReq)req, openApiClient);
            }
            return DealUtil.execute("setSealStatus", req, () -> sealClient.setSealStatus(req), openApiClient);
        }
        catch (Exception e) {
            ResponseData responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u5370\u7ae0\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddCorporateSealCUD_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd setSealStatus execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    @Override
    public ResponseData modifySeal(SealInfo sealInfo) {
        OpenApiClient openApiClient = this.getOpenApiClient();
        SealClient sealClient = this.getSealClient(openApiClient);
        ModifySealReq req = new ModifySealReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        req.setOpenCorpId(sealInfo.getOpenCorpId());
        req.setSealId(sealInfo.getSealId());
        req.setSealName(sealInfo.getSealName());
        try {
            if (this.isDevLocalEnv) {
                return FddSealMock.modifySeal((BaseReq)req, openApiClient);
            }
            return DealUtil.execute("modifySeal", req, () -> sealClient.modifySeal(req), openApiClient);
        }
        catch (Exception e) {
            ResponseData responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u5370\u7ae0\u4fee\u6539\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddCorporateSealCUD_4.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd modifySeal execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }
}

