/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealQuery;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.bo.SealAuthInfo;
import kd.hr.hrcs.bussiness.service.esign.bo.SealInfo;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddServiceHelper;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.SealStatusMappingEnum;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.SealTypeMappingEnum;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.mock.FddSealMock;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.DealUtil;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.SealUtil;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOSealMgrUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseReq;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SealClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.GetSealDetailReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.GetSealFreeSignUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.GetSealListReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.seal.FreeSignInfo;
import kd.hr.hrcs.esign3rd.fadada.v51.res.seal.GetListSealInfo;
import kd.hr.hrcs.esign3rd.fadada.v51.res.seal.GetSealListRes;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class FddCorporateSealQuery
extends FddBaseService<FddConfig>
implements CorporateSealQuery {
    private static final Log LOGGER = LogFactory.getLog(FddCorporateSealQuery.class);
    public static final Pattern URL_PATTERN = Pattern.compile("([hH][tT]{2}[pP]://|[hH][tT]{2}[pP][sS]://|[wW]{3}.|[wW][aA][pP].|[fF][tT][pP].|[fF][iI][lL][eE].)[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]");

    private SealClient getSealClient(OpenApiClient openApiClient) {
        return new SealClient(openApiClient);
    }

    @Override
    public ResponseData getSealList(String sealType, String openCorpId) {
        ResponseData responseData;
        OpenApiClient openApiClient = this.getOpenApiClient();
        SealClient sealClient = this.getSealClient(openApiClient);
        GetSealListReq req = new GetSealListReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        req.setOpenCorpId(openCorpId);
        if (StringUtils.isNotBlank((CharSequence)sealType)) {
            GetSealListReq.SealListFilter filter = new GetSealListReq.SealListFilter();
            filter.setCategoryType((List)ImmutableList.of((Object)SealTypeMappingEnum.findFddSealTypeEnum(sealType).getCategoryType()));
            req.setListFilter(filter);
        }
        try {
            responseData = this.isDevLocalEnv ? FddSealMock.getSealList((BaseReq)req, openApiClient) : DealUtil.execute("getSealList", req, () -> sealClient.getSealList(req), openApiClient);
            if (responseData.isFail()) {
                return responseData;
            }
        }
        catch (Exception e) {
            responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u67e5\u8be2\u5370\u7ae0\u5217\u8868\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd getSealList execution occurred exception", (Object)e.getMessage(), (Object)e);
        }
        return responseData;
    }

    @Override
    public boolean synData(ResponseData sealListResponseData, Long spId, Long corporateId, Long eSignAppId, Long mainCorporateId, String openCorpId) {
        BaseRes res = (BaseRes)sealListResponseData.getData();
        GetSealListRes data = (GetSealListRes)res.getData();
        if (ObjectUtils.isEmpty((Object)data)) {
            return true;
        }
        List sealInfos = data.getSealInfos();
        if (CollectionUtils.isEmpty((Collection)sealInfos)) {
            return true;
        }
        Map<String, DynamicObject> allSealTypeMap = this.buildAllSealTypeMap(spId, corporateId);
        HashSet<String> addDynSet = new HashSet<String>(6);
        Map<String, GetListSealInfo> targetDataMap = this.buildDealInfo(sealInfos, allSealTypeMap, addDynSet);
        ArrayList<DynamicObject> addDyns = new ArrayList<DynamicObject>(6);
        ArrayList<DynamicObject> updDyns = new ArrayList<DynamicObject>(6);
        ArrayList<DynamicObject> authSealAddDyns = new ArrayList<DynamicObject>(6);
        ArrayList<DynamicObject> authSealUpdDyns = new ArrayList<DynamicObject>(6);
        if (MapUtils.isNotEmpty(targetDataMap)) {
            String businessId = this.getBusinessId();
            Map<String, DynamicObject> dbFreeSignInfos = ESignCOSealMgrUtil.getAuthAllSeals(spId, corporateId, mainCorporateId, openCorpId, businessId);
            boolean isExistAuthedSeals = false;
            Set<Object> dbFreeSignInfoKeys = new HashSet(0);
            if (MapUtils.isNotEmpty(dbFreeSignInfos)) {
                isExistAuthedSeals = true;
                dbFreeSignInfoKeys = dbFreeSignInfos.keySet();
            }
            long currUserId = RequestContext.get().getCurrUserId();
            for (Map.Entry<String, GetListSealInfo> sealInfoEntry : targetDataMap.entrySet()) {
                List matchFreeSignInfos;
                DynamicObject sealDyn;
                GetListSealInfo sealInfo = sealInfoEntry.getValue();
                if (addDynSet.contains(sealInfoEntry.getKey())) {
                    sealDyn = this.buildAddDyn(spId, eSignAppId, corporateId, sealInfo);
                    addDyns.add(sealDyn);
                } else {
                    sealDyn = allSealTypeMap.get(SealTypeMappingEnum.tranSealType(sealInfo.getCategoryType()));
                    if (ObjectUtils.isEmpty((Object)sealDyn)) continue;
                    this.buildUpdDyn(sealDyn, sealInfo);
                    updDyns.add(sealDyn);
                }
                HashSet<String> dealedFreeSignInfoKeys = new HashSet<String>(8);
                List freeSignInfos = sealInfo.getFreeSignInfos();
                if (CollectionUtils.isNotEmpty((Collection)freeSignInfos) && CollectionUtils.isNotEmpty(matchFreeSignInfos = freeSignInfos.stream().filter(item -> businessId.equals(item.getBusinessId())).collect(Collectors.toList()))) {
                    for (FreeSignInfo matchFreeSignInfo : matchFreeSignInfos) {
                        Long expiresTime = Long.valueOf(matchFreeSignInfo.getExpiresTime());
                        Date endTime = HRDateTimeUtils.convertDate((Long)expiresTime);
                        Date startTime = HRDateTimeUtils.convertBefore365DayDate((Long)expiresTime);
                        if (isExistAuthedSeals) {
                            String freeSignInfoKey = ESignCOSealMgrUtil.buildFreeSignInfoKey(openCorpId, String.valueOf(sealInfo.getSealId()), businessId);
                            if (dbFreeSignInfoKeys.contains(freeSignInfoKey)) {
                                dealedFreeSignInfoKeys.add(freeSignInfoKey);
                                DynamicObject authSealUpdDyn = dbFreeSignInfos.get(freeSignInfoKey);
                                authSealUpdDyn.set("starttime", (Object)startTime);
                                authSealUpdDyn.set("endtime", (Object)endTime);
                                authSealUpdDyn.set("authstatus", (Object)"1");
                                authSealUpdDyns.add(authSealUpdDyn);
                                continue;
                            }
                            DynamicObject authSealDyn = this.buildAuthSealAddDyn(spId, mainCorporateId, sealDyn.getLong("id"), startTime, endTime, currUserId);
                            authSealAddDyns.add(authSealDyn);
                            continue;
                        }
                        DynamicObject authSealDyn = this.buildAuthSealAddDyn(spId, mainCorporateId, sealDyn.getLong("id"), startTime, endTime, currUserId);
                        authSealAddDyns.add(authSealDyn);
                    }
                }
                LOGGER.info("dbFreeSignInfoKeys:{} dealedFreeSignInfoKeys:{}", dbFreeSignInfoKeys, dealedFreeSignInfoKeys);
                dbFreeSignInfoKeys.removeAll(dealedFreeSignInfoKeys);
            }
            if (CollectionUtils.isNotEmpty(dbFreeSignInfoKeys)) {
                LOGGER.info("\u5df2\u53d6\u6d88\u6388\u6743\u7684\u5370\u7ae0\u4fe1\u606f\uff1a{}", dbFreeSignInfoKeys);
                DynamicObject[] authSealCancelDyns = new DynamicObject[dbFreeSignInfoKeys.size()];
                int i = 0;
                Set<Map.Entry<String, DynamicObject>> entries = dbFreeSignInfos.entrySet();
                for (Map.Entry<String, DynamicObject> entry : entries) {
                    if (!dbFreeSignInfoKeys.contains(entry.getKey())) continue;
                    DynamicObject authSealCancelDyn = entry.getValue();
                    authSealCancelDyn.set("authstatus", (Object)"2");
                    authSealCancelDyns[i] = authSealCancelDyn;
                    ++i;
                }
                ESignDBServiceUtil.eSignCOAuthService.update(authSealCancelDyns);
            }
        }
        if (CollectionUtils.isNotEmpty(addDyns)) {
            LOGGER.info("\u65b0\u589e\u5370\u7ae0\u4fe1\u606f\uff1a{}", addDyns.stream().map(item -> item.get("sealid")).collect(Collectors.toSet()));
            ESignDBServiceUtil.eSignCOSealService.save(addDyns.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(updDyns)) {
            LOGGER.info("\u66f4\u65b0\u5370\u7ae0\u4fe1\u606f\uff1a{}", updDyns.stream().map(item -> item.get("sealid")).collect(Collectors.toSet()));
            ESignDBServiceUtil.eSignCOSealService.update(updDyns.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(authSealAddDyns)) {
            LOGGER.info("\u65b0\u589e\u6388\u6743\u7684\u5370\u7ae0\u4fe1\u606f\uff1a{}", authSealAddDyns.stream().map(item -> item.get("seal.sealid")).collect(Collectors.toSet()));
            ESignDBServiceUtil.eSignCOAuthService.save(authSealAddDyns.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(authSealUpdDyns)) {
            LOGGER.info("\u66f4\u65b0\u6388\u6743\u7684\u5370\u7ae0\u4fe1\u606f\uff1a{}", authSealUpdDyns.stream().map(item -> item.get("seal.sealid")).collect(Collectors.toSet()));
            ESignDBServiceUtil.eSignCOAuthService.update(authSealUpdDyns.toArray(new DynamicObject[0]));
        }
        return true;
    }

    private Map<String, GetListSealInfo> buildDealInfo(List<GetListSealInfo> sealInfos, Map<String, DynamicObject> allSealTypeMap, Set<String> addDynSet) {
        HashSet<String> dealedSealType = new HashSet<String>(6);
        HashMap<String, GetListSealInfo> targetDataMap = new HashMap<String, GetListSealInfo>(6);
        for (GetListSealInfo sealInfo : sealInfos) {
            String sealType = SealTypeMappingEnum.tranSealType(sealInfo.getCategoryType());
            if (dealedSealType.contains(sealType)) continue;
            String sealStatus = SealStatusMappingEnum.tranSealStatus(sealInfo.getSealStatus());
            Long sealId = sealInfo.getSealId();
            DynamicObject dbSealInfo = allSealTypeMap.get(sealType);
            if (ObjectUtils.isEmpty((Object)dbSealInfo)) {
                if ("2".equals(sealStatus)) continue;
                GetListSealInfo targetSealInfo = (GetListSealInfo)targetDataMap.get(sealType);
                if (ObjectUtils.isEmpty((Object)targetSealInfo)) {
                    targetDataMap.put(sealType, sealInfo);
                    addDynSet.add(sealType);
                    continue;
                }
                List freeSignInfos = sealInfo.getFreeSignInfos();
                if (!CollectionUtils.isNotEmpty((Collection)freeSignInfos)) continue;
                String businessId = this.getBusinessId();
                Optional<FreeSignInfo> findData = freeSignInfos.stream().filter(item -> businessId.equals(item.getBusinessId())).findFirst();
                if (!findData.isPresent()) continue;
                targetDataMap.put(sealType, sealInfo);
                dealedSealType.add(sealType);
                continue;
            }
            if (!String.valueOf(sealId).equals(dbSealInfo.getString("sealid"))) continue;
            targetDataMap.put(sealType, sealInfo);
            dealedSealType.add(sealType);
        }
        return targetDataMap;
    }

    private Map<String, DynamicObject> buildAllSealTypeMap(Long spId, Long corporateId) {
        Object[] allSeals = ESignCOSealMgrUtil.queryAllSeal(spId, corporateId);
        HashMap<String, DynamicObject> allSealTypeMap = new HashMap<String, DynamicObject>(6);
        for (String sealType : SealTypeMappingEnum.getAllSealTypes()) {
            allSealTypeMap.put(sealType, null);
        }
        if (ArrayUtils.isNotEmpty((Object[])allSeals)) {
            for (Object seal : allSeals) {
                String sealType = seal.getString("sealtype.orinumber");
                String sealSort = seal.getString("sealsortradiogrp");
                if ("larseal".equals(sealSort)) {
                    sealType = "1060_S";
                }
                allSealTypeMap.put(sealType, (DynamicObject)seal);
            }
        }
        return allSealTypeMap;
    }

    private DynamicObject buildAddDyn(Long spId, Long eSignAppId, Long corporateId, GetListSealInfo sealInfo) {
        DynamicObject dyn = ESignDBServiceUtil.eSignCOSealService.generateEmptyDynamicObject();
        String sealId = String.valueOf(sealInfo.getSealId());
        dyn.set("id", (Object)ORM.create().genLongId("hrcs_esigncoseal"));
        dyn.set("number", (Object)sealId);
        dyn.set("name", (Object)sealInfo.getSealName());
        dyn.set("esignsp", (Object)spId);
        dyn.set("corporate", (Object)corporateId);
        dyn.set("esignapp", (Object)eSignAppId);
        String sealType = SealTypeMappingEnum.tranSealType(sealInfo.getCategoryType());
        if ("1060_S".equals(sealType)) {
            dyn.set("sealsortradiogrp", (Object)"larseal");
        } else {
            dyn.set("sealsortradiogrp", (Object)"coseal");
        }
        dyn.set("sealtype", (Object)SealTypeMappingEnum.getSealTypeId(sealType));
        dyn.set("sealid", (Object)String.valueOf(sealId));
        dyn.set("sealsource", (Object)"synfromsp");
        String picFileUrl = ESignCOSealMgrUtil.uploadUrl(sealInfo.getPicFileUrl());
        if (StringUtils.isNotBlank((CharSequence)picFileUrl)) {
            dyn.set("sealpic", (Object)picFileUrl);
        }
        dyn.set("enable", (Object)SealStatusMappingEnum.tranSealStatus(sealInfo.getSealStatus()));
        dyn.set("status", (Object)"C");
        dyn.set("thirdauditstatus", (Object)"1");
        return dyn;
    }

    private void buildUpdDyn(DynamicObject sealDyn, GetListSealInfo sealInfo) {
        String picFileUrl;
        sealDyn.set("name", (Object)sealInfo.getSealName());
        String sealPic = sealDyn.getString("sealpic");
        if (StringUtils.isBlank((CharSequence)sealPic) && StringUtils.isNotBlank((CharSequence)(picFileUrl = ESignCOSealMgrUtil.uploadUrl(sealInfo.getPicFileUrl())))) {
            sealDyn.set("sealpic", (Object)picFileUrl);
        }
        sealDyn.set("enable", (Object)SealStatusMappingEnum.tranSealStatus(sealInfo.getSealStatus()));
        sealDyn.set("thirdauditstatus", (Object)"1");
    }

    private DynamicObject buildAuthSealAddDyn(Long spId, Long mainCorporateId, Long eSignSealId, Date startTime, Date endTime, long currUserId) {
        DynamicObject dyn = ESignDBServiceUtil.eSignSealAuthService.generateEmptyDynamicObject();
        dyn.set("esignsp", (Object)spId);
        dyn.set("authcompany", (Object)mainCorporateId);
        dyn.set("seal", (Object)eSignSealId);
        dyn.set("auttype", (Object)"1");
        dyn.set("authrange", (Object)"1");
        dyn.set("authstatus", (Object)"1");
        dyn.set("starttime", (Object)startTime);
        dyn.set("endtime", (Object)endTime);
        dyn.set("enable", (Object)"1");
        dyn.set("status", (Object)"C");
        dyn.set("creator", (Object)currUserId);
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        return dyn;
    }

    @Override
    public ResponseData getSealDetail(SealInfo sealInfo) {
        OpenApiClient openApiClient = this.getOpenApiClient();
        SealClient sealClient = this.getSealClient(openApiClient);
        GetSealDetailReq req = new GetSealDetailReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        req.setOpenCorpId(sealInfo.getOpenCorpId());
        req.setSealId(sealInfo.getSealId());
        try {
            if (this.isDevLocalEnv) {
                return FddSealMock.getSealDetail((BaseReq)req, openApiClient);
            }
            return DealUtil.execute("getSealDetail", req, () -> sealClient.getSealDetail(req), openApiClient);
        }
        catch (Exception e) {
            ResponseData responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u67e5\u8be2\u5370\u7ae0\u660e\u7ec6\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd getSealDetail execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    @Override
    public ResponseData check(ESignAppInfo eSignAppInfo) {
        BaseRes res;
        ResponseData<Object> checkResponseData;
        if (!URL_PATTERN.matcher(eSignAppInfo.getServerUrl()).matches()) {
            return ResponseData.invokeFail(String.format(ResManager.loadKDString((String)"ServerUrl=[%s]\u914d\u7f6e\u6709\u8bef\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), eSignAppInfo.getServerUrl()));
        }
        HashSet<Object> sealIds = new HashSet<Object>(1);
        sealIds.add(66668888L);
        SealAuthInfo sealAuthInfo = new SealAuthInfo(eSignAppInfo.getThirdCorpId(), sealIds);
        OpenApiClient openApiClient = this.getOpenApiClient();
        GetSealFreeSignUrlReq req = new GetSealFreeSignUrlReq();
        ResponseData accessTokenResp = FddServiceHelper.getAccessTokenResp(openApiClient);
        if (accessTokenResp.isFail() && (checkResponseData = FddCorporateSealQuery.checkResponseData(eSignAppInfo, res = (BaseRes)accessTokenResp.getData())).isFail()) {
            return checkResponseData;
        }
        req.setAccessToken(this.getAccessToken(openApiClient));
        String openCorpId = sealAuthInfo.getOpenCorpId();
        req.setOpenCorpId(openCorpId);
        List targetSealIds = sealIds.stream().map(item -> Long.parseLong(String.valueOf(item))).collect(Collectors.toList());
        req.setSealIds(targetSealIds);
        req.setBusinessId(this.getBusinessId());
        req.setClientUserId(sealAuthInfo.getClientUserId());
        ResponseData responseData = SealUtil.getSealFreeSignUrl(sealAuthInfo, openApiClient, req);
        if (responseData.isFail()) {
            BaseRes res2 = (BaseRes)responseData.getData();
            return FddCorporateSealQuery.checkResponseData(eSignAppInfo, res2);
        }
        return ResponseData.success();
    }

    private static ResponseData<Object> checkResponseData(ESignAppInfo eSignAppInfo, BaseRes res) {
        String errMsg = null;
        if (res == null) {
            errMsg = String.format(ResManager.loadKDString((String)"ServerUrl=[%s]\u914d\u7f6e\u6709\u8bef\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), eSignAppInfo.getServerUrl());
        } else if (Integer.valueOf("404").equals(res.getHttpStatusCode())) {
            errMsg = String.format(ResManager.loadKDString((String)"ServerUrl=[%s]\u914d\u7f6e\u6709\u8bef\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), eSignAppInfo.getServerUrl());
        } else if (Integer.valueOf("200").equals(res.getHttpStatusCode())) {
            String code = res.getCode();
            if ("100001".equals(code)) {
                errMsg = String.format(ResManager.loadKDString((String)"AppID=[%s]\u914d\u7f6e\u6709\u8bef\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_4.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), eSignAppInfo.getAppId());
            } else if ("100003".equals(code)) {
                errMsg = String.format(ResManager.loadKDString((String)"AppSecret\u4e3a\u201c%s\u201d\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_5.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), eSignAppInfo.getAppSecret());
            } else if ("215008".equals(code)) {
                errMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u4f01\u4e1aID\u201c%s\u201d\u914d\u7f6e\u6709\u8bef\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_6.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), eSignAppInfo.getThirdCorpId());
            } else if ("215015".equals(code) || "100011".equals(code)) {
                errMsg = String.format(ResManager.loadKDString((String)"BusinessId\u4e3a\u201c%s\u201d\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)HrcsBusinessRes.FddCorporateSealQuery_7.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), eSignAppInfo.getExtParam().get("businessId"));
            }
        }
        if (StringUtils.isBlank(errMsg)) {
            return ResponseData.success();
        }
        return ResponseData.invokeFail(errMsg);
    }

    @Override
    public Triple<List<DynamicObject>, Set<String>, List<DynamicObject>> checkCOSealAuth(ResponseData sealListResponseData, Long spId, Long corporateId, Long mainCorporateId, String openCorpId, Set<String> checkSealIds) {
        BaseRes res = (BaseRes)sealListResponseData.getData();
        GetSealListRes data = (GetSealListRes)res.getData();
        if (ObjectUtils.isEmpty((Object)data)) {
            return Triple.of(new ArrayList(0), new HashSet(0), new ArrayList(0));
        }
        List sealInfos = data.getSealInfos();
        if (CollectionUtils.isEmpty((Collection)sealInfos)) {
            return Triple.of(new ArrayList(0), new HashSet(0), new ArrayList(0));
        }
        return this.checkCOSealAuth(sealInfos, spId, corporateId, mainCorporateId, openCorpId, checkSealIds);
    }

    private Triple<List<DynamicObject>, Set<String>, List<DynamicObject>> checkCOSealAuth(List<GetListSealInfo> sealInfos, Long spId, Long corporateId, Long mainCorporateId, String openCorpId, Set<String> checkSealIds) {
        String businessId = this.getBusinessId();
        Map<String, DynamicObject> dbFreeSignInfos = ESignCOSealMgrUtil.getAuthSeals(spId, corporateId, mainCorporateId, openCorpId, businessId, checkSealIds);
        Set<Object> dbFreeSignInfoKeys = new HashSet(0);
        boolean isExistAuthedSeals = false;
        if (MapUtils.isNotEmpty(dbFreeSignInfos)) {
            isExistAuthedSeals = true;
            dbFreeSignInfoKeys = dbFreeSignInfos.keySet();
        }
        HashSet<String> checkErrSealIds = new HashSet<String>(8);
        ArrayList<DynamicObject> authSealUpdDateDyns = new ArrayList<DynamicObject>(6);
        HashSet<String> dealedFreeSignInfoKeys = new HashSet<String>(8);
        for (GetListSealInfo sealInfo : sealInfos) {
            List matchFreeSignInfos;
            String sealStatus = SealStatusMappingEnum.tranSealStatus(sealInfo.getSealStatus());
            String sealId = String.valueOf(sealInfo.getSealId());
            if (!checkSealIds.contains(sealId) || "2".equals(sealStatus)) continue;
            List freeSignInfos = sealInfo.getFreeSignInfos();
            if (CollectionUtils.isNotEmpty((Collection)freeSignInfos) && CollectionUtils.isNotEmpty(matchFreeSignInfos = freeSignInfos.stream().filter(item -> businessId.equals(item.getBusinessId())).collect(Collectors.toList()))) {
                for (FreeSignInfo matchFreeSignInfo : matchFreeSignInfos) {
                    String freeSignInfoKey;
                    Long expiresTime = Long.valueOf(matchFreeSignInfo.getExpiresTime());
                    Date startTime = HRDateTimeUtils.convertBefore365DayDate((Long)expiresTime);
                    Date endTime = HRDateTimeUtils.convertDate((Long)expiresTime);
                    if (!isExistAuthedSeals || !dbFreeSignInfoKeys.contains(freeSignInfoKey = ESignCOSealMgrUtil.buildFreeSignInfoKey(openCorpId, String.valueOf(sealInfo.getSealId()), businessId)) || endTime.getTime() - new Date().getTime() < 0L) continue;
                    dealedFreeSignInfoKeys.add(freeSignInfoKey);
                    checkErrSealIds.add(sealId);
                    DynamicObject authSealUpdDateDyn = dbFreeSignInfos.get(freeSignInfoKey);
                    authSealUpdDateDyn.set("starttime", (Object)startTime);
                    authSealUpdDateDyn.set("endtime", (Object)endTime);
                    authSealUpdDateDyn.set("authstatus", (Object)"1");
                    authSealUpdDateDyns.add(authSealUpdDateDyn);
                }
            }
            LOGGER.info("dbFreeSignInfoKeys:{} dealedFreeSignInfoKeys:{}", dbFreeSignInfoKeys, dealedFreeSignInfoKeys);
            dbFreeSignInfoKeys.removeAll(dealedFreeSignInfoKeys);
        }
        ArrayList<DynamicObject> authSealNonuseDyns = new ArrayList<DynamicObject>(6);
        if (CollectionUtils.isNotEmpty(dbFreeSignInfoKeys)) {
            LOGGER.info("\u5df2\u53d6\u6d88\u6388\u6743\u6216\u8005\u5df2\u8fc7\u671f\u7684\u5370\u7ae0\u4fe1\u606f\uff1a{}", dbFreeSignInfoKeys);
            Set<Map.Entry<String, DynamicObject>> entries = dbFreeSignInfos.entrySet();
            for (Map.Entry<String, DynamicObject> entry : entries) {
                if (!dbFreeSignInfoKeys.contains(entry.getKey())) continue;
                DynamicObject authSealNonuseDyn = entry.getValue();
                authSealNonuseDyn.set("authstatus", (Object)"0");
                authSealNonuseDyns.add(authSealNonuseDyn);
            }
        }
        return Triple.of(authSealUpdDateDyns, checkErrSealIds, authSealNonuseDyns);
    }
}

