/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.econtract.ContractView;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hrcs.bussiness.service.esign.SignFileService;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.DownLoadSignFile;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddServiceHelper;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.bean.common.OpenId;
import kd.hr.hrcs.esign3rd.fadada.stratey.JsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.utils.ResultUtil;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SignTaskClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.GetOwnerDownloadUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.OwnerDownloadUrlRes;

public class FddDownLoadSignFile
extends FddBaseService<FddConfig>
implements DownLoadSignFile {
    private static final Log logger = LogFactory.getLog(FddDownLoadSignFile.class);

    @Override
    public SignRespParam getPrevAndDown(SignReqParam signReqParam, String contractNo) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
        Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
        List<String> downloadUrl = this.getDownloadUrl(signFlowExtMap.get("signTaskId"), contractNo, this.getOwnerOpenCorpId(signReqParam));
        SignRespParam signRespParam = new SignRespParam(contractNo);
        ContractView contractView = new ContractView();
        contractView.setDownloadUrlList(downloadUrl);
        signRespParam.setSealInfo(contractView);
        return signRespParam;
    }

    private long getDocCount(String contractNo) {
        SignFileService signFileService = new SignFileService();
        DynamicObject signFile = signFileService.queryOneByNo(contractNo);
        Map<String, String> signFlowExtMap = signFileService.getExtMap(signFile);
        return signFlowExtMap.keySet().stream().filter(key -> key.contains("fileId")).count();
    }

    private List<String> getDownloadUrl(String signTaskId, String contractNo, String openCorpId) {
        ArrayList<String> downloadUrl = new ArrayList<String>(10);
        OpenApiClient openApiClient = this.getOpenApiClientByContractNo(contractNo);
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        long docCnt = this.getDocCount(contractNo);
        logger.info("getDownloadUrl docCnt={}", (Object)docCnt);
        int idx = 1;
        while ((long)idx <= docCnt) {
            String accessToken = FddServiceHelper.getAccessToken(openApiClient);
            GetOwnerDownloadUrlReq req = new GetOwnerDownloadUrlReq();
            req.setAccessToken(accessToken);
            req.setOwnerId(OpenId.getInstance((String)"corp", (String)openCorpId));
            req.setSignTaskId(signTaskId);
            req.setFileType("doc");
            req.setId(String.valueOf(idx));
            BaseRes res = signTaskClient.getOwnerDownloadUrl(req);
            ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
            if (!res.isSuccess()) {
                throw new KDBizException("get getHandSignUrl error, " + res.getMsg());
            }
            logger.info("getDownloadUrl downloadUrl idx ={}", (Object)idx);
            downloadUrl.add(((OwnerDownloadUrlRes)res.getData()).getDownloadUrl());
            ++idx;
        }
        return downloadUrl;
    }

    private String getOwnerOpenCorpId(SignReqParam signReqParam) {
        String spId = this.getConfig().getSpId();
        Long corporateId = signReqParam.getLawEntityId();
        logger.info("getOpenCorpId reqParams:spId={}  corporateId={}", (Object)spId, (Object)corporateId);
        return ESignAppCfgUtil.getOwnerOpenCorpId(Long.parseLong(spId), corporateId);
    }
}

