/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.ContractView;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.EContemplateService;
import kd.hr.hrcs.bussiness.service.econtract.EContractServiceHelper;
import kd.hr.hrcs.bussiness.service.esign.ESignConstants;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.InitiateSignTask;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddServiceHelper;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOSealMgrUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.bean.common.Actor;
import kd.hr.hrcs.esign3rd.fadada.bean.common.ActorCorpMember;
import kd.hr.hrcs.esign3rd.fadada.bean.common.Field;
import kd.hr.hrcs.esign3rd.fadada.bean.common.FieldPosition;
import kd.hr.hrcs.esign3rd.fadada.bean.common.Notification;
import kd.hr.hrcs.esign3rd.fadada.bean.common.OpenId;
import kd.hr.hrcs.esign3rd.fadada.stratey.JsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.utils.ResultUtil;
import kd.hr.hrcs.esign3rd.fadada.v51.client.DocClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SignTaskClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.doc.FddFileUrl;
import kd.hr.hrcs.esign3rd.fadada.v51.req.doc.FileProcessReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.doc.GetUploadUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.AddActorsInfo;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.AddDocInfo;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.AddSignConfigInfo;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.AddSignFieldInfo;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.BusinessSceneInfo;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.CreateSignTaskReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.GetOwnerDownloadUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.SignTaskActorGetUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.SignTaskBaseReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.SignTaskCancelReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.UnblockReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.doc.FileId;
import kd.hr.hrcs.esign3rd.fadada.v51.res.doc.FileProcessRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.doc.GetUploadUrlRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.CreateSignTaskRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.OwnerDownloadUrlRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.SignTaskActorGetUrlRes;

public class FddInitiateSignTask
extends FddBaseService<FddConfig>
implements InitiateSignTask {
    private static final Log logger = LogFactory.getLog(FddInitiateSignTask.class);

    @Override
    public boolean check(ESignAppInfo eSignAppInfo) {
        OpenApiClient openApiClient = this.getOpenApiClient();
        String accessToken = this.getAccessToken(openApiClient);
        return InitiateSignTask.super.check(eSignAppInfo);
    }

    @Override
    public HashMap<String, String> uploadDoc(SignReqParam signReqParam) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        DocClient docClient = new DocClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
            BaseRes<FileProcessRes> fileProcessRes;
            GetUploadUrlReq req = new GetUploadUrlReq();
            req.setAccessToken(accessToken);
            req.setFileType("doc");
            BaseRes uploadUrlRes = docClient.getUploadFileUrl(req);
            logger.info("uploadUrlRes");
            int index = i + 1;
            result.put("fddFileUrl" + index, ((GetUploadUrlRes)uploadUrlRes.getData()).getFddFileUrl());
            ResultUtil.printLog((BaseRes)uploadUrlRes, (JsonStrategy)openApiClient.getJsonStrategy());
            if (uploadUrlRes.isSuccess()) {
                this.updateFile2Url((String)signReqParam.getFilePathList().get(i), ((GetUploadUrlRes)uploadUrlRes.getData()).getUploadUrl());
                fileProcessRes = this.fileProcess(docClient, (String)signReqParam.getFileNameList().get(i), ((GetUploadUrlRes)uploadUrlRes.getData()).getFddFileUrl(), accessToken);
                ResultUtil.printLog(fileProcessRes, (JsonStrategy)openApiClient.getJsonStrategy());
                if (!fileProcessRes.isSuccess() || ((FileProcessRes)fileProcessRes.getData()).getFileIdList().size() <= 0) {
                    logger.error("uploadDoc error:{}", (Object)fileProcessRes.getMsg());
                    throw new KDBizException("upload doc file error : " + fileProcessRes.getMsg());
                }
            } else {
                logger.error("uploadDoc error:{}", (Object)uploadUrlRes.getMsg());
                throw new KDBizException("upload doc file exception");
            }
            result.put("fileId" + index, ((FileId)((FileProcessRes)fileProcessRes.getData()).getFileIdList().get(0)).getFileId());
        }
        return result;
    }

    private BaseRes<FileProcessRes> fileProcess(DocClient docClient, String fileName, String fadadaFileUrl, String accessToken) {
        FileProcessReq req = new FileProcessReq();
        req.setAccessToken(accessToken);
        ArrayList<FddFileUrl> list = new ArrayList<FddFileUrl>();
        FddFileUrl fddFileUrl = new FddFileUrl();
        fddFileUrl.setFileType("doc");
        fddFileUrl.setFddFileUrl(fadadaFileUrl);
        fddFileUrl.setFileName(fileName + ".pdf");
        list.add(fddFileUrl);
        req.setFddFileUrlList(list);
        return docClient.process(req);
    }

    private void updateFile2Url(String filePath, String fadadaUploadUrl) {
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int readByte;
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream ins = service.getInputStream(filePath);
            URL uploadUrl = new URL(fadadaUploadUrl);
            HttpURLConnection connection = (HttpURLConnection)uploadUrl.openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            bos = new BufferedOutputStream(connection.getOutputStream());
            bis = new BufferedInputStream(ins);
            while ((readByte = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(readByte);
                ((BufferedOutputStream)bos).flush();
            }
            bos.close();
            int responseCode = connection.getResponseCode();
            logger.info("responseCode:{},getResponseMessage: {} ", (Object)(responseCode + ":"), (Object)connection.getResponseMessage());
            if (responseCode != 200) {
                throw new KDBizException("uploadFile2Url error,responseCode:" + responseCode);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public HashMap<String, String> createSignFlow(SignReqParam signReqParam, HashMap<String, String> fileParams, SignRespParam signRespParam) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        DynamicObject contTplDyo = this.getDynamiTplDyo(signReqParam);
        String signType = contTplDyo.getString("signtype");
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        CreateSignTaskReq createSignTaskReq = new CreateSignTaskReq();
        createSignTaskReq.setAccessToken(accessToken);
        createSignTaskReq.setSignTaskSubject(signReqParam.getFileName());
        createSignTaskReq.setInitiator(OpenId.getInstance((String)"corp", (String)this.getOwnerOpenCorpId(signReqParam)));
        createSignTaskReq.setExpiresTime(null);
        createSignTaskReq.setAutoStart(Boolean.valueOf(true));
        createSignTaskReq.setAutoFillFinalize(Boolean.valueOf(true));
        createSignTaskReq.setSignInOrder(Boolean.valueOf(true));
        BusinessSceneInfo businessSceneInfo = new BusinessSceneInfo();
        if (this.isAutoSign(contTplDyo)) {
            businessSceneInfo.setBusinessId(this.getBusinessId());
            businessSceneInfo.setTransReferenceId(signReqParam.getContractNo());
            createSignTaskReq.setBusinessScene(businessSceneInfo);
        } else {
            createSignTaskReq.setBusinessScene(null);
        }
        createSignTaskReq.setCertCAOrg(null);
        ArrayList docs = Lists.newArrayListWithCapacity((int)16);
        for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
            int index = i + 1;
            docs.add(this.getDoc(signType, contTplDyo, signReqParam, fileParams, String.valueOf(i + 1), (String)signReqParam.getFileNameList().get(i), fileParams.get("fileId" + index)));
        }
        createSignTaskReq.setDocs((List)docs);
        List<AddActorsInfo> actors = this.getActors(signType, signReqParam, contTplDyo);
        createSignTaskReq.setActors(actors);
        BaseRes res = signTaskClient.create(createSignTaskReq);
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
        if (res.isSuccess()) {
            String signTaskId = ((CreateSignTaskRes)res.getData()).getSignTaskId();
            result.put("signTaskId", signTaskId);
            String signUrl = this.getPersonSignUrl(signType, signTaskId, signReqParam);
            if (!HRStringUtils.isEmpty((String)signUrl)) {
                result.put("personSignUrl", signUrl);
                signRespParam.setHandSignUrl(signUrl);
            }
        } else {
            throw new KDBizException("createSignFlow error," + res.getMsg());
        }
        return result;
    }

    private boolean isAutoSign(DynamicObject dynamicObject) {
        return "1".equals(dynamicObject.getString("sealway"));
    }

    private DynamicObject getDynamiTplDyo(SignReqParam signReqParam) {
        DynamicObject contTplDyo;
        if (this.longIsEmpty(signReqParam.getTemplateTypeId()) && this.longIsEmpty(signReqParam.getTemplateId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7f72\u914d\u7f6e\u548c\u7b7e\u7f72\u7c7b\u578b\u90fd\u4e3a\u7a7a", (String)"EContractSignApiService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (this.longIsEmpty(signReqParam.getTemplateTypeId())) {
            contTplDyo = EContemplateService.queryEContplInfo(signReqParam.getTemplateId());
        } else {
            DynamicObject econtemplatetype = EContractServiceHelper.getSignConfig(signReqParam.getTemplateTypeId());
            contTplDyo = EContemplateService.queryEContplInfo(econtemplatetype.getDynamicObject("template").getLong("id"));
        }
        return contTplDyo;
    }

    private boolean longIsEmpty(Long naturalId) {
        return naturalId == null || naturalId == 0L;
    }

    private List<AddActorsInfo> getActors(String signType, SignReqParam signReqParam, DynamicObject contTplDyo) {
        ArrayList<AddActorsInfo> addActors = new ArrayList<AddActorsInfo>();
        int order = 10;
        int orderStep = "1".equals(signReqParam.getSignMode()) ? -1 : 1;
        ArrayList<String> verifyMethods = null;
        if ("2".equals(signType) || "3".equals(signType)) {
            String actorId = "person";
            String actorType = "person";
            String actorName = signReqParam.getName();
            String[] permissions = new String[]{"sign"};
            String actorOpenId = null;
            String actorFDDId = null;
            String identNameForMatch = signReqParam.getName();
            String certNoForMatch = signReqParam.getIdentity();
            String accountName = signReqParam.getMobile();
            Notification notification = Notification.getInstance((boolean)false, (String)"mobile", (String)accountName);
            Actor person = this.getActor(actorId, actorType, actorName, permissions, actorOpenId, actorFDDId, null, identNameForMatch, certNoForMatch, notification);
            person.setAccountName(accountName);
            if ("1020".equals(signReqParam.getIdentityType())) {
                person.setCertType("passport");
            } else if ("1030".equals(signReqParam.getIdentityType())) {
                person.setCertType("hk_mac_rp");
            } else if ("1040".equals(signReqParam.getIdentityType())) {
                person.setCertType("taiwan_rp");
            } else if ("1070".equals(signReqParam.getIdentityType())) {
                person.setCertType("taiwan");
            } else if ("1060".equals(signReqParam.getIdentityType())) {
                person.setCertType("hk_macao");
            } else if ("1050".equals(signReqParam.getIdentityType())) {
                person.setCertType("foreign_prc");
            } else {
                person.setCertType("id_card");
            }
            person.setCertNoForMatch(signReqParam.getIdentity());
            ArrayList signFields = Lists.newArrayListWithCapacity((int)16);
            for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
                AddSignFieldInfo addSignFieldInfo = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "person", null, false);
                signFields.add(addSignFieldInfo);
                if (!contTplDyo.getBoolean("isshowdate")) continue;
                AddSignFieldInfo addSignFieldInfo2 = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "persondate", null, false);
                signFields.add(addSignFieldInfo2);
            }
            Boolean blockHere = false;
            Boolean requestVerifyFree = false;
            Boolean joinByLink = true;
            Boolean readingToEnd = contTplDyo.getBoolean("lastpageflag");
            Boolean readtimeflag = (Boolean)contTplDyo.get("readtimeflag");
            String readingTime = null;
            if (readtimeflag.booleanValue()) {
                String string = readingTime = contTplDyo.getString("readingtime").equals("0") ? null : contTplDyo.getString("readingtime");
            }
            if (!HRStringUtils.isEmpty((String)contTplDyo.getString("signidea"))) {
                String[] split = contTplDyo.getString("signidea").split(",");
                verifyMethods = new ArrayList<String>(Arrays.asList(split));
                verifyMethods.removeIf(method -> HRStringUtils.equals((String)"", (String)method));
            }
            AddSignConfigInfo signConfigInfo = this.getAddSignConfigInfo(order++, blockHere, requestVerifyFree, this.getSignerSignMethod(contTplDyo), true, verifyMethods, joinByLink, readingToEnd, readingTime, false);
            AddActorsInfo addPerson = new AddActorsInfo();
            addPerson.setActor(person);
            addPerson.setSignFields((List)signFields);
            addPerson.setSignConfigInfo(signConfigInfo);
            addActors.add(addPerson);
        }
        if ("1".equals(signType) || "3".equals(signType)) {
            ArrayList actorCorpMembers = new ArrayList();
            Notification corpNotification = null;
            String corpName = this.getCorpName(signReqParam);
            String openCorpId = this.getOwnerOpenCorpId(signReqParam);
            Actor corp = this.getActor("corp", "corp", corpName, new String[]{"sign"}, openCorpId, null, actorCorpMembers.toArray(new ActorCorpMember[actorCorpMembers.size()]), null, null, corpNotification);
            ArrayList signFields1 = Lists.newArrayListWithCapacity((int)16);
            for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
                AddSignFieldInfo addSignFieldInfo2;
                Long corpSealId = this.getAutoSignSealId(signReqParam, contTplDyo, contTplDyo.getLong("sealtypeid.id"));
                AddSignFieldInfo addSignFieldInfo1 = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "corp", corpSealId, false);
                signFields1.add(addSignFieldInfo1);
                if (contTplDyo.getBoolean("acrosspagesign")) {
                    addSignFieldInfo2 = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "corpacross", corpSealId, false);
                    signFields1.add(addSignFieldInfo2);
                }
                if (contTplDyo.getBoolean("corporateseal")) {
                    addSignFieldInfo2 = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "legal", this.getAutoSignSealId(signReqParam, contTplDyo, ESignConstants.SEAL_TYPE_ID_LEGAL), false);
                    signFields1.add(addSignFieldInfo2);
                }
                if (!contTplDyo.getBoolean("isshowdate")) continue;
                addSignFieldInfo2 = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "cropdate", null, false);
                signFields1.add(addSignFieldInfo2);
            }
            AddSignConfigInfo signConfigInfo1 = this.getAddSignConfigInfo(order + orderStep, true, this.isAutoSign(contTplDyo), "unlimited", false, verifyMethods, true, false, null, false);
            AddActorsInfo addCorp = new AddActorsInfo();
            addCorp.setActor(corp);
            addCorp.setSignFields((List)signFields1);
            addCorp.setSignConfigInfo(signConfigInfo1);
            addActors.add(addCorp);
        }
        return addActors;
    }

    private String getOwnerOpenCorpId(SignReqParam signReqParam) {
        String spId = this.getConfig().getSpId();
        Long corporateId = signReqParam.getLawEntityId();
        logger.info("getOpenCorpId reqParams:spId={}  corporateId={}", (Object)spId, (Object)corporateId);
        return ESignAppCfgUtil.getOwnerOpenCorpId(Long.parseLong(spId), corporateId);
    }

    private String getSignerSignMethod(DynamicObject contTplDyo) {
        String signWay = contTplDyo.getString("personsignway");
        if (!HRStringUtils.isEmpty((String)signWay)) {
            if (signWay.contains("4")) {
                return "unlimited";
            }
            if (signWay.contains("1")) {
                return "hand_write";
            }
            if (signWay.contains("2")) {
                return "standard";
            }
            if (signWay.contains("3")) {
                return "ai_hand_write";
            }
        }
        return "unlimited";
    }

    private String getCorpName(SignReqParam signReqParam) {
        String result = null;
        if (signReqParam.getLawEntityId() != null && signReqParam.getLawEntityId() != 0L) {
            HRBaseServiceHelper lawHelper = new HRBaseServiceHelper("hbss_lawentity");
            DynamicObject dynObj = lawHelper.queryOne((Object)signReqParam.getLawEntityId());
            return dynObj.getString("name");
        }
        return result;
    }

    private Long getAutoSignSealId(SignReqParam signReqParam, DynamicObject contTplDyo, Long sealTypeId) {
        block5: {
            if (!this.isAutoSign(contTplDyo)) {
                return null;
            }
            String signType = contTplDyo.getString("signtype");
            if ("1".equals(signType) || "3".equals(signType)) {
                logger.info("getAutoSignSealId spid={},LawEntityId={},sealtypeid={}", new Object[]{this.getConfig().getSpId(), signReqParam.getLawEntityId(), sealTypeId});
                try {
                    DynamicObject sealDyn = ESignCOSealMgrUtil.querySealBySealType((Object)Long.parseLong(this.getConfig().getSpId()), (Object)signReqParam.getLawEntityId(), sealTypeId);
                    if (sealDyn != null) {
                        return sealDyn.getLong("sealid");
                    }
                }
                catch (Exception exp) {
                    if (!this.isAutoSign(contTplDyo)) break block5;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%1$s\u7684%2$s\uff0c\u8bf7\u786e\u8ba4\u7cfb\u7edf\u4e2d\u662f\u5426\u5df2\u7ef4\u62a4/\u540c\u6b65\u7535\u5b50\u5370\u7ae0\u3002", (String)"FddInitiateSignTask_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getCorpName(signReqParam), this.getSealTypeName(sealTypeId)));
                }
            }
        }
        return null;
    }

    private String getSealTypeName(Long sealTypeId) {
        DynamicObject dynamicObject;
        if (sealTypeId != null && (dynamicObject = ESignDBServiceUtil.hrSealType.queryOne((Object)sealTypeId)) != null) {
            return dynamicObject.getString("name");
        }
        return null;
    }

    private AddSignConfigInfo getAddSignConfigInfo(int orderNo, boolean blockHere, boolean requestVerifyFree, String signerSignMethod, Boolean identifiedView, List<String> verifyMethods, Boolean joinByLink, Boolean readingToEnd, String readingTime, Boolean requestMemberSign) {
        AddSignConfigInfo addSignConfigInfo = new AddSignConfigInfo();
        addSignConfigInfo.setVerifyMethods(verifyMethods);
        addSignConfigInfo.setJoinByLink(joinByLink);
        addSignConfigInfo.setReadingToEnd(readingToEnd);
        addSignConfigInfo.setReadingTime(readingTime);
        addSignConfigInfo.setOrderNo(Integer.valueOf(orderNo));
        addSignConfigInfo.setBlockHere(Boolean.valueOf(blockHere));
        addSignConfigInfo.setRequestVerifyFree(Boolean.valueOf(requestVerifyFree));
        addSignConfigInfo.setSignerSignMethod(signerSignMethod);
        addSignConfigInfo.setIdentifiedView(identifiedView);
        addSignConfigInfo.setRequestMemberSign(requestMemberSign);
        return addSignConfigInfo;
    }

    private AddSignFieldInfo getAddSignFieldInfo(String fieldDocId, String fieldId, String fieldName, Long sealId, Boolean moveable) {
        AddSignFieldInfo addSignFieldInfo = new AddSignFieldInfo();
        addSignFieldInfo.setFieldDocId(fieldDocId);
        addSignFieldInfo.setFieldId(fieldId);
        addSignFieldInfo.setFieldName(fieldName);
        addSignFieldInfo.setSealId(sealId);
        addSignFieldInfo.setMoveable(moveable);
        return addSignFieldInfo;
    }

    private Actor getActor(String actorId, String actorType, String actorName, String[] permissions, String actorOpenId, String actorFDDId, ActorCorpMember[] actorCorpMembers, String identNameForMatch, String certNoForMatch, Notification notification) {
        Actor actor = new Actor();
        actor.setActorId(actorId);
        actor.setActorType(actorType);
        actor.setActorName(actorName);
        if (permissions != null) {
            actor.setPermissions(Arrays.asList(permissions));
        }
        actor.setActorOpenId(actorOpenId);
        actor.setActorFDDId(actorFDDId);
        if (actorCorpMembers != null) {
            actor.setActorCorpMembers(Arrays.asList(actorCorpMembers));
        }
        actor.setIdentNameForMatch(identNameForMatch);
        actor.setCertNoForMatch(certNoForMatch);
        actor.setNotification(notification);
        return actor;
    }

    private AddDocInfo getDoc(String signType, DynamicObject contTplDyo, SignReqParam signReqParam, HashMap<String, String> fileParams, String docId, String fileName, String docFileId) {
        AddDocInfo docInfo = new AddDocInfo();
        docInfo.setDocId(docId);
        docInfo.setDocName(fileName);
        docInfo.setDocFileId(docFileId);
        docInfo.setDocFields(this.fields(signType, contTplDyo, signReqParam, docId));
        return docInfo;
    }

    private List<Field> fields(String signType, DynamicObject contTplDyo, SignReqParam signReqParam, String docId) {
        Field field1;
        ArrayList<Field> docFields = new ArrayList<Field>();
        if ("2".equals(signType) || "3".equals(signType)) {
            field1 = new Field();
            field1.setFieldId("person" + docId);
            field1.setFieldName("person");
            field1.setFieldType("person_sign");
            field1.setPosition(this.getFieldPosition("keyword", null, "100", "100", contTplDyo.getString("keyworddouble")));
            field1.getPosition().setKeywordOffsetX(contTplDyo.getString("offsetxdouble"));
            field1.getPosition().setKeywordOffsetY(contTplDyo.getString("offsetydouble"));
            docFields.add(field1);
            if (contTplDyo.getBoolean("isshowdate")) {
                Field field2 = new Field();
                field2.setFieldId("persondate" + docId);
                field2.setFieldName("persondate");
                field2.setFieldType("date_sign");
                field2.setPosition(this.getFieldPosition("keyword", null, "0", "0", contTplDyo.getString("keyworddouble")));
                field2.getPosition().setKeywordOffsetX(contTplDyo.getString("offsetxdouble"));
                field2.getPosition().setKeywordOffsetY("60");
                docFields.add(field2);
            }
        }
        if ("1".equals(signType) || "3".equals(signType)) {
            Field field2;
            field1 = new Field();
            field1.setFieldId("corp" + docId);
            field1.setFieldName("corp");
            String positionMode = "keyword";
            field1.setFieldType("corp_seal");
            field1.setPosition(this.getFieldPosition("keyword", null, "0", "100", contTplDyo.getString("keyword")));
            field1.getPosition().setKeywordOffsetX(contTplDyo.getString("offsetx"));
            field1.getPosition().setKeywordOffsetY(contTplDyo.getString("offsety"));
            docFields.add(field1);
            if (contTplDyo.getBoolean("acrosspagesign")) {
                field2 = new Field();
                field2.setFieldId("corpacross" + docId);
                field2.setFieldName("corpacross");
                field2.setFieldType("corp_seal_cross_page");
                field2.setPosition(this.getFieldPosition("pixel", null, "0", "100", contTplDyo.getString("legalsealkey")));
                docFields.add(field2);
            }
            if (contTplDyo.getBoolean("corporateseal")) {
                field2 = new Field();
                field2.setFieldId("legal" + docId);
                field2.setFieldName("legal");
                field2.setFieldType("corp_seal");
                field2.setPosition(this.getFieldPosition("keyword", null, "0", "0", contTplDyo.getString("legalsealkey")));
                field2.getPosition().setKeywordOffsetX(contTplDyo.getString("offsetx"));
                field2.getPosition().setKeywordOffsetY(contTplDyo.getString("offsety"));
                docFields.add(field2);
            }
            if (contTplDyo.getBoolean("isshowdate")) {
                field2 = new Field();
                field2.setFieldId("cropdate" + docId);
                field2.setFieldName("cropdate");
                field2.setFieldType("date_sign");
                field2.setPosition(this.getFieldPosition("keyword", null, "0", "0", contTplDyo.getString("keyword")));
                field2.getPosition().setKeywordOffsetX(contTplDyo.getString("offsetx"));
                field2.getPosition().setKeywordOffsetY("110");
                docFields.add(field2);
            }
        }
        return docFields;
    }

    public FieldPosition getFieldPosition(String positionMode, Integer positionPageNo, String positionX, String postionY, String positionKeyword) {
        FieldPosition fieldPosition = new FieldPosition();
        fieldPosition.setPositionMode(positionMode);
        fieldPosition.setPositionPageNo(positionPageNo);
        fieldPosition.setPositionX(positionX);
        fieldPosition.setPositionY(postionY);
        fieldPosition.setPositionKeyword(positionKeyword);
        return fieldPosition;
    }

    private String getPersonSignUrl(String signType, String signTaskId, SignReqParam signReqParam) {
        if ("2".equals(signType) || "3".equals(signType)) {
            OpenApiClient openApiClient = this.getOpenApiClientByContractNo(signReqParam.getContractNo());
            SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
            String accessToken = FddServiceHelper.getAccessToken(openApiClient);
            SignTaskActorGetUrlReq signTaskActorGetUrlReq = new SignTaskActorGetUrlReq();
            signTaskActorGetUrlReq.setActorId("person");
            signTaskActorGetUrlReq.setRedirectUrl(signReqParam.getHandSignFrontUrl());
            signTaskActorGetUrlReq.setSignTaskId(signTaskId);
            signTaskActorGetUrlReq.setAccessToken(accessToken);
            BaseRes res = signTaskClient.signTaskActorGetUrl(signTaskActorGetUrlReq);
            ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
            if (res.isSuccess()) {
                return ((SignTaskActorGetUrlRes)res.getData()).getActorSignTaskUrl();
            }
            throw new KDBizException("get getHandSignUrl error, " + res.getMsg());
        }
        return null;
    }

    @Override
    public SignRespParam getHandSignUrl(String contractNo, SignReqParam signReqParam) {
        SignRespParam signRespParam = new SignRespParam(contractNo);
        DynamicObject contTplDyo = this.getDynamiTplDyo(signReqParam);
        String signType = contTplDyo.getString("signtype");
        if ("2".equals(signType) || "3".equals(signType)) {
            SignFlowService signFlowService = new SignFlowService();
            DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
            Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
            String signUrl = signFlowExtMap.get("personSignUrl");
            if (!HRStringUtils.isEmpty((String)signUrl)) {
                signRespParam.setHandSignUrl(signUrl);
            } else {
                signUrl = this.getPersonSignUrl(signType, signFlowExtMap.get("signTaskId"), signReqParam);
                if (!HRStringUtils.isEmpty((String)signUrl)) {
                    signRespParam.setHandSignUrl(signUrl);
                    signFlowExtMap.put("personSignUrl", signUrl);
                    signFlowService.saveExtMap(contractNo, signFlowExtMap);
                }
            }
        }
        return signRespParam;
    }

    @Override
    public SignRespParam sign(SignReqParam signReqParam, String contractNo) {
        this.unBlockCorp(signReqParam, contractNo);
        return this.getPrevAndDown(signReqParam, contractNo);
    }

    private void unBlockCorp(SignReqParam signReqParam, String contractNo) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
        Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
        OpenApiClient openApiClient = this.getOpenApiClientByContractNo(contractNo);
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        UnblockReq unblockReq = new UnblockReq();
        unblockReq.setAccessToken(accessToken);
        unblockReq.setSignTaskId(signFlowExtMap.get("signTaskId"));
        unblockReq.setActorId("corp");
        BaseRes res = signTaskClient.unblock(unblockReq);
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
    }

    @Override
    public SignRespParam getPrevAndDown(SignReqParam signReqParam, String contractNo) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
        Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
        String downloadUrl = this.getDownloadUrl(signFlowExtMap.get("signTaskId"), contractNo, this.getOwnerOpenCorpId(signReqParam));
        SignRespParam signRespParam = new SignRespParam(contractNo);
        ContractView contractView = new ContractView();
        contractView.setDownloadUrl(downloadUrl);
        signRespParam.setSealInfo(contractView);
        return signRespParam;
    }

    private String getDownloadUrl(String signTaskId, String contractNo, String openCorpId) {
        OpenApiClient openApiClient = this.getOpenApiClientByContractNo(contractNo);
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        GetOwnerDownloadUrlReq req = new GetOwnerDownloadUrlReq();
        req.setAccessToken(accessToken);
        req.setOwnerId(OpenId.getInstance((String)"corp", (String)openCorpId));
        req.setSignTaskId(signTaskId);
        req.setFileType("doc");
        req.setId("1");
        BaseRes res = signTaskClient.getOwnerDownloadUrl(req);
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
        if (res.isSuccess()) {
            return ((OwnerDownloadUrlRes)res.getData()).getDownloadUrl();
        }
        throw new KDBizException("get getHandSignUrl error, " + res.getMsg());
    }

    @Override
    public boolean cancel(SignReqParam signReqParam, String contractNo) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
        Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
        OpenApiClient openApiClient = this.getOpenApiClientByContractNo(contractNo);
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        SignTaskCancelReq signTaskBaseReq = new SignTaskCancelReq();
        signTaskBaseReq.setAccessToken(accessToken);
        signTaskBaseReq.setSignTaskId(signFlowExtMap.get("signTaskId"));
        BaseRes res = signTaskClient.cancel(signTaskBaseReq);
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
        return res.isSuccess();
    }

    @Override
    public Map getSignTaskStatus(SignReqParam signReqParam, String contractNo) {
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        SignTaskBaseReq signTaskBaseReq = new SignTaskBaseReq();
        signTaskBaseReq.setAccessToken(accessToken);
        Map<String, String> extMap = this.getExtMap(contractNo);
        String signTaskId = extMap.get("signTaskId");
        signTaskBaseReq.setSignTaskId(signTaskId);
        BaseRes res = signTaskClient.getDetail(signTaskBaseReq);
        logger.info("getSignTaskStatus res={}", (Object)SerializationUtils.toJsonString((Object)res));
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
        if (res.isSuccess()) {
            Map result = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)res), Map.class);
            return result;
        }
        throw new KDBizException("getSignTaskStatus error, " + res.getMsg());
    }

    private Map<String, String> getExtMap(String contractNo) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
        Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
        return signFlowExtMap;
    }
}

